/*
 * Decompiled with CFR 0.152.
 */
package jet.api;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import jet.api.Node;
import jet.controls.JetBoolean;
import jet.controls.JetColor;
import jet.controls.JetContainable;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetProperty;
import jet.controls.JetQualifyReference;
import jet.controls.JetString;
import jet.controls.JetUnitNumber;
import jet.controls.JetVector;
import jet.report.JRObjectTemplate;
import jet.report.JetLink;
import jet.report.JetRptChartLabel;
import jet.report.JetRptGeometryObject;

public abstract class API {
    public static final int UNKNOWN = -1;
    public static final int BOOLEAN = 0;
    public static final int INTEGER = 1;
    public static final int LONG = 2;
    public static final int FLOAT = 3;
    public static final int DOUBLE = 4;
    public static final int STRING = 5;
    public static final int COLOR = 6;
    public static final int ENUM = 7;
    public static final int REFERENCE = 8;
    public static final int INCH = 0;
    public static final int CENTIMETER = 1;
    public static final int PIXEL = 2;
    public static final String RPT = ".cls";
    public static final String XMLRPT = ".cls.xml";
    public static final String SELFRPT = ".clx";
    public static final String TEXTRPT = ".rpt";
    public static final String CAT = ".cat";
    public static final String XMLCAT = ".cat.xml";
    int I;
    public Hashtable handles = new Hashtable();
    String Z;
    String C;
    PrintWriter QOIV;

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows") >= 0;
    }

    public static String checkFilename(String string) {
        return API.isWindows() ? string.toLowerCase() : string;
    }

    public boolean setUnit(int n) {
        this.clearMsg();
        if (n >= 0 && n <= 2) {
            this.I = n;
            return true;
        }
        this.I("setUnit(" + n + "): Value of unit must be one of the 'INCH' and 'CENTIMETER'.");
        return false;
    }

    public int getUnit() {
        return this.I;
    }

    boolean I(JetContainable jetContainable, String string) {
        Vector vector = jetContainable.getChildren();
        int n = vector.size();
        while (--n >= 0) {
            if (!((JetObject)vector.elementAt(n)).getInstName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean delete(String var1);

    public String[] getPropNames(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            Hashtable hashtable = jetObject.getProperties();
            String[] stringArray = new String[hashtable.size()];
            int n = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                stringArray[n++] = (String)enumeration.nextElement();
            }
            return stringArray;
        }
        this.setError("getPropName(\"" + string + "\"): Illegal handle " + string + '.');
        return null;
    }

    public boolean containPropName(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            return jetObject.nameToProperty(string2) != null;
        }
        this.setError("containPropName(\"" + string + "\",\"" + string2 + "\"): Illegal handle " + string + '.');
        return false;
    }

    public int getPropType(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetBoolean) {
                    return 0;
                }
                if (jetProperty instanceof JetEnumeration) {
                    return 7;
                }
                if (jetProperty instanceof JetUnitNumber) {
                    return 4;
                }
                if (jetProperty instanceof JetNumber) {
                    Object object = jetProperty.getObject();
                    if (object instanceof Integer) {
                        return 1;
                    }
                    if (object instanceof Float) {
                        return 3;
                    }
                    if (object instanceof Double) {
                        return 4;
                    }
                    if (object instanceof Long) {
                        return 2;
                    }
                    return 3;
                }
                if (jetProperty instanceof JetString || jetProperty instanceof JetVector || jetProperty instanceof JetLink) {
                    return 5;
                }
                if (jetProperty instanceof JetColor) {
                    return 6;
                }
                if (jetProperty instanceof JetQualifyReference) {
                    return 8;
                }
            } else {
                this.setError("getPropType(\"" + string + "\",\"" + string2 + "\"): " + string2 + " is not a property in " + string + '.');
            }
        } else {
            this.setError("getPropType(\"" + string + "\",\"" + string2 + "\"): Illegal handle " + string + '.');
        }
        return -1;
    }

    boolean I(int[] nArray, int n) {
        int n2 = nArray.length;
        while (--n2 >= 0) {
            if (nArray[n2] != n) continue;
            return true;
        }
        return false;
    }

    public boolean set(String string, String string2, boolean bl) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string3 = this.arraycopy(jetProperty, string, string2);
            if (string3 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + bl + "): " + string3);
            } else {
                if (jetProperty instanceof JetBoolean) {
                    ((JetBoolean)jetProperty).set(bl);
                    if (string2.equals("TileDetailSection")) {
                        ((JRObjectTemplate)jetObject).width.setEditFlag(2);
                    }
                    return true;
                }
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + bl + "): Property " + string2 + " is not boolean type.");
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + bl + "): Illegal handle " + string + '.');
        }
        return false;
    }

    public boolean set(String string, String string2, int n) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string3 = this.arraycopy(jetProperty, string, string2);
            if (string3 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + n + "): " + string3);
            } else {
                if (jetProperty instanceof JetNumber) {
                    if (!this.afterInit((JetNumber)jetProperty, n)) {
                        ((JetNumber)jetProperty).set(n);
                    }
                    return true;
                }
                if (jetProperty instanceof JetEnumeration) {
                    ((JetEnumeration)jetProperty).set((Object)new Integer(n));
                    return true;
                }
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + n + "): Property " + string2 + " is not integer type.");
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + n + "): Illegal handle " + string + '.');
        }
        return false;
    }

    public boolean set(String string, String string2, long l) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string3 = this.arraycopy(jetProperty, string, string2);
            if (string3 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + l + "): " + string3);
            } else {
                if (jetProperty instanceof JetNumber) {
                    if (!this.afterInit((JetNumber)jetProperty, l)) {
                        ((JetNumber)jetProperty).set(l);
                    }
                    return true;
                }
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + l + "): Property " + string2 + " is not long type.");
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + l + "): Illegal handle " + string + '.');
        }
        return false;
    }

    public boolean set(String string, String string2, float f) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string3 = this.arraycopy(jetProperty, string, string2);
            if (string3 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + f + "): " + string3);
            } else {
                if (jetProperty instanceof JetNumber) {
                    if (!this.afterInit((JetNumber)jetProperty, f)) {
                        ((JetNumber)jetProperty).set(f);
                    }
                    return true;
                }
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + f + "): Property " + string2 + " is not float type.");
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + f + "): Illegal handle " + string + '.');
        }
        return false;
    }

    public boolean set(String string, String string2, double d) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string3 = this.arraycopy(jetProperty, string, string2);
            if (string3 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + d + "): " + string3);
            } else {
                if (jetProperty instanceof JetNumber) {
                    if (!this.afterInit((JetNumber)jetProperty, d)) {
                        ((JetNumber)jetProperty).set(d);
                    }
                    return true;
                }
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + d + "): Property " + string2 + " is not double type.");
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + d + "): Illegal handle " + string + '.');
        }
        return false;
    }

    public boolean set(String string, String string2, String string3) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string4 = this.arraycopy(jetProperty, string, string2);
            if (string4 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + string3 + "): " + string4);
            } else {
                if (jetProperty instanceof JetString) {
                    ((JetString)jetProperty).set(string3);
                    return true;
                }
                if (jetProperty instanceof JetEnumeration) {
                    ((JetEnumeration)jetProperty).set(string3);
                    return true;
                }
                if (jetProperty instanceof JetVector) {
                    ((JetVector)jetProperty).set(string3);
                    return true;
                }
                if (jetProperty instanceof JetColor) {
                    ((JetColor)jetProperty).set(string3);
                    return true;
                }
                if (jetProperty instanceof JetLink) {
                    ((JetLink)jetProperty).set(string3);
                    return true;
                }
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + string3 + "): Property " + string2 + " is not String type.");
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + string3 + "): Illegal handle " + string + '.');
        }
        return false;
    }

    public boolean set(String string, String string2, Color color) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string3 = this.arraycopy(jetProperty, string, string2);
            if (string3 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + color + "): " + string3);
            } else {
                if (jetProperty instanceof JetColor) {
                    ((JetColor)jetProperty).set(color);
                    return true;
                }
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + color + "): Property " + string2 + " is not color type.");
            }
        } else {
            this.setError("set(\"" + string + "\",\"" + string2 + "\"," + color + "): Illegal handle " + string + '.');
        }
        return false;
    }

    public boolean setReference(String string, String string2, String string3) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            String string4 = this.arraycopy(jetProperty, string, string2);
            if (string4 != null) {
                this.setError("set(\"" + string + "\",\"" + string2 + "\"," + string3 + "): " + string4);
            } else {
                if (jetProperty instanceof JetQualifyReference) {
                    ((JetQualifyReference)jetProperty).setObject((Object)this.getObj(string3));
                    ((JetQualifyReference)jetProperty).setInstanceName(string3);
                    if (jetObject instanceof JetRptGeometryObject) {
                        ((JRObjectTemplate)jetObject).afterInit();
                    }
                    return true;
                }
                this.setError("setRefence(\"" + string + "\",\"" + string2 + "\"," + string3 + "): Property " + string2 + " is not reference type.");
            }
        } else {
            this.setError("setRefence(\"" + string + "\",\"" + string2 + "\"," + string3 + "): Illegal handle " + string + '.');
        }
        return false;
    }

    public JetObject getObj(String string) {
        if (string != null) {
            JetObject jetObject = (JetObject)this.handles.get(string);
            return jetObject;
        }
        this.setError(" handle can not be null.");
        return null;
    }

    public boolean getBool(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetBoolean) {
                    return ((JetBoolean)jetProperty).get();
                }
                this.setError("getBool(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not boolean type.");
            } else {
                this.setError("getBool(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not existence in " + string + '.');
            }
        } else {
            this.setError("getBool(\"" + string + "\",\"" + string2 + "\"): Illegal handle " + string + '.');
        }
        return false;
    }

    public int getInt(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetNumber) {
                    return jetProperty instanceof JetUnitNumber && this.I != 2 ? (int)this.append((JetUnitNumber)jetProperty) : ((JetNumber)jetProperty).get();
                }
                if (jetProperty instanceof JetEnumeration) {
                    return ((JetEnumeration)jetProperty).intValue();
                }
                this.setError("getInt(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not integer type.");
            } else {
                this.setError("getInt(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not existence in " + string + '.');
            }
        } else {
            this.setError("getInt(\"" + string + "\",\"" + string2 + "\"): Illegal handle " + string + '.');
        }
        return 0;
    }

    public long getLong(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetNumber) {
                    return jetProperty instanceof JetUnitNumber && this.I != 2 ? (long)this.append((JetUnitNumber)jetProperty) : ((JetNumber)jetProperty).longValue();
                }
                this.setError("getLong(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not long type.");
            } else {
                this.setError("getLong(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not existence in " + string + '.');
            }
        } else {
            this.setError("getLong(\"" + string + "\",\"" + string2 + "\"): Illegal handle " + string + '.');
        }
        return 0L;
    }

    public float getFloat(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetNumber) {
                    return jetProperty instanceof JetUnitNumber && this.I != 2 ? (float)this.append((JetUnitNumber)jetProperty) : ((JetNumber)jetProperty).floatValue();
                }
                this.setError("getFloat(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not float type.");
            } else {
                this.setError("getFloat(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not existence in " + string + '.');
            }
        } else {
            this.setError("getFloat(\"" + string + "\",\"" + string2 + "\"): Illegal handle " + string + '.');
        }
        return 0.0f;
    }

    public double getDouble(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetNumber) {
                    return jetProperty instanceof JetUnitNumber && this.I != 2 ? this.append((JetUnitNumber)jetProperty) : ((JetNumber)jetProperty).doubleValue();
                }
                this.setError("getDouble(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not double type.");
            } else {
                this.setError("getDouble(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not existence in " + string + '.');
            }
        } else {
            this.setError("getDouble(\"" + string + "\",\"" + string2 + "\"): Illegal handle " + string + '.');
        }
        return 0.0;
    }

    public String getString(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetString) {
                    return ((JetString)jetProperty).get();
                }
                if (jetProperty instanceof JetEnumeration) {
                    return ((JetEnumeration)jetProperty).getCurKey();
                }
                if (jetProperty instanceof JetQualifyReference) {
                    return ((JetQualifyReference)jetProperty).toString();
                }
                if (jetProperty instanceof JetVector) {
                    String[] stringArray = ((JetVector)jetProperty).toStringArray();
                    return stringArray.length == 0 ? "" : stringArray[0];
                }
                if (jetProperty instanceof JetLink) {
                    return ((JetLink)jetProperty).toString();
                }
                this.setError("getString(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not String type.");
            } else {
                this.setError("getString(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not existence in " + string + '.');
            }
        } else {
            this.setError("getString(\"" + string + "\",\"" + string2 + "\"): Illegal handle " + string + '.');
        }
        return "";
    }

    public String[] getStringArray(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        String[] stringArray = new String[]{};
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetVector) {
                    stringArray = ((JetVector)jetProperty).toStringArray();
                } else {
                    this.setError("getStringArray(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not String array type.");
                }
            } else {
                this.setError("getStringArray(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not existence in " + string + '.');
            }
        } else {
            this.setError("getStringArray(\"" + string + "\",\"" + string2 + "\"): Illegal handle " + string + '.');
        }
        return stringArray;
    }

    public Color getColor(String string, String string2) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetProperty jetProperty = jetObject.nameToProperty(string2);
            if (jetProperty != null) {
                if (jetProperty instanceof JetColor) {
                    return ((JetColor)jetProperty).get();
                }
                this.setError("getColor(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not Color type.");
            } else {
                this.setError("getColor(\"" + string + "\",\"" + string2 + "\"): Property " + string2 + " is not existence in " + string + '.');
            }
        } else {
            this.setError("getColor(\"" + string + "\",\"" + string2 + "\"): Illegal handle " + string + '.');
        }
        return Color.lightGray;
    }

    public String[] getHandles() {
        int n = 0;
        String[] stringArray = new String[this.handles.size()];
        Enumeration enumeration = this.handles.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public String[] getHandles(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            String[] stringArray;
            if (jetObject instanceof JetContainable) {
                Vector vector = ((JetContainable)jetObject).getChildren();
                stringArray = new String[vector.size()];
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = ((JetObject)vector.elementAt(n)).getQualifyName();
                    ++n;
                }
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        this.setError("getHandles(\"" + string + "\"): Illegal handle " + string + '.');
        return new String[0];
    }

    public String[] getHandles(String string, int n) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            String[] stringArray;
            int n2 = 0;
            if (jetObject instanceof JetContainable) {
                Vector vector = ((JetContainable)jetObject).getChildren();
                stringArray = new String[vector.size()];
                int n3 = 0;
                while (n3 < stringArray.length) {
                    JetObject jetObject2 = (JetObject)vector.elementAt(n3);
                    if (n == this.getClassType(jetObject2)) {
                        stringArray[n2++] = jetObject2.getQualifyName();
                    }
                    ++n3;
                }
                if (n2 < stringArray.length) {
                    String[] stringArray2 = new String[n2];
                    System.arraycopy(stringArray, 0, stringArray2, 0, n2);
                    stringArray = stringArray2;
                }
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        this.setError("getHandles(\"" + string + "\"," + n + "): Illegal handle " + string + '.');
        return new String[0];
    }

    public String[] getHandles(String string, int n, int n2) {
        this.clearMsg();
        if (n2 == 0) {
            return this.getHandles(string, n);
        }
        if (n2 < 0) {
            return this.getHandles(string, n, 16);
        }
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            int n3;
            String[] stringArray;
            Vector vector = new Vector();
            Vector<String> vector2 = new Vector<String>();
            Stack<Node> stack = new Stack<Node>();
            Node node = new Node(string, n2);
            stack.push(node);
            while (!stack.empty()) {
                this.QOIV(stack, vector);
            }
            int n4 = vector.size();
            while (--n4 >= 0) {
                stringArray = this.getHandles((String)vector.elementAt(n4), n);
                n3 = stringArray.length;
                while (--n3 >= 0) {
                    vector2.addElement(stringArray[n3]);
                }
            }
            int n5 = vector2.size();
            stringArray = new String[n5];
            n3 = n5;
            while (--n3 >= 0) {
                stringArray[n3] = (String)vector2.elementAt(n3);
            }
            return stringArray;
        }
        this.setError("getHandles(\"" + string + "\"," + n + "): Illegal handle " + string + '.');
        return new String[0];
    }

    void QOIV(Stack stack, Vector vector) {
        Node node = (Node)stack.pop();
        if (node.I > 0) {
            String[] stringArray = this.getHandles(node.Z);
            vector.addElement(node.Z);
            --node.I;
            int n = stringArray.length;
            while (--n >= 0) {
                stack.push(new Node(stringArray[n], node.I));
            }
        }
    }

    public String getInstanceName(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            return jetObject.getInstName();
        }
        this.setError("getInstanceName(\"" + string + "\"): Illegal handle " + string + '.');
        return null;
    }

    public String getQualifyName(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            return jetObject.getQualifyName();
        }
        this.setError("getQualifyName(\"" + string + "\"): Illegal handle " + string + '.');
        return null;
    }

    public int getClassType(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            return this.getClassType(jetObject);
        }
        this.setError("getClassType(\"" + string + "\"): Illegal handle " + string + '.');
        return -1;
    }

    public String getParent(String string) {
        this.clearMsg();
        JetObject jetObject = this.getObj(string);
        if (jetObject != null) {
            JetContainable jetContainable = jetObject.getParent();
            if (jetContainable != null) {
                return ((JetObject)jetContainable).getQualifyName();
            }
            this.I("getParent(\"" + string + "\"): " + string + " is root node.");
        } else {
            this.setError("getParent(\"" + string + "\"): Illegal handle " + string + '.');
        }
        return null;
    }

    public String getWarning() {
        return this.Z;
    }

    public void clearWarning() {
        this.Z = null;
    }

    public String getError() {
        return this.C;
    }

    public void clearError() {
        this.C = null;
    }

    public void clearMsg() {
        this.Z = null;
        this.C = null;
    }

    public boolean setLog(OutputStream outputStream, String string) {
        this.clearMsg();
        try {
            this.QOIV = new PrintWriter(new OutputStreamWriter(outputStream, string));
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.QOIV = new PrintWriter(new OutputStreamWriter(outputStream));
            this.addElement(unsupportedEncodingException);
            return false;
        }
    }

    public boolean setLog(String string, boolean bl) {
        try {
            this.setLog(new FileOutputStream(string, bl), "8859_1");
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.addElement(fileNotFoundException);
            return false;
        }
    }

    public boolean setLog(String string) {
        return this.setLog(string, false);
    }

    public void writeLog(String string) {
        if (this.QOIV != null) {
            this.QOIV.print('\n');
            this.QOIV.print(string);
            this.QOIV.flush();
        }
    }

    public void writeLog(String string, Throwable throwable) {
        if (this.QOIV != null) {
            this.QOIV.print('\n');
            this.QOIV.print(string);
            throwable.printStackTrace(this.QOIV);
            this.QOIV.flush();
        }
    }

    public void closeLog() throws IOException {
        if (this.QOIV != null) {
            this.QOIV.close();
            this.QOIV = null;
        }
    }

    void I(String string) {
        this.Z = string;
        this.writeLog("Warning: " + string);
    }

    void addElement(Exception exception) {
        this.Z = exception.getMessage();
        this.writeLog("Warning: ", exception);
    }

    protected void setError(String string) {
        this.C = string;
        this.writeLog("Error: " + string);
    }

    void I(Exception exception) {
        this.C = exception.getMessage();
        this.writeLog("Error: ", exception);
    }

    protected void createHandles(JetContainable jetContainable, String string) {
        Vector vector = jetContainable.getChildren();
        string = string + '.';
        int n = vector.size();
        while (--n >= 0) {
            JetObject jetObject = (JetObject)vector.elementAt(n);
            String string2 = string + jetObject.getInstName();
            this.handles.put(string2, jetObject);
            if (!(jetObject instanceof JetContainable)) continue;
            this.createHandles((JetContainable)jetObject, string2);
        }
    }

    protected void createHandles(JetRptChartLabel jetRptChartLabel, String string) {
        this.handles.put(string, jetRptChartLabel);
    }

    protected void destroyHandles(JetContainable jetContainable, String string) {
        Vector vector = jetContainable.getChildren();
        string = string + '.';
        int n = vector.size();
        while (--n >= 0) {
            JetObject jetObject = (JetObject)vector.elementAt(n);
            String string2 = string + jetObject.getInstName();
            this.handles.remove(string2);
            if (!(jetObject instanceof JetContainable)) continue;
            this.destroyHandles((JetContainable)jetObject, string2);
        }
    }

    abstract int getClassType(JetObject var1);

    boolean afterInit(JetNumber jetNumber, double d) {
        if (this.I != 2 && jetNumber instanceof JetUnitNumber) {
            ((JetUnitNumber)jetNumber).setUnitValue(this.I == 0 ? Unit.convertInchToUnit((double)d) : Unit.convertCentimeterToUnit((double)d));
            return true;
        }
        return false;
    }

    double append(JetUnitNumber jetUnitNumber) {
        return this.I == 0 ? Unit.convertUnitToInch((int)jetUnitNumber.getUnit()) : Unit.convertUnitToCentimeter((int)jetUnitNumber.getUnit());
    }

    String arraycopy(JetProperty jetProperty, String string, String string2) {
        if (jetProperty == null) {
            return "Property " + string2 + " is not existence in " + string + '.';
        }
        int n = jetProperty.getEditFlag();
        if (n == 0 || n == 3) {
            return "Property " + string2 + " cannot be changed.";
        }
        return null;
    }

    boolean I(String[] stringArray, String string) {
        boolean bl = false;
        int n = stringArray.length;
        while (--n >= 0) {
            if (!stringArray[n].equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String[] getChildren(String string) {
        this.clearMsg();
        String[] stringArray = new String[]{};
        JetObject jetObject = (JetObject)this.handles.get(string);
        if (jetObject != null && jetObject instanceof JetContainable) {
            Vector vector = ((JetContainable)jetObject).getChildren();
            int n = vector.size();
            JetObject jetObject2 = null;
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                jetObject2 = (JetObject)vector.elementAt(n2);
                stringArray[n2] = jetObject2.getQualifyName();
                ++n2;
            }
        } else {
            this.setError("getChildren(\"" + string + "\")invalid handle " + string);
        }
        return stringArray;
    }
}

