/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.jacl;

import guitools.toolkit.JDebug;
import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.LastOwnerException;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JAclEnumerator;
import jet.cs.jacl.JOwnerImpl;
import jet.cs.jacl.JPermission;
import jet.cs.jacl.JPermissionImpl;
import jet.cs.jacl.JPermissionLinkException;
import jet.cs.jacl.JPolicy;
import jet.cs.jacl.JPolicyLinkException;
import jet.cs.jacl.SecurityData;

public class JAclImpl
implements JAcl {
    private Hashtable EXECUTE;
    private Hashtable GRANT;
    private Hashtable QOIV;
    private Hashtable READ;
    private Hashtable SCHEDULE;
    private Hashtable WARNING;
    private String add;
    private JOwnerImpl addElement;
    private boolean addOwner;
    private SecurityData append;
    private boolean checkPermission = false;

    public JAclImpl(Principal principal, String string, SecurityData securityData) {
        this.addElement = new JOwnerImpl(principal);
        this.addOwner = true;
        this.EXECUTE = new Hashtable(23);
        this.GRANT = new Hashtable(23);
        this.QOIV = new Hashtable(23);
        this.READ = new Hashtable(23);
        this.SCHEDULE = new Hashtable(23);
        this.WARNING = new Hashtable(23);
        string = null;
        try {
            this.setName(principal, string);
        }
        catch (Exception exception) {
            JDebug.WARNING((Throwable)exception);
        }
        this.append = securityData;
    }

    public JAclImpl(String string, SecurityData securityData) {
        this.addOwner = false;
        this.EXECUTE = new Hashtable(23);
        this.GRANT = new Hashtable(23);
        this.QOIV = new Hashtable(23);
        this.READ = new Hashtable(23);
        this.SCHEDULE = new Hashtable(23);
        this.WARNING = new Hashtable(23);
        this.add = string;
        this.append = securityData;
    }

    public void setName(Principal principal, String string) throws NotOwnerException {
        if (this.addOwner && (!this.addElement.isOwner(principal) || principal == null)) {
            throw new NotOwnerException();
        }
        this.add = string;
    }

    public String getName() {
        return this.add;
    }

    public synchronized boolean addEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        Principal principal2;
        String string;
        if (aclEntry == null) {
            return false;
        }
        if (this.addOwner && (!this.addElement.isOwner(principal) || principal == null)) {
            throw new NotOwnerException();
        }
        Hashtable hashtable = this.QOIV(aclEntry);
        if (hashtable.get(string = (principal2 = aclEntry.getPrincipal()).getName()) != null) {
            return false;
        }
        hashtable.put(string, aclEntry);
        return true;
    }

    public boolean removeEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        Principal principal2;
        if (aclEntry == null) {
            return false;
        }
        if (this.addOwner && (!this.addElement.isOwner(principal) || principal == null)) {
            throw new NotOwnerException();
        }
        Hashtable hashtable = this.QOIV(aclEntry);
        Object v = hashtable.remove((principal2 = aclEntry.getPrincipal()).getName());
        return v != null;
    }

    public synchronized Enumeration getPermissions(Principal principal) {
        if (principal == null) {
            return null;
        }
        if (!(principal instanceof BaseGroup || principal instanceof BaseUser || principal instanceof BaseRole)) {
            return null;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.GRANT(principal, vector, vector2);
        this.EXECUTE(principal, vector, vector2);
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        this.getPermissions(principal, vector3, vector4);
        int n = 0;
        while (n < vector4.size()) {
            Object e = vector4.elementAt(n);
            if (vector.contains(e)) {
                vector.removeElement(e);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            vector3.addElement(vector.elementAt(n2));
            ++n2;
        }
        return vector3.elements();
    }

    private void EXECUTE(Principal principal, Vector vector, Vector vector2) {
        block29: {
            BaseRole baseRole;
            block30: {
                BaseRole baseRole2;
                block28: {
                    if (!(principal instanceof BaseRole)) break block28;
                    BaseRole baseRole3 = this.append.getRole(principal.getName());
                    if (baseRole3 == null) {
                        return;
                    }
                    Vector vector3 = baseRole3.getParentRoleNames();
                    Vector vector4 = new Vector();
                    Vector vector5 = new Vector();
                    int n = 0;
                    while (n < vector3.size()) {
                        BaseRole baseRole4 = this.append.getRole((String)vector3.get(n));
                        this.EXECUTE(baseRole4, vector, vector2);
                        this.getPermissions(baseRole4, vector4, vector5);
                        int n2 = 0;
                        while (n2 < vector4.size()) {
                            Object e = vector4.elementAt(n2);
                            if (!vector.contains(e)) {
                                vector.addElement(e);
                            }
                            ++n2;
                        }
                        int n3 = 0;
                        while (n3 < vector5.size()) {
                            Object e = vector5.elementAt(n3);
                            if (!vector2.contains(e)) {
                                vector2.addElement(e);
                            }
                            ++n3;
                        }
                        ++n;
                    }
                    int n4 = vector.size() - 1;
                    while (n4 >= 0) {
                        Object e = vector.elementAt(n4);
                        if (vector2.contains(e)) {
                            vector.removeElement(e);
                            vector2.removeElement(e);
                        }
                        --n4;
                    }
                    break block29;
                }
                if (!(principal instanceof BaseUser)) break block30;
                BaseUser baseUser = this.append.getUser(principal.getName());
                if (baseUser == null) {
                    return;
                }
                Vector vector6 = baseUser.getParentRoleNames();
                if (vector6 == null || vector6.size() == 0) {
                    return;
                }
                Vector vector7 = new Vector();
                Vector vector8 = new Vector();
                int n = 0;
                while (n < vector6.size()) {
                    String string = (String)vector6.get(n);
                    baseRole2 = this.append.getRole(string);
                    if (baseRole2 != null) {
                        this.EXECUTE(baseRole2, vector, vector2);
                        this.getPermissions(baseRole2, vector7, vector8);
                        int n5 = 0;
                        while (n5 < vector7.size()) {
                            Object e = vector7.elementAt(n5);
                            if (!vector.contains(e)) {
                                vector.addElement(e);
                            }
                            ++n5;
                        }
                        int n6 = 0;
                        while (n6 < vector8.size()) {
                            Object e = vector8.elementAt(n6);
                            if (!vector2.contains(e)) {
                                vector2.addElement(e);
                            }
                            ++n6;
                        }
                    }
                    ++n;
                }
                int n7 = vector.size() - 1;
                while (n7 >= 0) {
                    baseRole2 = vector.elementAt(n7);
                    if (vector2.contains(baseRole2)) {
                        vector.removeElement(baseRole2);
                        vector2.removeElement(baseRole2);
                    }
                    --n7;
                }
                break block29;
            }
            if (!(principal instanceof BaseGroup)) break block29;
            BaseGroup baseGroup = this.append.getGroup(principal.getName());
            if (baseGroup == null) {
                return;
            }
            Vector vector9 = baseGroup.getRoleNames();
            if (vector9 == null || vector9.size() == 0) {
                return;
            }
            Vector vector10 = new Vector();
            Vector vector11 = new Vector();
            int n = 0;
            while (n < vector9.size()) {
                String string = (String)vector9.get(n);
                baseRole = this.append.getRole(string);
                if (baseRole != null) {
                    this.EXECUTE(baseRole, vector, vector2);
                    this.getPermissions(baseRole, vector10, vector11);
                    int n8 = 0;
                    while (n8 < vector10.size()) {
                        Object e = vector10.elementAt(n8);
                        if (!vector.contains(e)) {
                            vector.addElement(e);
                        }
                        ++n8;
                    }
                    int n9 = 0;
                    while (n9 < vector11.size()) {
                        Object e = vector11.elementAt(n9);
                        if (!vector2.contains(e)) {
                            vector2.addElement(e);
                        }
                        ++n9;
                    }
                }
                ++n;
            }
            int n10 = vector.size() - 1;
            while (n10 >= 0) {
                baseRole = vector.elementAt(n10);
                if (vector2.contains(baseRole)) {
                    vector.removeElement(baseRole);
                    vector2.removeElement(baseRole);
                }
                --n10;
            }
        }
    }

    private void GRANT(Principal principal, Vector vector, Vector vector2) {
        block22: {
            BaseGroup baseGroup;
            block21: {
                BaseGroup baseGroup2;
                if (principal instanceof BaseRole) {
                    return;
                }
                if (!(principal instanceof BaseUser)) break block21;
                BaseUser baseUser = this.append.getUser(principal.getName());
                if (baseUser == null) {
                    return;
                }
                Vector vector3 = baseUser.getGroupNames();
                if (vector3 == null || vector3.size() == 0) {
                    return;
                }
                Vector vector4 = new Vector();
                Vector vector5 = new Vector();
                int n = 0;
                while (n < vector3.size()) {
                    String string = (String)vector3.get(n);
                    baseGroup2 = this.append.getGroup(string);
                    if (baseGroup2 != null) {
                        this.GRANT(baseGroup2, vector, vector2);
                        this.EXECUTE(baseGroup2, vector, vector2);
                        this.getPermissions(baseGroup2, vector4, vector5);
                        int n2 = 0;
                        while (n2 < vector4.size()) {
                            Object e = vector4.elementAt(n2);
                            if (!vector.contains(e)) {
                                vector.addElement(e);
                            }
                            ++n2;
                        }
                        int n3 = 0;
                        while (n3 < vector5.size()) {
                            Object e = vector5.elementAt(n3);
                            if (!vector2.contains(e)) {
                                vector2.addElement(e);
                            }
                            ++n3;
                        }
                    }
                    ++n;
                }
                int n4 = vector.size() - 1;
                while (n4 >= 0) {
                    baseGroup2 = vector.elementAt(n4);
                    if (vector2.contains(baseGroup2)) {
                        vector.removeElement(baseGroup2);
                        vector2.removeElement(baseGroup2);
                    }
                    --n4;
                }
                break block22;
            }
            if (!(principal instanceof BaseGroup)) break block22;
            BaseGroup baseGroup3 = this.append.getGroup(principal.getName());
            if (baseGroup3 == null) {
                return;
            }
            Vector vector6 = baseGroup3.getParentGroupNames();
            if (vector6 == null || vector6.size() == 0) {
                return;
            }
            Vector vector7 = new Vector();
            Vector vector8 = new Vector();
            int n = 0;
            while (n < vector6.size()) {
                String string = (String)vector6.get(n);
                baseGroup = this.append.getGroup(string);
                if (baseGroup != null) {
                    this.GRANT(baseGroup, vector, vector2);
                    this.EXECUTE(baseGroup, vector, vector2);
                    this.getPermissions(baseGroup, vector7, vector8);
                    int n5 = 0;
                    while (n5 < vector7.size()) {
                        Object e = vector7.elementAt(n5);
                        if (!vector.contains(e)) {
                            vector.addElement(e);
                        }
                        ++n5;
                    }
                    int n6 = 0;
                    while (n6 < vector8.size()) {
                        Object e = vector8.elementAt(n6);
                        if (!vector2.contains(e)) {
                            vector2.addElement(e);
                        }
                        ++n6;
                    }
                }
                ++n;
            }
            int n7 = vector.size() - 1;
            while (n7 >= 0) {
                baseGroup = vector.elementAt(n7);
                if (vector2.contains(baseGroup)) {
                    vector.removeElement(baseGroup);
                    vector2.removeElement(baseGroup);
                }
                --n7;
            }
        }
    }

    private void getPermissions(Principal principal, Vector vector, Vector vector2) {
        block15: {
            block16: {
                Object object;
                block14: {
                    Object object2;
                    vector.removeAllElements();
                    vector2.removeAllElements();
                    if (!(principal instanceof BaseUser) || this.checkPermission) break block14;
                    String string = principal.getName();
                    BaseUser baseUser = this.append.getUser(principal.getName());
                    if (baseUser == null) {
                        return;
                    }
                    JAclEntry jAclEntry = (JAclEntry)this.EXECUTE.get(string);
                    if (jAclEntry != null) {
                        object2 = jAclEntry.permissions();
                        while (object2.hasMoreElements()) {
                            vector.addElement(object2.nextElement());
                        }
                    }
                    if ((object2 = (JAclEntry)this.READ.get(string)) == null) break block15;
                    Enumeration enumeration = object2.permissions();
                    while (enumeration.hasMoreElements()) {
                        vector2.addElement(enumeration.nextElement());
                    }
                    break block15;
                }
                if (!(principal instanceof BaseRole)) break block16;
                String string = principal.getName();
                BaseRole baseRole = this.append.getRole(string);
                if (baseRole == null) {
                    return;
                }
                JAclEntry jAclEntry = (JAclEntry)this.GRANT.get(string);
                if (jAclEntry != null) {
                    object = jAclEntry.permissions();
                    while (object.hasMoreElements()) {
                        vector.addElement(object.nextElement());
                    }
                }
                if ((object = (JAclEntry)this.SCHEDULE.get(string)) == null) break block15;
                Enumeration enumeration = object.permissions();
                while (enumeration.hasMoreElements()) {
                    vector2.addElement(enumeration.nextElement());
                }
                break block15;
            }
            if (!this.checkPermission) {
                Object object;
                String string = principal.getName();
                BaseGroup baseGroup = this.append.getGroup(string);
                if (baseGroup == null) {
                    return;
                }
                JAclEntry jAclEntry = (JAclEntry)this.QOIV.get(string);
                if (jAclEntry != null) {
                    object = jAclEntry.permissions();
                    while (object.hasMoreElements()) {
                        vector.addElement(object.nextElement());
                    }
                }
                if ((object = (JAclEntry)this.WARNING.get(string)) != null) {
                    Enumeration enumeration = object.permissions();
                    while (enumeration.hasMoreElements()) {
                        vector2.addElement(enumeration.nextElement());
                    }
                }
            }
        }
    }

    public Enumeration entries() {
        return new JAclEnumerator(this, this.EXECUTE, this.GRANT, this.QOIV, this.READ, this.SCHEDULE, this.WARNING);
    }

    public boolean checkPermission(Principal principal, Permission permission) {
        if (principal == null || permission == null) {
            return false;
        }
        Enumeration enumeration = this.getPermissions(principal);
        while (enumeration.hasMoreElements()) {
            Permission permission2 = (Permission)enumeration.nextElement();
            if (permission2.equals((Object)JPermissionImpl.GRANT)) {
                return true;
            }
            if ((permission2.equals((Object)JPermissionImpl.EXECUTE) || permission2.equals((Object)JPermissionImpl.SCHEDULE)) && permission.equals((Object)JPermissionImpl.READ)) {
                return true;
            }
            if (!permission.equals((Object)permission2)) continue;
            return true;
        }
        return false;
    }

    public void setRoleBased(boolean bl) {
        this.checkPermission = bl;
    }

    public JPermission getPolicyPermission(Principal principal, String string, int n) throws JPermissionLinkException, JPolicyLinkException {
        Object object;
        Object object2;
        Object object3;
        Enumeration<Object> enumeration;
        Enumeration enumeration2;
        if (principal == null || string == null) {
            return null;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.GRANT(principal, vector, vector2);
        this.EXECUTE(principal, vector, vector2);
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        this.getPermissions(principal, vector3, vector4);
        int n2 = 0;
        while (n2 < vector4.size()) {
            enumeration2 = vector4.elementAt(n2);
            if (vector.contains(enumeration2)) {
                vector.removeElement(enumeration2);
            }
            ++n2;
        }
        enumeration2 = vector3.elements();
        while (enumeration2.hasMoreElements()) {
            JPermissionImpl jPermissionImpl = (JPermissionImpl)enumeration2.nextElement();
            jPermissionImpl.setPolicyIndividual(true);
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            vector3.addElement(vector.elementAt(n3));
            ++n3;
        }
        Enumeration enumeration3 = vector3.elements();
        if (enumeration3 == null || !enumeration3.hasMoreElements()) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        while (enumeration3.hasMoreElements()) {
            Vector vector5;
            enumeration = enumeration3.nextElement();
            if (!(enumeration instanceof JPermission)) continue;
            object3 = (JPermission)((Object)enumeration);
            int n4 = object3.getType();
            object2 = object3.getName();
            object = (String)object2 + n4;
            if (!hashtable.containsKey(object)) {
                hashtable.put(object, object3);
            }
            if (n == -1) continue;
            if (!hashtable2.containsKey(object)) {
                vector5 = new Vector();
                vector5.add(object3.getPolicy());
                hashtable2.put(object, vector5);
                continue;
            }
            vector5 = (Vector)hashtable2.get(object);
            vector5.add(object3.getPolicy());
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            Vector vector6 = (Vector)hashtable2.get(object3);
            object2 = null;
            if (!vector6.isEmpty()) {
                while (object2 == null && vector6.size() >= 1) {
                    object2 = (JPolicy)vector6.get(0);
                    vector6.remove(0);
                }
                object = vector6.elements();
                if (object2 != null && object.hasMoreElements()) {
                    object2 = object2.unionJPolicies((Enumeration)object);
                }
            }
            object = (JPermission)hashtable.get(object3);
            object.setPolicy((JPolicy)object2);
        }
        object3 = string + n;
        Object v = hashtable.get(object3);
        if (v != null && v instanceof JPermission) {
            return (JPermission)v;
        }
        return null;
    }

    public JAclEntry getJAclEntry(Principal principal, boolean bl) {
        if (principal instanceof BaseUser) {
            if (bl) {
                return (JAclEntry)this.EXECUTE.get(principal.getName());
            }
            return (JAclEntry)this.READ.get(principal.getName());
        }
        if (principal instanceof BaseRole) {
            if (bl) {
                return (JAclEntry)this.GRANT.get(principal.getName());
            }
            return (JAclEntry)this.SCHEDULE.get(principal.getName());
        }
        if (principal instanceof BaseGroup) {
            if (bl) {
                return (JAclEntry)this.QOIV.get(principal.getName());
            }
            return (JAclEntry)this.WARNING.get(principal.getName());
        }
        return null;
    }

    public void removeJAclEntry(Principal principal, boolean bl) {
        if (principal instanceof BaseUser) {
            if (bl) {
                this.EXECUTE.remove(principal.getName());
            } else {
                this.READ.remove(principal.getName());
            }
        } else if (principal instanceof BaseRole) {
            if (bl) {
                this.GRANT.remove(principal.getName());
            } else {
                this.SCHEDULE.remove(principal.getName());
            }
        } else if (principal instanceof BaseGroup) {
            if (bl) {
                this.QOIV.remove(principal.getName());
            } else {
                this.WARNING.remove(principal.getName());
            }
        }
    }

    public void removeJAclEntry(String string, int n) {
        if (n == 1) {
            this.EXECUTE.remove(string);
            this.READ.remove(string);
        } else if (n == 2) {
            this.GRANT.remove(string);
            this.SCHEDULE.remove(string);
        } else if (n == 3) {
            this.QOIV.remove(string);
            this.WARNING.remove(string);
        }
    }

    public void removeJAclEntry(int n) {
        if (n == 1) {
            this.EXECUTE.clear();
            this.READ.clear();
        } else if (n == 1) {
            this.GRANT.clear();
            this.SCHEDULE.clear();
        } else if (n == 1) {
            this.QOIV.clear();
            this.WARNING.clear();
        }
    }

    public JPermission getPolicyPermission(Principal principal, SecurityData securityData, String string, int n) throws JPermissionLinkException, JPolicyLinkException {
        if (securityData != null) {
            this.append = securityData;
        }
        return this.getPolicyPermission(principal, string, n);
    }

    public boolean checkPermission(Principal principal, SecurityData securityData, JPermission jPermission) {
        if (securityData != null) {
            this.append = securityData;
        }
        return this.checkPermission(principal, jPermission);
    }

    private Hashtable QOIV(AclEntry aclEntry) {
        Principal principal = aclEntry.getPrincipal();
        Hashtable hashtable = principal instanceof BaseRole ? (aclEntry.isNegative() ? this.SCHEDULE : this.GRANT) : (principal instanceof BaseUser ? (aclEntry.isNegative() ? this.READ : this.EXECUTE) : (aclEntry.isNegative() ? this.WARNING : this.QOIV));
        return hashtable;
    }

    public void removeAllEntries() {
        this.EXECUTE.clear();
        this.GRANT.clear();
        this.QOIV.clear();
        this.READ.clear();
        this.SCHEDULE.clear();
        this.WARNING.clear();
    }

    public boolean isOwner(Principal principal) {
        return this.addElement.isOwner(principal);
    }

    public boolean addOwner(Principal principal, Principal principal2) throws NotOwnerException {
        return this.addElement.addOwner(principal, principal2);
    }

    public boolean deleteOwner(Principal principal, Principal principal2) throws NotOwnerException, LastOwnerException {
        return this.addElement.deleteOwner(principal, principal2);
    }
}

