/*
 * Decompiled with CFR 0.152.
 */
package jet.server.api.db;

import java.lang.reflect.Field;
import java.util.HashMap;

public final class JDBCType {
    private static HashMap QOIV = new HashMap();
    private static HashMap append = new HashMap();
    private static HashMap containsKey = new HashMap();
    public static final JDBCType BIT;
    public static final JDBCType TINYINT;
    public static final JDBCType SMALLINT;
    public static final JDBCType INTEGER;
    public static final JDBCType BIGINT;
    public static final JDBCType FLOAT;
    public static final JDBCType REAL;
    public static final JDBCType DOUBLE;
    public static final JDBCType NUMERIC;
    public static final JDBCType DECIMAL;
    public static final JDBCType CHAR;
    public static final JDBCType VARCHAR;
    public static final JDBCType LONGVARCHAR;
    public static final JDBCType DATE;
    public static final JDBCType TIME;
    public static final JDBCType TIMESTAMP;
    public static final JDBCType BINARY;
    public static final JDBCType VARBINARY;
    public static final JDBCType LONGVARBINARY;
    public static final JDBCType NULL;
    public static final JDBCType OTHER;
    public static final JDBCType JAVA_OBJECT;
    public static final JDBCType DISTINCT;
    public static final JDBCType STRUCT;
    public static final JDBCType ARRAY;
    public static final JDBCType BLOB;
    public static final JDBCType CLOB;
    public static final JDBCType REF;
    public static final JDBCType DATALINK;
    public static final JDBCType BOOLEAN;
    private int dataType;

    public static final String toString(int n) {
        return (String)QOIV.get(new Integer(n));
    }

    public static final int toInteger(String string) {
        return (Integer)append.get(string);
    }

    public static final boolean isSupported(int n) {
        return QOIV.containsKey(new Integer(n));
    }

    public static final boolean isSupported(String string) {
        return append.containsKey(string);
    }

    public static final JDBCType getJDBCType(int n) {
        return (JDBCType)containsKey.get(new Integer(n));
    }

    private JDBCType(int n) {
        this.dataType = n;
    }

    public String typeName() {
        return JDBCType.toString(this.dataType);
    }

    public final int dataType() {
        return this.dataType;
    }

    public boolean equals(Object object) {
        if (object instanceof JDBCType) {
            return this.dataType == ((JDBCType)object).dataType;
        }
        return false;
    }

    public int hashCode() {
        return this.typeName().hashCode();
    }

    public boolean isVariationalSize() {
        switch (this.dataType) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.typeName()).append(":").append(this.dataType());
        return stringBuffer.substring(0);
    }

    static {
        try {
            Class<?> clazz = Class.forName("java.sql.Types");
            Field[] fieldArray = clazz.getDeclaredFields();
            int n = 0;
            while (n < fieldArray.length) {
                String string = fieldArray[n].getName();
                Integer n2 = new Integer(fieldArray[n].getInt(fieldArray[n]));
                QOIV.put(n2, string);
                append.put(string, n2);
                containsKey.put(n2, new JDBCType(n2));
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        BIT = new JDBCType(-7);
        TINYINT = new JDBCType(-6);
        SMALLINT = new JDBCType(5);
        INTEGER = new JDBCType(4);
        BIGINT = new JDBCType(-5);
        FLOAT = new JDBCType(6);
        REAL = new JDBCType(7);
        DOUBLE = new JDBCType(8);
        NUMERIC = new JDBCType(2);
        DECIMAL = new JDBCType(3);
        CHAR = new JDBCType(1);
        VARCHAR = new JDBCType(12);
        LONGVARCHAR = new JDBCType(-1);
        DATE = new JDBCType(91);
        TIME = new JDBCType(92);
        TIMESTAMP = new JDBCType(93);
        BINARY = new JDBCType(-2);
        VARBINARY = new JDBCType(-3);
        LONGVARBINARY = new JDBCType(-4);
        NULL = new JDBCType(0);
        OTHER = new JDBCType(1111);
        JAVA_OBJECT = new JDBCType(2000);
        DISTINCT = new JDBCType(2001);
        STRUCT = new JDBCType(2002);
        ARRAY = new JDBCType(2003);
        BLOB = new JDBCType(2004);
        CLOB = new JDBCType(2005);
        REF = new JDBCType(2006);
        DATALINK = new JDBCType(70);
        BOOLEAN = new JDBCType(16);
    }
}

