/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cache.core.memory;

import java.util.Hashtable;
import java.util.Map;
import jet.server.cache.core.intf.CacheAttributes;
import jet.server.cache.core.intf.ElementAttributes;
import jet.server.cache.core.memory.intf.MemoryCache;
import jet.server.cache.util.CacheShrinker;
import jet.server.cache.util.ThreadCreator;
import jet.server.cache.util.ThreadExecutor;

public abstract class AbstractMemoryCache
implements MemoryCache {
    protected String cacheName;
    protected Map map = new Hashtable();
    private static ThreadExecutor QOIV;
    public ElementAttributes attr;
    CacheAttributes I;

    public synchronized void initialize(CacheAttributes cacheAttributes) {
        this.I = cacheAttributes;
        this.cacheName = cacheAttributes.getCacheName();
        if (cacheAttributes.isUseMemoryShrinker()) {
            if (QOIV == null) {
                QOIV = new ThreadExecutor(new MyThreadCreator(this));
            }
            QOIV.executePeriodically(cacheAttributes.getShrinkerRunTime() * 1000, new CacheShrinker(this), false);
        }
    }

    public void removeAll() {
        this.map = new Hashtable();
    }

    public void dispose() {
        if (QOIV != null) {
            QOIV.shutDown();
        }
    }

    public int getSize() {
        return this.map.size();
    }

    public String getCacheName() {
        return this.I.getCacheName();
    }

    class MyThreadCreator
    implements ThreadCreator {
        private final AbstractMemoryCache this$0;

        MyThreadCreator(AbstractMemoryCache abstractMemoryCache) {
            this.this$0 = abstractMemoryCache;
        }

        public Thread create(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setPriority(1);
            return thread;
        }
    }
}

