/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cache.core.memory;

import jet.server.cache.core.intf.CacheAttributes;
import jet.server.cache.core.intf.CacheElement;
import jet.server.cache.core.memory.AbstractMemoryCache;
import jet.server.cache.util.DoubleLinkedList;
import jet.server.cache.util.MemoryListElement;
import jet.server.log.ServiceLogger;

public class DefaultMemoryCacheImpl
extends AbstractMemoryCache {
    private DoubleLinkedList QOIV;

    public DefaultMemoryCacheImpl(CacheAttributes cacheAttributes) {
        this.initialize(cacheAttributes);
    }

    public void initialize(CacheAttributes cacheAttributes) {
        super.initialize(cacheAttributes);
        this.QOIV = new DoubleLinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getKeys() {
        DefaultMemoryCacheImpl defaultMemoryCacheImpl = this;
        synchronized (defaultMemoryCacheImpl) {
            Object[] objectArray = this.map.keySet().toArray();
            return objectArray;
        }
    }

    public CacheElement getQuiet(Object object) {
        CacheElement cacheElement = null;
        MemoryListElement memoryListElement = (MemoryListElement)this.map.get(object);
        if (memoryListElement != null) {
            ServiceLogger.print(6670047, new Object[]{this.cacheName, object});
            cacheElement = memoryListElement.ce;
        } else {
            ServiceLogger.print(6670048, new Object[]{this.cacheName, object});
        }
        return cacheElement;
    }

    public void setCacheAttributes(CacheAttributes cacheAttributes) {
        this.I = cacheAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CacheElement cacheElement) {
        int n;
        DefaultMemoryCacheImpl defaultMemoryCacheImpl;
        if (this.I.getMaxObjects() > 0) {
            cacheElement.getElementAttributes().setLastAccessTimeNow();
            MemoryListElement memoryListElement = null;
            defaultMemoryCacheImpl = this;
            synchronized (defaultMemoryCacheImpl) {
                MemoryListElement memoryListElement2 = new MemoryListElement(cacheElement);
                this.QOIV.addFirst(memoryListElement2);
                memoryListElement = this.map.put(((MemoryListElement)this.QOIV.getFirst()).ce.getKey(), (MemoryListElement)this.QOIV.getFirst());
                if (memoryListElement != null && ((MemoryListElement)this.QOIV.getFirst()).ce.getKey().equals(memoryListElement.ce.getKey())) {
                    this.QOIV.remove(memoryListElement);
                }
            }
        }
        if ((n = this.map.size()) <= this.I.getMaxObjects()) {
            return;
        }
        ServiceLogger.print(6670049);
        defaultMemoryCacheImpl = this;
        synchronized (defaultMemoryCacheImpl) {
            if (this.QOIV.getLast() != null) {
                if (((MemoryListElement)this.QOIV.getLast()).ce != null) {
                    if (!this.map.containsKey(((MemoryListElement)this.QOIV.getLast()).ce.getKey())) {
                        ServiceLogger.logError(3670050, ((MemoryListElement)this.QOIV.getLast()).ce.getKey(), 3);
                    }
                    if (this.map.remove(((MemoryListElement)this.QOIV.getLast()).ce.getKey()) == null) {
                        ServiceLogger.logError(3670051, ((MemoryListElement)this.QOIV.getLast()).ce.getKey(), 3);
                    }
                } else {
                    ServiceLogger.logError("Remove the object from cache failed since last.ce is null.", 3);
                }
                this.QOIV.removeLast();
            } else {
                ServiceLogger.logError("Remove the object from cache failed since last is null.", 3);
            }
        }
    }

    public CacheElement get(Object object) {
        CacheElement cacheElement = null;
        ServiceLogger.print(6670052, new Object[]{this.cacheName, object});
        MemoryListElement memoryListElement = (MemoryListElement)this.map.get(object);
        if (memoryListElement != null) {
            ServiceLogger.print(6670053, new Object[]{this.cacheName, object});
            cacheElement = memoryListElement.ce;
            cacheElement.getElementAttributes().setLastAccessTimeNow();
            this.QOIV.makeFirst(memoryListElement);
        } else {
            ServiceLogger.print(6670054, new Object[]{this.cacheName, object});
        }
        return cacheElement;
    }

    public boolean remove(Object object) {
        ServiceLogger.print(6670055, object);
        boolean bl = false;
        MemoryListElement memoryListElement = (MemoryListElement)this.map.remove(object);
        if (memoryListElement != null) {
            this.QOIV.remove(memoryListElement);
            bl = true;
        }
        return bl;
    }

    public CacheAttributes getCacheAttributes() {
        return this.I;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Default memory cache********************\n");
        stringBuffer.append("Cache attributes------------------------\n");
        stringBuffer.append(this.I.toString());
        stringBuffer.append("----------------------------------------\n");
        stringBuffer.append("The cache size now: " + this.map.size() + "\n");
        Object[] objectArray = this.getKeys();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            stringBuffer.append("The Element Key: " + object + "\n");
            ++n;
        }
        stringBuffer.append("****************************************\n");
        return stringBuffer.toString();
    }
}

