/*
 * Decompiled with CFR 0.152.
 */
package jet.server.cache.util;

import java.util.Comparator;

public class Heap {
    protected Object[] nodes;
    protected int count = 0;
    protected final Comparator cmp;

    public Heap(int n, Comparator comparator) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.nodes = new Object[n];
        this.cmp = comparator;
    }

    public Heap(int n) {
        this(n, null);
    }

    protected int compare(Object object, Object object2) {
        if (this.cmp == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return this.cmp.compare(object, object2);
    }

    protected final int parent(int n) {
        return (n - 1) / 2;
    }

    protected final int left(int n) {
        return 2 * n + 1;
    }

    protected final int right(int n) {
        return 2 * (n + 1);
    }

    public synchronized void insert(Object object) {
        int n;
        if (this.count >= this.nodes.length) {
            n = 3 * this.nodes.length / 2 + 1;
            Object[] objectArray = new Object[n];
            System.arraycopy(this.nodes, 0, objectArray, 0, this.nodes.length);
            this.nodes = objectArray;
        }
        n = this.count++;
        while (n > 0) {
            int n2 = this.parent(n);
            if (this.compare(object, this.nodes[n2]) >= 0) break;
            this.nodes[n] = this.nodes[n2];
            n = n2;
        }
        this.nodes[n] = object;
    }

    public synchronized Object extract() {
        int n;
        if (this.count < 1) {
            return null;
        }
        int n2 = 0;
        Object object = this.nodes[n2];
        --this.count;
        Object object2 = this.nodes[this.count];
        this.nodes[this.count] = null;
        while ((n = this.left(n2)) < this.count) {
            int n3;
            int n4 = this.right(n2);
            int n5 = n3 = n4 >= this.count || this.compare(this.nodes[n], this.nodes[n4]) < 0 ? n : n4;
            if (this.compare(object2, this.nodes[n3]) <= 0) break;
            this.nodes[n2] = this.nodes[n3];
            n2 = n3;
        }
        this.nodes[n2] = object2;
        return object;
    }

    public synchronized Object peek() {
        if (this.count > 0) {
            return this.nodes[0];
        }
        return null;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this.count) {
            this.nodes[n] = null;
            ++n;
        }
        this.count = 0;
    }
}

