/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import jet.connect.DbBigInt;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbDateTime;
import jet.connect.DbInteger;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.cs.CSUtil;
import jet.cs.CustomTaskManager;
import jet.server.log.ServiceLogger;

public class CompletedRecord {
    public static final int TASK_ID_COL = 1;
    public static final int CATFILE_COL = 2;
    public static final int RPTFILE_COL = 3;
    public static final int PARAMFILE_COL = 4;
    public static final int RESULTFILE_COL = 5;
    public static final int COMPLETED_TIME_COL = 6;
    public static final int SUBMITUSER_COL = 7;
    public static final int SUCCESSFUL_COL = 8;
    public static final int ERROR_COL = 9;
    public static final int TASK_CLASS_COL = 10;
    public static final int VERSION_ID_COL = 11;
    public static final int RECORD_ID_COL = 12;
    public static final int LAUNCH_TYPE_COL = 13;
    public static final int ENG_MSG_COL = 14;
    public static final int FORMAT_EXISTS_COL = 15;
    public static final int FORMAT_SUCCESSFUL_COL = 16;
    public static final int TASK_NAME_COL = 17;
    public static final int IS_MISSED_COL = 18;
    public static final int TRIGGER_COL = 19;
    public static final int LOGIC_COL = 20;
    public static final int RPTNAMES_COL = 21;
    DbValue[] QOIV = null;

    public CompletedRecord(DbValue[] dbValueArray) {
        this.QOIV = new DbValue[dbValueArray.length];
        int n = 0;
        while (n < dbValueArray.length) {
            this.QOIV[n] = (DbValue)dbValueArray[n].clone();
            ++n;
        }
    }

    public synchronized void setRecord(String string, String string2, String string3, String string4, String string5, Date date, String string6, boolean bl, long[] lArray, String string7, String string8, int n, String string9, int n2, String string10) throws SQLException {
        ((DbChar)this.QOIV[1]).set(string);
        ((DbChar)this.QOIV[2]).set(string2);
        ((DbChar)this.QOIV[3]).set(string3);
        ((DbChar)this.QOIV[4]).set(string4);
        ((DbChar)this.QOIV[5]).set(string5);
        ((DbChar)this.QOIV[7]).set(string6);
        ((DbChar)this.QOIV[9]).set(string7);
        ((DbChar)this.QOIV[10]).set(string8);
        ((DbInteger)this.QOIV[11]).set(n);
        ((DbTimestamp)this.QOIV[6]).set(date.getTime());
        ((DbBit)this.QOIV[8]).set(bl);
        if (lArray != null) {
            ((DbBigInt)this.QOIV[15]).set(lArray[0]);
            ((DbBigInt)this.QOIV[16]).set(lArray[1]);
        } else {
            ((DbBigInt)this.QOIV[15]).set(0L);
            ((DbBigInt)this.QOIV[16]).set(0L);
        }
        ((DbChar)this.QOIV[12]).set(string9);
        ((DbInteger)this.QOIV[13]).set(n2);
        ((DbChar)this.QOIV[14]).set(string10);
    }

    public DbValue[] getValues() {
        return this.QOIV;
    }

    public String getEngineMsg() throws SQLException {
        return ((DbChar)this.QOIV[14]).get();
    }

    public String getRecordId() throws SQLException {
        return ((DbChar)this.QOIV[12]).get();
    }

    public int getVersionId() throws SQLException {
        return ((DbInteger)this.QOIV[11]).get();
    }

    public String getCatFile() throws SQLException {
        return ((DbChar)this.QOIV[2]).get();
    }

    public String getReportFile() throws SQLException {
        return ((DbChar)this.QOIV[3]).get();
    }

    public String getReportNames() throws SQLException {
        return ((DbChar)this.QOIV[21]).get();
    }

    public String getParamFile() throws SQLException {
        return ((DbChar)this.QOIV[4]).get();
    }

    public String getResultFile() throws SQLException {
        return ((DbChar)this.QOIV[5]).get();
    }

    public String getTaskId() throws SQLException {
        return ((DbChar)this.QOIV[1]).get();
    }

    public String getSubmitUser() throws SQLException {
        return ((DbChar)this.QOIV[7]).get();
    }

    public Date getCompletedTime() throws SQLException {
        return ((DbTimestamp)this.QOIV[6]).toUtilDate();
    }

    public static Properties toProperties(DbValue[] dbValueArray, Properties properties) {
        String string;
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        if ((string = ((DbDateTime)dbValueArray[6]).toUtilDate().toString()) != null) {
            properties2.put("jrs.exe_date", string);
        }
        if ((string = dbValueArray[8].toString()) != null) {
            properties2.put("jrs.is_successful", string);
        }
        if ((string = dbValueArray[2].toString()) != null) {
            properties2.put("jrs.catalog", string);
        }
        if ((string = dbValueArray[3].toString()) != null) {
            properties2.put("jrs.report", string);
        }
        if ((string = dbValueArray[21].toString()) != null) {
            properties2.put("jrs.report_names", string);
        }
        if ((string = dbValueArray[4].toString()) != null) {
            properties2.put("jrs.param_file", string);
        }
        if ((string = dbValueArray[5].toString()) != null) {
            properties2.put("jrs.result", string);
        }
        if ((string = CSUtil.getLaunchTypeString(((DbInteger)dbValueArray[13]).intValue())) != null) {
            properties2.put("jrs.launch_type", string);
        }
        if ((string = dbValueArray[1].toString()) != null) {
            properties2.put("jrs.task_id", string);
        }
        string = dbValueArray[10].toString();
        try {
            String string2 = CustomTaskManager.getDisplayName(string);
            if (string2 != null) {
                string = string2;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        if (string != null) {
            properties2.put("jrs.task_class", string);
        }
        if ((string = dbValueArray[7].toString()) != null) {
            properties2.put("jrs.uid", string);
        }
        if ((string = dbValueArray[9].toString()) != null) {
            properties2.put("jrs.error", string);
        }
        if ((string = dbValueArray[12].toString()) != null) {
            properties2.put("jrs.id", string);
        }
        if ((string = dbValueArray[14].toString()) != null) {
            properties2.put("jrs.engine_message", string);
        }
        if ((string = String.valueOf(((DbBigInt)dbValueArray[15]).get())) != null) {
            properties2.put("jrs.format_exists_col", string);
        }
        if ((string = String.valueOf(((DbBigInt)dbValueArray[16]).get())) != null) {
            properties2.put("jrs.format_successful_col", string);
        }
        return properties2;
    }

    public static Hashtable toHashtable(DbValue[] dbValueArray, Hashtable hashtable) {
        String string;
        Hashtable<String, String> hashtable2 = hashtable;
        if (hashtable2 == null) {
            hashtable2 = new Hashtable<String, String>();
        }
        if ((string = ((DbDateTime)dbValueArray[6]).toUtilDate().toString()) != null) {
            hashtable2.put("jrs.exe_date", string);
        }
        if ((string = dbValueArray[8].toString()) != null) {
            hashtable2.put("jrs.is_successful", string);
        }
        if ((string = dbValueArray[2].toString()) != null) {
            hashtable2.put("jrs.catalog", string);
        }
        if ((string = dbValueArray[3].toString()) != null) {
            hashtable2.put("jrs.report", string);
        }
        if ((string = dbValueArray[21].toString()) != null) {
            hashtable2.put("jrs.report_names", string);
        }
        if ((string = dbValueArray[4].toString()) != null) {
            hashtable2.put("jrs.param_file", string);
        }
        if ((string = dbValueArray[5].toString()) != null) {
            hashtable2.put("jrs.result", string);
        }
        if ((string = CSUtil.getLaunchTypeString(((DbInteger)dbValueArray[13]).intValue())) != null) {
            hashtable2.put("jrs.launch_type", string);
        }
        if ((string = dbValueArray[1].toString()) != null) {
            hashtable2.put("jrs.task_id", string);
        }
        string = dbValueArray[10].toString();
        try {
            String string2 = CustomTaskManager.getDisplayName(string);
            if (string2 != null) {
                string = string2;
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        if (string != null) {
            hashtable2.put("jrs.task_class", string);
        }
        if ((string = dbValueArray[7].toString()) != null) {
            hashtable2.put("jrs.uid", string);
        }
        if ((string = dbValueArray[9].toString()) != null) {
            hashtable2.put("jrs.error", string);
        }
        if ((string = dbValueArray[12].toString()) != null) {
            hashtable2.put("jrs.id", string);
        }
        if ((string = dbValueArray[14].toString()) != null) {
            hashtable2.put("jrs.engine_message", string);
        }
        return hashtable2;
    }
}

