/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.cs.CustomTaskManager;
import jet.cs.TaskSuccInfo;
import jet.server.api.CompletedTaskRecord;
import jet.server.api.TaskSuccessInfo;
import jet.server.db.JRTaskSuccessInfo;

public class CompletedTaskRecordImpl
implements CompletedTaskRecord,
Serializable {
    protected int id = 0;
    protected String taskID = "";
    protected String taskName = "";
    protected String catalogFile = "";
    protected String reportFile = "";
    protected String paramFile = "";
    protected String results = "";
    protected Date completedTime = new Date();
    protected String submitter = "";
    protected boolean successful = false;
    protected String errorMessage = "";
    protected String taskClass = "";
    protected int versionID = -1;
    protected String completedRecordID = "";
    protected int launchType = -1;
    protected String engineStatus = "";
    protected long formatExists = 0L;
    protected long formatSuccessful = 0L;
    protected boolean missed = false;
    protected String trigger = "";
    protected String logic = "";
    protected String rptNames = "";
    private JRTaskSuccessInfo taskSuccInfo = null;
    protected Hashtable publishRecords = null;

    public CompletedTaskRecordImpl() {
    }

    public CompletedTaskRecordImpl(String string, String string2, String string3, String string4, String string5, Date date, String string6, boolean bl, String string7, String string8, int n, String string9, int n2, String string10, long l, long l2, String string11) {
        this.taskID = string == null ? "" : string;
        this.catalogFile = string2 == null ? "" : string2;
        this.reportFile = string3 == null ? "" : string3;
        this.paramFile = string4 == null ? "" : string4;
        this.results = string5 == null ? "" : string5;
        this.completedTime = date == null ? new Date() : date;
        this.submitter = string6 == null ? "" : string6;
        this.successful = bl;
        this.errorMessage = string7 == null ? "" : string7;
        this.taskClass = string8 == null ? "" : string8;
        this.versionID = n;
        this.completedRecordID = string9 == null ? "" : string9;
        this.launchType = n2;
        this.engineStatus = string10 == null ? "" : string10;
        this.formatExists = l;
        this.formatSuccessful = l2;
        this.taskName = string11 == null ? "" : string11;
    }

    public CompletedTaskRecordImpl(String string, String string2, String string3, String string4, String string5, Date date, String string6, boolean bl, String string7, String string8, int n, String string9, int n2, String string10, long l, long l2, String string11, boolean bl2, Hashtable hashtable) {
        this.taskID = string == null ? "" : string;
        this.catalogFile = string2 == null ? "" : string2;
        this.reportFile = string3 == null ? "" : string3;
        this.paramFile = string4 == null ? "" : string4;
        this.results = string5 == null ? "" : string5;
        this.completedTime = date == null ? new Date() : date;
        this.submitter = string6 == null ? "" : string6;
        this.successful = bl;
        this.errorMessage = string7 == null ? "" : string7;
        this.taskClass = string8 == null ? "" : string8;
        this.versionID = n;
        this.completedRecordID = string9 == null ? "" : string9;
        this.launchType = n2;
        this.engineStatus = string10 == null ? "" : string10;
        this.formatExists = l;
        this.formatSuccessful = l2;
        this.taskName = string11 == null ? "" : string11;
        this.missed = bl2;
        this.publishRecords = hashtable;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getCatalogFile() {
        return this.catalogFile;
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public String getParamFile() {
        if (this.paramFile != null && !this.paramFile.equalsIgnoreCase("null")) {
            return this.paramFile;
        }
        return "";
    }

    public String getResults() {
        return this.results;
    }

    public Date getCompletedTime() {
        return this.completedTime;
    }

    public String getSubmitter() {
        return this.submitter;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getTaskClass() {
        return this.taskClass;
    }

    public String getVersionID() {
        return String.valueOf(this.versionID);
    }

    public String getCompletedRecordID() {
        return this.completedRecordID;
    }

    public int getLaunchType() {
        return this.launchType;
    }

    public String getEngineStatus() {
        return this.engineStatus;
    }

    public TaskSuccessInfo getSuccessInfo() {
        if (this.taskSuccInfo == null) {
            TaskSuccInfo taskSuccInfo = new TaskSuccInfo(this.formatExists, this.formatSuccessful);
            this.taskSuccInfo = new JRTaskSuccessInfo(taskSuccInfo, this.publishRecords);
        }
        return this.taskSuccInfo;
    }

    public Properties toProperties(Properties properties) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.task_id", this.taskID);
        properties2.put("jrs.schedule_name", this.taskName == null ? "" : this.taskName);
        properties2.put("jrs.catalog", this.catalogFile == null ? "" : this.catalogFile);
        properties2.put("jrs.report", this.reportFile == null ? "" : this.reportFile);
        if (this.rptNames != null) {
            properties2.put("jrs.report_names", this.rptNames);
        }
        properties2.put("jrs.param_file", this.paramFile == null ? "" : this.paramFile);
        properties2.put("jrs.result", this.results);
        properties2.put("jrs.exe_date", CSUtil.commonDateFormator.format(this.completedTime));
        properties2.put("jrs.uid", this.submitter);
        properties2.put("jrs.is_successful", String.valueOf(this.successful));
        properties2.put("jrs.error", this.errorMessage);
        try {
            properties2.put("jrs.task_class", CustomTaskManager.getDisplayName(this.taskClass));
        }
        catch (Exception exception) {
            properties2.put("jrs.task_class", this.taskClass);
        }
        properties2.put("jrs.version_id", String.valueOf(this.versionID));
        properties2.put("jrs.id", this.completedRecordID);
        properties2.put("jrs.launch_type", CSUtil.getLaunchTypeString(this.launchType));
        properties2.put("jrs.engine_message", this.engineStatus);
        properties2.put("jrs.format_exists_col", String.valueOf(this.formatExists));
        properties2.put("jrs.format_successful_col", String.valueOf(this.formatSuccessful));
        properties2.setProperty("jrs.triggers", this.getTrigger());
        properties2.setProperty("jrs.triggers.logic", this.getLogicOfConditions());
        return properties2;
    }

    public boolean isMissed() {
        return this.missed;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public String getLogicOfConditions() {
        return this.logic;
    }

    public String getReportNames() {
        return this.rptNames;
    }
}

