/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.db.ConnectionImpl;
import jet.server.db.Pool;
import jet.server.log.ServiceLogger;

public class ConnectionPool
implements Pool {
    private String QOIV = null;
    private String addElement = null;
    private String close = null;
    private String elementAt = null;
    private int emptyPool = 10;
    private int forName;
    private int getConnection;
    private int getProperty = 50;
    private int getUsedCount = 3600;
    private long incrCount;
    private int indexOf = -1;
    private Vector isEmpty = null;
    private Vector logError = null;

    public ConnectionPool(Properties properties) throws SQLException, ClassNotFoundException {
        this.QOIV = properties.getProperty("Driver", "");
        this.addElement = properties.getProperty("URL", "");
        this.close = properties.getProperty("User", "");
        this.elementAt = properties.getProperty("Password", "");
        this.emptyPool = CSUtil.parseInt(properties.getProperty("MIN_SIZE", ""), 10);
        this.forName = CSUtil.parseInt(properties.getProperty("MAX_HOLD", ""), 100);
        this.getProperty = CSUtil.parseInt(properties.getProperty("MAX_USED", ""), 50);
        this.incrCount = CSUtil.parseLong(properties.getProperty("MAX_LIFE", ""), 3600L);
        Class.forName(this.QOIV);
        this.isEmpty = new Vector(this.emptyPool);
        int n = 0;
        while (n < this.emptyPool) {
            Connection connection = DriverManager.getConnection(this.addElement, this.close, this.elementAt);
            this.isEmpty.addElement(ConnectionImpl.getConnection(connection, this));
            ++n;
        }
        this.getConnection = this.isEmpty.size();
        this.logError = new Vector();
    }

    public synchronized ConnectionImpl getConnection() throws SQLException {
        ConnectionImpl connectionImpl = null;
        if (!this.isEmpty.isEmpty()) {
            connectionImpl = (ConnectionImpl)this.isEmpty.elementAt(0);
            this.isEmpty.removeElementAt(0);
            this.logError.addElement(connectionImpl);
            return connectionImpl;
        }
        if (this.getConnection < this.forName) {
            Connection connection = DriverManager.getConnection(this.addElement, this.close, this.elementAt);
            connectionImpl = ConnectionImpl.getConnection(connection, this);
            connectionImpl.incrCount();
            ++this.getConnection;
            this.logError.addElement(connectionImpl);
            return connectionImpl;
        }
        try {
            this.wait();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
        return this.getConnection();
    }

    public void returnConnection(ConnectionImpl connectionImpl) throws SQLException {
        if (this.isEmpty.indexOf(connectionImpl) != -1) {
            return;
        }
        if (connectionImpl instanceof ConnectionImpl) {
            ConnectionImpl connectionImpl2 = connectionImpl;
            if (connectionImpl2.getUsedCount() > this.getProperty) {
                connectionImpl2.getConnection().close();
                --this.getConnection;
                if (this.getConnection < this.emptyPool) {
                    Connection connection = DriverManager.getConnection(this.addElement, this.close, this.elementAt);
                    this.isEmpty.addElement(ConnectionImpl.getConnection(connection, this));
                    ++this.getConnection;
                }
            } else {
                this.isEmpty.addElement(connectionImpl);
                if (this.logError.indexOf(connectionImpl) != -1) {
                    this.logError.removeElement(connectionImpl);
                }
            }
        }
    }

    public void emptyPool() throws SQLException {
        ConnectionImpl connectionImpl = null;
        while (!this.isEmpty.isEmpty()) {
            connectionImpl = (ConnectionImpl)this.isEmpty.elementAt(0);
            this.isEmpty.removeElementAt(0);
            connectionImpl.getConnection().close();
        }
        while (!this.logError.isEmpty()) {
            connectionImpl = (ConnectionImpl)this.logError.elementAt(0);
            this.logError.removeElementAt(0);
            connectionImpl.getConnection().close();
        }
        this.getConnection = 0;
    }

    public int getPoolSize() {
        return this.isEmpty.size();
    }

    public int getConnectionCount() {
        return this.getConnection;
    }

    public void finalize() {
        try {
            this.emptyPool();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
    }
}

