/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import jet.connect.jdbms.IndexFile;
import jet.server.log.ServiceLogger;

public class TableIndexManager {
    private String QOIV = "";
    private String addElement = "";
    private int addRecord = 0;
    private IndexFile append = null;
    private int close = 0;
    private int commit = 0;

    public TableIndexManager(String string, String string2, String string3, int n) throws IOException {
        this.append = new IndexFile(string, string2 + ".idx");
        this.QOIV = string2;
        this.addElement = string3;
        this.close = n;
        int n2 = this.append.getRealRecordCount();
        this.commit = n2 / n + 1;
        this.addRecord = n2 % n;
    }

    public int getRealRecordCount() {
        return this.append.getRealRecordCount();
    }

    public int getAvailableRecordCount() {
        return this.append.getAvailableRecordCount();
    }

    public int getSubtableCount() {
        return this.commit;
    }

    public String getAppendTableName() {
        return this.addElement(this.commit - 1);
    }

    public String getOldestSubtableName() {
        int n = this.QOIV();
        if (n < this.commit) {
            return this.addElement(n);
        }
        return null;
    }

    private int QOIV() {
        int n = 0;
        while (n < this.commit) {
            if (this.append.getRecordCountByTableID(n) > 0) break;
            ++n;
        }
        return n;
    }

    public Enumeration getAllTableNames() {
        Vector<String> vector = new Vector<String>();
        int n = this.commit - 1;
        while (n >= this.QOIV()) {
            vector.addElement(this.addElement(n));
            --n;
        }
        return vector.elements();
    }

    public void addIndex(String string, String string2) throws IOException {
        this.append.addRecord(string, this.addRecord(string2));
        ++this.addRecord;
    }

    public boolean appendTableFull() {
        if (this.addRecord == this.close) {
            this.addRecord = 0;
            ++this.commit;
            return true;
        }
        return false;
    }

    public void deleteIndex(String string) throws IOException {
        this.append.deleteByID(string);
    }

    public void commitIndexFile() throws IOException {
        this.append.commit();
    }

    public void close() {
        this.append.close();
    }

    public String getTableNameById(String string) {
        int n = this.append.getTableIDByID(string);
        if (n == -1) {
            return null;
        }
        return this.addElement(n);
    }

    public void deleteAllIndexRecord() {
        try {
            this.append.deleteAllRecords();
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 3);
        }
        int n = this.append.getRealRecordCount();
        this.commit = n / this.close + 1;
        this.addRecord = n % this.close;
    }

    private String addElement(int n) {
        return this.QOIV + String.valueOf(n) + this.addElement;
    }

    private int addRecord(String string) {
        String string2 = string.substring(this.QOIV.length(), string.indexOf("."));
        return Integer.parseInt(string2);
    }
}

