/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jet.JCliResource;
import jet.cs.CSUtil;
import jet.cs.PrefixFilenameFilter;
import jet.server.ServerEnv;
import jet.server.db.ExpirationManager;
import jet.server.db.VersionAmountRecord;
import jet.server.db.VersionAmountRecordContainer;
import jet.server.db.VersionAmountRecordContainerImpl;
import jet.server.db.VersionController;
import jet.server.db.VersionManager;
import jet.server.db.VersionRecord;
import jet.server.jrc.JRSchedulingService;
import jet.server.jrc.param.ParameterFileManager;
import jet.server.log.ServiceLogger;
import jet.server.schedule.JRResultFiles;
import jet.server.schedule.ResultFolderManager;
import jet.server.schedule.SchdTools;

public class VersionControllerImpl
extends UnicastRemoteObject
implements VersionController,
Runnable {
    VersionManager QOIV;
    ExpirationManager addVersion;
    VersionAmountRecordContainerImpl adjustVersions;
    String append = null;
    JRSchedulingService close = null;
    ResultFolderManager commit = null;
    boolean compareWith = false;

    public VersionControllerImpl(JRSchedulingService jRSchedulingService, boolean bl) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.close = jRSchedulingService;
        this.QOIV = new VersionManager(bl);
        this.addVersion = new ExpirationManager(this, jRSchedulingService);
        this.adjustVersions = new VersionAmountRecordContainerImpl();
    }

    public VersionAmountRecordContainer getVersionAmountContainer() {
        return this.adjustVersions;
    }

    public void publishResultToVersion(String string, String string2, String string3, String string4, String string5, Properties properties, String string6) throws RemoteException {
        Object object;
        String string7;
        Object object2;
        String string8 = CSUtil.getNameWithoutExt(string2);
        String string9 = this.commit.getNextResultName(string8);
        if (string9 == null) {
            throw new ServerException(JCliResource.getMessage("CS_ERR_47"));
        }
        int n = string9.lastIndexOf(File.separator);
        String string10 = string9.substring(n);
        String string11 = string9 + string10;
        String string12 = CSUtil.getNameWithoutExt(string3);
        String string13 = CSUtil.getExtName(string3);
        JRResultFiles jRResultFiles = new JRResultFiles(string11, string13);
        int n2 = string12.indexOf(95);
        if (n2 != -1) {
            string12 = string12.substring(0, n2);
        }
        String string14 = string5 + string11;
        int n3 = string12.length();
        File file = new File(string4);
        PrefixFilenameFilter prefixFilenameFilter = new PrefixFilenameFilter(string12);
        String[] stringArray = file.list(prefixFilenameFilter);
        int n4 = stringArray.length;
        if (n4 > 0) {
            int n5 = 0;
            while (n5 < n4) {
                String string15 = string14 + stringArray[n5].substring(n3);
                SchdTools.copyFile(new File(string4 + stringArray[n5]), new File(string15));
                if (CSUtil.getExtName(stringArray[n5]).equals(".html")) {
                    object2 = string11.substring(string11.lastIndexOf(File.separator) + 1, string11.length());
                    SchdTools.replaceStringInFile(string15, string12, (String)object2);
                }
                ++n5;
            }
        }
        String string16 = null;
        object2 = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (properties != null) {
                string16 = string11 + ".param";
                object2 = new File(string5, string16);
                fileOutputStream = new FileOutputStream((File)object2);
                string7 = null;
                CSUtil.evalExpressionValues(properties);
                object = properties.keys();
                while (object.hasMoreElements()) {
                    string7 = (String)object.nextElement();
                    Object object3 = properties.get(string7);
                    fileOutputStream.write((string7 + "=" + object3 + "\n").getBytes());
                }
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException2) {
                    ServiceLogger.logError(iOException, 3);
                }
            }
            ServiceLogger.logError(iOException, 2);
            throw new ServerException("", iOException);
        }
        string7 = string11 + string13;
        object = string4 + CSUtil.getNameWithoutExt(string3) + ".rst";
        if (new File((String)object).exists()) {
            string7 = string11 + ".rst";
        }
        this.addVersion(string, string2, string16, jRResultFiles.getSharedPrefix(), jRResultFiles.getResultFormats(), new Date(), string6, false, null, null, 0, null);
    }

    public Vector adjustVersions(String string, String string2, String string3) throws RemoteException {
        Vector vector = null;
        vector = this.getVersions(string, string2, null, null, null, -1, null);
        int n = this.adjustVersions.getMaxAmount(string, string2);
        int n2 = vector.size();
        if (n > 0 && n2 > n) {
            VersionRecord versionRecord = null;
            int n3 = 0;
            while (n3 < n2 - n) {
                versionRecord = this.min(vector);
                if (versionRecord != null) {
                    this.removeVersion(versionRecord);
                    vector.removeElement(versionRecord);
                }
                ++n3;
            }
        }
        return vector;
    }

    private VersionRecord min(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        VersionRecord versionRecord = (VersionRecord)enumeration.nextElement();
        VersionRecord versionRecord2 = null;
        while (enumeration.hasMoreElements()) {
            versionRecord2 = (VersionRecord)enumeration.nextElement();
            if (versionRecord2.compareWith(versionRecord) >= 0) continue;
            versionRecord = versionRecord2;
        }
        return versionRecord;
    }

    public VersionRecord addVersion(String string, String string2, String string3, String string4, long l, Date date, String string5, boolean bl, Date date2, String string6, int n, String string7) throws RemoteException {
        try {
            VersionRecord versionRecord;
            String string8 = string;
            if (string8 != null && !string8.equals("/") && string8.endsWith("/")) {
                string8 = string8.substring(0, string8.length() - 1);
            }
            if ((versionRecord = this.QOIV.addVersion(string8, string2, string3, string4, l, date, string5, bl, date2, string6, n, string7)) != null && bl) {
                this.addVersion.addVersion(versionRecord.getVersionId(), date2);
            }
            return versionRecord;
        }
        catch (SQLException sQLException) {
            throw new ServerException("", sQLException);
        }
    }

    public void removeVersion(VersionRecord versionRecord) {
        String string = null;
        String string2 = null;
        String string3 = null;
        long l = 0L;
        String string4 = null;
        Date date = null;
        Date date2 = null;
        int n = -1;
        int n2 = -1;
        String string5 = null;
        String string6 = null;
        try {
            string = versionRecord.getCatFile();
            string2 = versionRecord.getReportFile();
            string3 = versionRecord.getResultFile();
            l = versionRecord.getResultFormats();
            string4 = versionRecord.getParamFile();
            date = versionRecord.getGenerateTime();
            date2 = versionRecord.getExpirationTime();
            n2 = versionRecord.getLaunchType();
            string5 = versionRecord.getTaskId();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        try {
            n = versionRecord.getVersionId();
            this.QOIV.removeVersion(versionRecord);
            this.addVersion.removeVersion(n);
            String string7 = null;
            if (l == 0L) {
                string7 = string3;
            } else {
                int n3 = string3.lastIndexOf(File.separator);
                String string8 = null;
                if (n3 != -1) {
                    string8 = string3.substring(0, n3);
                    if ((n3 = string8.lastIndexOf(File.separator)) != -1) {
                        string6 = string8.substring(0, n3);
                    }
                } else {
                    string8 = string3;
                }
                string7 = string8;
            }
            if (string7 != null && string7.length() > 0) {
                try {
                    if (l != 0L) {
                        if (this.append != null) {
                            string7 = this.append + string7;
                        }
                        SchdTools.deleteDir(string7);
                        if (string6 != null) {
                            this.commit.decreaseResultAmount(string6);
                        }
                    } else {
                        int n4;
                        int n5 = string7.lastIndexOf(File.separator);
                        File file = n5 < 0 ? (this.append != null ? new File(this.append) : new File("")) : new File(string7.substring(0, n5));
                        String string9 = CSUtil.getNameWithoutExt(string7);
                        File file2 = new File(file, string9);
                        if (file2.exists()) {
                            file2.delete();
                        }
                        PrefixFilenameFilter prefixFilenameFilter = new PrefixFilenameFilter(string9 + "_");
                        String[] stringArray = file.list(prefixFilenameFilter);
                        int n6 = 0;
                        if (stringArray != null) {
                            n6 = stringArray.length;
                            n4 = 0;
                            while (n4 < n6) {
                                new File(file, stringArray[n4]).delete();
                                ++n4;
                            }
                        }
                        if ((stringArray = file.list(prefixFilenameFilter = new PrefixFilenameFilter(string9 + "."))) != null) {
                            n6 = stringArray.length;
                            n4 = 0;
                            while (n4 < n6) {
                                if (!CSUtil.getExtName(stringArray[n4]).equalsIgnoreCase(".param")) {
                                    new File(file, stringArray[n4]).delete();
                                }
                                ++n4;
                            }
                        }
                    }
                    ParameterFileManager.getInstance().delete(string4);
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    public void removeVersion(int n) throws RemoteException {
        VersionRecord versionRecord = this.getVersion(n);
        if (versionRecord != null) {
            this.removeVersion(versionRecord);
        }
    }

    public VersionRecord getVersion(int n) throws RemoteException {
        return this.QOIV.getVersion(n);
    }

    public Vector getVersions(String string, String string2, String string3, Date date, String string4, int n, String string5) throws RemoteException {
        String string6 = string;
        if (string6 != null && !string6.equals("/") && string6.endsWith("/")) {
            string6 = string6.substring(0, string6.length() - 1);
        }
        return this.QOIV.getVersions(string6, string2, string3, date, string4, n, string5);
    }

    public Vector getVersions() throws RemoteException {
        return this.QOIV.getVersions();
    }

    public void shutdown() {
        this.compareWith = true;
        this.QOIV.I.close();
        this.adjustVersions.disconnect();
    }

    public void setVersionDir(String string) {
        this.append = string;
        this.commit = new ResultFolderManager(string, ServerEnv.getMaxVersionAmountPerSubfolder());
        Thread thread = new Thread(this);
        thread.setPriority(1);
        thread.start();
    }

    public ResultFolderManager getResultFolderManager() {
        return this.commit;
    }

    public synchronized void commit() throws RemoteException {
        try {
            this.QOIV.I.commit();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
            throw new ServerException("", exception);
        }
    }

    public boolean isCommitted() {
        return this.QOIV.I.isCommitted();
    }

    public long getLastModify() {
        return this.QOIV.I.getLastModify();
    }

    private synchronized void QOIV() {
        Vector vector = this.adjustVersions.getVersionAmountRecords();
        if (vector != null && vector.size() != 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                VersionAmountRecord versionAmountRecord = (VersionAmountRecord)enumeration.nextElement();
                try {
                    this.adjustVersions(versionAmountRecord.getCatFile(), versionAmountRecord.getReportFile(), null);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
            }
        }
    }

    public void run() {
        while (!this.compareWith) {
            try {
                Thread.sleep(900000L);
            }
            catch (InterruptedException interruptedException) {
                ServiceLogger.logError(interruptedException, 3);
            }
            if (this.compareWith) continue;
            this.QOIV();
        }
    }
}

