/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jet.JSvrResource;
import jet.connect.DbInteger;
import jet.connect.DbValue;
import jet.connect.jdbms.JDbConnection;
import jet.connect.jdbms.JDbTableDesc;
import jet.connect.jdbms.JDbTables;
import jet.connect.jdbms.JResultSet;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.db.TableIndexManager;
import jet.server.db.VersionRecord;
import jet.server.log.ServiceLogger;
import jet.server.schedule.CommitRunner;
import jet.server.schedule.Committer;
import jet.server.schedule.SchdTools;
import jet.util.IntKeyHashtable;

public class VersionRecordContainer
implements Committer {
    private String C = "";
    private JDbTableDesc QOIV = null;
    private JDbConnection addElement = null;
    IntKeyHashtable addIndex = new IntKeyHashtable();
    JResultSet addVersionRecord = null;
    boolean append = false;
    boolean appendTableFull = false;
    private TableIndexManager checkTable = null;
    private CommitRunner close = null;
    int commit = 0;
    long commitIndexFile = -1L;
    private long connect = 0L;
    private boolean copyFile = true;
    private boolean createTable = false;
    private File currentTimeMillis = null;
    private File delete = null;
    private File deleteAllIndexRecord = null;
    String deleteIndex = null;
    VersionRecordContainer disconnect = null;
    private String elementAt = "";
    private String endsWith = "";
    private String equals = "";

    public VersionRecordContainer(boolean bl, String string, String string2, String string3) {
        this.elementAt = string2;
        this.endsWith = string3;
        this.equals = string;
        File file = new File(this.equals, "version");
        this.C = file.exists() ? "version" : "version.jtb";
        this.append = bl;
        try {
            this.checkTable = new TableIndexManager(this.equals, "version", ".jtb", 1620);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        this.appendTableFull();
        this.connect();
        this.deleteIndex = this.checkTable.getAppendTableName();
        this.disconnect = this.createTable(true, this.deleteIndex);
    }

    public VersionRecordContainer(boolean bl) {
        this.C = "version.jtb";
        this.append = bl;
        this.endsWith = ServerEnv.getActiveRealm();
        this.equals = ServerEnv.propertiesPath;
        try {
            this.checkTable = new TableIndexManager(this.equals, "version", ".jtb", 1620);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        this.appendTableFull();
        this.connect();
        this.deleteIndex = this.checkTable.getAppendTableName();
        this.disconnect = this.createTable(true, this.deleteIndex);
    }

    public VersionRecordContainer(boolean bl, String string) {
        this.append = bl;
        this.appendTableFull = true;
        this.endsWith = ServerEnv.getActiveRealm();
        this.equals = ServerEnv.propertiesPath;
        this.C = string;
        this.appendTableFull();
        this.connect();
        if (bl) {
            this.loadAllVersionRecords();
        }
    }

    public VersionRecordContainer(boolean bl, String string, String string2, String string3, String string4) {
        this.append = bl;
        this.appendTableFull = true;
        this.elementAt = string3;
        this.endsWith = string4;
        this.equals = string2;
        this.C = string;
        this.appendTableFull();
        this.connect();
        if (bl) {
            this.loadAllVersionRecords();
        }
    }

    public void init() {
        this.QOIV();
        this.addElement();
    }

    private ExProperties C() {
        String string = this.elementAt + this.endsWith + File.separator + "resource.alias";
        ExProperties exProperties = new ExProperties();
        if (new File(string).exists()) {
            try {
                exProperties.load(string);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return exProperties;
    }

    private void QOIV() {
        try {
            VersionRecordContainer versionRecordContainer = this.createTable(false, "version");
            Vector vector = versionRecordContainer.getVersionRecords();
            versionRecordContainer.close();
            if (vector.size() == 0) {
                return;
            }
            File file = new File(this.equals, "version");
            File file2 = new File(this.equals, "version.OldVersion");
            SchdTools.copyFile(file, file2);
            file.delete();
            String string = this.endsWith;
            ExProperties exProperties = this.C();
            int n = vector.size();
            int n2 = 0;
            System.out.println(JSvrResource.getMessage("SVR_80", "version"));
            int n3 = 0;
            while (n3 < vector.size()) {
                String string2;
                VersionRecord versionRecord = (VersionRecord)vector.elementAt(n3);
                String string3 = versionRecord.getCatFile();
                String string4 = null;
                int n4 = 0;
                String string5 = null;
                String string6 = null;
                Enumeration<Object> enumeration = exProperties.keys();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    String string7 = exProperties.getProperty(string2);
                    if (string7.equalsIgnoreCase(string3)) {
                        string4 = string2;
                        break;
                    }
                    if (!string3.startsWith(string7) || string7.length() <= n4) continue;
                    n4 = string7.length();
                    string5 = string2;
                    string6 = string7;
                }
                if (string4 == null) {
                    if (string5 != null) {
                        string2 = string3.substring(n4 + 1);
                        string2 = string2.replace(File.separatorChar, '/');
                        string4 = !string5.endsWith("/") && !string2.startsWith("/") ? string5 + "/" + string2 : (string5.endsWith("/") && string2.startsWith("/") ? string5 + string2.substring(1) : string5 + string2);
                        if (string4.endsWith("/")) {
                            string4 = string4.substring(0, string4.length() - 1);
                        }
                    } else {
                        string4 = string3;
                    }
                }
                this.addVersionRecord(versionRecord.getVersionId(), string4, CSUtil.getFileNameOnly(versionRecord.getReportFile()), CSUtil.getFileNameOnly(versionRecord.getParamFile()), CSUtil.getFileNameOnly(versionRecord.getResultFile()), versionRecord.getResultFormats(), versionRecord.getGenerateTime(), versionRecord.getSubmitUser(), versionRecord.getExpire(), versionRecord.getExpirationTime(), versionRecord.getVersionName(), versionRecord.getLaunchType(), versionRecord.getTaskId());
                int n5 = ++n2 * 100 / n;
                if (n5 <= 98) {
                    System.out.print(JSvrResource.getMessage("SVR_81", String.valueOf(n5)));
                }
                ++n3;
            }
            System.out.print(JSvrResource.getMessage("SVR_81", "99"));
            this.commit();
            System.out.println(JSvrResource.getMessage("SVR_82", "version"));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private void addElement() {
        if (this.checkTable.getRealRecordCount() - this.checkTable.getAvailableRecordCount() >= 540) {
            try {
                Vector vector = this.getVersionRecords();
                this.addIndex();
                int n = 0;
                while (n < vector.size()) {
                    VersionRecord versionRecord = (VersionRecord)vector.elementAt(n);
                    this.addVersionRecord(versionRecord.getVersionId(), versionRecord.getCatFile(), versionRecord.getReportFile(), versionRecord.getParamFile(), versionRecord.getResultFile(), versionRecord.getResultFormats(), versionRecord.getGenerateTime(), versionRecord.getSubmitUser(), versionRecord.getExpire(), versionRecord.getExpirationTime(), versionRecord.getVersionName(), versionRecord.getLaunchType(), versionRecord.getTaskId());
                    ++n;
                }
                this.commit();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
    }

    private synchronized boolean addIndex() {
        if (!this.appendTableFull) {
            boolean bl = true;
            Enumeration enumeration = this.checkTable.getAllTableNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl2 = string.equals(this.disconnect.getName()) ? this.disconnect.addIndex() : this.createTable(false, string).addIndex();
                if (bl2) continue;
                bl = false;
                ServiceLogger.logError(2640003, string, 2);
            }
            this.checkTable.deleteAllIndexRecord();
            this.deleteIndex = this.checkTable.getAppendTableName();
            this.disconnect = this.createTable(false, this.deleteIndex);
            return bl;
        }
        try {
            this.commit();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        this.close();
        File file = new File(this.equals, this.C);
        return file.delete();
    }

    private void addVersionRecord() {
        if (this.close == null && ServerEnv.isCommitInThread()) {
            this.close = new CommitRunner(this);
        }
    }

    private void append() {
        if (this.close != null) {
            this.close.stop();
            this.close = null;
        }
    }

    public String getName() {
        return this.C;
    }

    private void appendTableFull() {
        try {
            JDbTableDesc jDbTableDesc = new JDbTableDesc(this.equals, this.C, 11, 180, 3);
            jDbTableDesc.setColumnDesc(1, "VersionId", 4, 0, 10, 0, false);
            jDbTableDesc.setColumnDesc(2, "CatFile", 1, 255, 0, 0, false);
            jDbTableDesc.setColumnDesc(3, "RptFile", 1, 255, 0, 0, false);
            jDbTableDesc.setColumnDesc(4, "ParamFile", 1, 255, 0, 1, false);
            jDbTableDesc.setColumnDesc(5, "ResultFile", 1, 255, 0, 0, false);
            jDbTableDesc.setColumnDesc(6, "CreateDate", 93, 19, 0, 0, false);
            jDbTableDesc.setColumnDesc(7, "SubmitUser", 1, 255, 0, 0, false);
            jDbTableDesc.setColumnDesc(8, "Expire", -7, 1, 0, 0, false);
            jDbTableDesc.setColumnDesc(9, "ExpireDate", 93, 19, 0, 1, false);
            jDbTableDesc.setColumnDesc(10, "VersionName", 1, 255, 0, 1, false);
            jDbTableDesc.setNewColDescs(14);
            jDbTableDesc.setNewColumnDesc(1, "VersionId", 4, 0, 10, 0, false);
            jDbTableDesc.setNewColumnDesc(2, "CatFile", 1, 255, 0, 0, false);
            jDbTableDesc.setNewColumnDesc(3, "RptFile", 1, 255, 0, 0, false);
            jDbTableDesc.setNewColumnDesc(4, "ParamFile", 1, 255, 0, 1, false);
            jDbTableDesc.setNewColumnDesc(5, "ResultFile", 1, 255, 0, 0, false);
            jDbTableDesc.setNewColumnDesc(6, "CreateDate", 93, 19, 0, 0, false);
            jDbTableDesc.setNewColumnDesc(7, "SubmitUser", 1, 255, 0, 0, false);
            jDbTableDesc.setNewColumnDesc(8, "Expire", -7, 1, 0, 0, false);
            jDbTableDesc.setNewColumnDesc(9, "ExpireDate", 93, 19, 0, 1, false);
            jDbTableDesc.setNewColumnDesc(10, "VersionName", 1, 255, 0, 1, false);
            jDbTableDesc.setNewColumnDesc(11, "LaunchType", 4, 0, 10, 1, false);
            jDbTableDesc.setNewColumnDesc(12, "TaskId", 1, 255, 0, 1, false);
            jDbTableDesc.setNewColumnDesc(13, "ResultFormats", -5, 0, 10, 1, false);
            if (!jDbTableDesc.isUpgraded()) {
                jDbTableDesc.upgrade();
            }
            JDbTables.createTable(jDbTableDesc);
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
    }

    protected void connect() {
        try {
            String string = this.equals;
            File file = new File(string);
            this.checkTable(file, this.C);
            if (this.appendTableFull) {
                this.addElement = JDbConnection.connect(file, this.C, 180, 3);
                this.addVersionRecord = this.addElement.select(null);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    protected boolean checkTable(File file, String string) {
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file.exists()) {
            File file2 = new File(file.getPath(), string);
            this.connect = file2.length();
            this.currentTimeMillis = new File(file.getPath(), string + ".bak");
            this.delete = new File(file.getPath(), string + ".old");
            this.deleteAllIndexRecord = new File(file.getPath(), string + ".old2");
            if (!file2.exists()) {
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
                    randomAccessFile.writeInt(8);
                    randomAccessFile.writeInt(0);
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            try {
                if (!this.currentTimeMillis.exists()) {
                    SchdTools.copyFile(file2, this.currentTimeMillis);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            return true;
        }
        return false;
    }

    public synchronized void close() {
        if (!this.appendTableFull) {
            this.disconnect.close();
            this.checkTable.close();
            return;
        }
        this.disconnect();
    }

    protected void disconnect() {
        try {
            if (this.close != null) {
                this.close.stop();
            }
            this.addElement.disconnect();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (this.createTable && this.currentTimeMillis != null && this.delete != null && this.currentTimeMillis.exists()) {
            try {
                if (this.delete.exists()) {
                    if (this.deleteAllIndexRecord.exists()) {
                        this.deleteAllIndexRecord.delete();
                    }
                    this.delete.renameTo(this.deleteAllIndexRecord);
                }
                this.currentTimeMillis.renameTo(this.delete);
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        }
    }

    private void checkTable() {
        String string = this.disconnect.getName();
        if (!this.deleteIndex.equals(string) || this.deleteIndex.equals(string) && this.checkTable.appendTableFull()) {
            try {
                this.disconnect.commit();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            this.disconnect.close();
            this.deleteIndex = this.checkTable.getAppendTableName();
            this.disconnect = this.createTable(true, this.deleteIndex);
        }
    }

    public synchronized VersionRecord addVersionRecord(int n, String string, String string2, String string3, String string4, long l, Date date, String string5, boolean bl, Date date2, String string6, int n2, String string7) {
        if (!this.appendTableFull) {
            VersionRecord versionRecord = null;
            this.checkTable();
            versionRecord = this.disconnect.addVersionRecord(n, string, string2, string3, string4, l, date, string5, bl, date2, string6, n2, string7);
            if (versionRecord != null) {
                try {
                    this.checkTable.addIndex(String.valueOf(n), this.deleteIndex);
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
            }
            return versionRecord;
        }
        try {
            int n3 = this.insert();
            VersionRecord versionRecord = new VersionRecord(this.addVersionRecord.getValueArray());
            versionRecord.setRecord(n, string, string2, string3, string4, l, date, string5, bl, date, string6, n2, string7);
            this.addIndex.put(n, (Object)new Integer(n3));
            this.update(versionRecord);
            this.createTable = true;
            this.commitIndexFile();
            return versionRecord;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    private void commitIndexFile() throws Exception {
        this.copyFile = false;
        this.addVersionRecord();
        if (this.close != null) {
            this.close.notifyCommit();
        } else {
            this.copyFile();
            this.commit();
        }
    }

    public synchronized void removeVersionRecord(VersionRecord versionRecord) {
        if (!this.appendTableFull) {
            try {
                String string = this.checkTable.getTableNameById(String.valueOf(versionRecord.getVersionId()));
                if (string == null) {
                    return;
                }
                if (!string.equals(this.disconnect.getName())) {
                    try {
                        this.disconnect.commit();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                    this.disconnect.close();
                    this.disconnect = this.createTable(true, string);
                }
                this.disconnect.removeVersionRecord(versionRecord);
                this.checkTable.deleteIndex(String.valueOf(versionRecord.getVersionId()));
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
            return;
        }
        try {
            Integer n = (Integer)this.addIndex.get(versionRecord.getVersionId());
            if (n != null) {
                this.addIndex.remove(versionRecord.getVersionId());
                int n2 = n;
                this.delete(n2);
                this.createTable = true;
                this.commitIndexFile();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public synchronized void removeVersionRecord(int n) {
        if (!this.appendTableFull) {
            String string = this.checkTable.getTableNameById(String.valueOf(n));
            if (string == null) {
                return;
            }
            try {
                if (!string.equals(this.disconnect.getName())) {
                    try {
                        this.disconnect.commit();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                    this.disconnect.close();
                    this.disconnect = this.createTable(true, string);
                }
                this.disconnect.removeVersionRecord(n);
                this.checkTable.deleteIndex(String.valueOf(n));
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
            return;
        }
        try {
            VersionRecord versionRecord = this.getVersionRecord(n);
            if (versionRecord != null) {
                this.removeVersionRecord(versionRecord);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public synchronized VersionRecord getVersionRecord(int n) {
        if (!this.appendTableFull) {
            VersionRecord versionRecord = null;
            String string = this.checkTable.getTableNameById(String.valueOf(n));
            if (string != null) {
                VersionRecordContainer versionRecordContainer = null;
                versionRecordContainer = string.equals(this.disconnect.getName()) ? this.disconnect : this.createTable(true, string);
                versionRecord = versionRecordContainer.getVersionRecord(n);
                if (versionRecordContainer != this.disconnect) {
                    versionRecordContainer.close();
                }
            }
            return versionRecord;
        }
        VersionRecord versionRecord = null;
        Integer n2 = (Integer)this.addIndex.get(n);
        int n3 = n2 != null ? n2.intValue() : this.loadVersionRecord(n);
        if (n3 != -1) {
            this.connect(n3);
            versionRecord = new VersionRecord(this.addVersionRecord.getValueArray());
        }
        return versionRecord;
    }

    public synchronized Vector getVersionRecords(String string, String string2, String string3, Date date, String string4, int n, String string5) {
        if (!this.appendTableFull) {
            Vector vector = new Vector();
            Enumeration enumeration = this.checkTable.getAllTableNames();
            while (enumeration.hasMoreElements()) {
                String string6 = (String)enumeration.nextElement();
                try {
                    VersionRecordContainer versionRecordContainer = null;
                    versionRecordContainer = string6.equals(this.disconnect.getName()) ? this.disconnect : this.createTable(false, string6);
                    Vector vector2 = versionRecordContainer.getVersionRecords(string, string2, string3, date, string4, n, string5);
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        vector.addElement(vector2.elementAt(n2));
                        ++n2;
                    }
                    if (versionRecordContainer == this.disconnect) continue;
                    versionRecordContainer.close();
                }
                catch (NullPointerException nullPointerException) {
                    ServiceLogger.logError(nullPointerException, 3);
                }
            }
            return vector;
        }
        Vector<VersionRecord> vector = new Vector<VersionRecord>();
        try {
            int n3;
            this.addVersionRecord.setCursor(0);
            while ((n3 = this.addVersionRecord.nextRecord()) != -1) {
                VersionRecord versionRecord = new VersionRecord(this.addVersionRecord.getValueArray());
                if (string != null && !string.equalsIgnoreCase(versionRecord.getCatFile()) || string2 != null && !string2.equalsIgnoreCase(versionRecord.getReportFile()) || string3 != null && !string3.equalsIgnoreCase(versionRecord.getParamFile()) || date != null && !date.equals(versionRecord.getGenerateTime()) || string4 != null && !string4.equalsIgnoreCase(versionRecord.getSubmitUser()) || n != -1 && n != versionRecord.getLaunchType() || string5 != null && !string5.equalsIgnoreCase(versionRecord.getTaskId())) continue;
                vector.addElement(versionRecord);
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return vector;
    }

    public synchronized Vector getVersionRecords() {
        int n;
        if (!this.appendTableFull) {
            Vector vector = new Vector();
            Enumeration enumeration = this.checkTable.getAllTableNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                VersionRecordContainer versionRecordContainer = null;
                versionRecordContainer = string.equals(this.disconnect.getName()) ? this.disconnect : this.createTable(false, string);
                Vector vector2 = versionRecordContainer.getVersionRecords();
                int n2 = 0;
                while (n2 < vector2.size()) {
                    vector.addElement(vector2.elementAt(n2));
                    ++n2;
                }
                if (versionRecordContainer == this.disconnect) continue;
                versionRecordContainer.close();
            }
            return vector;
        }
        Vector<VersionRecord> vector = new Vector<VersionRecord>();
        this.loadAllVersionRecords();
        this.addVersionRecord.setCursor(0);
        while ((n = this.addVersionRecord.nextRecord()) != -1) {
            vector.addElement(new VersionRecord(this.addVersionRecord.getValueArray()));
        }
        return vector;
    }

    protected synchronized int loadVersionRecord(int n) {
        int n2;
        this.addVersionRecord.setCursor(this.commit);
        while ((n2 = this.addVersionRecord.nextRecord()) != -1) {
            this.commit = n2;
            DbValue[] dbValueArray = this.addVersionRecord.getValueArray();
            int n3 = ((DbInteger)dbValueArray[1]).get();
            this.addIndex.put(n3, (Object)new Integer(n2));
            if (n3 != n) continue;
            return n2;
        }
        return -1;
    }

    protected synchronized void loadAllVersionRecords() {
        int n;
        this.addVersionRecord.setCursor(this.commit);
        while ((n = this.addVersionRecord.nextRecord()) != -1) {
            this.commit = n;
            DbValue[] dbValueArray = this.addVersionRecord.getValueArray();
            int n2 = ((DbInteger)dbValueArray[1]).get();
            this.addIndex.put(n2, (Object)new Integer(n));
        }
    }

    public synchronized void commit() throws Exception {
        if (!this.appendTableFull) {
            this.disconnect.commit();
            this.checkTable.commitIndexFile();
            return;
        }
        if (!this.isCommitted()) {
            this.addElement.commit();
            this.copyFile = true;
        }
        this.append();
    }

    private void connect(int n) {
        this.addVersionRecord.setCursor(n);
        this.addVersionRecord.nextRecord();
    }

    protected void update(VersionRecord versionRecord) throws SQLException {
        DbValue[] dbValueArray = versionRecord.getValues();
        DbValue[] dbValueArray2 = this.addVersionRecord.getValueArray();
        int n = 0;
        while (n < dbValueArray2.length) {
            dbValueArray2[n] = dbValueArray[n];
            ++n;
        }
        this.addVersionRecord.update();
    }

    protected void delete(int n) throws SQLException {
        this.connect(n);
        this.addVersionRecord.delete();
    }

    protected int insert() throws SQLException {
        return this.addVersionRecord.insert();
    }

    private synchronized void copyFile() {
        this.commitIndexFile = System.currentTimeMillis();
    }

    public synchronized boolean isCommitted() {
        return this.copyFile;
    }

    public synchronized long getLastModify() {
        return this.commitIndexFile;
    }

    private VersionRecordContainer createTable(boolean bl, String string) {
        return new VersionRecordContainer(bl, string, this.equals, this.elementAt, this.endsWith);
    }
}

