/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.adapter;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.api.db.Unique;
import jet.server.db.adapter.DB;
import jet.server.db.adapter.DBAdapter;
import jet.server.db.core.TableImpl;
import jet.server.db.core.UniqueImpl;

public final class DBOdbc
extends DB
implements DBAdapter {
    public boolean createTable(Table table) throws SQLException {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE ").append(table.getName()).append(" (");
        Field[] fieldArray = table.fields().toArray();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = fieldArray[n3];
            stringBuffer.append(object.getName());
            JDBCType jDBCType = object.getJDBCType();
            stringBuffer.append(" ").append(jDBCType.typeName());
            if (jDBCType.isVariationalSize()) {
                if (jDBCType.dataType() == 12) {
                    n = object.getSize();
                    stringBuffer.append("(").append(n > 255 ? 255 : n).append(")");
                } else {
                    stringBuffer.append("(").append(object.getSize()).append(")");
                }
            }
            if (object.isNotNull()) {
                stringBuffer.append(" NOT NULL");
            }
            if (object.isPrimaryKey()) {
                stringBuffer.append(" PRIMARY KEY");
            }
            if (object.isIdentity()) {
                this.idGen.createIdentity(table, (Field)object);
            }
            if (n3 < n2 - 1) {
                stringBuffer.append(",");
            }
            if (object.isUnique()) {
                Unique unique = table.uniques("UNQ_UNFORMED");
                if (unique == null) {
                    unique = new UniqueImpl(table, "UNQ_UNFORMED");
                    ((TableImpl)table).append(unique);
                }
                unique.append((Field)object);
            }
            ++n3;
        }
        object = table.uniques().toArray();
        n2 = ((Unique[])object).length;
        int n4 = 0;
        while (n4 < n2) {
            n = object[n4].fields().size();
            int n5 = 0;
            while (n5 < n) {
                if (n5 == 0) {
                    stringBuffer.append(",");
                    stringBuffer.append(" CONSTRAINT ").append(object[n4].getName());
                    stringBuffer.append(" UNIQUE(");
                }
                stringBuffer.append(object[n4].fields(n5).getName());
                if (n5 < n - 1) {
                    stringBuffer.append(",");
                }
                ++n5;
            }
            stringBuffer.append(")");
            if (n4 < n2 - 1) {
                stringBuffer.append(",");
            }
            ++n4;
        }
        stringBuffer.append(")");
        return super.execute(stringBuffer.substring(0));
    }

    public boolean dropTable(Table table) throws SQLException {
        this.idGen.deleteIdentity(table, null);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP TABLE ").append(table.getName());
        return super.execute(stringBuffer.substring(0));
    }

    public int delete(Table table, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ").append(table.getName()).append(this.QOIV(string));
        return super.executeUpdate(stringBuffer.substring(0));
    }

    public int insert(Table table, FieldValue[] fieldValueArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ").append(table.getName()).append(" (");
        int n = fieldValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(fieldValueArray[n2].getName());
            if (n2 < n - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        stringBuffer.append(") VALUES (");
        int n3 = 0;
        while (n3 < n) {
            this.valueToString(stringBuffer, table, fieldValueArray[n3]);
            if (n3 < n - 1) {
                stringBuffer.append(",");
            }
            ++n3;
        }
        stringBuffer.append(")");
        return super.executeUpdate(stringBuffer.substring(0));
    }

    public int update(Table table, FieldValue[] fieldValueArray, String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ").append(table.getName()).append(" SET (");
        int n = fieldValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            FieldValue fieldValue = fieldValueArray[n2];
            stringBuffer.append(fieldValue.getName()).append("=");
            this.valueToString(stringBuffer, table, fieldValue);
            if (n2 < n - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        stringBuffer.append(")").append(this.QOIV(string));
        return super.executeUpdate(stringBuffer.substring(0));
    }

    public Recordset select(Field[] fieldArray, Table[] tableArray, String string, boolean bl, int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ").append(bl ? "DISTINCT " : "");
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            switch (field.getCalculating()) {
                case 0: {
                    stringBuffer.append(field.getFullyQualifiedName());
                    break;
                }
                case 1: {
                    stringBuffer.append("COUNT(").append(field.getFullyQualifiedName()).append(")");
                    break;
                }
                case 2: {
                    stringBuffer.append("SUM(").append(field.getFullyQualifiedName()).append(")");
                    break;
                }
                case 3: {
                    stringBuffer.append("AVG(").append(field.getFullyQualifiedName()).append(")");
                    break;
                }
                case 5: {
                    stringBuffer.append("MIN(").append(field.getFullyQualifiedName()).append(")");
                    break;
                }
                case 4: {
                    stringBuffer.append("MAX(").append(field.getFullyQualifiedName()).append(")");
                }
            }
            if (!field.getDispName().equals(field.getName())) {
                stringBuffer.append(" AS ").append(field.getDispName());
            }
            if (n3 < n2 - 1) {
                stringBuffer.append(",");
            }
            ++n3;
        }
        stringBuffer.append(" FROM ");
        n2 = tableArray.length;
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer.append(tableArray[n4].getName());
            if (n4 < n2 - 1) {
                stringBuffer.append(",");
            }
            ++n4;
        }
        stringBuffer.append(this.QOIV(string));
        return super.executeQuery(fieldArray, stringBuffer.substring(0), n);
    }

    protected String valueToString(StringBuffer stringBuffer, Table table, FieldValue fieldValue) {
        int n = stringBuffer.length();
        JDBCType jDBCType = fieldValue.getJDBCType();
        Object object = fieldValue.getValue();
        if (fieldValue.isIdentity()) {
            if (object == null) {
                int n2 = 0;
                try {
                    n2 = this.getID(table, table.fields(fieldValue.getName()));
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                stringBuffer.append(n2);
            } else {
                stringBuffer.append(object);
            }
        } else {
            switch (jDBCType.dataType()) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    stringBuffer.append(object == null ? "0" : object);
                    break;
                }
                case 91: {
                    stringBuffer.append(this.formatValue((Date)object));
                    break;
                }
                case 92: {
                    stringBuffer.append(this.formatValue((Time)object));
                    break;
                }
                case 93: {
                    stringBuffer.append(this.formatValue((Timestamp)object));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    String string = (String)object;
                    if (string != null && string.length() > 255) {
                        stringBuffer.append(this.formatValue(string.substring(0, 254)));
                        break;
                    }
                    stringBuffer.append(this.formatValue(string));
                    break;
                }
                case -7: 
                case 16: {
                    stringBuffer.append(this.formatValue((Boolean)object));
                    break;
                }
                default: {
                    stringBuffer.append("'").append(object).append("'");
                }
            }
        }
        return stringBuffer.substring(n);
    }

    private String QOIV(String string) {
        return string != null && string.length() > 0 ? " " + string : "";
    }
}

