/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.core;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import jet.server.ServerEnvBuilder;
import jet.server.api.db.Database;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Table;
import jet.server.api.db.Tables;
import jet.server.api.db.Workspace;
import jet.server.db.Connector;
import jet.server.db.adapter.DBFactory;
import jet.server.db.core.AbstractDBObject;
import jet.server.db.core.ConnectorManager;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.IDGenerator;
import jet.server.db.core.IDGeneratorImpl;
import jet.server.db.core.TableImpl;
import jet.server.db.core.TablesImpl;
import jet.server.db.core.TransferHelp;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;
import jet.server.util.StringUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class DatabaseImpl
extends AbstractDBObject
implements Database {
    private Workspace QOIV;
    private TablesImpl add = new TablesImpl();
    private Connector append;
    private IDGeneratorImpl backup;
    private boolean checkIntegrality = false;
    public static HashSet set = new HashSet();
    private TransferHelp clear;

    protected DatabaseImpl() {
    }

    public DatabaseImpl(Workspace workspace, String string) {
        super(string);
        this.QOIV = workspace;
    }

    protected void buildFrom(Element element) {
        Object object;
        Object object2;
        Object object3;
        String string = element.getAttribute("name");
        super.setName(string);
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            object3 = nodeList.item(n2);
            switch (object3.getNodeType()) {
                case 1: {
                    object2 = (Element)object3;
                    if ("driver".equalsIgnoreCase(object2.getTagName())) {
                        object = object2.getAttribute("classpath");
                        object = object == null ? "" : ((String)object).trim();
                        this.info.setProperty("classpath", (String)object);
                    }
                    String string2 = (object = object2.getFirstChild()) == null ? "" : object.getNodeValue().trim();
                    this.info.setProperty(object2.getTagName().toLowerCase(), string2);
                    break;
                }
            }
            ++n2;
        }
        object3 = this.getProperty("encrypt-sign");
        if (object3 != null && (object = StringUtil.split((String)(object2 = ServerUtil.decode((String)object3)), "\r\n")) != null) {
            int n3 = 0;
            while (n3 < ((String[])object).length) {
                object2 = object[n3];
                int n4 = ((String)object2).indexOf("=");
                if (n4 != -1) {
                    String string3 = ((String)object2).substring(0, n4);
                    String string4 = ((String)object2).substring(n4 + 1);
                    this.setProperty(string3, string4);
                }
                ++n3;
            }
        }
    }

    public Workspace getWorkspace() {
        return this.QOIV;
    }

    public void setWorkspace(Workspace workspace) {
        this.QOIV = workspace;
    }

    public Tables tables() {
        return this.add;
    }

    public Table tables(int n) {
        return (Table)this.add.get(n);
    }

    public Table tables(String string) {
        return (Table)this.add.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connector getConnector() {
        DatabaseImpl databaseImpl = this;
        synchronized (databaseImpl) {
            if (this.append == null) {
                this.append = ConnectorManager.newInstance().getConnector(this.info);
                this.setProperties(this.append.getProperties());
            }
            Connector connector = this.append;
            return connector;
        }
    }

    public void append(Table table) {
        this.add.append(table);
    }

    public void remove(Table table) {
        if (table instanceof TableImpl) {
            ((TableImpl)table).close();
        }
        this.add.remove(table.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws SQLException {
        DatabaseImpl databaseImpl = this;
        synchronized (databaseImpl) {
            if (this.isOpened()) {
                return;
            }
            Connection connection = this.getConnector().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ServiceLogger.logDebug(4640001, new String[]{this.getWorkspace().getName(), this.getName(), databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getDriverName(), databaseMetaData.getDriverVersion(), databaseMetaData.getDatabaseProductVersion()}, 4);
            this.QOIV(connection);
            try {
                this.backup = new IDGeneratorImpl(this);
                this.backup.open();
            }
            catch (InstantiationException instantiationException) {
                ServiceLogger.logError(instantiationException);
            }
            if ("true".equals(ServerEnvBuilder.servEnv.getProperty("jreport.resource.cleanup", "false"))) {
                Iterator iterator = this.add.iterator();
                while (iterator.hasNext()) {
                    Table table = (Table)iterator.next();
                    table.delete("");
                }
            }
            connection.close();
            this.checkIntegrality = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpened() {
        DatabaseImpl databaseImpl = this;
        synchronized (databaseImpl) {
            boolean bl = this.checkIntegrality;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DatabaseImpl databaseImpl = this;
        synchronized (databaseImpl) {
            String string;
            int n = this.add.size();
            int n2 = 0;
            while (n2 < n) {
                ((TableImpl)this.tables(n2)).close();
                ++n2;
            }
            this.add.clear();
            if (this.backup != null) {
                this.backup.close();
                this.backup = null;
            }
            if (this.append != null) {
                this.append.destroy();
                this.append = null;
            }
            if ((string = this.getProperty("url")) != null && string.startsWith("jdbc:derby:")) {
                String string2 = this.getProperty("user");
                String string3 = this.getProperty("password");
                ServiceLogger.logDebug("url:" + string);
                ServiceLogger.logDebug("user:" + string2);
                ServiceLogger.logDebug("password:" + string3);
                try {
                    ServiceLogger.logDebug("shuting down Derby");
                    DriverManager.getConnection(string + ";user=" + string2 + ";password=" + string3 + ";shutdown=true");
                    ServiceLogger.logDebug("Derby database has been shutdown");
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logDebug(sQLException.getMessage());
                }
                System.gc();
            }
            this.checkIntegrality = false;
        }
    }

    public IDGenerator getIDGenerator() {
        return this.backup;
    }

    public void setTransferHelp(TransferHelp transferHelp) {
        this.clear = transferHelp;
    }

    public boolean backup(String string) throws SQLException, IOException {
        if (this.clear != null) {
            return this.clear.backup(this, string);
        }
        return false;
    }

    public boolean restore(String string) throws SQLException, IOException {
        if (this.clear != null) {
            return this.clear.restore(this, string);
        }
        return false;
    }

    public boolean cutdownTable(Table table, String string, String string2) throws SQLException, IOException {
        if (this.clear != null) {
            return this.clear.cutdownTable(this, table, string, string2);
        }
        return false;
    }

    public boolean importsTable(Table table, String string) throws SQLException, IOException {
        if (this.clear != null) {
            return this.clear.importsTable(this, table, string);
        }
        return false;
    }

    public void checkIntegrality(Map map) throws SQLException {
        if (this.clear != null) {
            this.clear.checkIntegrality(this, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void QOIV(Connection connection) {
        String string;
        int n;
        HashSet<String> hashSet;
        Object object;
        String string2;
        long l;
        block15: {
            String[] stringArray;
            ServiceLogger.logDebug(4640005, 4);
            l = System.currentTimeMillis();
            string2 = this.getProperty("schema");
            if (string2 == null || string2.trim().length() == 0) {
                stringArray = this.getProperty("user");
                try {
                    object = DBFactory.create(this.append);
                    string2 = object.getDefaultSchema((String)stringArray, connection);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 2);
                }
            }
            ServiceLogger.logDebug(4640006, string2, 4);
            stringArray = new String[]{"TABLE", "ALIAS", "SYNONYM"};
            object = null;
            ResultSet resultSet = null;
            hashSet = new HashSet<String>();
            n = 0;
            string = null;
            object = connection.getMetaData();
            resultSet = object.getTables(null, string2, null, stringArray);
            while (resultSet.next()) {
                string = resultSet.getString("TABLE_NAME").toUpperCase();
                if (!set.contains(string)) continue;
                hashSet.add(string);
                ++n;
            }
            Object var13_11 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
            break block15;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    var13_11 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            try {
                string = (String)iterator.next();
                TableImpl tableImpl = new TableImpl(this, string);
                this.add(tableImpl, string2, (DatabaseMetaData)object);
                this.append(tableImpl);
                ServiceLogger.logDebug(4640007, string, 4);
            }
            catch (InstantiationException instantiationException) {
                ServiceLogger.logError(instantiationException);
            }
        }
        long l2 = System.currentTimeMillis() - l;
        ServiceLogger.logDebug(4640008, new Object[]{new Integer(n), new Long(l2)}, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void add(TableImpl tableImpl, String string, DatabaseMetaData databaseMetaData) {
        block9: {
            ResultSet resultSet = null;
            String string2 = tableImpl.getName();
            resultSet = databaseMetaData.getDatabaseProductName().equalsIgnoreCase("interbase") ? databaseMetaData.getColumns("", "", string2, "%") : databaseMetaData.getColumns(null, string, string2, null);
            while (resultSet.next()) {
                FieldImpl fieldImpl = new FieldImpl();
                fieldImpl.setParentTable(tableImpl);
                fieldImpl.setFieldName(resultSet.getString("COLUMN_NAME"));
                fieldImpl.setSize(resultSet.getInt("COLUMN_SIZE"));
                fieldImpl.setType(JDBCType.getJDBCType(resultSet.getInt("DATA_TYPE")));
                boolean bl = resultSet.getInt("NULLABLE") == 0;
                fieldImpl.setNotNull(bl);
                tableImpl.append(fieldImpl);
            }
            Object var9_9 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
            break block9;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var9_10 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 3);
                }
                throw throwable;
            }
        }
    }

    static {
        set.add("ACLENTRYS_1");
        set.add("ACLENTRIES_2");
        set.add("ACLENTRIES_3");
        set.add("ACLS_1");
        set.add("ACLS_2");
        set.add("ACLS_WITH_RESOURCE_1");
        set.add("ALIASES_1");
        set.add("ALIASES_2");
        set.add("CATALOGVERSION_1");
        set.add("CATALOGVERSION_2");
        set.add("COMPLETEDTABLE_1");
        set.add("COMPLETEDTABLE_2");
        set.add("COMPLETEDTABLE_3");
        set.add("COMPLETEDTABLE_4");
        set.add("COMPLETEDPUBLISHTABLE_1");
        set.add("COMPLETEDPUBLISHTABLE_2");
        set.add("COMPLETEDRESULTTABLE_1");
        set.add("COMPLETEDRESULTTABLE_2");
        set.add("COMPLETEDRESULTTABLE_3");
        set.add("DRESULT_1");
        set.add("DRESULT_2");
        set.add("DYNAMICNODE_1");
        set.add("DYNAMICNODE_2");
        set.add("DYNAMICRESULT_1");
        set.add("EXTENDACLENTRIES_1");
        set.add("EXTENDACLENTRIES_2");
        set.add("EXTENDACLENTRIES_3");
        set.add("FOLDERS_1");
        set.add("FOLDERS_2");
        set.add("FOLDERS_3");
        set.add("GROUPPROFILES_1");
        set.add("GROUPS_1");
        set.add("GUPROFILES_1");
        set.add("GUPROFILES_2");
        set.add("JNDIDSMAPPING_2");
        set.add("NODES_1");
        set.add("NODES_2");
        set.add("NODES_3");
        set.add("REPORTVERSION_1");
        set.add("REPORTVERSION_2");
        set.add("RESOURCEMAP_1");
        set.add("RESOURCENODES_1");
        set.add("RESOURCENODES_2");
        set.add("RESOURCENODES_3");
        set.add("RESULT_1");
        set.add("RESULT_2");
        set.add("RESULTVERSION_1");
        set.add("RESULTVERSION_2");
        set.add("RGPROFILES_1");
        set.add("ROLEPROFILES_2");
        set.add("ROLES_1");
        set.add("ROLES_2");
        set.add("SCHDLASTEXETIME_1");
        set.add("TASKCONTEXT");
        set.add("TBL_IDGENRATOR_JINFONET");
        set.add("TRIGGERS_1");
        set.add("UPDATEDETAILS_1");
        set.add("USERPROFILES_1");
        set.add("USERPROFILES_2");
        set.add("USERPROFILES_3");
        set.add("USERS_1");
        set.add("USERS_2");
        set.add("USERS_3");
        set.add("USERS_4");
        set.add("VERSIONNODES_1");
        set.add("VERSIONNODES_2");
    }
}

