/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.factory;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import jet.server.db.ColumnDescImpl;
import jet.server.db.Connector;
import jet.server.db.DataTable;
import jet.server.log.ServiceLogger;

public class DataTableHSQLDBImpl
implements DataTable {
    public static int COMMIT_DELAY = 100;
    protected Connection conn = null;
    protected Statement stmt = null;
    protected StringBuffer sqlbuf = null;
    protected Connector connector = null;
    private int QOIV = 0;

    public DataTableHSQLDBImpl(Connector connector) throws SQLException {
        this.connector = connector;
        this.conn = connector.getConnection(10000L);
        this.stmt = this.conn.createStatement();
    }

    public synchronized boolean commit() {
        try {
            this.conn.commit();
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean hasTable(String string) {
        try {
            this.stmt.executeQuery("SELECT COUNT(*) FROM " + string);
            return true;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    public synchronized boolean createTable(String string, ColumnDescImpl[] columnDescImplArray) {
        this.sqlbuf = new StringBuffer();
        this.sqlbuf.append("CREATE CACHED TABLE ").append(string);
        String string2 = this.COMMIT_DELAY(columnDescImplArray);
        if (string2.charAt(string2.length() - 1) == ',') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        this.sqlbuf.append("(").append(string2).append(")");
        try {
            this.stmt.execute(this.sqlbuf.toString().trim());
            return true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return false;
        }
    }

    public synchronized boolean dropTable(String string) {
        this.sqlbuf = new StringBuffer();
        this.sqlbuf.append("DROP TABLE").append(string);
        try {
            this.stmt.execute(this.sqlbuf.toString().trim());
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean createView(String string, String string2, String string3, String string4) {
        this.sqlbuf = new StringBuffer();
        this.sqlbuf.append("CREATE VIEW ").append(string2);
        this.sqlbuf.append(" AS SELECT ").append(string3);
        this.sqlbuf.append(" FROM ").append(string).append(this.sqlWhere(string4));
        try {
            this.stmt.execute(this.sqlbuf.toString().trim());
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean dropView(String string) {
        this.sqlbuf = new StringBuffer();
        this.sqlbuf.append("DROP VIEW").append(string);
        try {
            this.stmt.execute(this.sqlbuf.toString().trim());
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized int getMaxFieldValue(String string, String string2, String string3) {
        int n;
        block12: {
            ResultSet resultSet;
            block11: {
                n = -1;
                resultSet = null;
                this.sqlbuf = new StringBuffer();
                this.sqlbuf.append("SELECT MAX (").append(string2).append(")");
                this.sqlbuf.append(" FROM ").append(string);
                this.sqlbuf.append(this.sqlWhere(string3));
                resultSet = this.stmt.executeQuery(this.sqlbuf.toString().trim());
                if (!resultSet.next()) break block11;
                n = resultSet.getInt(1);
            }
            Object var8_6 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var8_7 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return n;
    }

    public synchronized ResultSet getResultSet(String string, String string2, String string3, boolean bl) {
        ResultSet resultSet = null;
        Vector vector = new Vector();
        this.sqlbuf = new StringBuffer();
        this.sqlbuf.append("SELECT ");
        if (bl) {
            this.sqlbuf.append(" DISTINCT ");
        }
        this.sqlbuf.append(string2);
        this.sqlbuf.append(" FROM ").append(string).append(this.sqlWhere(string3));
        try {
            resultSet = this.stmt.executeQuery(this.sqlbuf.toString().trim());
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return resultSet;
    }

    public synchronized ResultSet execQuery(String string) {
        ResultSet resultSet = null;
        try {
            resultSet = this.stmt.executeQuery(string);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized int getRecordAmount(String string, String string2, String string3) {
        int n;
        block10: {
            n = 0;
            ResultSet resultSet = this.getResultSet(string, "COUNT(" + string2 + ")", string3, true);
            if (resultSet != null) {
                block9: {
                    if (!resultSet.next()) break block9;
                    n = resultSet.getInt(1);
                }
                Object var8_6 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                break block10;
                {
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                        Object var8_7 = null;
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {
                            ServiceLogger.logError(exception);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                    throw throwable;
                }
            }
        }
        return n;
    }

    public synchronized boolean delRecord(String string, String string2, boolean bl) {
        this.sqlbuf = new StringBuffer();
        this.sqlbuf.append("DELETE FROM ").append(string).append(this.sqlWhere(string2));
        try {
            this.stmt.executeUpdate(this.sqlbuf.toString().trim());
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean updRecord(String string, String[] stringArray, String[] stringArray2, String string2, boolean bl) {
        this.sqlbuf = new StringBuffer();
        this.sqlbuf.append("UPDATE ").append(string);
        this.sqlbuf.append(" ").append(this.append(stringArray, stringArray2));
        this.sqlbuf.append(" ").append(this.sqlWhere(string2));
        try {
            this.stmt.executeUpdate(this.sqlbuf.toString().trim());
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean addRecord(String string, String[] stringArray, String[] stringArray2, boolean bl) {
        this.sqlbuf = new StringBuffer();
        this.sqlbuf.append("INSERT INTO ").append(string);
        this.sqlbuf.append(this.QOIV(stringArray, stringArray2));
        try {
            this.stmt.executeUpdate(this.sqlbuf.toString().trim());
            return true;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized void checkDoCommit(boolean bl) {
        if (bl) {
            this.commit();
        } else {
            ++this.QOIV;
            if (this.QOIV > COMMIT_DELAY) {
                this.commit();
            }
        }
    }

    public synchronized StringBuffer cleanedBuffer() {
        this.sqlbuf = new StringBuffer();
        return this.sqlbuf;
    }

    public synchronized void close() {
        try {
            this.stmt.close();
            this.conn.close();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    public String sqlWhere(String string) {
        return string != null && string.length() > 0 ? " " + string : "";
    }

    private String COMMIT_DELAY(ColumnDescImpl[] columnDescImplArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        Object var4_4 = null;
        String string2 = "";
        int n = 0;
        while (n < columnDescImplArray.length) {
            stringBuffer.append(columnDescImplArray[n].getColName());
            int n2 = columnDescImplArray[n].getColType();
            switch (n2) {
                case -5: {
                    stringBuffer.append(" BIGINT");
                    break;
                }
                case -2: {
                    break;
                }
                case -7: {
                    stringBuffer.append(" BIT");
                    break;
                }
                case -6: {
                    stringBuffer.append(" TINYINT");
                    break;
                }
                case 1: {
                    break;
                }
                case 91: {
                    stringBuffer.append(" DATE");
                    break;
                }
                case 3: {
                    break;
                }
                case 8: {
                    stringBuffer.append(" DOUBLE(").append(columnDescImplArray[n].getColPrecesion()).append(")");
                    break;
                }
                case 6: {
                    break;
                }
                case 4: {
                    stringBuffer.append(" INTEGER");
                    break;
                }
                case -4: {
                    break;
                }
                case -1: {
                    break;
                }
                case 92: {
                    break;
                }
                case -3: {
                    break;
                }
                case 12: {
                    stringBuffer.append(" VARCHAR(").append(columnDescImplArray[n].getColPrecesion()).append(")");
                    break;
                }
            }
            if (!columnDescImplArray[n].isNull()) {
                stringBuffer.append(" NOT NULL");
            }
            if (columnDescImplArray[n].isIdentity()) {
                stringBuffer.append(" IDENTITY");
            }
            if (columnDescImplArray[n].isKey()) {
                stringBuffer.append(" PRIMARY KEY");
            }
            stringBuffer.append(",");
            if (columnDescImplArray[n].isUnique()) {
                string2 = string2 + columnDescImplArray[n].getColName() + ",";
            }
            ++n;
        }
        if ((string2 = string2.trim()).length() != 0) {
            if (string2.charAt(string2.length() - 1) == ',') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            stringBuffer.append(" UNIQUE(").append(string2).append(")");
        }
        string = stringBuffer.toString();
        return string;
    }

    private String QOIV(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        String string2 = "";
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            string = string + stringArray[n2] + ",";
            string2 = string2 + (stringArray2[n2] == null ? "null" : stringArray2[n2]) + ",";
            ++n2;
        }
        if (string.charAt(string.length() - 1) == ',') {
            string = string.substring(0, string.length() - 1);
        }
        if (string2.charAt(string2.length() - 1) == ',') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        stringBuffer.append("(").append(string).append(")");
        stringBuffer.append(" VALUES(").append(string2).append(")");
        return stringBuffer.toString();
    }

    private String append(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length;
        stringBuffer.append(" SET");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ").append(stringArray[n2]).append(" =").append(stringArray2[n2] == null ? "null" : stringArray2[n2]).append(',');
            ++n2;
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized int getMinFieldValue(String string, String string2, String string3) {
        int n;
        block12: {
            ResultSet resultSet;
            block11: {
                resultSet = null;
                n = -1;
                this.sqlbuf = new StringBuffer();
                this.sqlbuf.append("SELECT MIN (").append(string2).append(")");
                this.sqlbuf.append(" FROM ").append(string);
                this.sqlbuf.append(" ").append(string3);
                resultSet = this.stmt.executeQuery(this.sqlbuf.toString().trim());
                if (!resultSet.next()) break block11;
                n = resultSet.getInt(1);
            }
            Object var8_6 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var8_7 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return n;
    }
}

