/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.TableImpl;
import jet.server.db.security2.GroupRecord;
import jet.server.db.security2.GroupTable;
import jet.server.log.ServiceLogger;

public class GroupTableImpl
extends TableImpl
implements Table,
GroupTable {
    public static final int VERSION = 1;
    static final String[] BIT = new String[4];

    public static GroupTableImpl newInstance(Database database) {
        try {
            return new GroupTableImpl(database);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, "GROUPS_1", 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private GroupTableImpl(Database database) throws InstantiationException, SQLException {
        super(database, "GROUPS_1");
        super.append(new FieldImpl(this.getName(), BIT[0], JDBCType.VARCHAR, 32, 9, 0));
        super.append(new FieldImpl(this.getName(), BIT[1], JDBCType.BIT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), BIT[2], JDBCType.VARCHAR, 32, 0, 0));
        super.append(new FieldImpl(this.getName(), BIT[3], JDBCType.INTEGER, 0, 1, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    public synchronized GroupRecord addRecord(String string, boolean bl, String string2, int n) {
        GroupRecord groupRecord = new GroupRecord(string, bl, string2, n);
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(groupRecord.getName());
        fieldValueArray[1].setValue(new Boolean(groupRecord.isBuiltin()));
        fieldValueArray[2].setValue(groupRecord.getDescription());
        fieldValueArray[3].setValue(new Integer(n));
        try {
            super.insert(fieldValueArray);
            return groupRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    public synchronized boolean deleteGroup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(BIT[0]).getName()).append("=").append(this.adapter.formatValue(string));
        try {
            int n = super.delete(stringBuffer.substring(0));
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized GroupRecord getGroup(String string) {
        GroupRecord groupRecord;
        block12: {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WHERE ").append(super.fields(BIT[0]).getName()).append("=").append(this.adapter.formatValue(string));
            groupRecord = null;
            Recordset recordset = null;
            recordset = super.query(this.fields().toArray(), stringBuffer.substring(0), true);
            while (recordset.next()) {
                groupRecord = this.BIT(recordset);
            }
            Object var7_5 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var7_6 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return groupRecord;
    }

    private synchronized GroupRecord BIT(Recordset recordset) throws SQLException {
        GroupRecord groupRecord = new GroupRecord();
        groupRecord.setName(recordset.getString(BIT[0]));
        groupRecord.setBuiltin(recordset.getBoolean(BIT[1]));
        groupRecord.setDescription(recordset.getString(BIT[2]));
        groupRecord.setType(recordset.getInt(BIT[3]));
        return groupRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getAllGroups() {
        Vector<GroupRecord> vector;
        block12: {
            vector = new Vector<GroupRecord>();
            Recordset recordset = null;
            recordset = super.query(this.fields().toArray(), "", true);
            while (recordset.next()) {
                GroupRecord groupRecord = this.BIT(recordset);
                if (groupRecord == null) continue;
                vector.add(groupRecord);
            }
            Object var5_5 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var5_6 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getAllGroupsName() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        FieldValue[] fieldValueArray = new FieldValue[]{this.fields(BIT[0]).createFieldValue()};
        Recordset recordset = null;
        recordset = super.query(this.fields().toArray(), "", true);
        if (recordset.next() && (object = recordset.getString(BIT[0])) != null) {
            vector.add(object);
        }
        object = vector;
        Object var6_6 = null;
        try {
            if (recordset != null) {
                recordset.close();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return object;
        catch (SQLException sQLException) {
            vector = null;
            ServiceLogger.logError(sQLException);
            Object var6_7 = null;
            {
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                    throw throwable;
                }
            }
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    static {
        GroupTableImpl.BIT[0] = "name";
        GroupTableImpl.BIT[1] = "buildin";
        GroupTableImpl.BIT[2] = "description";
        GroupTableImpl.BIT[3] = "group_type";
    }
}

