/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.security2;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.TableImpl;
import jet.server.db.security2.RGProfileRecord;
import jet.server.db.security2.RGProfileTable;
import jet.server.log.ServiceLogger;

public class RGProfileTableImpl
extends TableImpl
implements Table,
RGProfileTable {
    public static final int VERSION = 1;
    public static final String TABLENAME = "RGPROFILES_1";
    static final String[] QOIV = new String[2];

    public static RGProfileTableImpl newInstance(Database database) {
        try {
            return new RGProfileTableImpl(database);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, TABLENAME, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private RGProfileTableImpl(Database database) throws SQLException, InstantiationException {
        super(database, TABLENAME);
        super.append(new FieldImpl(this.getName(), QOIV[0], JDBCType.VARCHAR, 32, 0, 0));
        super.append(new FieldImpl(this.getName(), QOIV[1], JDBCType.VARCHAR, 32, 0, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
    }

    public synchronized RGProfileRecord addRecord(String string, String string2) {
        RGProfileRecord rGProfileRecord = new RGProfileRecord(string, string2);
        FieldValue[] fieldValueArray = super.fields().values();
        fieldValueArray[0].setValue(rGProfileRecord.getRoleName());
        fieldValueArray[1].setValue(rGProfileRecord.getGroupName());
        try {
            super.insert(fieldValueArray);
            return rGProfileRecord;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return null;
        }
    }

    public synchronized boolean deleteRecordByGroupName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[1]).getName()).append("=").append(this.adapter.formatValue(string));
        try {
            int n = super.delete(stringBuffer.toString());
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean deleteRecordByRoleName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[0]).getName()).append("=").append(this.adapter.formatValue(string));
        try {
            int n = super.delete(stringBuffer.toString());
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean deleteRecord(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[0]).getName()).append("=").append(this.adapter.formatValue(string)).append(" AND ").append(super.fields(QOIV[1]).getName()).append("=").append(this.adapter.formatValue(string2));
        try {
            int n = super.delete(stringBuffer.toString());
            return n >= 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getRoleNamesByGroup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[1]).getName()).append("=").append(this.adapter.formatValue(string));
        Field[] fieldArray = new Field[]{this.fields(QOIV[0])};
        Vector<String> vector = null;
        Recordset recordset = null;
        recordset = super.query(fieldArray, stringBuffer.toString(), false);
        vector = new Vector<String>();
        while (recordset.next()) {
            vector.add(recordset.getString(QOIV[0]));
        }
        Vector<String> vector2 = vector;
        Object var8_8 = null;
        try {
            if (recordset != null) {
                recordset.close();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return vector2;
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            Object var8_9 = null;
            {
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                    throw throwable;
                }
            }
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getGroupNamesByRole(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[0]).getName()).append("=").append(this.adapter.formatValue(string));
        Field[] fieldArray = new Field[]{this.fields(QOIV[1])};
        Vector<String> vector = null;
        Recordset recordset = null;
        recordset = super.query(fieldArray, stringBuffer.toString(), false);
        vector = new Vector<String>();
        while (recordset.next()) {
            vector.add(recordset.getString(QOIV[1]));
        }
        Vector<String> vector2 = vector;
        Object var8_8 = null;
        try {
            if (recordset != null) {
                recordset.close();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return vector2;
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            Object var8_9 = null;
            {
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                    throw throwable;
                }
            }
            try {
                if (recordset != null) {
                    recordset.close();
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        return vector;
    }

    public synchronized int getRolesCount(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[1]).getName()).append("=").append(this.adapter.formatValue(string));
        int n = 0;
        try {
            n = super.queryCountValue(QOIV[0], stringBuffer.toString(), false);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n;
    }

    public synchronized int getGroupsCount(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WHERE ").append(super.fields(QOIV[0]).getName()).append("=").append(this.adapter.formatValue(string));
        int n = 0;
        try {
            n = super.queryCountValue(QOIV[1], stringBuffer.toString(), false);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized RGProfileRecord getRecord(String string, String string2) {
        RGProfileRecord rGProfileRecord;
        block12: {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("where ").append(super.fields(QOIV[0]).getName()).append(" = ").append(this.adapter.formatValue(string)).append(" AND ").append(super.fields(QOIV[1]).getName()).append(" = ").append(this.adapter.formatValue(string2));
            rGProfileRecord = null;
            Recordset recordset = null;
            recordset = super.query(this.fields().toArray(), stringBuffer.toString(), true);
            while (recordset.next()) {
                rGProfileRecord = this.QOIV(recordset);
            }
            Object var8_6 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block12;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    rGProfileRecord = null;
                    ServiceLogger.logError(sQLException);
                    Object var8_7 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return rGProfileRecord;
    }

    private synchronized RGProfileRecord QOIV(Recordset recordset) throws SQLException {
        RGProfileRecord rGProfileRecord = new RGProfileRecord();
        rGProfileRecord.setRoleName(recordset.getString(QOIV[0]));
        rGProfileRecord.setGroupName(recordset.getString(QOIV[1]));
        return rGProfileRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Hashtable[] getAllRecords() {
        Hashtable[] hashtableArray;
        block15: {
            hashtableArray = new Hashtable[]{new Hashtable(), new Hashtable()};
            Recordset recordset = null;
            recordset = super.query(this.fields().toArray(), null, false);
            while (recordset.next()) {
                Vector<String> vector;
                String string = recordset.getString(QOIV[0]);
                String string2 = recordset.getString(QOIV[1]);
                Vector vector2 = (Vector)hashtableArray[0].get(string);
                Vector vector3 = (Vector)hashtableArray[1].get(string2);
                if (vector2 != null) {
                    vector2.add(string2);
                } else {
                    vector = new Vector<String>();
                    vector.add(string2);
                    hashtableArray[0].put(string, vector);
                }
                if (vector3 != null) {
                    vector3.add(string);
                    continue;
                }
                vector = new Vector();
                vector.add(string);
                hashtableArray[1].put(string2, vector);
            }
            Object var9_9 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                break block15;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block15;
            {
                catch (SQLException sQLException) {
                    hashtableArray = null;
                    ServiceLogger.logError(sQLException);
                    Object var9_10 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        break block15;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return hashtableArray;
    }

    static {
        RGProfileTableImpl.QOIV[0] = "role_name";
        RGProfileTableImpl.QOIV[1] = "group_name";
    }
}

