/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.transfer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import jet.server.api.db.Database;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.core.TableImpl;
import jet.server.db.transfer.AbstractTransferHelp;

public final class ProfilingTransferHelp
extends AbstractTransferHelp {
    public synchronized boolean backup(Database database, String string) throws SQLException, IOException {
        Object object;
        Object object2;
        if (string == null) {
            throw new NullPointerException();
        }
        System.err.println("Backup begin...");
        String string2 = database.getWorkspace().getName();
        String string3 = database.getName();
        String string4 = string2 + "/";
        ZipOutputStream zipOutputStream = AbstractTransferHelp.createBackupVolume(string, string4);
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        properties.setProperty("version", "1.0");
        properties.setProperty("type", "BAK");
        properties.setProperty("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        properties.setProperty("realm", string2);
        properties.setProperty("database", string3);
        HashMap<String, AbstractTransferHelp.PK> hashMap = new HashMap<String, AbstractTransferHelp.PK>();
        Iterator iterator = database.tables().iterator();
        while (iterator.hasNext()) {
            object2 = (Table)iterator.next();
            object = object2.query(object2.fields().toArray(), null, false, 2);
            hashMap.put(object2.getName(), new AbstractTransferHelp.PK(this, (Table)object2, (Recordset)object));
        }
        iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            object2 = (AbstractTransferHelp.PK)iterator.next();
            object = ((AbstractTransferHelp.PK)object2).I;
            String string5 = object.getName();
            Recordset recordset = ((AbstractTransferHelp.PK)object2).Z;
            System.err.print("Backup " + string3 + "." + string5 + " ... ");
            n = AbstractTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string4 + object.getName() + ".dat"), recordset);
            recordset.close();
            System.err.println(n + " OK");
            stringBuffer.append(string5).append(";");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        zipOutputStream.putNextEntry(new ZipEntry("MANIFEST"));
        properties.setProperty("tableset", stringBuffer.toString());
        object2 = new ByteArrayOutputStream();
        properties.store((OutputStream)object2, "JREntServer profiling data backup archive");
        zipOutputStream.write(((ByteArrayOutputStream)object2).toByteArray());
        zipOutputStream.closeEntry();
        zipOutputStream.close();
        System.gc();
        System.err.println("Backup end");
        return true;
    }

    public synchronized boolean restore(Database database, String string) throws SQLException, IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        ZipFile zipFile = new ZipFile(string);
        Properties properties = AbstractTransferHelp.getVolumeSummary(zipFile);
        int n = Integer.parseInt(properties.getProperty("status"));
        if (n < 0) {
            throw (IOException)properties.get("exception");
        }
        String string2 = properties.getProperty("version");
        String string3 = properties.getProperty("type");
        String string4 = properties.getProperty("realm");
        String string5 = properties.getProperty("database");
        String string6 = database.getWorkspace().getName();
        String string7 = database.getName();
        if (!(string6.equals(string4) && string7.equals(string5) && string2.equals("1.0") && string3.equals("BAK"))) {
            throw new IOException("The " + string + " is not for " + string6 + "." + string7);
        }
        String string8 = string6 + "/";
        ZipEntry zipEntry = zipFile.getEntry(string8);
        if (zipEntry == null) {
            throw new IOException("The " + string + " is not for " + string6 + " workspace.");
        }
        List list = AbstractTransferHelp.getRestoreList(properties);
        if (list == null || list.size() == 0) {
            throw new IOException("The " + string + " can not be restored.");
        }
        System.err.println("Restore begin...");
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            String string9 = (String)iterator.next();
            Table table = database.tables(string9);
            String string10 = string8 + string9 + ".dat";
            ZipEntry zipEntry2 = zipFile.getEntry(string10);
            if (table == null || zipEntry2 == null) continue;
            System.err.print("Restore " + database.getName() + "." + string9 + " ...");
            table.delete("");
            AbstractTransferHelp.importsTableData(table, arrayList, zipFile.getInputStream(zipEntry2));
            int n2 = table.insert(arrayList);
            arrayList.clear();
            System.err.println(n2 + " OK");
        }
        zipFile.close();
        System.gc();
        System.err.println("Restore end");
        return true;
    }

    public synchronized boolean cutdownTable(Database database, Table table, String string, String string2) throws SQLException, IOException {
        String string3 = database.getWorkspace().getName();
        String string4 = database.getName();
        String string5 = table.getName();
        String string6 = database.getProperty("schema");
        String string7 = string6 != null && string6.length() > 0 ? "\"" + string6 + "\".TASKCONTEXT" : "TASKCONTEXT";
        if (!string7.equalsIgnoreCase(string5)) {
            throw new SQLException("Can not cut down " + string5 + " in " + string4);
        }
        String string8 = null;
        long l = 0L;
        if (string2 != null && string2.trim().length() > 0) {
            try {
                l = AbstractTransferHelp.DF.parse(string2).getTime() + 60000L;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        string8 = "WHERE TS_TSK_COMPLETE <= " + ((TableImpl)table).getDBAdapter().formatValue(new Timestamp(l));
        Properties properties = new Properties();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        properties.setProperty("version", "1.0");
        properties.setProperty("type", "CUT");
        properties.setProperty("date", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        properties.setProperty("realm", string3);
        properties.setProperty("database", string4);
        if (string != null && string.trim().length() > 0) {
            System.err.println("Backup begin...");
            String string9 = string3 + "/";
            ZipOutputStream zipOutputStream = AbstractTransferHelp.createBackupVolume(string, string9);
            Recordset recordset = table.query(table.fields().toArray(), string8 + " ORDER BY " + string7 + ".TS_TSK_COMPLETE ASC", false);
            String string10 = null;
            if (recordset.next()) {
                string10 = AbstractTransferHelp.DF.format(new Date(recordset.getTimestamp("TS_TSK_COMPLETE").getTime()));
            }
            System.err.print("Backup " + string4 + "." + string5 + " ... ");
            int n = AbstractTransferHelp.exportTableData(zipOutputStream, new ZipEntry(string9 + string5 + ".dat"), recordset);
            string10 = string10 != null ? string10 + " to " + AbstractTransferHelp.DF.format(new Date(recordset.getTimestamp("TS_TSK_COMPLETE").getTime())) : "";
            properties.setProperty("scope", string10);
            recordset.close();
            System.err.println(n + " OK");
            stringBuffer.append(string5);
            zipOutputStream.putNextEntry(new ZipEntry("MANIFEST"));
            properties.setProperty("tableset", stringBuffer.toString());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            properties.store(byteArrayOutputStream, "JREntServer profiling data cutdown archive");
            zipOutputStream.write(byteArrayOutputStream.toByteArray());
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            System.err.println("Backup end");
        }
        table.delete(string8);
        System.gc();
        return true;
    }

    public synchronized boolean importsTable(Database database, Table table, String string) throws SQLException, IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        ZipFile zipFile = new ZipFile(string);
        Properties properties = AbstractTransferHelp.getVolumeSummary(zipFile);
        int n = Integer.parseInt(properties.getProperty("status"));
        if (n < 0) {
            throw (IOException)properties.get("exception");
        }
        String string2 = properties.getProperty("version");
        String string3 = properties.getProperty("type");
        String string4 = properties.getProperty("realm");
        String string5 = properties.getProperty("database");
        String string6 = database.getWorkspace().getName();
        String string7 = database.getName();
        if (!(string6.equals(string4) && string7.equals(string5) && string2.equals("1.0") && string3.equals("CUT"))) {
            throw new IOException("The " + string + " is not for " + string6 + "." + string7);
        }
        String string8 = table.getName();
        String string9 = database.getProperty("schema");
        String string10 = string9 != null && string9.length() > 0 ? "\"" + string9 + "\".TASKCONTEXT" : "TASKCONTEXT";
        if (!string10.equalsIgnoreCase(string8)) {
            throw new SQLException("Can not import " + string8 + " in " + string7);
        }
        String string11 = string6 + "/";
        ZipEntry zipEntry = zipFile.getEntry(string11);
        if (zipEntry == null) {
            throw new IOException("The " + string + " is not for " + string6 + " workspace.");
        }
        List list = AbstractTransferHelp.getRestoreList(properties);
        if (list == null || list.size() == 0) {
            throw new IOException("The " + string + " can not be restored.");
        }
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            String string12 = (String)iterator.next();
            if (!string12.equals(string8)) {
                throw new IOException("The " + string + " not for " + string8);
            }
            String string13 = string11 + string12 + ".dat";
            ZipEntry zipEntry2 = zipFile.getEntry(string13);
            if (zipEntry2 == null) continue;
            System.err.print("Restore " + database.getName() + "." + string12 + " ...");
            AbstractTransferHelp.importsTableData(table, arrayList, zipFile.getInputStream(zipEntry2));
            int n2 = table.insert(arrayList);
            arrayList.clear();
            System.err.println(n2 + " OK");
        }
        zipFile.close();
        System.gc();
        System.err.println("Restore end");
        return true;
    }

    public synchronized void checkIntegrality(Database database, Map map) throws SQLException {
    }
}

