/*
 * Decompiled with CFR 0.152.
 */
package jet.server.db.version;

import java.io.File;
import java.sql.SQLException;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.db.Database;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.api.db.Recordset;
import jet.server.api.db.Table;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.core.DatabaseImpl;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.TableImpl;
import jet.server.db.version.ReportVersionRecord;
import jet.server.intf.version.ReportVersionTable;
import jet.server.log.ServiceLogger;

public class ReportVersionTableImpl
extends TableImpl
implements Table,
ReportVersionTable {
    private static String BIGINT = "REPORTVERSION_2";
    private static String INTEGER = "REPORTVERSION_1";
    private static final String[] QOIV = new String[]{"versionNumber", "versionName", "resourceID", "creator", "createTime", "modifier", "modifiedTime", "reportFile", "id"};

    public static ReportVersionTableImpl newInstance(Database database, UpdateDetailsTable updateDetailsTable) {
        try {
            return new ReportVersionTableImpl(database, updateDetailsTable);
        }
        catch (Exception exception) {
            ServiceLogger.logError(1640001, BIGINT, 1);
            ServiceLogger.logError(exception, 1);
            return null;
        }
    }

    private ReportVersionTableImpl(Database database, UpdateDetailsTable updateDetailsTable) throws InstantiationException, SQLException {
        super(database, BIGINT);
        super.append(new FieldImpl(this.getName(), QOIV[0], JDBCType.INTEGER, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), QOIV[1], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), QOIV[2], JDBCType.INTEGER, 0, 5, 0));
        super.append(new FieldImpl(this.getName(), QOIV[3], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), QOIV[4], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), QOIV[5], JDBCType.VARCHAR, 128, 0, 0));
        super.append(new FieldImpl(this.getName(), QOIV[6], JDBCType.BIGINT, 0, 1, 0));
        super.append(new FieldImpl(this.getName(), QOIV[7], JDBCType.VARCHAR, 128, 1, 0));
        super.append(new FieldImpl(this.getName(), QOIV[8], JDBCType.BIGINT, 0, 7, 0));
        if (!database.tables().contains(super.getName())) {
            this.adapter.createTable(this);
        }
        ((DatabaseImpl)database).append(this);
        try {
            boolean bl = database.tables().contains(INTEGER);
            boolean bl2 = updateDetailsTable.isUpdating(INTEGER);
            if (bl) {
                Table table = database.tables(INTEGER);
                if (!bl2) {
                    this.BIGINT(table);
                    updateDetailsTable.setUpdateDetails(INTEGER, true);
                }
                try {
                    this.adapter.dropTable(table);
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(3640001, table.getName(), 3);
                    ServiceLogger.logError(sQLException, 3);
                }
                ((DatabaseImpl)database).remove(table);
            }
            this.adapter.setID(this, this.fields(QOIV[8]), this.QOIV() + 1);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    public synchronized int addRecord(String string, int n, String string2, long l, String string3, long l2, String string4) {
        FieldValue[] fieldValueArray = super.fields().values();
        int n2 = this.INTEGER(n);
        fieldValueArray[0].setValue(new Integer(n2));
        fieldValueArray[1].setValue(string);
        fieldValueArray[2].setValue(new Integer(n));
        fieldValueArray[3].setValue(string2);
        fieldValueArray[4].setValue(new Long(l));
        fieldValueArray[5].setValue(string3);
        fieldValueArray[6].setValue(new Long(l2));
        fieldValueArray[7].setValue(this.adapter(string4, this.getHistDir()));
        fieldValueArray[8].setValue(new Integer(this.VARCHAR()));
        try {
            super.insert(fieldValueArray);
            return n2;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Object getRecord(int n, int n2) {
        ReportVersionRecord reportVersionRecord;
        block12: {
            Recordset recordset;
            block11: {
                reportVersionRecord = new ReportVersionRecord();
                String string = "WHERE " + super.fields(0).getName() + " = " + n + " AND " + super.fields(2).getName() + " = " + n2;
                recordset = null;
                recordset = super.query(this.fields().toArray(), string, true);
                if (!recordset.next()) break block11;
                reportVersionRecord.setVersionID(recordset.getInt(QOIV[0]));
                reportVersionRecord.setVersionName(recordset.getString(QOIV[1]));
                reportVersionRecord.setResourceID(recordset.getInt(QOIV[2]));
                reportVersionRecord.setCreator(recordset.getString(QOIV[3]));
                reportVersionRecord.setCreatedTime(recordset.getLong(QOIV[4]));
                reportVersionRecord.setModifier(recordset.getString(QOIV[5]));
                reportVersionRecord.setModifiedTime(recordset.getLong(QOIV[6]));
                reportVersionRecord.setReportFile(recordset.getString(QOIV[7]));
            }
            Object var8_6 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var8_7 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        recordset = null;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                    recordset = null;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return reportVersionRecord;
    }

    public synchronized boolean delRecord(int n, int n2) {
        String string = "WHERE " + super.fields(0).getName() + " = " + n + "AND " + super.fields(2).getName() + " = " + n2;
        try {
            int n3 = super.delete(string);
            return n3 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized boolean delRecords(int n) {
        String string = "WHERE " + super.fields(2).getName() + " = " + n;
        try {
            int n2 = super.delete(string);
            return n2 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getAllRecords(int n) {
        Vector<ReportVersionRecord> vector;
        block12: {
            vector = new Vector<ReportVersionRecord>();
            String string = "WHERE " + super.fields(2).getName() + " = " + n;
            Recordset recordset = null;
            recordset = super.query(this.fields().toArray(), string, true);
            while (recordset.next()) {
                ReportVersionRecord reportVersionRecord = new ReportVersionRecord();
                reportVersionRecord.setVersionID(recordset.getInt(QOIV[0]));
                reportVersionRecord.setVersionName(recordset.getString(QOIV[1]));
                reportVersionRecord.setResourceID(recordset.getInt(QOIV[2]));
                reportVersionRecord.setCreator(recordset.getString(QOIV[3]));
                reportVersionRecord.setCreatedTime(recordset.getLong(QOIV[4]));
                reportVersionRecord.setModifier(recordset.getString(QOIV[5]));
                reportVersionRecord.setModifiedTime(recordset.getLong(QOIV[6]));
                reportVersionRecord.setReportFile(recordset.getString(QOIV[7]));
                vector.addElement(reportVersionRecord);
            }
            Object var7_7 = null;
            try {
                if (recordset != null) {
                    recordset.close();
                }
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block12;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var7_8 = null;
                    try {
                        if (recordset != null) {
                            recordset.close();
                        }
                        recordset = null;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (recordset != null) {
                        recordset.close();
                    }
                    recordset = null;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return vector;
    }

    private void BIGINT(Table table) throws SQLException {
        Recordset recordset = table.query(table.fields().toArray(), null, false);
        while (recordset.next()) {
            String string = recordset.fields(QOIV[7]).getString();
            recordset.fields(QOIV[7]).setValue(this.adapter(string, this.getHistDir()));
            super.insert(recordset.fields());
        }
        recordset.close();
    }

    public synchronized boolean updateRecord(Object object) {
        ReportVersionRecord reportVersionRecord = (ReportVersionRecord)object;
        String string = " WHERE " + super.fields(0).getName() + " = " + reportVersionRecord.getVersionID() + " AND " + super.fields(2).getName() + " = " + reportVersionRecord.getResourceID();
        FieldValue[] fieldValueArray = super.fields().values();
        FieldValue[] fieldValueArray2 = new FieldValue[fieldValueArray.length - 1];
        int n = 0;
        while (n < fieldValueArray.length - 1) {
            fieldValueArray2[n] = fieldValueArray[n];
            ++n;
        }
        fieldValueArray2[0].setValue(new Integer(reportVersionRecord.getVersionID()));
        fieldValueArray2[1].setValue(reportVersionRecord.getVersionName());
        fieldValueArray2[2].setValue(new Integer(reportVersionRecord.getResourceID()));
        fieldValueArray2[3].setValue(reportVersionRecord.getCreator());
        fieldValueArray2[4].setValue(new Long(reportVersionRecord.getCreatedTime()));
        fieldValueArray2[5].setValue(reportVersionRecord.getModifier());
        fieldValueArray2[6].setValue(new Long(reportVersionRecord.getModifiedTime()));
        fieldValueArray2[7].setValue(this.adapter(reportVersionRecord.getReportFile(), this.getHistDir()));
        try {
            int n2 = super.update(fieldValueArray2, string);
            return n2 > 0;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return false;
        }
    }

    public synchronized Object getLatestVerRec(int n) {
        Number number = null;
        String string = "WHERE " + super.fields(2).getName() + " = " + n;
        try {
            number = super.queryMaxValue(QOIV[0], string, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number != null) {
            return this.getRecord(number.intValue(), n);
        }
        return null;
    }

    public synchronized Object getEarliestVerRec(int n) {
        Number number = null;
        String string = "WHERE " + super.fields(2).getName() + " = " + n;
        try {
            number = super.queryMinValue(QOIV[0], string, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number != null) {
            return this.getRecord(number.intValue(), n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized Vector getVersionNumbers(int n) {
        Vector<Integer> vector;
        block9: {
            vector = new Vector<Integer>();
            String string = "WHERE " + super.fields(2).getName() + " = " + n;
            Recordset recordset = null;
            Field[] fieldArray = new Field[]{this.fields(QOIV[0])};
            recordset = super.query(fieldArray, string, true);
            while (recordset.next()) {
                vector.addElement(new Integer(recordset.getInt(QOIV[0])));
            }
            Object var7_7 = null;
            try {
                recordset.close();
                recordset = null;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            break block9;
            {
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                    Object var7_8 = null;
                    try {
                        recordset.close();
                        recordset = null;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    recordset.close();
                    recordset = null;
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                throw throwable;
            }
        }
        return vector;
    }

    public synchronized int getVersionAmount(int n) {
        int n2 = 0;
        String string = "WHERE " + super.fields(2).getName() + " =" + n;
        try {
            n2 = super.querySumValue(QOIV[0], string, true).intValue();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return n2;
    }

    public synchronized boolean delEarliestVersion(int n) {
        Number number = null;
        String string = "WHERE " + super.fields(2).getName() + " = " + n;
        try {
            number = super.queryMinValue(QOIV[0], string, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number != null) {
            return this.delRecord(number.intValue(), n);
        }
        return false;
    }

    private synchronized int INTEGER(int n) {
        Number number = null;
        String string = "WHERE " + super.fields(2).getName() + " = " + n;
        try {
            number = super.queryMaxValue(QOIV[0], string, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        if (number == null || number.intValue() <= 0) {
            return 1;
        }
        return number.intValue() + 1;
    }

    private synchronized int QOIV() {
        Number number = null;
        try {
            number = super.queryMaxValue(QOIV[8], null, true);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        return number == null ? -1 : number.intValue();
    }

    private synchronized int VARCHAR() {
        try {
            return this.adapter.getID(this, this.fields(QOIV[8]));
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
            return 1;
        }
    }

    public boolean hasExternalData() {
        return true;
    }

    public String getExternalDataPath(FieldValue[] fieldValueArray) {
        String string;
        int n;
        String string2 = (String)fieldValueArray[7].getValue();
        if (string2 != null && string2.length() != 0 && (n = string2.lastIndexOf(File.separator)) > 0) {
            string2 = string2.substring(0, n);
        }
        if (!(string = this.getHistDir()).endsWith(File.separator)) {
            string = string + File.separator;
        }
        return string + string2;
    }

    private String getHistDir() {
        String string = System.getProperty("history_dir") != null ? System.getProperty("history_dir") : ServerEnv.homePath + "history";
        string = ServerEnv.isSharedHistDir() ? ServerEnv.getSharedHistDir() : string;
        return string;
    }

    private String adapter(String string, String string2) {
        String string3 = string2.endsWith(File.separator) ? string2 : string2 + File.separator;
        return string.startsWith(string3) ? string.substring(string3.length()) : string;
    }
}

