/*
 * Decompiled with CFR 0.152.
 */
package jet.server.intf.resource;

import java.security.acl.Permission;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.NodeExistsException;
import jet.server.api.exception.UnknownResource;
import jet.server.intf.resource.Folder;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.Resource;
import jet.server.intf.resource.ResourceInfo;
import jet.server.intf.resource.Version;
import jet.server.intf.security.SecurityService;
import jet.server.intf.security.User;
import jet.server.jrc.JRSchedulingService;
import jet.server.util.ui.UITree;

public interface ResourceTreeManager {
    public void initTree() throws SQLException;

    public void loadDefaultTree() throws SQLException, NoPrivilegeException;

    public Folder addSubFolder(Folder var1, Hashtable var2, String var3) throws NoPrivilegeException, NodeExistsException;

    public Version addResource(Folder var1, Hashtable var2, ResourceInfo var3, String var4) throws NoPrivilegeException, NodeExistsException;

    public Version addResult(Resource var1, Hashtable var2, ResourceInfo var3, String var4) throws NoPrivilegeException;

    public Version addVersion(Resource var1, ResourceInfo var2, String var3, Hashtable[] var4, String var5) throws NoPrivilegeException;

    public Vector getChildren(Folder var1, String var2) throws NoPrivilegeException;

    public Vector getSubFolders(Folder var1, String var2) throws NoPrivilegeException;

    public Vector getResources(Folder var1, String var2) throws NoPrivilegeException;

    public Vector getVersions(Resource var1, String var2) throws NoPrivilegeException;

    public void removeChild(Folder var1, Node var2, String var3) throws NoPrivilegeException;

    public void removeVersion(int var1, String var2) throws NoPrivilegeException;

    public UITree getUITreeByUser(String var1);

    public UITree getUITree();

    public Node getNodeByPath(String var1, String var2) throws NoPrivilegeException, UnknownResource;

    public Node getNodeByPath(String var1) throws UnknownResource;

    public Node getNodeByID(int var1, String var2) throws NoPrivilegeException;

    public Node getNodeByID(int var1);

    public void setMaxVersionAmount(Resource var1, int var2);

    public Version getVersion(String var1, int var2, String var3) throws NoPrivilegeException, UnknownResource;

    public Version getVersion(String var1, int var2, String var3, boolean var4) throws NoPrivilegeException, UnknownResource;

    public void setNodeProperties(Node var1, Hashtable var2, Hashtable[] var3, String var4) throws NoPrivilegeException, NodeExistsException;

    public boolean checkPermission(String var1, String var2, Permission var3) throws NoSuchUserException, UnknownResource;

    public boolean checkPermission(String var1, int var2, String var3, Permission var4) throws NoSuchUserException, UnknownResource;

    public boolean checkPermission(Node var1, User var2, Permission var3);

    public SecurityService getSecurityService();

    public void setSchedulingService(JRSchedulingService var1);

    public String convertReports(String var1, boolean var2, boolean var3, boolean var4);

    public void quit();
}

