/*
 * Decompiled with CFR 0.152.
 */
package jet.server.intf.security;

import java.security.Principal;
import java.security.acl.NotOwnerException;
import java.util.Date;
import java.util.Vector;
import jet.cs.jacl.JAcl;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.RoleExistsException;
import jet.server.api.exception.UserExistsException;
import jet.server.jrc.security.AclManager;
import jet.server.jrc.security.RoleManager;
import jet.server.jrc.security.UserManager;
import jet.server.jrc.security.ldap.intf.LDAPGroup;
import jet.server.jrc.security.ldap.intf.LDAPUser;

public interface SecurityProvider {
    public JAcl getAclByID(int var1) throws NoSuchAclException, NotOwnerException;

    public String updateAttributes(String var1, String var2, String var3, String var4, boolean var5, int var6, Date var7, boolean var8, int var9, boolean var10) throws NoSuchUserException;

    public String addNewUser(String var1, String var2, String var3, String var4, String var5, Date var6, String var7, boolean var8, int var9, Date var10, boolean var11, int var12, boolean var13) throws UserExistsException;

    public String updataEvent(String var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6) throws NoSuchUserException;

    public int getUserParentRolesCount(String var1) throws NoSuchUserException;

    public String addUserToParentRole(String var1, String var2) throws NoSuchRoleException, NoSuchUserException;

    public int getRoleSubMembersCount(String var1) throws NoSuchRoleException;

    public Vector getSubRolesByRole(String var1) throws NoSuchRoleException;

    public Vector getSubUsersByRole(String var1) throws NoSuchRoleException;

    public Vector getSubUsersNameByRole(String var1) throws NoSuchRoleException;

    public String addSubUserToRole(String var1, String var2) throws NoSuchRoleException, NoSuchUserException;

    public String addSubRoleToRole(String var1, String var2) throws NoSuchRoleException;

    public String addNewRole(String var1, String var2) throws RoleExistsException;

    public String removeRoleFromParentRole(String var1, String var2) throws NoSuchRoleException;

    public String removeUserFromParentRole(String var1, String var2) throws NoSuchRoleException, NoSuchUserException;

    public String removeUser(String var1, String var2) throws NoSuchUserException, InUseException;

    public String removeRole(String var1) throws NoSuchRoleException, InUseException;

    public Vector getParentRolesByUser(String var1) throws NoSuchUserException;

    public AclManager getAclManager();

    public RoleManager getRoleManager();

    public UserManager getUserManager();

    public String getPassword(String var1) throws NoSuchUserException;

    public JAcl getDefaultAcl() throws NoSuchAclException;

    public boolean isExpired(String var1);

    public Vector getImportedLDAPUsers();

    public Vector getImportedLDAPUserNames();

    public Vector getImportedLDAPRoles();

    public Vector getImportedLDAPRoleNames();

    public Vector getImportedLDAPGroups();

    public Vector getImportedLDAPGroupNames();

    public String addLDAPUser(LDAPUser var1, boolean var2);

    public String addLDAPGroup(LDAPGroup var1, boolean var2);

    public boolean removeUserInherRelation(String var1);

    public boolean removeRoleInherRelation(String var1);

    public boolean removeGroupInherRelation(String var1);

    public JAcl getExtendAcl() throws NoSuchAclException;

    public void setPrincipalPrivileges(Principal var1, Vector var2);

    public Vector getPrincipalPrivileges(Principal var1);

    public Vector getPrivilegedPrincipals(byte var1, String var2);

    public void addPrivilegedPrincipal(String var1, Vector var2, byte var3);

    public String removePrivilegedPrincipals(String var1, Vector var2, byte var3);

    public String addNewGroup(String var1, String var2) throws GroupExistsException;

    public String removeGroup(String var1) throws InUseException, NoSuchGroupException;

    public String addSubGroupToGroup(String var1, String var2) throws NoSuchGroupException;

    public String addUserToGroup(String var1, String var2) throws NoSuchGroupException, NoSuchUserException;

    public String addGroupToRole(String var1, String var2) throws NoSuchGroupException, NoSuchRoleException;

    public String removeSubGroupFromGroup(String var1, String var2) throws NoSuchGroupException;

    public String removeUserFromGroup(String var1, String var2) throws NoSuchGroupException, NoSuchUserException;

    public String removeGroupFromRole(String var1, String var2) throws NoSuchGroupException, NoSuchRoleException;

    public Vector getSubGroupsByGroup(String var1) throws NoSuchGroupException;

    public Vector getGroupsByUser(String var1) throws NoSuchUserException;

    public Vector getUsersByGroup(String var1) throws NoSuchGroupException;

    public Vector getRolesByGroup(String var1) throws NoSuchGroupException;

    public Vector getGroupsByRole(String var1) throws NoSuchRoleException;
}

