/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.cluster.Member;
import jet.server.intf.jrs.BackupService;
import jet.server.jrc.JRClusterService;
import jet.server.jrc.PromoteThread;
import jet.server.jrserver.JRRptServer;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;

public class JRBackupService
extends UnicastRemoteObject
implements BackupService {
    private JRRptServer QOIV = null;
    private Member[] append = null;
    private PromoteThread enableNotifyServerDown = null;
    private long getClusterService = 0L;
    private boolean getLocalMember = false;

    public JRBackupService(boolean bl) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.getLocalMember = bl;
    }

    public void setRptServer(JRRptServer jRRptServer) {
        this.QOIV = jRRptServer;
        if (this.getLocalMember) {
            this.enableNotifyServerDown = new PromoteThread(this);
            this.enableNotifyServerDown.setPriority(10);
            this.enableNotifyServerDown.start();
        }
    }

    public synchronized void upgradeToAdminServer() {
        try {
            this.QOIV.rebuildAdminServer();
            System.out.println(JSvrResource.getMessage("SVR_83"));
            Member member = this.QOIV.getClusterService().getLocalMember();
            if (ServerEnv.enableNotifyServerDown()) {
                try {
                    ServerUtil.sendNormalMail(ServerEnv.getNotifyServerDownAddress(), null, null, JSvrResource.getMessage("SVR_89", member.getServerName()), JSvrResource.getMessage("SVR_90", new String[]{member.getServerName(), "" + new Date()}), null);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 5);
                }
            }
            ServiceLogger.logEvent(6650025, 6);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
        }
    }

    public boolean isAdminServerRestarted() {
        if (this.QOIV != null) {
            JRClusterService jRClusterService = (JRClusterService)this.QOIV.getClusterService();
            return jRClusterService.isAdminServerRestarted();
        }
        return false;
    }

    public synchronized void rebuildRemoteServices(String string, int n) throws RemoteException {
        try {
            if ((this.isAdminServerCrashed() || this.isAdminServerRestarted()) && this.QOIV != null) {
                this.QOIV.rebuildClusteredServer(string, n);
                ServiceLogger.logEvent(6650026, new String[]{string, "" + n}, 6);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
            throw new ServerException("", exception);
        }
    }

    public void refreshActiveMembers(Member[] memberArray, long l) throws RemoteException {
        this.append = memberArray;
        this.getClusterService = l;
        JRClusterService jRClusterService = (JRClusterService)this.QOIV.getClusterService();
        jRClusterService.setCreateAdminServerTime(l);
    }

    public boolean isAdminServerCrashed() {
        if (this.QOIV != null) {
            JRClusterService jRClusterService = (JRClusterService)this.QOIV.getClusterService();
            return jRClusterService.isAdminServerCrashed();
        }
        return false;
    }

    public synchronized void startUpgrading() throws RemoteException {
        if (this.QOIV == null || this.enableNotifyServerDown == null) {
            throw new ServerException("Can not promoted to admin server: invalid backup server!");
        }
        this.enableNotifyServerDown.notifyPromote();
    }

    public Member[] getActiveMembers() {
        return this.append;
    }
}

