/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Date;
import jet.JSRuntimeException;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.ClusterService;
import jet.server.api.cluster.LoadBalancer;
import jet.server.api.cluster.Member;
import jet.server.api.cluster.ReportMember;
import jet.server.intf.jrs.BackupService;
import jet.server.intf.jrs.ClusterReceiver;
import jet.server.intf.jrs.MemberManager;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.jrc.ConnectAdminServerThread;
import jet.server.jrc.JRClusterReceiver;
import jet.server.jrc.JRLoadBalancer;
import jet.server.jrc.JRMemberManager;
import jet.server.jrc.JRRandomLoadBalancer;
import jet.server.jrc.JRReportMember;
import jet.server.jrc.JRRoundLoadBalancer;
import jet.server.jrc.JRWeightLoadBalancer;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.util.ServerUtil;

public class JRClusterService
implements ClusterService,
Runnable {
    private int QOIV = 0;
    private String append = null;
    private int backupService;
    private int canAcceptMember;
    private String clearMem = null;
    private JRClusterReceiver currentThread = null;
    private ClusterReceiver dealAdminServerCrash = null;
    private boolean enableNotifyServerDown = false;
    private boolean equals = true;
    private JRReportMember err = null;
    private LoadBalancer forName = null;
    private MemberManager getAdminMember = null;
    private Member[] getAllMembers = null;
    private int getBackupPriority = 0;
    private long getCause = 0L;
    private int getConcurrentReports = 30000;
    private int getCreateAdminServerTime = 3;

    public JRClusterService(boolean bl, boolean bl2, String string, int n, int n2, String string2, ReportMember[] reportMemberArray, Member[] memberArray, int n3, int n4) throws ClusterException {
        if (bl) {
            this.QOIV = 1;
            this.canAcceptMember = n;
        } else {
            this.canAcceptMember = n2;
            if (bl2) {
                this.QOIV = 2;
            }
        }
        this.append = string.trim();
        this.clearMem = string2.trim();
        this.backupService = n;
        this.getAllMembers = memberArray;
        this.getConcurrentReports = n3;
        this.getCreateAdminServerTime = n4;
        this.init(reportMemberArray);
    }

    /*
     * Unable to fully structure code
     */
    private void init(ReportMember[] var1_1) throws ClusterException {
        if (this.append != null) {
            try {
                block24: {
                    var2_2 = this.append + ":" + this.backupService;
                    this.currentThread = new JRClusterReceiver(var1_1);
                    RemoteObjectFactory.register("ClusterReceiver", this.currentThread);
                    this.err = new JRReportMember(this.QOIV, ServerEnv.getQueueSize(), this.clearMem, String.valueOf(this.QOIV == 1 ? this.backupService : this.canAcceptMember));
                    if (this.QOIV == 1) {
                        this.getAdminMember = new JRMemberManager(this.currentThread);
                        var3_4 = var1_1.length;
                        var4_8 = 0;
                        while (var4_8 < var3_4) {
                            if (var1_1[var4_8].equals(this.err)) {
                                this.err.setServerName(var1_1[var4_8].getServerName());
                                this.err.setBackupPriority(var1_1[var4_8].getBackupPriority());
                                break;
                            }
                            ++var4_8;
                        }
                        RemoteObjectFactory.register("MemberManager", this.getAdminMember);
                        this.forName = this.getLoadBanlancer();
                        ((JRMemberManager)this.getAdminMember).setLoadBalancer(this.forName);
                        this.currentThread.setMemberManager((JRMemberManager)this.getAdminMember);
                    }
                    System.out.println(JSvrResource.getMessage("SVR_74", "[" + var2_2 + "]"));
                    ServiceLogger.logEvent(6650023, var2_2, 6);
                    try {
                        this.getAdminMember = (MemberManager)RemoteObjectFactory.getRemoteObject(this.append, this.backupService, "MemberManager");
                        if (!this.getAdminMember.isAdminServerPrepared()) {
                            throw new Exception("not prepared");
                        }
                        break block24;
                    }
                    catch (Exception var3_5) {
                        var4_9 = 0;
                        ** while (var4_9 < 10)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Thread.sleep(6000L);
                            System.out.print(JSvrResource.getMessage("SVR_77", String.valueOf(var4_9)));
                            this.getAdminMember = (MemberManager)RemoteObjectFactory.getRemoteObject(this.append, this.backupService, "MemberManager");
                            if (this.getAdminMember.isAdminServerPrepared()) {
                                break;
                            }
                        }
                        catch (Exception var5_11) {
                            ServiceLogger.logError(var5_11, 3);
                        }
                        ++var4_9;
                        continue;
                    }
lbl44:
                    // 2 sources

                    try {
                        this.getAdminMember = (MemberManager)RemoteObjectFactory.getRemoteObject(this.append, this.backupService, "MemberManager");
                        if (!this.getAdminMember.isAdminServerPrepared()) {
                            throw new Exception("not prepared");
                        }
                    }
                    catch (Exception var5_12) {
                        ServiceLogger.logError(var5_12, 2);
                        System.err.println(JSvrResource.getMessage("SVR_76", "[" + var2_2 + "]"));
                        throw new JSRuntimeException(650009, new Object[]{var2_2}, null);
                    }
                }
                this.err = (JRReportMember)this.getAdminMember.canAcceptMember(this.err);
                if (this.err == null) {
                    throw new JSRuntimeException(650010);
                }
                try {
                    this.dealAdminServerCrash = (ClusterReceiver)RemoteObjectFactory.getRemoteObject(this.append, this.backupService, "ClusterReceiver");
                }
                catch (RemoteException var3_6) {
                    ServiceLogger.logError(var3_6);
                }
                catch (MalformedURLException var4_10) {
                    ServiceLogger.logError(var4_10);
                }
                catch (NotBoundException var5_13) {
                    ServiceLogger.logError(var5_13);
                }
                System.out.println(JSvrResource.getMessage("SVR_75", "[" + var2_2 + "]"));
                ServiceLogger.logEvent(6650014, var2_2, 6);
            }
            catch (UnknownHostException var2_3) {
                throw new ClusterException(650002);
            }
            catch (RemoteException var3_7) {
                throw new ClusterException(650003);
            }
        } else {
            throw new ClusterException(650004);
        }
        if (this.QOIV == 1) {
            this.registerLocalMember();
        }
    }

    public MemberManager getMemberManager() {
        return this.getAdminMember;
    }

    public ReportMember[] getPredefinedMembers() {
        return this.currentThread.getPredefinedMembers();
    }

    public JRClusterReceiver getClusterReceiver() {
        return this.currentThread;
    }

    public String getClusterName() {
        return "JReport Cluster";
    }

    public LoadBalancer getLoadBanlancer() throws RemoteException {
        LoadBalancer loadBalancer = null;
        try {
            String string = ServerEnv.getCustomLoadBalancer();
            if (string != null && string.trim().length() > 0) {
                loadBalancer = (LoadBalancer)Class.forName(string).newInstance();
                ServiceLogger.logEvent(6650015, string, 6);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 2);
            ServiceLogger.logEvent(6650016, throwable, 6);
        }
        if (loadBalancer == null) {
            int n = ServerEnv.getLoadBalancerType();
            ServiceLogger.logEvent(5650001, String.valueOf(n), 5);
            switch (n) {
                case 0: {
                    loadBalancer = new JRLoadBalancer();
                    break;
                }
                case 1: {
                    loadBalancer = new JRRoundLoadBalancer(this);
                    break;
                }
                case 2: {
                    loadBalancer = new JRWeightLoadBalancer();
                    break;
                }
                case 3: {
                    loadBalancer = new JRRandomLoadBalancer(this);
                    break;
                }
                default: {
                    loadBalancer = new JRLoadBalancer();
                    ServiceLogger.logEvent(6650017, String.valueOf(n), 6);
                    ServiceLogger.logEvent("Unknown load balancer type: " + n + "! Use the default load balancer.");
                }
            }
        }
        return loadBalancer;
    }

    public Member[] getAllMembers() throws ClusterException {
        try {
            return this.getAdminMember.getAllMembers();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException, 2);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException, 2);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 2);
            throw new ClusterException(remoteException);
        }
    }

    public Member getLocalMember() {
        return this.err;
    }

    public Member getAdminMember() throws ClusterException {
        try {
            if (this.err.isAdmin()) {
                return this.err;
            }
            return this.getAdminMember.getAdminMember();
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException, 2);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException, 2);
            ServerEnv.dealAdminServerCrash();
            return null;
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 2);
            throw new ClusterException(remoteException);
        }
    }

    public LoadBalancer getDefaultLoadBalancer() {
        return this.forName;
    }

    public void setDefaultLoadBalancer(LoadBalancer loadBalancer) {
        this.forName = loadBalancer;
    }

    public synchronized Member getMember() {
        Member[] memberArray = new Member[]{};
        String string = null;
        try {
            memberArray = this.getAdminMember.getAllMembers();
            string = this.getAdminMember.selectMember(this.err.getServerName());
        }
        catch (ConnectException connectException) {
            ServiceLogger.logError(connectException, 2);
            ServerEnv.dealAdminServerCrash();
        }
        catch (ConnectIOException connectIOException) {
            ServiceLogger.logError(connectIOException, 2);
            ServerEnv.dealAdminServerCrash();
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 2);
        }
        if (string == null) {
            return this.err;
        }
        return this.getMember(string, memberArray);
    }

    public Member getMember(String string, Member[] memberArray) {
        int n = 0;
        while (n < memberArray.length) {
            if (string.equals(memberArray[n].getServerName())) {
                return memberArray[n];
            }
            ++n;
        }
        return this.err;
    }

    public void registerLocalMember() throws ClusterException {
        try {
            this.getAdminMember.registerMember(this.err);
            ServiceLogger.logDebug(6650018, this.err, 6);
            if (this.QOIV != 1) {
                this.start();
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 2);
            throw new ClusterException(remoteException);
        }
    }

    public void removeLocalMember() throws ClusterException {
        try {
            this.getAdminMember.removeMember(this.err);
            ServiceLogger.logDebug(6650019, this.err, 6);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 2);
            throw new ClusterException(remoteException);
        }
    }

    public int getConcurrentReports(Member member) throws Exception {
        MemberMonitor memberMonitor = null;
        memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(member.getHost(), CSUtil.parseInt(member.getPort()), "MemberMonitor");
        return memberMonitor.getConcurrentReports();
    }

    public boolean isAdminServerCrashed() {
        boolean bl = false;
        MemberManager memberManager = null;
        try {
            memberManager = (MemberManager)RemoteObjectFactory.getRemoteObject(this.append, this.backupService, "MemberManager");
            memberManager.getAdminMember();
        }
        catch (ConnectIOException connectIOException) {
            if (connectIOException.getCause() instanceof SocketTimeoutException) {
                ServiceLogger.logError(connectIOException, 2);
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = true;
            ServiceLogger.logError(exception, 2);
        }
        return bl;
    }

    public boolean isAdminServerRestarted() {
        boolean bl = false;
        try {
            if (this.getCause != this.getAdminMember.getCreateAdminServerTime()) {
                bl = true;
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 2);
            try {
                MemberManager memberManager = (MemberManager)RemoteObjectFactory.getRemoteObject(this.append, this.backupService, "MemberManager");
                if (this.getCause != memberManager.getCreateAdminServerTime()) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
            }
        }
        return bl;
    }

    public void setCreateAdminServerTime(long l) {
        this.getCause = l;
    }

    public String getAdminAddress() {
        return this.append + ":" + this.backupService;
    }

    public void setAdminServerPrepared() {
        ((JRMemberManager)this.getAdminMember).setAdminServerPrepared();
        Member[] memberArray = null;
        memberArray = this.getAllMembers != null ? this.getAllMembers : this.getPredefinedMembers();
        int n = 0;
        while (n < memberArray.length) {
            if (!memberArray[n].equals(this.err)) {
                ConnectAdminServerThread connectAdminServerThread = new ConnectAdminServerThread(this.err, memberArray[n]);
                connectAdminServerThread.start();
            }
            ++n;
        }
        ServiceLogger.logDebug(6650020, this.err, 6);
        this.start();
    }

    public void notifyPromoteAdminServer() {
        if (!this.isAdminServerCrashed() && this.isAdminServerRestarted()) {
            return;
        }
        ReportMember[] reportMemberArray = this.currentThread.getPredefinedBackupServers();
        int n = 0;
        if (reportMemberArray != null) {
            while (n < reportMemberArray.length) {
                try {
                    ServiceLogger.logEvent(6650021, new String[]{reportMemberArray[n].getServerName(), reportMemberArray[n].getHost(), reportMemberArray[n].getPort()}, 6);
                    BackupService backupService = (BackupService)RemoteObjectFactory.getRemoteObject(reportMemberArray[n].getHost(), Integer.parseInt(reportMemberArray[n].getPort()), "BackupService");
                    backupService.startUpgrading();
                    break;
                }
                catch (NotBoundException notBoundException) {
                    try {
                        RemoteObjectFactory.getRemoteObject(reportMemberArray[n].getHost(), Integer.parseInt(reportMemberArray[n].getPort()), "MemberManager");
                        break;
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 2);
                }
                ++n;
            }
        }
        if (n == 0 || reportMemberArray == null || reportMemberArray != null && n >= reportMemberArray.length) {
            ServiceLogger.logDebug(6650022, new String[]{this.err.getServerName(), "" + new Date()}, 6);
        }
        if ((n == 0 || n >= reportMemberArray.length) && this.equals && ServerEnv.enableNotifyServerDown()) {
            try {
                ServerUtil.sendNormalMail(ServerEnv.getNotifyServerDownAddress(), null, null, JSvrResource.getMessage("SVR_91", this.err.getServerName()), JSvrResource.getMessage("SVR_92", new String[]{this.err.getServerName(), "" + new Date()}), null);
                this.equals = false;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 5);
            }
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.getConcurrentReports);
            }
            catch (InterruptedException interruptedException) {
                ServiceLogger.logError(interruptedException, 3);
            }
            if (this.enableNotifyServerDown) break;
            if (!this.err.isAdmin()) {
                try {
                    if (!this.isAdminServerRestarted()) {
                        if (this.dealAdminServerCrash == null) {
                            this.dealAdminServerCrash = (ClusterReceiver)RemoteObjectFactory.getRemoteObject(this.append, this.backupService, "ClusterReceiver");
                        }
                        this.dealAdminServerCrash.receive(this.err);
                    } else {
                        System.out.println(JSvrResource.getMessage("SVR_85"));
                        ServiceLogger.logEvent(5650002, 5);
                        ServerEnv.backupService.rebuildRemoteServices(this.append, this.backupService);
                    }
                    this.getBackupPriority = 0;
                }
                catch (Exception exception) {
                    if (++this.getBackupPriority < this.getCreateAdminServerTime) continue;
                    System.out.println(JSvrResource.getMessage("SVR_84"));
                    ServiceLogger.logEvent(4650024, 4);
                    ServiceLogger.logError(exception, 2);
                    this.notifyPromoteAdminServer();
                    this.getBackupPriority = 0;
                }
                continue;
            }
            try {
                this.getAdminMember.getAllMembers();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 6);
            }
        }
    }

    public void start() {
        Thread thread = new Thread(this);
        ThreadGroup threadGroup = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            threadGroup = securityManager.getThreadGroup();
        }
        if (threadGroup == null) {
            threadGroup = Thread.currentThread().getThreadGroup();
        }
        threadGroup.setMaxPriority(10);
        thread.setPriority(10);
        thread.start();
    }

    public void quit() {
        this.enableNotifyServerDown = true;
    }

    public void clearMem() {
        this.currentThread.clearMem();
        this.currentThread = null;
        this.dealAdminServerCrash = null;
        this.err = null;
        this.forName = null;
        this.getAdminMember = null;
        this.getAllMembers = null;
    }

    public boolean isTaskQueueFull(int n) {
        try {
            ReportMember[] reportMemberArray = this.getAdminMember.getAllMembers();
            int n2 = reportMemberArray.length;
            String string = null;
            int n3 = 0;
            while (n3 < n2) {
                ReportMember reportMember = reportMemberArray[n3];
                string = reportMember.getHost();
                int n4 = Integer.parseInt(reportMember.getPort());
                try {
                    MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(string, n4, "MemberMonitor");
                    if (!memberMonitor.isTaskQueueFull(n)) {
                        return false;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    ServiceLogger.logError(malformedURLException);
                }
                catch (NotBoundException notBoundException) {
                    ServiceLogger.logError(notBoundException);
                }
                ++n3;
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        return true;
    }
}

