/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import jet.JSvrResource;
import jet.server.ServerEnv;
import jet.server.api.cluster.ReportMember;
import jet.server.intf.jrs.ClusterListener;
import jet.server.intf.jrs.MemberTable;
import jet.server.jrc.JRClusterReceiver;
import jet.server.log.ServiceLogger;
import jet.server.util.ServerUtil;

public class JRMemberTable
implements MemberTable {
    public static final String CLUSTER_TOPIC = "ClusterService";
    public static final int START_SERVER = 0;
    public static final int SHUT_SERVER = 1;
    public static final int CRASH_SERVER = 2;
    public static final String SERVER_NAME = "serverName";
    public static final String SERVER_HOST = "serverHost";
    public static final String SERVER_PORT = "serverPort";
    public static final String SERVER_TYPE = "serverType";
    public static final String START_TIME = "startTime";
    public static final String CLOSE_TIME = "closeTime";
    public static final String CRASH_REASON = "crashReason";
    public static int ADMIN_SERVER = 0;
    public static int BACKUP_SERVER = 1;
    public static int SLAVE_SERVER = 2;
    private ReportMember[] QOIV = new ReportMember[0];
    private JRClusterReceiver addServerCrashedEventToMonitor = null;
    private boolean addServerShutdownEventToMonitor = false;
    private ClusterListener addServerStartupEventToMonitor;

    public JRMemberTable(JRClusterReceiver jRClusterReceiver) {
        this.addServerCrashedEventToMonitor = jRClusterReceiver;
    }

    public ReportMember[] getAllMembers() {
        this.refreshMemberTable();
        return this.QOIV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReportMember getAdminMember() {
        ReportMember[] reportMemberArray = this.QOIV;
        synchronized (reportMemberArray) {
            int n = this.QOIV.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.QOIV[n2].isAdmin()) {
                    return this.QOIV[n2];
                }
                ++n2;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMember(ReportMember reportMember) {
        this.addServerStartupEventToMonitor(reportMember.getServerName() == null ? "" : reportMember.getServerName(), reportMember.getHost() == null ? "" : reportMember.getHost(), reportMember.getPort() == null ? "" : reportMember.getPort(), reportMember.isAdmin() ? ADMIN_SERVER : (reportMember.isBackupAdmin() ? BACKUP_SERVER : SLAVE_SERVER), System.currentTimeMillis());
        if (this.BACKUP_SERVER(reportMember) == -1) {
            ReportMember[] reportMemberArray = this.QOIV;
            synchronized (reportMemberArray) {
                ReportMember[] reportMemberArray2 = new ReportMember[this.QOIV.length + 1];
                System.arraycopy(this.QOIV, 0, reportMemberArray2, 0, this.QOIV.length);
                reportMemberArray2[this.QOIV.length] = reportMember;
                this.QOIV = reportMemberArray2;
            }
        }
        if (!reportMember.isAdmin()) {
            System.out.println(JSvrResource.getMessage("SVR_78", reportMember));
        }
        ServiceLogger.logDebug(6650030, reportMember, 6);
    }

    public void removeMember(ReportMember reportMember) {
        this.addServerShutdownEventToMonitor(reportMember.getHost() == null ? "" : reportMember.getHost(), reportMember.getPort() == null ? "" : reportMember.getPort(), System.currentTimeMillis());
        int n = this.BACKUP_SERVER(reportMember);
        if (n != -1) {
            this.ADMIN_SERVER(n);
            if (!reportMember.isAdmin()) {
                System.out.println(JSvrResource.getMessage("SVR_79", reportMember));
            }
            if (ServerEnv.enableNotifyServerDown()) {
                try {
                    ReportMember reportMember2 = null;
                    reportMember2 = reportMember.isAdmin() ? reportMember : this.getAdminMember();
                    String string = reportMember2.getServerName() + "(" + reportMember2.getHost() + ":" + reportMember2.getPort() + ")";
                    ServerUtil.sendNormalMail(ServerEnv.getNotifyServerDownAddress(), null, null, JSvrResource.getMessage("SVR_87", reportMember.getServerName()), JSvrResource.getMessage("SVR_88", new String[]{reportMember.getServerName(), string, "" + new Date()}), null);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 5);
                }
            }
            ServiceLogger.logDebug(6650031, reportMember, 6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ADMIN_SERVER(int n) {
        ReportMember[] reportMemberArray = this.QOIV;
        synchronized (reportMemberArray) {
            ReportMember[] reportMemberArray2 = new ReportMember[this.QOIV.length - 1];
            System.arraycopy(this.QOIV, 0, reportMemberArray2, 0, n);
            System.arraycopy(this.QOIV, n + 1, reportMemberArray2, n, reportMemberArray2.length - n);
            this.QOIV = reportMemberArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyConcurrentReports(ReportMember reportMember) {
        ReportMember[] reportMemberArray = this.QOIV;
        synchronized (reportMemberArray) {
            int n = 0;
            while (n < this.QOIV.length) {
                if (this.QOIV[n].equals(reportMember)) {
                    this.QOIV[n].setConcurrentReports(reportMember.getConcurrentReports());
                    break;
                }
                ++n;
            }
        }
    }

    public void refreshMemberTable() {
        int n = 0;
        while (n < this.QOIV.length) {
            if (!this.QOIV[n].isAdmin()) {
                ReportMember reportMember;
                boolean bl = false;
                Enumeration enumeration = this.addServerCrashedEventToMonitor.getActiveServers();
                while (enumeration.hasMoreElements()) {
                    reportMember = (ReportMember)enumeration.nextElement();
                    if (!this.QOIV[n].equals(reportMember)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.addServerCrashedEventToMonitor(this.QOIV[n].getHost() == null ? "" : this.QOIV[n].getHost(), this.QOIV[n].getPort() == null ? "" : this.QOIV[n].getPort(), System.currentTimeMillis(), JSvrResource.getMessage("SVR_79", this.QOIV[n]));
                    System.out.println(JSvrResource.getMessage("SVR_79", this.QOIV[n]));
                    if (ServerEnv.enableNotifyServerDown()) {
                        try {
                            reportMember = this.getAdminMember();
                            String string = reportMember.getServerName() + "(" + reportMember.getHost() + ":" + reportMember.getPort() + ")";
                            ServerUtil.sendNormalMail(ServerEnv.getNotifyServerDownAddress(), null, null, JSvrResource.getMessage("SVR_87", this.QOIV[n].getServerName()), JSvrResource.getMessage("SVR_88", new String[]{this.QOIV[n].getServerName(), string, "" + new Date()}), null);
                        }
                        catch (Exception exception) {
                            ServiceLogger.logError(exception, 5);
                        }
                    }
                    ServiceLogger.logDebug(6650031, this.QOIV[n], 6);
                    this.addServerStartupEventToMonitor.removeMember(this.QOIV[n]);
                    this.ADMIN_SERVER(n);
                    --n;
                }
            }
            ++n;
        }
    }

    private int BACKUP_SERVER(ReportMember reportMember) {
        int n = -1;
        int n2 = this.QOIV.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.QOIV[n3].equals(reportMember)) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n;
    }

    public void addClusterListener(ClusterListener clusterListener) {
        this.addServerStartupEventToMonitor = clusterListener;
    }

    public void printTable() {
        int n = this.QOIV.length;
        int n2 = 0;
        while (n2 < n) {
            System.out.println("members[" + n2 + "] = " + this.QOIV[n2]);
            ++n2;
        }
    }

    public void postEventToQueue(int n, Properties properties) {
        try {
            ServerEnv.getEventQueue().postEvent(CLUSTER_TOPIC, n, properties, 1);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException, 6);
        }
    }

    public void addServerStartupEventToMonitor(String string, String string2, String string3, int n, long l) {
        Properties properties = new Properties();
        properties.put(SERVER_NAME, string);
        properties.put(SERVER_HOST, string2);
        properties.put(SERVER_PORT, string3);
        properties.put(SERVER_TYPE, String.valueOf(n));
        properties.put(START_TIME, String.valueOf(l));
        this.postEventToQueue(0, properties);
    }

    public void addServerShutdownEventToMonitor(String string, String string2, long l) {
        Properties properties = new Properties();
        properties.put(SERVER_HOST, string);
        properties.put(SERVER_PORT, string2);
        properties.put(CLOSE_TIME, String.valueOf(l));
        this.postEventToQueue(1, properties);
    }

    public void addServerCrashedEventToMonitor(String string, String string2, long l, String string3) {
        Properties properties = new Properties();
        properties.put(SERVER_HOST, string);
        properties.put(SERVER_PORT, string2);
        properties.put(CLOSE_TIME, String.valueOf(l));
        properties.put(CRASH_REASON, string3);
        this.postEventToQueue(2, properties);
    }
}

