/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import jet.ReportEnv;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.intf.jrs.RemoteFileAccess;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.util.WildcardMatcher;

public class JRRemoteFileAccess
extends UnicastRemoteObject
implements RemoteFileAccess {
    public JRRemoteFileAccess() throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
    }

    public int openForRead(String string) throws IOException {
        ServiceLogger.logDebug(6650001, string, 6);
        try {
            File file = new File(string);
            return (int)file.length();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
            throw new RemoteException("", exception);
        }
    }

    public void openForWrite(String string) throws IOException {
        ServiceLogger.logDebug(6650002, string, 6);
        try {
            File file = new File(string.substring(0, string.lastIndexOf(File.separator)));
            if (!file.exists()) {
                file.mkdirs();
            }
            if ((file = new File(string)).exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
            throw new RemoteException("", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] read(long l, int n, String string) throws IOException {
        byte[] byArray;
        ServiceLogger.logDebug(6650003, new String[]{string, String.valueOf(l), String.valueOf(n)}, 6);
        FileInputStream fileInputStream = null;
        try {
            try {
                byte[] byArray2;
                fileInputStream = new FileInputStream(string);
                if (n != 0) {
                    byArray2 = new byte[n];
                    fileInputStream.skip(l);
                    fileInputStream.read(byArray2, 0, n);
                } else {
                    byArray2 = new byte[]{};
                }
                byArray = byArray2;
                Object var9_9 = null;
                if (fileInputStream == null) return byArray;
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 2);
                throw iOException;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
                throw new RemoteException("", exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void write(byte[] byArray, int n, int n2, String string) throws IOException, RemoteException {
        ServiceLogger.logDebug(6650004, new String[]{string, String.valueOf(n), String.valueOf(n2)}, 6);
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(string, true);
                fileOutputStream.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 2);
                throw iOException;
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 2);
                throw new RemoteException("", exception);
            }
            Object var9_6 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (fileOutputStream == null) throw throwable;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }

    public boolean delete(String string) {
        ServiceLogger.logDebug(6650005, string, 6);
        File file = new File(string);
        return file.delete();
    }

    public void close() throws IOException {
        ServiceLogger.logDebug(6650006, 6);
    }

    public long length(String string) {
        ServiceLogger.logDebug(6650007, string, 6);
        File file = new File(string);
        return file.length();
    }

    public long lastModified(String string) {
        ServiceLogger.logDebug(6650008, string, 6);
        File file = new File(string);
        return file.lastModified();
    }

    public String[] list(String string, String string2) {
        ServiceLogger.logDebug(6650009, new String[]{string, string2}, 6);
        File file = new File(string);
        return file.list((FilenameFilter)new WildcardMatcher(string2, false));
    }

    public boolean isDirectory(String string) {
        ServiceLogger.logDebug(6650010, string, 6);
        File file = new File(string);
        return file.isDirectory();
    }

    public String remoteHomePath() {
        ServiceLogger.logDebug(6650011, ReportEnv.homePath, 6);
        return ReportEnv.homePath;
    }

    public boolean exists(String string) {
        ServiceLogger.logDebug(6650012, string, 6);
        File file = new File(string);
        return file.exists();
    }

    public boolean setLastModified(String string, long l) {
        ServiceLogger.logDebug(6650013, new String[]{string, String.valueOf(l)}, 6);
        File file = new File(string);
        return file.setLastModified(l);
    }

    public boolean mkdir(String string) throws RemoteException {
        File file = new File(string);
        return file.mkdirs();
    }

    public boolean mkdirs(String string) throws IOException {
        return SchdTools.mkdirs(string);
    }

    public String getCanonicalPath(String string) throws IOException {
        return new File(string).getCanonicalPath();
    }

    public String getFileSeparator() {
        return File.separator;
    }

    public String getName(String string) {
        File file = new File(string);
        return file.getName();
    }

    public String getParent(String string) {
        File file = new File(string);
        return file.getParent();
    }
}

