/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import jet.cs.CSUtil;
import jet.server.api.RemoteFileService;
import jet.server.intf.jrs.RemoteFileAccess;
import jet.server.jrc.JRInputStream;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.schedule.SchdTools;
import jet.util.WildcardMatcher;

public class JRRemoteFileService
implements RemoteFileService {
    private RemoteFileAccess QOIV = null;
    private final int abs = 512000;
    private boolean append = false;
    private static String close = File.separator;
    private StringBuffer compareTo = new StringBuffer();

    public JRRemoteFileService(String string, int n) throws Exception {
        InetAddress inetAddress = null;
        if (string == null || string.equalsIgnoreCase("localhost") || string.equals("127.0.0.1")) {
            this.append = true;
            return;
        }
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Warning:" + unknownHostException.getMessage());
        }
        if (inetAddress != null) {
            String string2 = inetAddress.getHostName();
            if (string2 == null) {
                string2 = inetAddress.getHostAddress();
            }
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string2);
            InetAddress inetAddress2 = InetAddress.getByName(string);
            int n2 = 0;
            while (n2 < inetAddressArray.length) {
                if (inetAddressArray[n2].equals(inetAddress2)) {
                    this.append = true;
                    return;
                }
                ++n2;
            }
        }
        this.QOIV = (RemoteFileAccess)RemoteObjectFactory.getRemoteObject(string, n, "RemoteFileService");
        close = this.QOIV.getFileSeparator();
    }

    public InputStream readFile(String string) throws IOException {
        InputStream inputStream = this.append ? new FileInputStream(string) : new JRInputStream(this.QOIV, string);
        return inputStream;
    }

    public void writeFile(InputStream inputStream, String string) throws IOException {
        byte[] byArray = new byte[512000];
        int n = 0;
        if (this.append) {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            while ((n = inputStream.read(byArray, 0, 512000)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            fileOutputStream.close();
        } else {
            this.QOIV.openForWrite(string);
            while ((n = inputStream.read(byArray, 0, 512000)) != -1) {
                this.QOIV.write(byArray, 0, n, string);
            }
            inputStream.close();
            this.QOIV.close();
        }
    }

    public boolean delete(String string) throws RemoteException {
        boolean bl = false;
        if (this.append) {
            File file = new File(string);
            bl = file.delete();
        } else {
            bl = this.QOIV.delete(string);
        }
        return bl;
    }

    public String getRemoteHomePath() throws RemoteException {
        String string = null;
        if (this.append) {
            return null;
        }
        string = this.QOIV.remoteHomePath();
        return string;
    }

    public boolean exists(String string) throws RemoteException {
        boolean bl = false;
        if (this.append) {
            File file = new File(string);
            bl = file.exists();
        } else {
            bl = this.QOIV.exists(string);
        }
        return bl;
    }

    private boolean QOIV(long l, long l2) {
        long l3 = l - l2;
        return Math.abs(l3) < 60000L;
    }

    public synchronized void copyToRemote(String string, String string2, boolean bl) throws IOException {
        boolean bl2 = bl;
        File file = null;
        int n = -2;
        boolean bl3 = false;
        File file2 = new File(string);
        if (string.indexOf("*") != -1 || string.indexOf("?") != -1) {
            n = string.lastIndexOf(File.separator);
            file = new File(file2.getParent());
            if (!file.exists()) {
                throw new IOException("File not found " + file2.getParent());
            }
            if (string2.indexOf("*") != -1 || string2.indexOf("?") != -1) {
                string2 = CSUtil.getPathAndName(string2)[0];
            }
            bl3 = true;
        } else {
            file = new File(string);
            if (!file.exists()) {
                throw new IOException("File not found " + string);
            }
            bl3 = file.isDirectory();
        }
        if (bl3) {
            if (!string2.endsWith(close)) {
                string2 = string2 + close;
            }
            if (!this.isDirectory(string2) && !this.mkdir(string2)) {
                throw new IOException("Fail to create folder " + string2);
            }
            String[] stringArray = n == -2 ? file.list(null) : file.list((FilenameFilter)new WildcardMatcher(string.substring(n + 1), false));
            String string3 = file.getAbsolutePath();
            if (!string3.endsWith(File.separator)) {
                string3 = string3 + File.separator;
            }
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string4 = stringArray[n2];
                File file3 = new File(string3 + string4);
                if (!file3.isDirectory()) {
                    this.abs(string3 + stringArray[n2], string2 + stringArray[n2]);
                } else if (bl2) {
                    string4 = string4 + File.separator;
                    this.copyToRemote(string3 + string4, string2 + string4);
                }
                ++n2;
            }
        } else {
            if (string2.endsWith(close)) {
                string2 = string2 + file2.getName();
            }
            this.abs(string, string2);
        }
    }

    public synchronized void copyToRemote(String string, String string2) throws IOException {
        this.copyToRemote(string, string2, true);
    }

    private synchronized void abs(String string, String string2) throws IOException {
        byte[] byArray = new byte[512000];
        int n = 0;
        FileInputStream fileInputStream = new FileInputStream(string);
        File file = new File(string);
        if (this.append) {
            File file2 = new File(string2);
            if (file.exists() && file2.length() == file.length() && this.QOIV(file2.lastModified(), file.lastModified())) {
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            while ((n = fileInputStream.read(byArray, 0, 512000)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            fileOutputStream.close();
            String string3 = System.getProperty("java.version");
            if (string3.compareTo("1.2") >= 0) {
                file2.setLastModified(file.lastModified());
            }
        } else {
            if (file.exists() && this.QOIV.length(string2) == file.length() && this.QOIV(this.QOIV.lastModified(string2), file.lastModified())) {
                this.QOIV.close();
                return;
            }
            this.QOIV.openForWrite(string2);
            while ((n = fileInputStream.read(byArray, 0, 512000)) != -1) {
                this.QOIV.write(byArray, 0, n, string2);
            }
            fileInputStream.close();
            this.QOIV.close();
            String string4 = System.getProperty("java.version");
            if (string4.compareTo("1.2") >= 0) {
                long l = file.lastModified();
                this.QOIV.setLastModified(string2, l);
            }
        }
    }

    public synchronized void copyFromRemote(String string, String string2, boolean bl) throws IOException {
        boolean bl2 = bl;
        String string3 = null;
        String string4 = null;
        boolean bl3 = false;
        if (string.indexOf("*") != -1 || string.indexOf("?") != -1) {
            string3 = CSUtil.getPathAndName(string)[0];
            string4 = string2.indexOf("*") != -1 || string2.indexOf("?") != -1 ? CSUtil.getPathAndName(string2)[0] : string2;
            bl3 = true;
        } else {
            bl3 = this.isDirectory(string);
            string3 = string;
            string4 = string2;
        }
        if (!this.exists(string3)) {
            throw new IOException("File not found " + string3);
        }
        if (bl3) {
            String[] stringArray;
            if (!string4.endsWith(File.separator)) {
                string4 = string4 + File.separator;
            }
            if (!this.isDirectory(string4, true) && !this.mkdir(string4, true)) {
                throw new IOException("Fail to create folder " + string4);
            }
            if (this.append) {
                File file = new File(string3);
                stringArray = string3.equals(string) ? file.list(null) : file.list((FilenameFilter)new WildcardMatcher(this.getName(string), false));
            } else {
                stringArray = string3.equals(string) ? this.QOIV.list(string, "*") : this.QOIV.list(string3, this.getName(string));
            }
            if (!string3.endsWith(close)) {
                string3 = string3 + close;
            }
            int n = 0;
            while (n < stringArray.length) {
                String string5 = stringArray[n];
                this.compareTo.delete(0, this.compareTo.length());
                this.compareTo.append(string3).append(string5);
                String string6 = this.compareTo.toString();
                this.compareTo.delete(0, this.compareTo.length());
                this.compareTo.append(string4).append(string5);
                String string7 = this.compareTo.toString();
                if (!this.isDirectory(string6)) {
                    this.append(string6, string7);
                } else if (bl2) {
                    this.copyFromRemote(string6, string7);
                }
                ++n;
            }
        } else {
            if (string2.endsWith(File.separator)) {
                string2 = string2 + this.getName(string);
            }
            this.append(string, string2);
        }
    }

    public synchronized void copyFromRemote(String string, String string2) throws IOException {
        this.copyFromRemote(string, string2, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void append(String string, String string2) throws IOException {
        byte[] byArray = new byte[512000];
        File file = new File(string2);
        if (this.append) {
            File file2 = new File(string);
            if (!file2.exists()) return;
            if (file2.length() == 0L) {
                return;
            }
            if (file.exists()) {
                if (file2.length() == file.length() && this.QOIV(file2.lastModified(), file.lastModified())) {
                    return;
                }
            } else if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            int n = 0;
            FileInputStream fileInputStream = new FileInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            while (true) {
                if ((n = fileInputStream.read(byArray, 0, 512000)) == -1) {
                    fileInputStream.close();
                    fileOutputStream.close();
                    String string3 = System.getProperty("java.version");
                    if (string3.compareTo("1.2") < 0) return;
                    file.setLastModified(file2.lastModified());
                    return;
                }
                fileOutputStream.write(byArray, 0, n);
            }
        }
        if (file.exists()) {
            if (this.QOIV.length(string) == file.length() && this.QOIV(this.QOIV.lastModified(string), file.lastModified())) {
                this.QOIV.close();
                return;
            }
        } else if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            int n = this.QOIV.openForRead(string);
            fileOutputStream = new FileOutputStream(string2);
            int n2 = 512000 > n ? n : 512000;
            int n3 = 0;
            while (true) {
                if ((byArray = this.QOIV.read(n3, n2, string)).length == 0) {
                    fileOutputStream.close();
                    String string4 = System.getProperty("java.version");
                    if (string4.compareTo("1.2") >= 0) {
                        file.setLastModified(this.QOIV.lastModified(string));
                    }
                    break;
                }
                fileOutputStream.write(byArray);
                if ((n3 += n2) + n2 <= n) continue;
                n2 = n - n3;
            }
            Object var11_16 = null;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            this.QOIV.close();
            throw throwable;
        }
        this.QOIV.close();
    }

    public String[] list(String string, String string2) throws IOException {
        if (this.append) {
            return new File(string).list((FilenameFilter)new WildcardMatcher(string2, false));
        }
        return this.QOIV.list(string, string2);
    }

    private boolean mkdir(String string, boolean bl) throws RemoteException {
        if (bl) {
            File file = new File(string);
            if (!file.exists()) {
                return file.mkdirs();
            }
        } else {
            return this.QOIV.mkdir(string);
        }
        return false;
    }

    public boolean mkdir(String string) throws RemoteException {
        return this.mkdir(string, this.append);
    }

    public boolean mkdirs(String string) throws IOException, RemoteException {
        if (this.append) {
            return SchdTools.mkdirs(string);
        }
        return this.QOIV.mkdirs(string);
    }

    public String getCanonicalPath(String string) throws IOException {
        if (this.append) {
            return new File(string).getCanonicalPath();
        }
        return this.QOIV.getCanonicalPath(string);
    }

    private boolean isDirectory(String string, boolean bl) throws RemoteException {
        if (bl) {
            File file = new File(string);
            return file.isDirectory();
        }
        return this.QOIV.isDirectory(string);
    }

    public boolean isDirectory(String string) throws RemoteException {
        return this.isDirectory(string, this.append);
    }

    public long lastModified(String string) throws RemoteException {
        if (this.append) {
            File file = new File(string);
            return file.lastModified();
        }
        return this.QOIV.lastModified(string);
    }

    public long length(String string) throws RemoteException {
        if (this.append) {
            File file = new File(string);
            return file.length();
        }
        return this.QOIV.length(string);
    }

    public String getName(String string) throws RemoteException {
        if (this.append) {
            File file = new File(string);
            return file.getName();
        }
        return this.QOIV.getName(string);
    }

    public String getParent(String string) throws RemoteException {
        if (this.append) {
            File file = new File(string);
            return file.getParent();
        }
        return this.QOIV.getParent(string);
    }

    public String getRemoteFileSeparator() throws RemoteException {
        return close;
    }
}

