/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.File;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.OndemandReportRecord;
import jet.server.api.ReportSheetInfo;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.intf.jrs.RemoteOndemandManager;
import jet.server.jrc.JRTaskManager;
import jet.server.jrserver.JROndemandReportRecord;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;

public class JRRemoteOndemandManager
extends UnicastRemoteObject
implements RemoteOndemandManager {
    private Hashtable QOIV = null;
    private Hashtable addElement = new Hashtable();
    private Hashtable addLast = null;
    private JRTaskManager append = null;
    private int closeBackgroundReport = 0;
    private Hashtable compareTo = null;

    public JRRemoteOndemandManager() throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.QOIV = new Hashtable(100);
        this.addLast = new Hashtable(20);
        this.closeBackgroundReport = ServerEnv.getOndemandUserMaxRecords();
        if (this.closeBackgroundReport > 0) {
            this.compareTo = new Hashtable(20);
        }
    }

    public void setTaskManager(JRTaskManager jRTaskManager) {
        this.append = jRTaskManager;
    }

    public Vector getOndemandReports(String string) throws RemoteException {
        Vector vector = new Vector();
        Hashtable hashtable = (Hashtable)this.QOIV.get(string);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    public OndemandReportRecord getOndemandReportRecord(String string) throws RemoteException {
        Hashtable hashtable;
        String string2 = (String)this.addLast.get(string);
        if (string2 != null && (hashtable = (Hashtable)this.QOIV.get(string2)) != null) {
            return (OndemandReportRecord)hashtable.get(string);
        }
        return null;
    }

    public OndemandReportRecord notifyCompleted(String string) throws RemoteException {
        if (this.QOIV == null) {
            return null;
        }
        if (this.addLast == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        String string2 = (String)this.addLast.get(string);
        if (string2 == null) {
            return null;
        }
        Hashtable hashtable = (Hashtable)this.QOIV.get(string2);
        if (hashtable == null) {
            return null;
        }
        JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)hashtable.get(string);
        if (jROndemandReportRecord == null) {
            return null;
        }
        jROndemandReportRecord.setCompleted();
        if (this.addElement != null) {
            this.addElement.put(string, jROndemandReportRecord.getResult());
        }
        return jROndemandReportRecord;
    }

    public OndemandReportRecord changeStatus(String string, String string2) throws RemoteException {
        Hashtable hashtable;
        String string3 = (String)this.addLast.get(string);
        if (string3 != null && (hashtable = (Hashtable)this.QOIV.get(string3)) != null) {
            JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)hashtable.get(string);
            jROndemandReportRecord.setStatus(string2);
            this.addElement.put(string, jROndemandReportRecord.getResult());
            return jROndemandReportRecord;
        }
        return null;
    }

    public void removeOndemandReport(String string, boolean bl) throws RemoteException {
        Hashtable hashtable;
        String string2 = (String)this.addLast.remove(string);
        this.addElement.remove(string);
        if (string2 != null && (hashtable = (Hashtable)this.QOIV.get(string2)) != null) {
            JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)hashtable.remove(string);
            if (jROndemandReportRecord.getFormat() == 8) {
                return;
            }
            if (jROndemandReportRecord.isCompleted()) {
                if (ServerEnv.isPipeline() && jROndemandReportRecord.getResult().endsWith(".html")) {
                    String string3 = jROndemandReportRecord.getResult();
                    if ((string3 = string3.substring(0, string3.length() - ".html".length())).indexOf("_") != -1) {
                        string3 = string3.substring(0, string3.indexOf("_"));
                    }
                    if (jROndemandReportRecord.isLocal()) {
                        this.append.removePipelineFilenames(string3);
                    } else {
                        try {
                            String string4 = jROndemandReportRecord.getRemoteAddress() + "/" + "MemberMonitor";
                            int n = string4.indexOf(":");
                            String string5 = string4.substring(0, n);
                            int n2 = CSUtil.parseInt(string4.substring(n + 1));
                            MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(string5, n2, "MemberMonitor");
                            memberMonitor.removePipelineFilenames(string3);
                        }
                        catch (Exception exception) {
                            ServiceLogger.logError(exception, 5);
                        }
                    }
                }
            } else if (bl) {
                if (jROndemandReportRecord.isLocal()) {
                    this.append.deleteOndemandReport(string);
                } else {
                    try {
                        String string6 = jROndemandReportRecord.getRemoteAddress() + "/" + "MemberMonitor";
                        int n = string6.indexOf(":");
                        String string7 = string6.substring(0, n);
                        int n3 = CSUtil.parseInt(string6.substring(n + 1));
                        MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(string7, n3, "MemberMonitor");
                        memberMonitor.deleteOndemandReport(string);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 5);
                    }
                }
            }
        }
    }

    public void removeOndemandReport(String string) throws RemoteException {
        String string2 = null;
        String string3 = string;
        String string4 = File.separator;
        if (string3.indexOf(string4) != -1) {
            string3 = string3.substring(string3.lastIndexOf(string4) + 1);
        }
        if (this.addElement != null && this.addElement.containsValue(string)) {
            Enumeration enumeration = this.addElement.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (!string3.equals(this.addElement.get(string2))) continue;
                this.removeOndemandReport(string2, true);
                return;
            }
        }
    }

    public void removeAllOndemandReport(String string) throws RemoteException {
        Hashtable hashtable = (Hashtable)this.QOIV.get(string);
        if (hashtable != null) {
            String string2 = null;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                this.removeOndemandReport(string2, true);
            }
        }
    }

    public void registerOndemandReport(JROndemandReportRecord jROndemandReportRecord) {
        Hashtable hashtable;
        if (this.QOIV.containsKey(jROndemandReportRecord.getUserID())) {
            hashtable = (Hashtable)this.QOIV.get(jROndemandReportRecord.getUserID());
        } else {
            hashtable = new Hashtable();
            this.QOIV.put(jROndemandReportRecord.getUserID(), hashtable);
            if (this.closeBackgroundReport > 0) {
                LinkedList linkedList = new LinkedList();
                this.compareTo.put(jROndemandReportRecord.getUserID(), linkedList);
            }
        }
        hashtable.put(jROndemandReportRecord.getOndemandID(), jROndemandReportRecord);
        this.addLast.put(jROndemandReportRecord.getOndemandID(), jROndemandReportRecord.getUserID());
        if (this.closeBackgroundReport > 0) {
            this.QOIV(jROndemandReportRecord);
        }
    }

    public String registerOndemandReport(String string, String string2, String string3, int n, String string4, ReportSheetInfo reportSheetInfo, int n2, Properties properties, String string5, boolean bl, String string6, String string7, int n3) throws RemoteException {
        JROndemandReportRecord jROndemandReportRecord = new JROndemandReportRecord(string, string2, string3, n, string4, reportSheetInfo, n2, properties, string5, bl, string6, string7, n3);
        this.registerOndemandReport(jROndemandReportRecord);
        return string;
    }

    public void setErrorMessage(String string, String string2) throws RemoteException {
        JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)this.getOndemandReportRecord(string);
        if (jROndemandReportRecord != null) {
            jROndemandReportRecord.setErrorMessage(string2);
        }
    }

    public String registerOndemandReport(String string, String string2, String string3, int n, String string4, ReportSheetInfo reportSheetInfo, int n2, Properties properties, String string5, boolean bl, String string6, String string7, String string8, String string9, int n3) throws RemoteException {
        JROndemandReportRecord jROndemandReportRecord = new JROndemandReportRecord(string, string2, string3, n, string4, reportSheetInfo, n2, properties, string5, bl, string6, string7, n3);
        jROndemandReportRecord.setClusteredServer(string8, string9);
        this.registerOndemandReport(jROndemandReportRecord);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void QOIV(JROndemandReportRecord jROndemandReportRecord) {
        LinkedList linkedList = (LinkedList)this.compareTo.get(jROndemandReportRecord.getUserID());
        if (linkedList != null) {
            String string = null;
            LinkedList linkedList2 = linkedList;
            synchronized (linkedList2) {
                linkedList.addLast(jROndemandReportRecord.getOndemandID());
                if (linkedList.size() > this.closeBackgroundReport) {
                    string = (String)linkedList.removeFirst();
                }
            }
            if (string != null) {
                try {
                    this.removeOndemandReport(string, false);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception, 5);
                }
            }
        }
    }

    public void clearUserOndemandList(String string, boolean bl) throws RemoteException {
        if (string == null) {
            return;
        }
        Enumeration enumeration = this.addLast.keys();
        String string2 = "";
        String string3 = "";
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string3 = (String)this.addLast.get(string2);
            if (string3 == null || string3.compareTo(string) != 0) continue;
            if (httpRptServer.getDHTMLClientService().getBackgroundReportInfo(string2) != null) {
                httpRptServer.getDHTMLClientService().closeBackgroundReport(null, string2);
            }
            this.removeOndemandReport(string2, bl);
        }
    }

    public String getOndemandID(String string, String string2) throws RemoteException {
        if (string == null || string2 == null) {
            return "";
        }
        Hashtable hashtable = (Hashtable)this.QOIV.get(string);
        if (hashtable == null) {
            return "";
        }
        Enumeration enumeration = hashtable.keys();
        String string3 = "";
        String string4 = "";
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            JROndemandReportRecord jROndemandReportRecord = (JROndemandReportRecord)hashtable.get(string3);
            if (jROndemandReportRecord == null) continue;
            string4 = jROndemandReportRecord.getResult();
            if (string4 != null && string4.compareTo(string2) == 0) break;
            string3 = "";
        }
        return string3;
    }

    public void removeOndemandReport(String string, String string2, boolean bl) throws RemoteException {
        String string3 = this.getOndemandID(string, string2);
        if (string3 != null && string3.length() > 0) {
            this.removeOndemandReport(string3, bl);
        }
    }
}

