/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import guitools.toolkit.JDebug;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import jet.JCliResource;
import jet.JSvrResource;
import jet.controls.JetObject;
import jet.cs.CSUtil;
import jet.cs.Schedulable;
import jet.cs.Schedule;
import jet.cs.TaskIntf;
import jet.exception.InvalidParameterException;
import jet.server.ServerEnv;
import jet.server.api.Permissions;
import jet.server.api.RptServerException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpUtil;
import jet.server.api.trigger.TriggerManager;
import jet.server.intf.jrs.DataService;
import jet.server.intf.jrs.SchedulingService;
import jet.server.intf.jrs.TaskManager;
import jet.server.jrc.ScriptFileSubmit;
import jet.server.jrc.TableProxy;
import jet.server.jrc.TableProxyExecutorQueueFactory;
import jet.server.jrc.param.ParameterFileManager;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.JRActiveTaskRecord;
import jet.server.jrserver.JRResourceManager;
import jet.server.log.ServiceLogger;
import jet.server.schedule.AccessSchedule;
import jet.server.schedule.CommitRunner;
import jet.server.schedule.Committer;
import jet.server.schedule.CustomTask;
import jet.server.schedule.ExeTimeInfo;
import jet.server.schedule.JetLch;
import jet.server.schedule.JetSchds;
import jet.server.schedule.LaunchableObj;
import jet.server.schedule.ParameterManager;
import jet.server.schedule.RepeatLaunchableObj;
import jet.server.schedule.Repeatable;
import jet.server.schedule.SchdTools;
import jet.server.schedule.ScheduleController;
import jet.server.schedule.ScheduledTask;
import jet.server.schedule.ScheduledTaskImpl;
import jet.server.schedule.Scheduler;
import jet.server.schedule.TimeLaunchable;
import jet.server.schedule.TimeLaunchableObj;
import jet.server.schedule.TriggerLaunchableObj;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.jrtasks.RunRptTaskRoot;
import jet.server.schedule.jrtasks.UserTaskProxy;
import jet.server.trigger.TriggerManagerImpl;
import jet.util.WildcardMatcher;

public class JRSchedulingService
extends UnicastRemoteObject
implements SchedulingService,
Committer {
    private CommitRunner P_READ = null;
    private Scheduler P_WRITE = null;
    private TaskManager QOIV = null;
    private TriggerManager WARNING = null;
    private ScheduleController add = null;
    private String addElement = null;
    private String addLaunchableObj = null;
    private JRResourceManager addTask;
    private DataService append = null;
    private boolean before = false;
    private Vector cancel = new Vector();
    static Class class$jet$server$schedule$InternalTask;
    static Class class$jet$server$api$UserTask;

    public JRSchedulingService(TaskManager taskManager, JRResourceManager jRResourceManager) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.QOIV = taskManager;
        this.addTask = jRResourceManager;
        this.addElement = jRResourceManager.getRealm();
        this.addLaunchableObj = jRResourceManager.getRealmDir();
    }

    public JRResourceManager getResourceManager() {
        return this.addTask;
    }

    public void start() throws Exception {
        this.P_WRITE = new Scheduler(this);
        this.WARNING = TriggerManagerImpl.getInstance();
        this.add = new ScheduleController(this, this.P_WRITE);
        this.add.start();
        this.before = this.add.isStart();
        if (this.before) {
            this.loadSchedules();
        }
        if (ServerEnv.isCommitInThread()) {
            this.P_READ = new CommitRunner(this);
        }
    }

    public void stop() throws Exception {
        if (this.before) {
            if (this.P_READ != null) {
                this.P_READ.stop();
            }
            this.saveSchedules();
            AccessSchedule.setRestart();
            this.P_WRITE.shutdown();
            ((TriggerManagerImpl)this.WARNING).destroy();
            this.add.stop();
            this.before = false;
        }
    }

    public void quit() throws Exception {
        this.stop();
        this.P_READ = null;
        this.P_WRITE = null;
        this.QOIV = null;
        this.addTask = null;
        try {
            this.add.finalize();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        this.add = null;
    }

    public void createParameterFile(String string, Properties properties) throws Exception {
        String string2;
        if (JRTUtil.hasParameter(properties) && (string2 = JRTUtil.getParamFile(properties)) == null) {
            String string3 = (String)properties.get("jrs.report");
            string3 = CSUtil.getFileNameWithoutDir(string3);
            String string4 = null;
            string4 = ParameterManager.usedParamGen(properties) ? ".dparam" : ".param";
            string2 = JRTUtil.createParamFile(SchdTools.createTempFile(string, CSUtil.getNameWithoutExt(string3) + "_", string4), properties);
            properties.put("jrs.param_file", string2);
        }
    }

    public String submitScheduledTask(String string, Properties properties) throws RptServerException {
        String string2;
        String string3;
        if (string != null) {
            properties.put("jrs.uid", string);
        }
        try {
            if (!JRSchedulingService.isInternalTaskIntf(properties)) {
                JRTUtil.validateParameter(properties, 2, this.getResourceManager(), null, null);
            }
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new RptServerException(invalidParameterException);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            JDebug.WARNING((Throwable)exception);
            throw new RptServerException(exception);
        }
        int n = CSUtil.parseInt((String)properties.get("jrs.archive_location"), 0);
        boolean bl = CSUtil.getBoolean((String)properties.get("jrs.to_version"), false);
        if (bl) {
            switch (n) {
                case 0: {
                    string3 = (String)properties.get("jrs.report");
                    try {
                        if (string3 != null && HttpUtil.isSecure() && !this.addTask.checkPermission(string, string3, Permissions.P_WRITE)) {
                            String string4 = "Can not add result version of report " + string3;
                            throw new RptServerException(new NoPrivilegeException(string4));
                        }
                        break;
                    }
                    catch (Exception exception) {
                        throw new RptServerException(exception);
                    }
                }
                case 2: {
                    String string5 = (String)properties.get("jrs.archive_public_destination");
                    String[] stringArray = CSUtil.getLogicalFolderAndName(string5);
                    if (stringArray[1] == null || stringArray[1].length() == 0) {
                        String string6 = "Can not add result doc " + string5;
                        throw new RptServerException(new UnknownResource(string6));
                    }
                    try {
                        if (!this.addTask.checkPermission(string, string5, Permissions.P_WRITE)) {
                            String string7 = "Can not add version of result doc " + string5;
                            throw new RptServerException(new NoPrivilegeException(string7));
                        }
                    }
                    catch (Exception exception) {
                        String string8 = stringArray[0];
                        if (string8 == null || string8.length() == 0) {
                            string8 = "/";
                        }
                        try {
                            if (!this.addTask.checkPermission(string, string8, Permissions.P_WRITE)) {
                                String string9 = "Can not add result doc in folder " + string8;
                                throw new RptServerException(new NoPrivilegeException(string9));
                            }
                        }
                        catch (NoSuchUserException noSuchUserException) {
                            throw new RptServerException(noSuchUserException);
                        }
                        catch (UnknownResource unknownResource) {
                            ServiceLogger.logError(JSvrResource.getDebug(3610008, stringArray[0]), 3);
                        }
                    }
                    break;
                }
            }
        }
        this.P_READ(string, properties);
        string3 = null;
        SchdTools.removeUnusedTaskProps(properties);
        int n2 = CSUtil.parseInt((String)properties.get("jrs.auto_delete_method"), -1);
        if (n2 == 1) {
            int n3 = CSUtil.parseInt((String)properties.get("jrs.auto_delete_year"), 1900) - 1900;
            int n4 = CSUtil.parseInt((String)properties.get("jrs.auto_delete_month"), 1) - 1;
            int n5 = CSUtil.parseInt((String)properties.get("jrs.auto_delete_date"), 0);
            Date date = new Date(n3, n4, n5);
            Date date2 = new Date(System.currentTimeMillis());
            long l = (date.getTime() - new Date(date2.getYear(), date2.getMonth(), date2.getDate()).getTime()) / 86400000L;
            properties.put("jrs.expire_days", String.valueOf(l));
        }
        if ((string2 = (String)properties.get("jrs.submit_time")) == null || string2.trim().length() == 0) {
            properties.put("jrs.submit_time", String.valueOf(System.currentTimeMillis()));
        }
        try {
            string3 = this.submit(properties);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            JDebug.WARNING((Throwable)exception);
            throw new RptServerException(exception);
        }
        return string3;
    }

    private void P_READ(String string, Properties properties) throws RptServerException {
        boolean bl = CSUtil.getBoolean((String)properties.get("jrs.to_disk"), false);
        if (!bl) {
            return;
        }
        try {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            int n;
            Object object;
            Object object2;
            boolean bl7;
            int n2;
            boolean bl8 = CSUtil.getBoolean((String)properties.get("jrs.to_rsd"), false);
            if (bl8) {
                String string2 = (String)properties.get("jrs.rsd_dir");
                n2 = CSUtil.parseInt((String)properties.get("jrs.to_disk_rsd_path_type"), 0);
                if (n2 == 0 && string2.length() > 0 && !this.addTask.checkPermission(string, string2, Permissions.P_WRITE)) {
                    String string3 = "Can not write Rsd file to path: " + string2;
                    throw new RptServerException(string3, (Throwable)new NoPrivilegeException(string3));
                }
            }
            if (bl7 = CSUtil.getBoolean((String)properties.get("jrs.to_rst"), false)) {
                String string4 = (String)properties.get("jrs.rst_dir");
                int n3 = CSUtil.parseInt((String)properties.get("jrs.to_disk_rst_path_type"), 0);
                if (n3 == 0 && string4.length() > 0 && !this.addTask.checkPermission(string, string4, Permissions.P_WRITE)) {
                    String string5 = "Can not write Result file to path: " + string4;
                    throw new RptServerException(string5, (Throwable)new NoPrivilegeException(string5));
                }
            }
            if ((n2 = (int)(CSUtil.getBoolean((String)properties.get("jrs.to_html"), false) ? 1 : 0)) != 0) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    object2 = (String)enumeration.nextElement();
                    if (!((String)object2).startsWith("jrs.html_dir")) continue;
                    object = (String)properties.get(object2);
                    n = CSUtil.parseInt((String)properties.get("jrs.to_disk_html_path_type"), 0);
                    if (n != 0 || ((String)object).length() <= 0 || this.addTask.checkPermission(string, (String)object, Permissions.P_WRITE)) continue;
                    String string6 = "Can not write Html file to path: " + (String)object;
                    throw new RptServerException(string6, (Throwable)new NoPrivilegeException(string6));
                }
            }
            if (bl6 = CSUtil.getBoolean((String)properties.get("jrs.to_pdf"), false)) {
                object2 = properties.keys();
                while (object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    if (!((String)object).startsWith("jrs.pdf_dir")) continue;
                    String string7 = (String)properties.get(object);
                    int n4 = CSUtil.parseInt((String)properties.get("jrs.to_disk_pdf_path_type"), 0);
                    if (n4 != 0 || string7.length() <= 0 || this.addTask.checkPermission(string, string7, Permissions.P_WRITE)) continue;
                    String string8 = "Can not write Pdf file to path: " + string7;
                    throw new RptServerException(string8, (Throwable)new NoPrivilegeException(string8));
                }
            }
            if (bl5 = CSUtil.getBoolean((String)properties.get("jrs.to_text"), false)) {
                object = properties.keys();
                while (object.hasMoreElements()) {
                    String string9 = (String)object.nextElement();
                    if (!string9.startsWith("jrs.text_dir")) continue;
                    String string10 = (String)properties.get(string9);
                    int n5 = CSUtil.parseInt((String)properties.get("jrs.to_disk_text_path_type"), 0);
                    if (n5 != 0 || string10.length() <= 0 || this.addTask.checkPermission(string, string10, Permissions.P_WRITE)) continue;
                    String string11 = "Can not write Text file to path: " + string10;
                    throw new RptServerException(string11, (Throwable)new NoPrivilegeException(string11));
                }
            }
            if (bl4 = CSUtil.getBoolean((String)properties.get("jrs.to_excel"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string12 = (String)enumeration.nextElement();
                    if (!string12.startsWith("jrs.excel_dir")) continue;
                    String string13 = (String)properties.get(string12);
                    int n6 = CSUtil.parseInt((String)properties.get("jrs.to_disk_excel_path_type"), 0);
                    if (n6 != 0 || string13.length() <= 0 || this.addTask.checkPermission(string, string13, Permissions.P_WRITE)) continue;
                    String string14 = "Can not write Excel file to path: " + string13;
                    throw new RptServerException(string14, (Throwable)new NoPrivilegeException(string14));
                }
            }
            if ((n = (int)(CSUtil.getBoolean((String)properties.get("jrs.to_ps"), false) ? 1 : 0)) != 0) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string15 = (String)enumeration.nextElement();
                    if (!string15.startsWith("jrs.ps_dir")) continue;
                    String string16 = (String)properties.get(string15);
                    int n7 = CSUtil.parseInt((String)properties.get("jrs.to_disk_ps_path_type"), 0);
                    if (n7 != 0 || string16.length() <= 0 || this.addTask.checkPermission(string, string16, Permissions.P_WRITE)) continue;
                    String string17 = "Can not write PostScript file to path: " + string16;
                    throw new RptServerException(string17, (Throwable)new NoPrivilegeException(string17));
                }
            }
            if (bl3 = CSUtil.getBoolean((String)properties.get("jrs.to_rtf"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string18 = (String)enumeration.nextElement();
                    if (!string18.startsWith("jrs.rtf_dir")) continue;
                    String string19 = (String)properties.get(string18);
                    int n8 = CSUtil.parseInt((String)properties.get("jrs.to_disk_rtf_path_type"), 0);
                    if (n8 != 0 || string19.length() <= 0 || this.addTask.checkPermission(string, string19, Permissions.P_WRITE)) continue;
                    String string20 = "Can not write Rich Text Format file to path: " + string19;
                    throw new RptServerException(string20, (Throwable)new NoPrivilegeException(string20));
                }
            }
            if (bl2 = CSUtil.getBoolean((String)properties.get("jrs.to_xml"), false)) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string21 = (String)enumeration.nextElement();
                    if (!string21.startsWith("jrs.xml_dir")) continue;
                    String string22 = (String)properties.get(string21);
                    int n9 = CSUtil.parseInt((String)properties.get("jrs.to_disk_xml_path_type"), 0);
                    if (n9 != 0 || string22.length() <= 0 || this.addTask.checkPermission(string, string22, Permissions.P_WRITE)) continue;
                    String string23 = "Can not write xml file to path: " + string22;
                    throw new RptServerException(string23, (Throwable)new NoPrivilegeException(string23));
                }
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            JDebug.WARNING((Throwable)exception);
            if (exception instanceof RptServerException) {
                throw (RptServerException)exception;
            }
            throw new RptServerException(exception.getMessage(), (Throwable)exception);
        }
    }

    public String submit(String string) throws Exception {
        String string2 = null;
        try {
            string2 = this.submit(CSUtil.parseQuery(string));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            JDebug.WARNING((Throwable)exception);
            throw exception;
        }
        return string2;
    }

    public String submit(Properties properties) throws Exception {
        return this.submit(properties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String submit(Properties properties, boolean bl) throws Exception {
        Object object;
        String string;
        String string2;
        String string3 = null;
        if (properties == null) {
            return null;
        }
        String string4 = (String)properties.get("jrs.task_id");
        if (string4 != null && bl) {
            this.removeScheduledTask(string4);
        }
        if ((string2 = (String)properties.get("jrs.engine_id")) != null) {
            properties.remove("jrs.engine_id");
        }
        String string5 = (String)properties.get("jrs.rst_dir");
        String string6 = (String)properties.get("jrs.rst");
        if (string5 != null && string5.trim().length() == 0) {
            properties.remove("jrs.rst_dir");
        }
        if (string6 != null && string6.trim().length() == 0) {
            properties.remove("jrs.rst");
        }
        String string7 = (String)properties.get("jrs.html_dir");
        String string8 = (String)properties.get("jrs.html");
        if (string7 != null && string7.trim().length() == 0) {
            properties.remove("jrs.html_dir");
        }
        if (string8 != null && string8.trim().length() == 0) {
            properties.remove("jrs.html");
        }
        String string9 = (String)properties.get("jrs.pdf_dir");
        String string10 = (String)properties.get("jrs.pdf");
        if (string9 != null && string9.trim().length() == 0) {
            properties.remove("jrs.pdf_dir");
        }
        if (string10 != null && string10.trim().length() == 0) {
            properties.remove("jrs.pdf");
        }
        String string11 = (String)properties.get("jrs.text_dir");
        String string12 = (String)properties.get("jrs.text");
        if (string11 != null && string11.trim().length() == 0) {
            properties.remove("jrs.text_dir");
        }
        if (string12 != null && string12.trim().length() == 0) {
            properties.remove("jrs.text");
        }
        String string13 = (String)properties.get("jrs.excel_dir");
        String string14 = (String)properties.get("jrs.excel");
        if (string13 != null && string13.trim().length() == 0) {
            properties.remove("jrs.excel_dir");
        }
        if (string14 != null && string14.trim().length() == 0) {
            properties.remove("jrs.excel");
        }
        String string15 = (String)properties.get("jrs.ps_dir");
        String string16 = (String)properties.get("jrs.ps");
        if (string15 != null && string15.trim().length() == 0) {
            properties.remove("jrs.ps_dir");
        }
        if (string16 != null && string16.trim().length() == 0) {
            properties.remove("jrs.ps");
        }
        String string17 = (String)properties.get("jrs.rtf_dir");
        String string18 = (String)properties.get("jrs.rtf");
        if (string17 != null && string17.trim().length() == 0) {
            properties.remove("jrs.rtf_dir");
        }
        if (string18 != null && string18.trim().length() == 0) {
            properties.remove("jrs.rtf");
        }
        String string19 = (String)properties.get("jrs.xml_dir");
        String string20 = (String)properties.get("jrs.xml");
        if (string19 != null && string19.trim().length() == 0) {
            properties.remove("jrs.xml_dir");
        }
        if (string20 != null && string20.trim().length() == 0) {
            properties.remove("jrs.xml");
        }
        if ((string = (String)properties.get("jrs.task_id")) != null) {
            object = this.cancel;
            synchronized (object) {
                if (!this.cancel.contains(string)) {
                    this.cancel.addElement(string);
                }
            }
        }
        boolean bl2 = (object = properties.getProperty("jrs.triggers", "")) != null && ((String)object).trim().length() > 0;
        boolean bl3 = false;
        if (bl2) {
            bl3 = properties.getProperty("jrs.triggers.logic").equalsIgnoreCase("ONLY");
        }
        try {
            int n;
            TimeLaunchableObj timeLaunchableObj = null;
            String string21 = (String)properties.get("jrs.launch_type");
            int n2 = n = string21 == null ? 0 : CSUtil.parseInt(string21);
            if (n == -1) {
                throw new Exception(JCliResource.getMessage("CS_ERR_55") + ": " + string21);
            }
            String string22 = (String)properties.get("jrs.uid");
            long l = -1L;
            int[] nArray = null;
            String string23 = null;
            switch (n) {
                case 0: {
                    if (!bl2 || properties.getProperty("jrs.triggers.logic").equalsIgnoreCase("OR")) {
                        return this.runTask(properties);
                    }
                    timeLaunchableObj = new TriggerLaunchableObj(properties);
                    break;
                }
                case 1: {
                    if (!bl3) {
                        nArray = SchdTools.getExeTime(properties);
                        String string24 = (String)properties.get("jrs.timezone");
                        GregorianCalendar gregorianCalendar = string24 != null && string24.trim().length() > 0 ? new GregorianCalendar(TimeZone.getTimeZone(string24)) : new GregorianCalendar();
                        gregorianCalendar.set(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
                        l = gregorianCalendar.getTime().getTime();
                        boolean bl4 = CSUtil.parseInt((String)properties.get("jrs.ileie")) == 1;
                        timeLaunchableObj = new TimeLaunchableObj(properties, new ExeTimeInfo(l, (String)properties.get("jrs.timezone"), 0L, bl4));
                        break;
                    }
                    timeLaunchableObj = new TriggerLaunchableObj(properties);
                    break;
                }
                case 8: {
                    if (!bl3) {
                        Schedule schedule = new Schedule((String)properties.get("jrs.timezone"));
                        string23 = schedule.setSchedule(properties);
                        if (string23 != null) break;
                        timeLaunchableObj = new RepeatLaunchableObj(properties, schedule);
                        break;
                    }
                    timeLaunchableObj = new TriggerLaunchableObj(properties);
                }
            }
            if (timeLaunchableObj == null) {
                if (string23 == null) {
                    throw new Exception(JCliResource.getMessage("CS_ERR_56") + "! " + properties);
                }
                throw new Exception(JCliResource.getMessage("CS_ERR_56") + "! " + string23);
            }
            timeLaunchableObj.setUid(string22);
            if (timeLaunchableObj != null && this.submit(timeLaunchableObj)) {
                string3 = timeLaunchableObj.getTaskId();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            JDebug.WARNING((Throwable)exception);
            throw exception;
        }
        return string3;
    }

    public String runTask(Properties properties) {
        try {
            return this.QOIV.runTask(null, properties);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public boolean cancelTask(TimeLaunchableObj timeLaunchableObj) {
        try {
            return this.QOIV.stopActiveTask(timeLaunchableObj.getTaskId());
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    public synchronized boolean submit(TimeLaunchableObj timeLaunchableObj) throws Exception {
        boolean bl = false;
        if (timeLaunchableObj != null) {
            if (timeLaunchableObj instanceof TimeLaunchable && !(timeLaunchableObj instanceof Repeatable) && timeLaunchableObj.isExeTimeExpired()) {
                GregorianCalendar gregorianCalendar = timeLaunchableObj.getGC();
                throw new Exception(CSUtil.toDateTimeString(gregorianCalendar.getTime(), gregorianCalendar.getTimeZone().getID()) + " expired!");
            }
            this.P_WRITE(timeLaunchableObj.getTaskId());
            bl = timeLaunchableObj instanceof TriggerLaunchableObj ? true : this.P_WRITE.addLaunchableObj(timeLaunchableObj);
            if (bl) {
                this.add.addTask(new ScheduledTaskImpl(timeLaunchableObj));
            }
            if (ServerEnv.isCommitInThread()) {
                this.P_READ.notifyCommit();
            } else {
                this.saveSchedules();
            }
        }
        return bl;
    }

    private void P_WRITE(String string) throws Exception {
        if (string != null) {
            TimeLaunchableObj timeLaunchableObj = this.getTask(string);
            if (timeLaunchableObj != null) {
                this.P_WRITE.removeLaunchableObj(timeLaunchableObj);
                ParameterFileManager.getInstance().delete(timeLaunchableObj.getParamFile());
            }
            ScheduledTask scheduledTask = this.add.getTask(string);
            this.add.delTask(scheduledTask);
        }
    }

    public Properties getScheduledTask(String string) {
        TimeLaunchableObj timeLaunchableObj = this.getTask(string);
        return timeLaunchableObj == null ? null : SchdTools.toProperties(timeLaunchableObj);
    }

    public Vector getScheduledTasks() {
        Vector<Properties> vector = new Vector<Properties>();
        Iterator iterator = this.add.getAllTasks().iterator();
        while (iterator.hasNext()) {
            ScheduledTask scheduledTask = (ScheduledTask)iterator.next();
            TimeLaunchableObj timeLaunchableObj = scheduledTask.getTimeLaunchableObj();
            Properties properties = timeLaunchableObj.getTask();
            if (JRSchedulingService.isInternalTaskIntf(properties)) continue;
            vector.addElement(SchdTools.toProperties(timeLaunchableObj));
        }
        return vector;
    }

    public Vector getScheduledTasksBindTrigger(String string) {
        Vector<Properties> vector = new Vector<Properties>();
        Iterator iterator = this.add.getAllTasks().iterator();
        while (iterator.hasNext()) {
            ScheduledTask scheduledTask = (ScheduledTask)iterator.next();
            TimeLaunchableObj timeLaunchableObj = scheduledTask.getTimeLaunchableObj();
            Properties properties = timeLaunchableObj.getTask();
            if (JRSchedulingService.isInternalTaskIntf(properties)) continue;
            vector.addElement(SchdTools.toProperties(timeLaunchableObj));
        }
        return vector;
    }

    public Vector getScheduledTasksByUser(String string) throws RemoteException {
        Vector<Properties> vector = new Vector<Properties>();
        Iterator iterator = this.add.getAllTasks().iterator();
        while (iterator.hasNext()) {
            ScheduledTask scheduledTask = (ScheduledTask)iterator.next();
            TimeLaunchableObj timeLaunchableObj = scheduledTask.getTimeLaunchableObj();
            if (!string.equalsIgnoreCase(timeLaunchableObj.getUid()) && !this.addTask.isAdminUser(string)) continue;
            Properties properties = timeLaunchableObj.getTask();
            Properties properties2 = (Properties)properties.get("jrs.schd_props");
            if (properties2 != null) {
                properties2.remove("jrs.schd_props");
            }
            if (JRSchedulingService.isInternalTaskIntf(properties)) continue;
            vector.addElement(SchdTools.toProperties(timeLaunchableObj));
        }
        return vector;
    }

    public boolean stopActiveScheduledTask(String string) {
        return this.QOIV.stopActiveTask(string);
    }

    public boolean stopActiveScheduledTaskByUser(String string, String string2) {
        return this.QOIV.stopActiveTaskByUser(string, string2);
    }

    public Vector getActiveScheduledTasks() {
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = CSUtil.toVector(this.QOIV.getAll());
        if (vector2 != null) {
            LaunchableObj launchableObj = null;
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                launchableObj = (LaunchableObj)vector2.elementAt(n2);
                TaskIntf taskIntf = null;
                taskIntf = launchableObj.getTask();
                if (taskIntf instanceof CustomTask) {
                    String string;
                    String string2;
                    Object object;
                    Object object2;
                    String string3 = null;
                    String string4 = null;
                    String string5 = null;
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (taskIntf instanceof RunRptTaskRoot) {
                        object2 = (RunRptTaskRoot)taskIntf;
                        string3 = ((RunRptTaskRoot)object2).getEngMsgs();
                        string4 = ((RunRptTaskRoot)object2).getCatalog();
                        string5 = ((RunRptTaskRoot)object2).getReport();
                        object = ((RunRptTaskRoot)object2).getRunningReportSheets().getAllReportSheets();
                        if (object != null) {
                            while (object.hasMoreElements()) {
                                stringBuffer.append(((RunRptTaskRoot)object2).getRunningReportSheets().getReportSheetDisplayName((String)object.nextElement()));
                                if (!object.hasMoreElements()) continue;
                                stringBuffer.append(",");
                            }
                            if (stringBuffer.length() > 1) {
                                stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                            }
                        } else {
                            stringBuffer.append(string5);
                        }
                        string6 = ((RunRptTaskRoot)object2).getPublishType();
                        string7 = ((RunRptTaskRoot)object2).getParamFile();
                        string2 = this.addTask.getHistDir();
                        if (string7 != null && string7.indexOf(string2) >= 0) {
                            string7 = string7.substring(string2.length());
                        }
                        string8 = ((RunRptTaskRoot)object2).getTaskName();
                    }
                    object2 = taskIntf.getClass().getName();
                    if (taskIntf instanceof UserTaskProxy) {
                        object = (UserTaskProxy)taskIntf;
                        object2 = ((UserTaskProxy)object).getTaskClass();
                        string8 = ((UserTaskProxy)object).getTaskName();
                        string4 = ((UserTaskProxy)object).getCatalog();
                        string5 = ((UserTaskProxy)object).getReport();
                        string6 = ((UserTaskProxy)object).getPublishType();
                        string7 = ((UserTaskProxy)object).getParamFile();
                        string2 = this.addTask.getHistDir();
                        if (string7 != null && string7.indexOf(string2) >= 0) {
                            string7 = string7.substring(string2.length());
                        }
                    }
                    object = new JRActiveTaskRecord(new Date(launchableObj.getStartTime()), string3, launchableObj.getUid(), taskIntf.getId(), (String)object2, launchableObj.getLaunchType(), string4, string5, string7, string6, string8, stringBuffer.toString());
                    string2 = (String)taskIntf.getValue("jrs.triggers");
                    if (string2 != null && string2.trim().length() > 0) {
                        ((JRActiveTaskRecord)object).setTrigger(string2);
                    }
                    if ((string = (String)taskIntf.getValue("jrs.triggers.logic")) != null && string.trim().length() > 0) {
                        ((JRActiveTaskRecord)object).setLogicOfConditions(string);
                    }
                    vector.addElement(object);
                }
                ++n2;
            }
        }
        return vector;
    }

    public Vector getActiveScheduledTasksByUser(String string) {
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = CSUtil.toVector(this.QOIV.getAll());
        if (vector2 != null) {
            LaunchableObj launchableObj = null;
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                launchableObj = (LaunchableObj)vector2.elementAt(n2);
                if (string.equalsIgnoreCase(launchableObj.getUid()) || this.addTask.isAdminUser(string)) {
                    TaskIntf taskIntf = null;
                    taskIntf = launchableObj.getTask();
                    if (taskIntf instanceof CustomTask || taskIntf instanceof UserTaskProxy) {
                        String string2;
                        String string3;
                        Object object;
                        Object object2;
                        String string4 = null;
                        String string5 = null;
                        String string6 = null;
                        String string7 = null;
                        String string8 = null;
                        String string9 = null;
                        StringBuffer stringBuffer = new StringBuffer();
                        if (taskIntf instanceof RunRptTaskRoot) {
                            object2 = (RunRptTaskRoot)taskIntf;
                            string4 = ((RunRptTaskRoot)object2).getEngMsgs();
                            string7 = ((RunRptTaskRoot)object2).getTaskName();
                            string5 = ((RunRptTaskRoot)object2).getCatalog();
                            string6 = ((RunRptTaskRoot)object2).getReport();
                            object = ((RunRptTaskRoot)object2).getRunningReportSheets().getAllReportSheets();
                            if (object != null) {
                                while (object.hasMoreElements()) {
                                    stringBuffer.append(((RunRptTaskRoot)object2).getRunningReportSheets().getReportSheetDisplayName((String)object.nextElement()));
                                    if (!object.hasMoreElements()) continue;
                                    stringBuffer.append(",");
                                }
                            } else {
                                stringBuffer.append(string6);
                            }
                            string8 = ((RunRptTaskRoot)object2).getPublishType();
                            string9 = ((RunRptTaskRoot)object2).getParamFile();
                            string3 = this.addTask.getHistDir();
                            if (string9 != null && string9.indexOf(string3) >= 0) {
                                string9 = string9.substring(string3.length());
                            }
                        }
                        object2 = taskIntf.getClass().getName();
                        if (taskIntf instanceof UserTaskProxy) {
                            object = (UserTaskProxy)taskIntf;
                            object2 = ((UserTaskProxy)object).getTaskClass();
                            string7 = ((UserTaskProxy)object).getTaskName();
                            string5 = ((UserTaskProxy)object).getCatalog();
                            string6 = ((UserTaskProxy)object).getReport();
                            string8 = ((UserTaskProxy)object).getPublishType();
                            string9 = ((UserTaskProxy)object).getParamFile();
                            string3 = this.addTask.getHistDir();
                            if (string9 != null && string9.indexOf(string3) >= 0) {
                                string9 = string9.substring(string3.length());
                            }
                        }
                        object = new JRActiveTaskRecord(new Date(launchableObj.getStartTime()), string4, launchableObj.getUid(), taskIntf.getId(), (String)object2, launchableObj.getLaunchType(), string5, string6, string9, string8, string7, stringBuffer.toString());
                        string3 = (String)taskIntf.getValue("jrs.triggers");
                        if (string3 != null && string3.trim().length() > 0) {
                            ((JRActiveTaskRecord)object).setTrigger(string3);
                        }
                        if ((string2 = (String)taskIntf.getValue("jrs.triggers.logic")) != null && string2.trim().length() > 0) {
                            ((JRActiveTaskRecord)object).setLogicOfConditions(string2);
                        }
                        vector.addElement(object);
                    }
                }
                ++n2;
            }
        }
        return vector;
    }

    public String enableSchedules(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "jrs.enable_schedule";
        if (stringArray == null || stringArray.length == 0) {
            return JSvrResource.getMessage("SLT_PG_209");
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeLaunchableObj timeLaunchableObj = this.getTask(stringArray[n2]);
            if (timeLaunchableObj != null) {
                long l = timeLaunchableObj.getExeTime();
                if (l < System.currentTimeMillis()) {
                    stringBuffer.append(stringArray[n2]).append("--").append(JSvrResource.getMessage("SLT_PG_385")).append("\r\n");
                }
                try {
                    Properties properties = SchdTools.toProperties(timeLaunchableObj);
                    properties.remove("jrs.task_id");
                    String string3 = (String)properties.get("jrs.report");
                    if ((string3 != null && !this.WARNING(timeLaunchableObj.getUid(), this.addElement, string, string3, -1, string2) || !this.enableScheduledTask(stringArray[n2])) && properties.get("jrs.is_enabled") != "true") {
                        stringBuffer.append(stringArray[n2]).append("--").append(JSvrResource.getMessage("SLT_PG_213")).append("\r\n");
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                    JDebug.WARNING((Throwable)throwable);
                }
            }
            ++n2;
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String disableSchedules(String[] stringArray, String string) {
        String string2 = null;
        String string3 = "jrs.disable_schedule";
        if (stringArray == null || stringArray.length == 0) {
            return JSvrResource.getMessage("SLT_PG_209");
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeLaunchableObj timeLaunchableObj = this.getTask(stringArray[n2]);
            if (timeLaunchableObj != null) {
                try {
                    Properties properties = SchdTools.toProperties(timeLaunchableObj);
                    properties.remove("jrs.task_id");
                    String string4 = (String)properties.get("jrs.report");
                    if (string4 != null && !this.WARNING(timeLaunchableObj.getUid(), this.addElement, string, string4, -1, string3) || !this.disableScheduledTask(stringArray[n2])) {
                        if (string2 == null) {
                            if ((String)properties.get("jrs.is_enabled") != "false") {
                                string2 = stringArray[n2] + "\r\n" + JSvrResource.getMessage("SLT_PG_213") + "\r\n";
                            }
                        } else if ((String)properties.get("jrs.is_enabled") != "false") {
                            string2 = string2 + stringArray[n2] + "\r\n" + JSvrResource.getMessage("SLT_PG_213") + "\r\n";
                        }
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                    JDebug.WARNING((Throwable)throwable);
                }
            }
            ++n2;
        }
        return string2;
    }

    private boolean QOIV(TimeLaunchableObj timeLaunchableObj, long l) {
        block6: {
            try {
                if (!timeLaunchableObj.isEnabled()) {
                    return false;
                }
                if (timeLaunchableObj instanceof RepeatLaunchableObj) {
                    Schedulable schedulable = ((RepeatLaunchableObj)timeLaunchableObj).getSchedule();
                    long l2 = this.append.getSchdLastExeTimeTable().getLastExeTime(timeLaunchableObj.getTaskId(), -1L);
                    if (l2 < 0L && (l2 = CSUtil.parseLong((String)timeLaunchableObj.getTask().get("jrs.submit_time"), -1L)) < 0L) {
                        return false;
                    }
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTimeInMillis(l2);
                    Date date = schedulable.getNextTime(gregorianCalendar);
                    GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
                    gregorianCalendar2.setTimeInMillis(l);
                    if (date.before(gregorianCalendar2.getTime())) {
                        return true;
                    }
                    break block6;
                }
                return timeLaunchableObj.isExeTimeExpired() && !timeLaunchableObj.isLaunchEvenIfExpired();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                JDebug.WARNING((Throwable)exception);
            }
        }
        return false;
    }

    public synchronized void loadSchedules() throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        AccessSchedule accessSchedule;
        int n;
        Hashtable<Object, Serializable> hashtable = new Hashtable<Object, Serializable>();
        long l = System.currentTimeMillis();
        String string2 = this.addLaunchableObj;
        if (!string2.endsWith(CSUtil.fileSep)) {
            string2 = string2 + CSUtil.fileSep;
        }
        if ((n = (accessSchedule = new AccessSchedule(string = string2 + this.addElement + CSUtil.fileSep + this.addElement)).loadSum()) == 0) {
            ++n;
        }
        int n2 = 0;
        while (n2 < n) {
            String string3 = n2 == 0 ? string : string + String.valueOf(n2);
            String string4 = string3 + ".tsk";
            File file = new File(string4);
            File file2 = new File(string4 + ".bak");
            boolean bl = false;
            boolean bl2 = false;
            if (file.exists()) {
                try {
                    object5 = new BufferedReader(new FileReader(file.getCanonicalPath()));
                    while (null != (object4 = ((BufferedReader)object5).readLine())) {
                        try {
                            object3 = CSUtil.parseQuery((String)object4);
                            object2 = (String)((Properties)object3).get("jrs.param_file");
                            if (object2 != null) {
                                ((Properties)object3).put("jrs.param_file", this.getResourceManager().getHistDir() + CSUtil.getFileNameOnly((String)object2));
                            }
                            if ((object = (String)((Properties)object3).get("jrs.task_id")) == null) continue;
                            hashtable.put(object, (Serializable)object3);
                            bl2 = true;
                        }
                        catch (Throwable throwable) {
                            ServiceLogger.logError(throwable);
                            JDebug.WARNING((Throwable)throwable);
                        }
                    }
                    ((BufferedReader)object5).close();
                    if (!bl && bl2) {
                        file2.delete();
                        SchdTools.copyFile(file, file2);
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                    JDebug.WARNING((Throwable)throwable);
                }
            }
            string4 = string3 + "_int.tsk";
            file = new File(string4);
            file2 = new File(string4 + ".bak");
            bl = false;
            bl2 = false;
            if (file.exists()) {
                try {
                    object5 = new BufferedReader(new FileReader(file.getCanonicalPath()));
                    while (null != (object4 = ((BufferedReader)object5).readLine())) {
                        try {
                            object3 = CSUtil.parseQuery((String)object4);
                            object = (String)((Properties)object3).get("jrs.task_id");
                            if (object == null) continue;
                            hashtable.put(object, (Serializable)object3);
                            bl2 = true;
                        }
                        catch (Throwable throwable) {
                            ServiceLogger.logError(throwable);
                            JDebug.WARNING((Throwable)throwable);
                        }
                    }
                    ((BufferedReader)object5).close();
                    if (!bl && bl2) {
                        file2.delete();
                        SchdTools.copyFile(file, file2);
                    }
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                    JDebug.WARNING((Throwable)throwable);
                }
            }
            string4 = string3 + ".sch";
            file = new File(string4);
            file2 = new File(string4 + ".bak");
            bl = false;
            bl2 = false;
            if (file.exists()) {
                object5 = new File(string + ".idx");
                if (!((File)object5).exists()) {
                    object3 = JetSchds.loadFromFile(file.getCanonicalPath());
                    if (object3 != null) {
                        object4 = object3.getChildren();
                        object = null;
                        object2 = null;
                        int n3 = ((Vector)object4).size();
                        int n4 = 0;
                        while (n4 < n3) {
                            object = (JetObject)((Vector)object4).elementAt(n4);
                            if (object instanceof JetLch && (object2 = ((JetLch)((Object)object)).createLaunchableObj(hashtable)) != null) {
                                Object object6;
                                ((TimeLaunchableObj)object2).setEnabled(true);
                                boolean bl3 = CSUtil.getBoolean((String)((TimeLaunchableObj)object2).getTask().get("jrs.rerun_missed_task"), false);
                                if (bl3 && this.QOIV((TimeLaunchableObj)object2, l)) {
                                    object6 = (Properties)((TimeLaunchableObj)object2).getTask().clone();
                                    ((Properties)object6).put("jrs.is_task_missed", "true");
                                    this.runTask((Properties)object6);
                                    if (object2 instanceof RepeatLaunchableObj) {
                                        ((RepeatLaunchableObj)object2).setLastExeTime(System.currentTimeMillis());
                                    }
                                }
                                if (!(object2 instanceof TriggerLaunchableObj)) {
                                    if (object2 instanceof RepeatLaunchableObj) {
                                        if (((TimeLaunchableObj)object2).isExeTimeExpired()) {
                                            ((RepeatLaunchableObj)object2).updateExeTime();
                                        }
                                    } else if (((TimeLaunchableObj)object2).isExeTimeExpired() && ((TimeLaunchableObj)object2).isLaunchEvenIfExpired()) {
                                        object6 = new ScheduledTaskImpl((TimeLaunchableObj)object2);
                                        this.add.addTask((ScheduledTask)object6);
                                        this.add.fireTaskTimeReady(((ScheduledTaskImpl)object6).getTaskId());
                                    }
                                    if (!((TimeLaunchableObj)object2).isExeTimeExpired()) {
                                        this.P_WRITE.addLaunchableObj((TimeLaunchableObj)object2);
                                        this.add.addTask(new ScheduledTaskImpl((TimeLaunchableObj)object2));
                                    }
                                } else {
                                    this.add.addTask(new ScheduledTaskImpl((TimeLaunchableObj)object2));
                                }
                                bl2 = true;
                            }
                            ++n4;
                        }
                        ((JetSchds)((Object)object3)).clearMem();
                    }
                    if (!bl && bl2) {
                        file2.delete();
                        file.renameTo(file2);
                    }
                } else {
                    try {
                        object3 = new BufferedReader(new FileReader(file.getCanonicalPath()));
                        while (null != (object = ((BufferedReader)object3).readLine())) {
                            try {
                                Object object7;
                                Object obj;
                                object4 = CSUtil.parseQuery((String)object);
                                object2 = (String)((Hashtable)object4).get("jrs.task_class");
                                TimeLaunchableObj timeLaunchableObj = null;
                                if (object2 == null || !((obj = Class.forName(((String)object2).trim()).newInstance()) instanceof JetLch)) continue;
                                JetLch jetLch = (JetLch)((Object)obj);
                                jetLch.init((Hashtable)object4);
                                timeLaunchableObj = jetLch.createLaunchableObj(hashtable);
                                if (timeLaunchableObj == null) continue;
                                boolean bl4 = CSUtil.getBoolean((String)timeLaunchableObj.getTask().get("jrs.rerun_missed_task"), false);
                                if (bl4 && this.QOIV(timeLaunchableObj, l)) {
                                    object7 = (Properties)timeLaunchableObj.getTask().clone();
                                    ((Properties)object7).put("jrs.is_task_missed", "true");
                                    this.runTask((Properties)object7);
                                    if (timeLaunchableObj instanceof RepeatLaunchableObj) {
                                        ((RepeatLaunchableObj)timeLaunchableObj).setLastExeTime(System.currentTimeMillis());
                                    }
                                }
                                if (!(timeLaunchableObj instanceof TriggerLaunchableObj)) {
                                    if (timeLaunchableObj instanceof RepeatLaunchableObj) {
                                        if (timeLaunchableObj.isExeTimeExpired()) {
                                            ((RepeatLaunchableObj)timeLaunchableObj).updateExeTime();
                                        }
                                    } else if (timeLaunchableObj.isExeTimeExpired() && timeLaunchableObj.isLaunchEvenIfExpired()) {
                                        object7 = new ScheduledTaskImpl(timeLaunchableObj);
                                        this.add.addTask((ScheduledTask)object7);
                                        this.add.fireTaskTimeReady(((ScheduledTaskImpl)object7).getTaskId());
                                    }
                                    if (!timeLaunchableObj.isExeTimeExpired()) {
                                        this.P_WRITE.addLaunchableObj(timeLaunchableObj);
                                        this.add.addTask(new ScheduledTaskImpl(timeLaunchableObj));
                                    }
                                } else {
                                    this.add.addTask(new ScheduledTaskImpl(timeLaunchableObj));
                                }
                                bl2 = true;
                            }
                            catch (Throwable throwable) {
                                ServiceLogger.logError(throwable);
                                JDebug.WARNING((Throwable)throwable);
                            }
                        }
                        ((BufferedReader)object3).close();
                        if (!bl && bl2) {
                            file2.delete();
                            SchdTools.copyFile(file, file2);
                        }
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                        JDebug.WARNING((Throwable)throwable);
                    }
                }
            }
            ++n2;
        }
        if (ServerEnv.isRestoreFromFile()) {
            object5 = string2 + this.addElement + CSUtil.fileSep + "schedule" + CSUtil.fileSep;
            object3 = new File((String)object5);
            object4 = null;
            object = null;
            if (object3.exists()) {
                object2 = object3.list((FilenameFilter)new WildcardMatcher("*.act", false));
                int n5 = 0;
                while (n5 < ((String[])object2).length) {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader((String)object5 + object2[n5]));
                    object4 = bufferedReader.readLine();
                    bufferedReader.close();
                    object = CSUtil.parseQuery((String)object4);
                    ((Properties)object).put("jrs.launch_type", String.valueOf(0));
                    this.submit((Properties)object, false);
                    object3 = new File((String)object5 + object2[n5]);
                    object3.delete();
                    ++n5;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSchedules() {
        Object object;
        Object object2;
        Vector vector = new Vector();
        Vector<JetLch> vector2 = new Vector<JetLch>();
        Object var3_3 = null;
        Object var4_4 = null;
        Iterator iterator = this.add.getAllTasks().iterator();
        while (iterator.hasNext()) {
            object2 = (ScheduledTask)iterator.next();
            object = object2.createJetLaunchable(vector);
            if (object == null) continue;
            vector2.add((JetLch)((Object)object));
        }
        object2 = this.addLaunchableObj;
        if (!((String)object2).endsWith(CSUtil.fileSep)) {
            object2 = (String)object2 + CSUtil.fileSep;
        }
        object = (String)object2 + this.addElement + CSUtil.fileSep + this.addElement;
        try {
            Vector vector3 = this.cancel;
            synchronized (vector3) {
                AccessSchedule accessSchedule = new AccessSchedule((String)object);
                accessSchedule.save(vector, vector2, this.cancel);
                this.cancel.removeAllElements();
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            JDebug.WARNING((Throwable)throwable);
        }
    }

    public void commit() {
        this.saveSchedules();
    }

    public Scheduler getScheduler() {
        return this.P_WRITE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastSuccess(String string, boolean bl) {
        TimeLaunchableObj timeLaunchableObj = this.getTask(string);
        if (timeLaunchableObj != null) {
            if (timeLaunchableObj instanceof RepeatLaunchableObj) {
                ((RepeatLaunchableObj)timeLaunchableObj).setSuccessful(bl);
            } else if (timeLaunchableObj instanceof TriggerLaunchableObj) {
                ((TriggerLaunchableObj)timeLaunchableObj).setSuccessful(bl);
            }
            Vector vector = this.cancel;
            synchronized (vector) {
                if (!this.cancel.contains(string)) {
                    this.cancel.addElement(string);
                }
            }
        }
    }

    public TimeLaunchableObj getTask(String string) {
        if (string == null) {
            return null;
        }
        ScheduledTask scheduledTask = this.add.getTask(string);
        return scheduledTask == null ? null : scheduledTask.getTimeLaunchableObj();
    }

    public synchronized boolean removeScheduledTask(String string) {
        TimeLaunchableObj timeLaunchableObj = this.getTask(string);
        ScheduledTask scheduledTask = this.add.getTask(string);
        this.add.delTask(scheduledTask);
        if (timeLaunchableObj != null && timeLaunchableObj instanceof TimeLaunchableObj) {
            if (!(timeLaunchableObj instanceof TriggerLaunchableObj)) {
                this.getScheduler().cancel(timeLaunchableObj);
            }
            if (ServerEnv.isCommitInThread()) {
                this.P_READ.notifyCommit();
            } else {
                this.saveSchedules();
            }
            try {
                ParameterFileManager.getInstance().delete(timeLaunchableObj.getParamFile());
            }
            catch (RptServerException rptServerException) {
                ServiceLogger.logError(rptServerException);
            }
            return true;
        }
        return false;
    }

    public String loadScheduledFromFile(String string) {
        String string2;
        String string3;
        File file;
        String string4 = "";
        if (string == null || string.length() == 0) {
            return JSvrResource.getMessage("SLT_PG_211");
        }
        if (string.lastIndexOf(".") >= 0) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        if ((file = new File(string3 = (string2 = this.addTask.getSchedulePath() + string) + ".sch")).exists()) {
            try {
                String string5;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file.getCanonicalPath()));
                while (null != (string5 = bufferedReader.readLine())) {
                    try {
                        Properties properties = CSUtil.parseQuery(string5);
                        properties.remove("jrs.task_id");
                        String string6 = this.submit(CSUtil.makeNoHeadQuery(properties));
                        if (string6 == null || string6.trim().length() <= 0) continue;
                        string4 = "All loaded";
                    }
                    catch (Throwable throwable) {
                        ServiceLogger.logError(throwable);
                        JDebug.WARNING((Throwable)throwable);
                    }
                }
                bufferedReader.close();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
                JDebug.WARNING((Throwable)throwable);
            }
        }
        string4 = string4 == null || string4 == "" ? JSvrResource.getMessage("SLT_PG_211") : JSvrResource.getMessage("SLT_PG_214", string + ".sch");
        return string4;
    }

    public String copySchedules(String[] stringArray, String string) {
        String string2 = null;
        String string3 = "jrs.submit_schedule";
        if (stringArray == null || stringArray.length == 0) {
            return JSvrResource.getMessage("SLT_PG_209");
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeLaunchableObj timeLaunchableObj = this.getTask(stringArray[n2]);
            if (timeLaunchableObj != null) {
                try {
                    Properties properties = SchdTools.toProperties(timeLaunchableObj);
                    properties.remove("jrs.task_id");
                    String string4 = (String)properties.get("jrs.report");
                    if (string4 == null || this.add(timeLaunchableObj.getUid(), this.addElement, string, string4, string3)) {
                        this.submit(CSUtil.makeNoHeadQuery(properties));
                    } else {
                        string2 = string2 == null ? stringArray[n2] + "\r\n" + JSvrResource.getMessage("SLT_PG_213") + "\r\n" : string2 + stringArray[n2] + "\r\n" + JSvrResource.getMessage("SLT_PG_213") + "\r\n";
                    }
                }
                catch (Throwable throwable) {
                    string2 = string2 == null ? stringArray[n2] + "\r\n" + JSvrResource.getMessage("SLT_PG_213") + "\r\n" : string2 + stringArray[n2] + "\r\n" + JSvrResource.getMessage("SLT_PG_213") + "\r\n";
                    ServiceLogger.logError(throwable);
                    JDebug.WARNING((Throwable)throwable);
                }
            }
            ++n2;
        }
        return string2;
    }

    public String saveScheduledToScriptFile(String[] stringArray) {
        String string = null;
        if (stringArray == null || stringArray.length == 0) {
            return JSvrResource.getMessage("SLT_PG_209");
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeLaunchableObj timeLaunchableObj = this.getTask(stringArray[n2]);
            if (timeLaunchableObj != null) {
                string = string == null ? CSUtil.makeQueryToRow(SchdTools.toProperties(timeLaunchableObj), "<task>", "</task>") : string + CSUtil.makeQueryToRow(SchdTools.toProperties(timeLaunchableObj), "<task>", "</task>");
            }
            ++n2;
        }
        return string;
    }

    public String saveScheduledToFile(String[] stringArray, String string, boolean bl) {
        String string2 = "";
        if (stringArray == null || stringArray.length == 0) {
            return JSvrResource.getMessage("SLT_PG_209");
        }
        if (string == null || string.length() == 0) {
            return JSvrResource.getMessage("SLT_PG_211");
        }
        if (string.lastIndexOf(".") >= 0) {
            string = string.substring(0, string.lastIndexOf("."));
        }
        String string3 = this.addTask.getSchedulePath() + string;
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string3 + ".sch", false)));
            int n = stringArray.length;
            String string4 = null;
            int n2 = 0;
            while (n2 < n) {
                TimeLaunchableObj timeLaunchableObj = this.getTask(stringArray[n2]);
                if (timeLaunchableObj != null && (string4 = CSUtil.makeNoHeadQuery(SchdTools.toProperties(timeLaunchableObj))) != null && string4.trim().length() != 0) {
                    printWriter.println(string4);
                }
                ++n2;
            }
            printWriter.close();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
            JDebug.WARNING((Throwable)throwable);
        }
        string2 = JSvrResource.getMessage("SLT_PG_212", string + ".sch");
        return string2;
    }

    private boolean WARNING(String string, String string2, String string3, String string4, int n, String string5) throws RemoteException {
        try {
            UserDataToolkit.getResourceManager(string2).getNodeByPath(string4, string3);
        }
        catch (Exception exception) {
            return string.equals(string3);
        }
        return UserDataToolkit.securityAdapter.isPermissionOk(string2, string3, string4, n, string5);
    }

    private boolean add(String string, String string2, String string3, String string4, String string5) {
        try {
            UserDataToolkit.getResourceManager(string2).getNodeByPath(string4, string3);
        }
        catch (Exception exception) {
            return string.equals(string3);
        }
        return HttpUtil.getHttpRptServer().getHttpUserSessionManager().getAuthenticator().isPermissionOk(string2, string3, string4, string5);
    }

    public String deleteSchedules(String[] stringArray, String string) {
        String string2 = null;
        String string3 = "jrs.del_schedule";
        if (stringArray == null || stringArray.length == 0) {
            return JSvrResource.getMessage("SLT_PG_209");
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeLaunchableObj timeLaunchableObj = this.getTask(stringArray[n2]);
            if (timeLaunchableObj != null) {
                try {
                    Properties properties = SchdTools.toProperties(timeLaunchableObj);
                    properties.remove("jrs.task_id");
                    String string4 = (String)properties.get("jrs.report");
                    if (string4 != null && !this.add(timeLaunchableObj.getUid(), this.addElement, string, string4, string3) || !this.removeScheduledTask(stringArray[n2])) {
                        string2 = string2 == null ? stringArray[n2] + "\r\n" + JSvrResource.getMessage("SLT_PG_213") + "\r\n" : string2 + stringArray[n2] + "\r\n" + JSvrResource.getMessage("SLT_PG_213") + "\r\n";
                    }
                }
                catch (Throwable throwable) {
                    string2 = string2 == null ? stringArray[n2] + "\r\n" + JSvrResource.getMessage("SLT_PG_213") + "\r\n" : string2 + stringArray[n2] + "\r\n" + JSvrResource.getMessage("SLT_PG_213") + "\r\n";
                    ServiceLogger.logError(throwable);
                    JDebug.WARNING((Throwable)throwable);
                }
            }
            ++n2;
        }
        return string2;
    }

    public CommitRunner getCommitRunner() {
        return this.P_READ;
    }

    public static boolean isInternalTaskIntf(Properties properties) {
        String string = (String)properties.get("jrs.task_class");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        try {
            return (class$jet$server$schedule$InternalTask == null ? (class$jet$server$schedule$InternalTask = JRSchedulingService.class$("jet.server.schedule.InternalTask")) : class$jet$server$schedule$InternalTask).isAssignableFrom(Class.forName(string.trim()));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isUserTaskIntf(Properties properties) {
        String string = (String)properties.get("jrs.task_class");
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        try {
            return (class$jet$server$api$UserTask == null ? (class$jet$server$api$UserTask = JRSchedulingService.class$("jet.server.api.UserTask")) : class$jet$server$api$UserTask).isAssignableFrom(Class.forName(string.trim()));
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean enableScheduledTask(String string) {
        long l;
        TimeLaunchableObj timeLaunchableObj = this.getTask(string);
        if (timeLaunchableObj == null) {
            return false;
        }
        if (!(timeLaunchableObj instanceof TriggerLaunchableObj) && (l = timeLaunchableObj.getExeTime()) < System.currentTimeMillis()) {
            this.removeScheduledTask(string);
            return true;
        }
        if (timeLaunchableObj.isEnabled()) {
            return false;
        }
        Vector vector = this.cancel;
        synchronized (vector) {
            if (!this.cancel.contains(string)) {
                this.cancel.addElement(string);
            }
        }
        if (timeLaunchableObj != null && timeLaunchableObj instanceof TimeLaunchableObj) {
            timeLaunchableObj.setEnabled(true);
            if (!(timeLaunchableObj instanceof TriggerLaunchableObj)) {
                this.P_WRITE.continueLaunch(timeLaunchableObj);
            }
            if (ServerEnv.isCommitInThread()) {
                this.P_READ.notifyCommit();
            } else {
                this.saveSchedules();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean disableScheduledTask(String string) {
        TimeLaunchableObj timeLaunchableObj = this.getTask(string);
        if (!timeLaunchableObj.isEnabled()) {
            return false;
        }
        Vector vector = this.cancel;
        synchronized (vector) {
            if (!this.cancel.contains(string)) {
                this.cancel.addElement(string);
            }
        }
        if (timeLaunchableObj != null && timeLaunchableObj instanceof TimeLaunchableObj) {
            timeLaunchableObj.setEnabled(false);
            if (!(timeLaunchableObj instanceof TriggerLaunchableObj)) {
                this.P_WRITE.stopLaunch(timeLaunchableObj);
            }
            if (ServerEnv.isCommitInThread()) {
                this.P_READ.notifyCommit();
            } else {
                this.saveSchedules();
            }
            return true;
        }
        return false;
    }

    public synchronized String[] getScriptsList() throws RemoteException {
        String string = ".script";
        File file = new File(this.addTask.getSchedulePath());
        String[] stringArray = file.list(JRSchedulingService.filter(string));
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = stringArray[n].substring(0, stringArray[n].indexOf(".script"));
            ++n;
        }
        return stringArray2;
    }

    public synchronized String loadScriptFromFile(String string) throws RemoteException {
        File file = new File(this.addTask.getSchedulePath() + string + ".script");
        return CSUtil.readStringFromFile(file);
    }

    public synchronized boolean saveScriptToFile(String string, String string2) throws RemoteException {
        File file = new File(this.addTask.getSchedulePath() + string2 + ".script");
        return CSUtil.writeStringToFile(string, file);
    }

    public synchronized void delScriptFile(String string) throws RemoteException {
        File file = new File(this.addTask.getSchedulePath() + string + ".script");
        if (file.exists()) {
            file.delete();
        }
    }

    public synchronized boolean isScriptFileExist(String string) throws RemoteException {
        File file = new File(this.addTask.getSchedulePath() + string + ".script");
        return file.exists();
    }

    private static FilenameFilter filter(String string) {
        return new FilenameFilter(string){
            private final String val$suffix;
            {
                this.val$suffix = string;
            }

            public boolean accept(File file, String string) {
                String string2 = new File(string).getName();
                return string2.endsWith(this.val$suffix);
            }
        };
    }

    public Properties[] parseScripts(String string) throws RemoteException, RptServerException {
        ScriptFileSubmit scriptFileSubmit = new ScriptFileSubmit(string);
        Object[] objectArray = scriptFileSubmit.getResults().toArray();
        Properties[] propertiesArray = null;
        if (objectArray != null) {
            propertiesArray = new Properties[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                propertiesArray[n] = (Properties)objectArray[n];
                ++n;
            }
        }
        return propertiesArray;
    }

    public String exportScripts(String string, String[] stringArray) throws RemoteException, RptServerException {
        String string2 = "";
        if (stringArray == null || stringArray.length == 0) {
            return JSvrResource.getMessage("SLT_PG_209");
        }
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                TimeLaunchableObj timeLaunchableObj = this.getTask(stringArray[n2]);
                if (timeLaunchableObj != null) {
                    block6: {
                        Properties properties = timeLaunchableObj.getTask();
                        String string3 = (String)properties.get("jrs.report");
                        if (string3 != null) {
                            try {
                                boolean bl = this.addTask.checkPermission(string, string3, Permissions.P_READ);
                                if (bl || this.addTask.isAdminUser(string)) break block6;
                                break block7;
                            }
                            catch (Exception exception) {
                                ServiceLogger.logError(exception);
                                throw new RptServerException(exception);
                            }
                        }
                    }
                    string2 = string2 + SchdTools.getSortedScript(timeLaunchableObj);
                }
            }
            ++n2;
        }
        return string2;
    }

    public void setDataService(DataService dataService) {
        this.append = dataService;
    }

    public void updateLastExeTime(String string, long l) {
        try {
            TableProxy tableProxy = new TableProxy();
            tableProxy.setProxyObject(this.append.getSchdLastExeTimeTable());
            tableProxy.setProxyMethod("updateLastExeTime");
            tableProxy.setArguments(new Object[]{string, new Long(l)});
            TableProxyExecutorQueueFactory.getQueue().enqueue(tableProxy, 0);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

