/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.FileNotFoundException;
import java.io.IOException;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.cluster.Member;
import jet.server.api.cluster.ReportMember;
import jet.server.jrc.JRLoadBalancer;
import jet.server.log.ServiceLogger;

public class JRWeightLoadBalancer
extends JRLoadBalancer {
    private static ExProperties QOIV = new ExProperties();
    private static long append = -1L;

    protected float[] make(Member[] memberArray) {
        JRWeightLoadBalancer.loadWeights();
        float[] fArray = new float[memberArray.length];
        int n = 0;
        while (n < memberArray.length) {
            fArray[n] = ((ReportMember)memberArray[n]).getConcurrentReports();
            float f = CSUtil.parseFloat(QOIV.getProperty(memberArray[n].getServerName()));
            if (f <= 0.0f) {
                f = 1.0f;
            }
            ServiceLogger.logDebug(6650032, new String[]{memberArray[n].getServerName(), "" + fArray[n], "" + f}, 6);
            fArray[n] = fArray[n] / f;
            ++n;
        }
        return fArray;
    }

    public static void save(ExProperties exProperties) {
        String string = ServerEnv.getClusterWeightPropName();
        try {
            exProperties.save(string, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ServiceLogger.logError(fileNotFoundException, 3);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException, 3);
        }
        append = -1L;
        JRWeightLoadBalancer.loadWeights();
    }

    public static void loadWeights() {
        if (System.currentTimeMillis() - append > 300000L) {
            String string = ServerEnv.getClusterWeightPropName();
            try {
                QOIV.load(string);
                append = System.currentTimeMillis();
            }
            catch (FileNotFoundException fileNotFoundException) {
                ServiceLogger.logError(fileNotFoundException, 3);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
            }
        }
    }
}

