/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Properties;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.server.jrc.JRReportMember;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;

public class PredefinedServerList {
    private String QOIV;
    private String add;
    private JRReportMember[] append = new JRReportMember[0];

    public PredefinedServerList(String string, String string2) throws IOException {
        this.QOIV = string;
        this.add = string2;
        this.init();
    }

    public void init() throws IOException {
        File file = new File(this.QOIV);
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(file, this.add);
        File file3 = new File(file, this.add + ".bak");
        if (file2.exists()) {
            SchdTools.copyFile(file2, file3);
        }
        if (!file2.exists()) {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "ISO-8859-1"));
            PredefinedServerList.QOIV(bufferedWriter, new Date().toString());
            bufferedWriter.flush();
        } else {
            this.add(new FileInputStream(file2));
        }
    }

    public void sort() {
    }

    private static void QOIV(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    private void add(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
        bufferedReader.readLine();
        String string = null;
        boolean bl = false;
        this.append = new JRReportMember[0];
        while ((string = bufferedReader.readLine()) != null) {
            Properties properties = CSUtil.parseQuery(string);
            JRReportMember jRReportMember = new JRReportMember(properties);
            int n = jRReportMember.getBackupPriority();
            if (n < -1) {
                jRReportMember.setBackupPriority(-1);
            }
            String string2 = null;
            string2 = this.add(jRReportMember);
            if (string2 == null) continue;
            bl = true;
            if (!string2.equals("Duplicate backup priority")) continue;
            jRReportMember.setBackupPriority(jRReportMember.getBackupPriority() + 1);
            this.add(jRReportMember);
        }
        if (bl) {
            System.out.println(JSvrResource.getMessage("SVR_86"));
            ServiceLogger.logError(6650027, 2);
            this.save();
        }
    }

    public void synchronizeAdminServer(String string, String string2) {
        try {
            JRReportMember jRReportMember = new JRReportMember(string, string2);
            if (!jRReportMember.equals(this.append[0]) || this.append[0].getBackupPriority() != 0) {
                this.append[0] = jRReportMember;
                this.save();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 2);
        }
    }

    public synchronized void save() throws IOException {
        File file = new File(this.QOIV, this.add);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "ISO-8859-1"));
        int n = this.append.length;
        PredefinedServerList.QOIV(bufferedWriter, new Date().toString());
        int n2 = 0;
        while (n2 < n) {
            Properties properties = this.append[n2].toProperties(null);
            String string = CSUtil.makeNoHeadQuery(properties);
            PredefinedServerList.QOIV(bufferedWriter, string);
            ++n2;
        }
        bufferedWriter.flush();
    }

    public boolean isEmpty() {
        return this.append.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String add(JRReportMember jRReportMember) {
        int n = 0;
        while (n < this.append.length) {
            if (this.append[n].getServerName().equals(jRReportMember.getServerName())) {
                return "Duplicate server name";
            }
            if (this.append[n].equals(jRReportMember)) {
                return "Duplicate address";
            }
            if (jRReportMember.getBackupPriority() != -1 && this.append[n].getBackupPriority() == jRReportMember.getBackupPriority()) {
                return "Duplicate backup priority";
            }
            ++n;
        }
        JRReportMember[] jRReportMemberArray = this.append;
        synchronized (jRReportMemberArray) {
            int n2 = this.append.length;
            if (jRReportMember.getBackupPriority() != -1) {
                int n3 = this.append.length - 1;
                int n4 = 0;
                int n5 = jRReportMember.getBackupPriority();
                while (n4 <= n3) {
                    int n6 = (n3 + n4) / 2;
                    int n7 = this.append[n6].getBackupPriority();
                    if (n7 == -1 || n5 < n7) {
                        n3 = n6 - 1;
                        continue;
                    }
                    n4 = n6 + 1;
                }
                n2 = n4;
            }
            JRReportMember[] jRReportMemberArray2 = new JRReportMember[this.append.length + 1];
            System.arraycopy(this.append, 0, jRReportMemberArray2, 0, n2);
            jRReportMemberArray2[n2] = jRReportMember;
            System.arraycopy(this.append, n2, jRReportMemberArray2, n2 + 1, this.append.length - n2);
            this.append = jRReportMemberArray2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JRReportMember remove(String string) {
        int n = this.append(string);
        if (n != -1) {
            JRReportMember jRReportMember = this.append[n];
            JRReportMember[] jRReportMemberArray = this.append;
            synchronized (jRReportMemberArray) {
                JRReportMember[] jRReportMemberArray2 = new JRReportMember[this.append.length - 1];
                System.arraycopy(this.append, 0, jRReportMemberArray2, 0, n);
                System.arraycopy(this.append, n + 1, jRReportMemberArray2, n, jRReportMemberArray2.length - n);
                this.append = jRReportMemberArray2;
            }
            return jRReportMember;
        }
        return null;
    }

    private int append(String string) {
        int n = -1;
        int n2 = this.append.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.append[n3].getServerName().equals(string)) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n;
    }

    public JRReportMember getPredefinedServer(JRReportMember jRReportMember) {
        int n = this.append.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.append[n2].equals(jRReportMember)) {
                return this.append[n2];
            }
            ++n2;
        }
        return null;
    }

    public JRReportMember[] getServerList() {
        return this.append;
    }
}

