/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.admin;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.api.admin.ClusterAdminService;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationAdvanced;
import jet.server.api.admin.cfg.ConfigurationMail;
import jet.server.api.admin.cfg.ConfigurationService;
import jet.server.api.cluster.ClusterException;
import jet.server.api.cluster.Member;
import jet.server.api.cluster.ReportMember;
import jet.server.intf.jrs.ClusterReceiver;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.jrc.JRClusterService;
import jet.server.jrc.JRReportMember;
import jet.server.jrc.JRWeightLoadBalancer;
import jet.server.jrc.PredefinedServerList;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;

public class JRClusterAdminService
implements ClusterAdminService {
    private JRClusterService QOIV = null;
    private ConfigurationService add = null;
    private ConfigurationAdvanced addPredefinedServer = null;
    private ConfigurationMail append = null;
    private PredefinedServerList close = null;
    private ExProperties enableNotifyServerDown = new ExProperties();
    private String equals = null;
    private Properties equalsIgnoreCase = new Properties();
    private int get = 5;

    public JRClusterAdminService(JRClusterService jRClusterService, ConfigService configService) {
        this.QOIV = jRClusterService;
        this.add = configService.getConfigurationService();
        this.addPredefinedServer = configService.getConfigurationAdvanced();
        this.append = configService.getConfigurationMail();
        this.close = ServerEnv.getPredefinedServerList();
        this.equals = ServerEnv.getServPropName();
        try {
            this.enableNotifyServerDown.load(this.equals);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private boolean isAdminUser(String string, String string2) {
        return UserDataToolkit.getSecurityService(string).isAdminUser(string2);
    }

    public String stopServer(String string, String string2, String string3) throws ClusterException {
        Object object;
        Member member = this.QOIV.getLocalMember();
        if ((member.getHost().equalsIgnoreCase(string) || string == null || string.length() == 0) && member.getPort().equalsIgnoreCase(string2) && ((Member[])(object = this.QOIV.getAllMembers())).length > 1) {
            int n = 0;
            while (n < ((Object)object).length) {
                if (object[n].isBackupAdmin()) break;
                ++n;
            }
            if (n == ((Object)object).length) {
                return "The admin server cannot be shut down, because there is no backup server in the cluster.";
            }
        }
        try {
            object = (MemberMonitor)RemoteObjectFactory.getRemoteObject(string, Integer.parseInt(string2), "MemberMonitor");
            object.stopServer();
        }
        catch (UnmarshalException unmarshalException) {
        }
        catch (Exception exception) {
            throw new ClusterException(exception);
        }
        ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string3, 6660041, new Object[]{string, String.valueOf(string2)}, 6);
        return null;
    }

    public String stopServer(String string, String string2) throws ClusterException {
        if (!this.isAdminUser(ServerEnv.getActiveRealm(), string2)) {
            return "user is not adminstrator";
        }
        if (string == null || string.trim().length() == 0) {
            return "server can not empty.";
        }
        Member[] memberArray = this.QOIV.getAllMembers();
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (n < memberArray.length) {
            if (string.equalsIgnoreCase(memberArray[n].getServerName())) {
                string3 = memberArray[n].getHost();
                string4 = memberArray[n].getPort();
                break;
            }
            ++n;
        }
        if (string3 != null) {
            return this.stopServer(string3, string4, string2);
        }
        throw new ClusterException(650001, new Object[]{string}, null);
    }

    private long runTestReport(String string, String string2, Properties properties) throws ClusterException {
        try {
            MemberMonitor memberMonitor = (MemberMonitor)RemoteObjectFactory.getRemoteObject(string, Integer.parseInt(string2), "MemberMonitor");
            return memberMonitor.runTestReport(properties);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
            throw new ClusterException(exception);
        }
    }

    public long runTestReport(String string, Properties properties) throws ClusterException {
        Member[] memberArray = this.QOIV.getAllMembers();
        String string2 = null;
        String string3 = null;
        int n = 0;
        while (n < memberArray.length) {
            if (string.equalsIgnoreCase(memberArray[n].getServerName())) {
                string2 = memberArray[n].getHost();
                string3 = memberArray[n].getPort();
                break;
            }
            ++n;
        }
        if (string2 != null) {
            return this.runTestReport(string2, string3, properties);
        }
        throw new ClusterException(650001, new Object[]{string}, null);
    }

    public void saveClusterWeights(Properties properties) {
        ExProperties exProperties = new ExProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = String.valueOf(enumeration.nextElement());
            exProperties.put(string, properties.get(string));
        }
        JRWeightLoadBalancer.save(exProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties loadClusterWeights() throws IOException {
        Properties properties = new Properties();
        String string = ServerEnv.getClusterWeightPropName();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        try {
            try {
                properties.load(bufferedInputStream);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException, 3);
                Object var6_5 = null;
                bufferedInputStream.close();
                return properties;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            bufferedInputStream.close();
            throw throwable;
        }
        bufferedInputStream.close();
        return properties;
    }

    public String stopCluster(String string) throws ClusterException {
        if (!this.isAdminUser(ServerEnv.getActiveRealm(), string)) {
            return "user is not adminstrator";
        }
        Member member = this.QOIV.getLocalMember();
        Member[] memberArray = this.QOIV.getAllMembers();
        String string2 = null;
        int n = 0;
        while (n < memberArray.length) {
            if (!member.equals(memberArray[n]) && (string2 = this.stopServer(memberArray[n].getHost(), memberArray[n].getPort(), string)) != null) {
                string2 = "Can not stop server " + memberArray[n].getHost() + ":" + memberArray[n].getPort();
                break;
            }
            ++n;
        }
        if (string2 == null) {
            string2 = this.stopServer(member.getHost(), member.getPort(), string);
        }
        return string2;
    }

    public boolean canEditPredefinedServers() {
        return this.close != null;
    }

    public int getCheckAdminCrashedInterval() {
        return this.get;
    }

    public void setCheckAdminCrashedInterval(int n) {
        this.get = n;
    }

    public String addPredefinedServer(String string, String string2, String string3, String string4) throws ClusterException {
        return this.addPredefinedServer(string, string2, string3, -1, string4);
    }

    public String addPredefinedServer(String string, String string2, String string3, int n, String string4) throws ClusterException {
        if (!this.isAdminUser(ServerEnv.getActiveRealm(), string4)) {
            return "user is not adminstrator";
        }
        if (this.close != null) {
            String string5 = null;
            if (string == null || string.trim().length() == 0) {
                return "Server name cannot be blank.";
            }
            try {
                JRReportMember jRReportMember = new JRReportMember(string, string2, string3, n);
                string5 = this.close.add(jRReportMember);
                this.close.save();
            }
            catch (Exception exception) {
                throw new ClusterException(exception);
            }
            this.QOIV();
            if (string5 == null) {
                ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string4, 6660042, string, 6);
            } else {
                ServiceLogger.logManageFailEvent(ServerEnv.getActiveRealm(), string4, 6660043, new Object[]{string, String.valueOf(string5)}, 6);
            }
            return string5;
        }
        return "Not support.";
    }

    private String QOIV() {
        Member[] memberArray;
        String string = null;
        ReportMember[] reportMemberArray = this.close.getServerList();
        try {
            memberArray = this.QOIV.getClusterReceiver();
            memberArray.receivePredefined(reportMemberArray);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(3660040, this.QOIV.getLocalMember(), 3);
            string = "Can not send predefined server list to " + this.QOIV.getLocalMember();
        }
        try {
            memberArray = this.QOIV.getAllMembers();
            ClusterReceiver clusterReceiver = null;
            int n = 0;
            while (n < memberArray.length) {
                if (!memberArray[n].isAdmin()) {
                    try {
                        clusterReceiver = (ClusterReceiver)RemoteObjectFactory.getRemoteObject(memberArray[n].getHost(), Integer.parseInt(memberArray[n].getPort()), "ClusterReceiver");
                        clusterReceiver.receivePredefined(reportMemberArray);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(3660040, memberArray[n], 3);
                        string = "Can not send predefined server list to " + memberArray[n];
                    }
                }
                ++n;
            }
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError(clusterException, 3);
            string = clusterException.getMessage();
        }
        return string;
    }

    public String removePredefinedServer(String string, String string2) throws ClusterException {
        if (!this.isAdminUser(ServerEnv.getActiveRealm(), string2)) {
            return "user is not adminstrator";
        }
        if (this.close != null) {
            String string3 = null;
            JRReportMember jRReportMember = this.close.remove(string);
            if (jRReportMember != null) {
                try {
                    this.close.save();
                }
                catch (IOException iOException) {
                    throw new ClusterException(iOException);
                }
                this.QOIV();
            } else {
                string3 = "Not exist in predefined server list.";
            }
            if (string3 == null) {
                ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string2, 6660044, string, 6);
            } else {
                ServiceLogger.logManageFailEvent(ServerEnv.getActiveRealm(), string2, 6660045, new Object[]{string, String.valueOf(string3)}, 6);
            }
            return string3;
        }
        return "Not support.";
    }

    public Member[] getPredefinedServers() {
        if (this.close != null) {
            return this.close.getServerList();
        }
        return this.QOIV.getPredefinedMembers();
    }

    public void setEnableNotifyServerDown(boolean bl) {
        try {
            this.enableNotifyServerDown.setProperty("cluster.enable_notify_server_down", bl);
            this.equalsIgnoreCase.put("cluster.enable_notify_server_down", String.valueOf(bl));
            this.enableNotifyServerDown.save(this.equals, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public boolean isEnableNotifyServerDown() {
        String string = (String)this.equalsIgnoreCase.get("cluster.enable_notify_server_down");
        if (string != null && string.trim().length() > 0) {
            return string.equalsIgnoreCase("true");
        }
        return ServerEnv.enableNotifyServerDown();
    }

    public void setNotifyServerDownAddress(String string) {
        try {
            this.enableNotifyServerDown.setProperty("cluster.notify_server_down_address", string);
            this.equalsIgnoreCase.put("cluster.notify_server_down_address", String.valueOf(string));
            this.enableNotifyServerDown.save(this.equals, null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public String getNotifyServerDownAddress() {
        String string = (String)this.equalsIgnoreCase.get("cluster.notify_server_down_address");
        if (string != null && string.trim().length() > 0) {
            return string;
        }
        return ServerEnv.getNotifyServerDownAddress();
    }

    public String getActiveRealm() {
        return this.add.getActiveRealm();
    }

    public void setActiveRealm(String string, String string2) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string2)) {
            this.add.setActiveRealm(string);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string2, 6660046, string, 6);
        }
    }

    public boolean isNeedSecurity() {
        return this.addPredefinedServer.getEnableSecurityCheck();
    }

    public void setNeedSecurity(boolean bl, String string) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string)) {
            this.addPredefinedServer.setEnableSecurityCheck(bl);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string, 6660047, String.valueOf(bl), 6);
        }
    }

    public boolean isEnableJSP() {
        return true;
    }

    public void setEnableJSP(boolean bl, String string) {
    }

    public boolean isEnablePublishTempToVersion() {
        return this.addPredefinedServer.getEnablePublishTempToVersion();
    }

    public void setEnablePublishTempToVersion(boolean bl, String string) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string)) {
            this.addPredefinedServer.setEnablePublishTempToVersion(bl);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string, 6660049, String.valueOf(bl), 6);
        }
    }

    public void setMailServer(String string, String string2) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string2)) {
            this.append.setMailServer(string);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string2, 6660050, string, 6);
        }
    }

    public String getMailServer() {
        return this.append.getMailServer();
    }

    public void setMailPort(int n, String string) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string)) {
            this.append.setMailPort(n);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string, 6660051, String.valueOf(n), 6);
        }
    }

    public int getMailPort() {
        return this.append.getMailPort();
    }

    public void setMailBox(String string, String string2) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string2)) {
            this.append.setMailBox(string);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string2, 6660052, string, 6);
        }
    }

    public String getMailBox() {
        return this.append.getMailBox();
    }

    public void setDefaultMailFormat(int n, String string) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string)) {
            this.append.setMailFormat(n);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string, 6660053, String.valueOf(n), 6);
        }
    }

    public int getDefaultMailFormat() {
        return this.append.getDefaultMailFormat();
    }

    public Vector getMailFormats() {
        return this.append.getMailFormats();
    }

    public void setEnableCompress(boolean bl, String string) {
        if (this.isAdminUser(ServerEnv.getActiveRealm(), string)) {
            this.append.setEnableCompress(bl);
            ServiceLogger.logManageSuccessEvent(ServerEnv.getActiveRealm(), string, 6660054, String.valueOf(bl), 6);
        }
    }

    public boolean isEnableCompress() {
        return this.append.getEnableCompress();
    }
}

