/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.engine;

import java.rmi.RemoteException;
import java.util.Properties;
import jet.JSvrResource;
import jet.server.jrc.engine.JREngineContext;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.bursting.BurstingTaskUtil;
import jet.server.schedule.bursting.NonBurstingResultListener;
import jet.server.schedule.jrtasks.RunRptTask;

class NonBurstingResultTaskThread
extends Thread
implements NonBurstingResultListener {
    private Properties QOIV;
    private JREngineContext createSubTask;
    private String[] getErrorMsg;
    private Object getJREngineManager = new Object();
    private boolean getJRTaskManager;

    NonBurstingResultTaskThread(Properties properties, String[] stringArray, JREngineContext jREngineContext) {
        this.QOIV = properties;
        this.createSubTask = jREngineContext;
        this.getErrorMsg = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        String string = null;
        Object object = this.getJREngineManager;
        synchronized (object) {
            try {
                this.getJREngineManager.wait();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
                string = JSvrResource.getMessage("NONBURSTING_RESULT_FAILED", interruptedException);
            }
        }
        if (!bl && !this.getJRTaskManager) {
            this.getJRTaskManager = true;
            string = this.QOIV();
        }
        try {
            this.createSubTask.getTaskListener().nonBurstingResultFinished(string);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNonBurstingResultTask() {
        Object object = this.getJREngineManager;
        synchronized (object) {
            this.getJREngineManager.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void I() {
        Object object = this.getJREngineManager;
        synchronized (object) {
            if (!this.getJRTaskManager) {
                // empty if block
            }
        }
    }

    private String QOIV() {
        RunRptTask runRptTask = null;
        String string = null;
        try {
            runRptTask = BurstingTaskUtil.createSubTask(this.QOIV, this.createSubTask.getJREngineManager().getTaskManager(), this.createSubTask, this.createSubTask.isLocal(), true);
            runRptTask.setBurstingExecutor(this.createSubTask.I);
            runRptTask.setSelectedSchemas(this.getErrorMsg);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
            string = SchdTools.getStackTraceString(remoteException);
        }
        if (runRptTask != null) {
            runRptTask.run();
            runRptTask.getJRTaskManager().sendTaskContext(runRptTask);
            string = runRptTask.getErrorMsg();
        }
        if (string != null) {
            string = JSvrResource.getMessage("NONBURSTING_RESULT_FAILED", string);
        }
        return string;
    }
}

