/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.io.InputStream;
import java.util.ArrayList;
import jet.server.api.RptServer;
import jet.server.api.http.HttpUtil;
import jet.server.intf.jrs.MemberMonitor;
import jet.server.intf.resource.AdhocResourceManager;
import jet.server.jrc.JRRemoteFileService;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;

public class AdhocResourceManagerImpl
implements AdhocResourceManager {
    private String QOIV;
    private String add;
    private String append;
    private JRRemoteFileService delete;

    public AdhocResourceManagerImpl(RptServer rptServer) {
        try {
            if (rptServer.isClusterEnable()) {
                this.add = rptServer.getAdminService().getClusterAdminService().getActiveRealm();
                String string = rptServer.getClusterService().getAdminMember().getHost();
                int n = Integer.parseInt(rptServer.getClusterService().getAdminMember().getPort());
                this.QOIV = ((MemberMonitor)RemoteObjectFactory.getRemoteObject(string, n, "MemberMonitor")).getRemoteRealmsPath();
                this.delete = new JRRemoteFileService(string, n);
            } else {
                this.add = rptServer.getAdminService().getSecurityAdminService().getActiveRealm();
                this.QOIV = HttpUtil.getRealmDir();
                this.delete = (JRRemoteFileService)HttpUtil.getRemoteFileService();
            }
            this.append = this.delete.getRemoteFileSeparator();
        }
        catch (Exception exception) {
            ServiceLogger.logError("new AdhocResourceManagerImpl(rptServer): rptServer=" + rptServer + ", realmsPath=" + this.QOIV + ", realm=" + this.add + ", fileSeparator=" + this.append);
            ServiceLogger.logError(exception);
        }
        ServiceLogger.logDebug("new AdhocResourceManagerImpl(rptServer): rptServer=" + rptServer + ", realmsPath=" + this.QOIV + ", realm=" + this.add + ", fileSeparator=" + this.append);
    }

    public AdhocResourceManagerImpl(String string, String string2, String string3, int n) throws Exception {
        this.QOIV = string;
        this.add = string2;
        try {
            this.delete = new JRRemoteFileService(string3, n);
            this.append = this.delete.getRemoteFileSeparator();
        }
        catch (Exception exception) {
            ServiceLogger.logError("new AdhocResourceManagerImpl(): realmsPath=" + this.QOIV + ", realm=" + string2 + ", fileSeparator=" + this.append);
            ServiceLogger.logError(exception);
        }
        ServiceLogger.logDebug("new AdhocResourceManagerImpl(): realmsPath=" + this.QOIV + ", realm=" + string2 + ", fileSeparator=" + this.append);
    }

    private String QOIV(String string, String string2) {
        return this.add(string, string2, null);
    }

    private String add(String string, String string2, String string3) {
        String string4 = this.QOIV + this.add + this.append + string + this.append + "upload";
        if (string2 != null) {
            if (!string2.startsWith(this.append) && !string2.startsWith("/")) {
                string4 = string4 + this.append;
            }
            string4 = string4 + string2;
        }
        if (string3 != null) {
            if (!string4.endsWith(this.append)) {
                string4 = string4 + this.append;
            }
            string4 = string4 + string3;
        }
        return string4;
    }

    public String[] listFiles(String string, String string2) throws Exception {
        String[] stringArray = this.delete.list(this.QOIV(string, string2), "*");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (!this.delete.isDirectory(this.add(string, string2, stringArray[n]))) {
                    arrayList.add(stringArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] listFolders(String string, String string2) throws Exception {
        String[] stringArray = this.delete.list(this.QOIV(string, string2), "*");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.delete.isDirectory(this.add(string, string2, stringArray[n]))) {
                    arrayList.add(stringArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public void delete(String string, String string2, String string3) throws Exception {
        this.deleteFile(this.add(string, string2, string3));
    }

    public InputStream readFile(String string, String string2, String string3) throws Exception {
        return this.delete.readFile(this.add(string, string2, string3));
    }

    public void saveFile(String string, String string2, String string3, InputStream inputStream) throws Exception {
        this.delete.mkdir(this.QOIV(string, string2));
        this.delete.writeFile(inputStream, this.add(string, string2, string3));
    }

    public void removeUpload(String string, String string2) {
        String string3 = this.QOIV + string + this.append + string2 + this.append + "upload";
        try {
            this.deleteFile(string3);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    private void deleteFile(String string) throws Exception {
        String[] stringArray;
        if (!this.delete.exists(string)) {
            return;
        }
        if (this.delete.isDirectory(string) && (stringArray = this.delete.list(string, "*")) != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string2 = string + this.append + stringArray[n];
                if (this.delete.isDirectory(string2)) {
                    this.deleteFile(string2);
                } else {
                    this.delete.delete(string2);
                }
                ++n;
            }
        }
        this.delete.delete(string);
    }

    public void copyTo(String string, String string2, String string3, String string4) throws Exception {
        if (!string4.endsWith(this.append)) {
            string4 = string4 + this.append;
        }
        string4 = string4 + string3;
        this.delete.writeFile(this.readFile(string, string2, string3), string4);
    }
}

