/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.Permission;
import java.util.Hashtable;
import jet.cs.CSUtil;
import jet.server.api.PathInfo;
import jet.server.db.resource.NodeRecord;
import jet.server.intf.resource.Node;
import jet.server.intf.security.User;
import jet.server.jrc.resource.FolderImpl;
import jet.server.jrc.resource.PathInfoImpl;

public abstract class NodeImpl
implements Node,
Cloneable {
    private NodeRecord checkPermission;
    private String clone = "";
    private Acl equals = null;
    private Node equalsIgnoreCase = null;
    private boolean get = false;
    private String getAbsolutePath = null;
    private Node getAclID = null;

    public NodeImpl() {
    }

    public NodeImpl(String string) {
        this.clone = string;
        this.checkPermission = new NodeRecord();
        this.checkPermission.setAclID(-1);
    }

    public String getDescription() {
        return this.checkPermission.getDescription();
    }

    public NodeImpl(NodeRecord nodeRecord) {
        this.checkPermission = nodeRecord;
        if (!nodeRecord.isDynamic()) {
            boolean bl = this.get = nodeRecord.getParentID() == -1;
        }
        if (this.get) {
            nodeRecord.setParentID(nodeRecord.getID());
            if (nodeRecord.getName().length() != 0) {
                nodeRecord.setName("");
            }
        }
    }

    public boolean setAcl(Acl acl, User user) {
        this.equals = acl;
        return true;
    }

    public Acl getAcl() {
        return this.equals;
    }

    public boolean removeAcl(User user) {
        this.equals = null;
        return true;
    }

    public String getName() {
        return this.checkPermission.getName();
    }

    public void rename(String string) {
        this.checkPermission.setName(string);
    }

    public String getAbsolutePath() {
        return this.clone;
    }

    public Node getParent() {
        return this.equalsIgnoreCase;
    }

    public void setParent(Node node) {
        this.equalsIgnoreCase = node;
        if (this.getOwnerName() == null) {
            this.getAbsolutePath = node.getOwnerName();
        }
    }

    public void remove() {
        this.checkPermission = null;
        this.equals = null;
        this.equalsIgnoreCase = null;
        this.getAclID = null;
    }

    public String getCreatorName() {
        return this.checkPermission.getCreatorName();
    }

    public long getCreateTime() {
        return this.checkPermission.getCreateTime().getTime();
    }

    public boolean checkPermission(User user, Permission permission) {
        if (this.isValidAdminUser(user) || this.checkPermission.getCreatorName().equals(user.getName())) {
            return true;
        }
        if (this.equals != null) {
            return this.equals.checkPermission((Principal)user, permission);
        }
        return this.equalsIgnoreCase.checkPermission(user, permission);
    }

    protected boolean isValidAdminUser(User user) {
        return false;
    }

    public boolean equals(Object object) {
        NodeImpl nodeImpl = (NodeImpl)object;
        return this.getID() == nodeImpl.getID();
    }

    public int getID() {
        return this.checkPermission.getID();
    }

    public boolean isRoot() {
        return this.get;
    }

    public int getParentID() {
        return this.checkPermission.getParentID();
    }

    public byte getNodeType() {
        return this.checkPermission.getNodeType();
    }

    protected void setNodeType(byte by) {
        this.checkPermission.setNodeType(by);
    }

    public PathInfoImpl getPathInfo(String string) {
        PathInfoImpl pathInfoImpl = new PathInfoImpl();
        pathInfoImpl.setID(this.checkPermission.getID());
        pathInfoImpl.setDescription(this.checkPermission.getDescription());
        pathInfoImpl.setName(this.checkPermission.getName());
        pathInfoImpl.setNodeType(this.checkPermission.getNodeType());
        pathInfoImpl.setPath(this.getAbsolutePath());
        pathInfoImpl.setUserID(string);
        pathInfoImpl.setIsDynamic(this.isDynamic());
        pathInfoImpl.setEnableLinkedCatalog(this.isEnableLinkedCatalog());
        pathInfoImpl.setLinkedCatalog(this.getLinkedCatalog());
        pathInfoImpl.setUseInherited(this.isUseInherited());
        if (!this.isRoot()) {
            pathInfoImpl.setParentPath(this.equalsIgnoreCase.getAbsolutePath());
        }
        return pathInfoImpl;
    }

    public String toString() {
        return "record=" + this.checkPermission + ", absolutePath=" + this.clone + ", acl=" + this.equals;
    }

    public void setAbsolutePath(String string) {
        this.clone = string;
    }

    public void setDescription(String string) {
        this.checkPermission.setDescription(string);
    }

    public PathInfo toPathInfo(String string) {
        return null;
    }

    public int getAclID() {
        return this.checkPermission.getAclID();
    }

    public void setAclID(int n) {
        this.checkPermission.setAclID(n);
    }

    public String getOwnerName() {
        return this.getAbsolutePath;
    }

    public void setOwnerName(String string) {
        this.getAbsolutePath = string;
    }

    public boolean isOwnerOrCreator(String string) {
        return this.getOwnerName() != null && this.getOwnerName().equals(string) || this.checkPermission.getCreatorName() != null && this.checkPermission.getCreatorName().equals(string);
    }

    public boolean setNodeProperties(Hashtable hashtable) {
        String string = (String)hashtable.get("jrs.node_name");
        String string2 = (String)hashtable.get("jrs.node_desc");
        boolean bl = CSUtil.getBoolean((String)hashtable.get("jrs.is_alias"), false);
        boolean bl2 = false;
        if (!bl && string != null && string.trim().length() > 0 && !(string = string.trim()).equalsIgnoreCase(this.checkPermission.getName())) {
            bl2 = true;
            if (this.equalsIgnoreCase.getNodeType() == 1) {
                ((FolderImpl)this.equalsIgnoreCase).replaceChildName(this.checkPermission.getName(), string);
            }
            this.checkPermission.setName(string);
        }
        if (!(string2 == null || this.checkPermission.getDescription() != null && string2.equalsIgnoreCase(this.checkPermission.getDescription()))) {
            bl2 = true;
            this.checkPermission.setDescription(string2);
        }
        return bl2;
    }

    public boolean setDefaultLinkedCatalogProps(Hashtable hashtable) {
        boolean bl = false;
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.enable.linked.catalog"), false);
        String string = (String)hashtable.get("jrs.linked.catalog");
        boolean bl3 = CSUtil.getBoolean((String)hashtable.get("jrs.is.use.inherited"), false);
        if (bl2 != this.checkPermission.isEnableLinkedCatalog() || string == null && this.checkPermission.getLinkedCatalog() != null || string != null && !string.equalsIgnoreCase(this.checkPermission.getLinkedCatalog()) || bl3 != this.checkPermission.isUseInherited()) {
            bl = true;
            this.checkPermission.setEnableLinkedCatalog(bl2);
            this.checkPermission.setLinkedCatalog(string);
            this.checkPermission.setUseInherited(bl3);
        }
        return bl;
    }

    public boolean isDynamic() {
        return this.checkPermission.isDynamic();
    }

    public Object clone() {
        Node node = null;
        try {
            node = (Node)super.clone();
            ((NodeImpl)node).checkPermission = (NodeRecord)this.checkPermission.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return node;
    }

    public boolean isEnableLinkedCatalog() {
        return this.checkPermission.isEnableLinkedCatalog();
    }

    public void setEnableLinkedCatalog(boolean bl) {
        this.checkPermission.setEnableLinkedCatalog(bl);
    }

    public String getLinkedCatalog() {
        return this.checkPermission.getLinkedCatalog();
    }

    public void setLinkedCatalog(String string) {
        this.checkPermission.setLinkedCatalog(string);
    }

    public boolean isUseInherited() {
        return this.checkPermission.isUseInherited();
    }

    public void setUseInherited(boolean bl) {
        this.checkPermission.setUseInherited(bl);
    }
}

