/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.io.File;
import java.io.Serializable;
import jet.server.api.PathInfo;
import jet.server.api.RptServerException;

public class PathInfoImpl
implements PathInfo,
Serializable {
    private int nodeID;
    private String userID;
    private String path;
    private String name;
    private String parentPath;
    private String description;
    private String realPath = "";
    private byte nodeType;
    private byte resourceType;
    private String[] fileInfo;
    private int maxVersionAmount = 0;
    private int versionNumber = -1;
    private boolean archiveNewVersion = true;
    private boolean enableArchivePolicy = false;
    private boolean shared = false;
    private boolean adhocReport = false;
    boolean isDynamic = false;
    boolean enableDynamicResource = false;
    private boolean isEnableLinkedCatalog = false;
    private String linkedCatalog = null;
    private boolean isUseInherited = false;
    private String profileName;
    private long lastModified = 0L;

    public String getUserID() {
        return this.userID;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getRealPath() throws RptServerException {
        return this.realPath == null || this.realPath.trim().length() == 0 ? "" : this.realPath;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public boolean isResourceNode() {
        return true;
    }

    public boolean isDir() {
        return this.nodeType == 1;
    }

    public boolean isFile() {
        return this.nodeType == 2;
    }

    public boolean isCatalog() {
        return this.nodeType == 2 && this.resourceType == 1;
    }

    public boolean isReport() {
        return this.nodeType == 2 && this.resourceType == 2;
    }

    public boolean isSelfContainReport() {
        return this.isReport() && this.realPath.endsWith(".clx");
    }

    public boolean isShared() {
        return this.shared;
    }

    public String[] getFileInfo() throws RptServerException {
        return this.fileInfo;
    }

    public boolean isResult() {
        return this.nodeType == 2 && this.resourceType == 3;
    }

    public void setDescription(String string) {
        if (string != null && string.equalsIgnoreCase("null")) {
            this.description = null;
            return;
        }
        this.description = string;
    }

    public void setFileInfo(String[] stringArray) {
        this.fileInfo = stringArray;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setNodeType(byte by) {
        this.nodeType = by;
    }

    public void setParentPath(String string) {
        this.parentPath = string;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public void setRealPath(String string) {
        File file;
        String string2 = this.realPath = string == null ? "" : string;
        if (this.realPath.length() > 0 && (file = new File(string)).exists()) {
            this.lastModified = file.lastModified();
        }
    }

    public void setResourceType(byte by) {
        this.resourceType = by;
    }

    public void setUserID(String string) {
        this.userID = string;
    }

    public int getID() {
        return this.nodeID;
    }

    public void setID(int n) {
        this.nodeID = n;
    }

    public int getMaxVersionAmount() {
        return this.maxVersionAmount;
    }

    public void setMaxVersionAmount(int n) {
        this.maxVersionAmount = n;
    }

    public String toString() {
        return super.toString() + "[" + "nodeID=" + this.nodeID + ", name=" + this.name + ", path=" + this.path + ", userID=" + this.userID + ", realPath=" + this.realPath + ", description=" + this.description + ", nodeType=" + this.nodeType + ", resourceType=" + this.resourceType + ", selfContainReport=" + this.isSelfContainReport() + ", adhocReport=" + this.isAdhocReport() + ", archiveNewVersion=" + this.archiveNewVersion + ", maxVersionAmount=" + this.maxVersionAmount + ", enableArchivePolicy=" + this.enableArchivePolicy + ", shared=" + this.shared + "]";
    }

    public boolean isInUserDir() {
        return this.path.startsWith("/USERFOLDERPATH");
    }

    public boolean isOwner(String string) {
        return this.path.startsWith("/USERFOLDERPATH/" + string);
    }

    public int getLatestVersionNumber() {
        return this.versionNumber;
    }

    public void setLatestVersionNumber(int n) {
        this.versionNumber = n;
    }

    public boolean isArchiveNewVersion() {
        return this.archiveNewVersion;
    }

    public void setArchiveNewVersion(boolean bl) {
        this.archiveNewVersion = bl;
    }

    public boolean isEnableArchivePolicy() {
        return this.enableArchivePolicy;
    }

    public void setEnableArchivePolicy(boolean bl) {
        this.enableArchivePolicy = bl;
    }

    public void setShared(boolean bl) {
        this.shared = bl;
    }

    public boolean isAdhocReport() {
        return this.adhocReport;
    }

    public byte getNodeType() {
        if (this.isDir()) {
            return 3;
        }
        if (this.isReport()) {
            return 0;
        }
        if (this.isCatalog()) {
            return 2;
        }
        return 1;
    }

    public void setAdhocReport(boolean bl) {
        this.adhocReport = bl;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setIsDynamic(boolean bl) {
        this.isDynamic = bl;
    }

    public boolean isEnableDynamicResource() {
        return this.enableDynamicResource;
    }

    public void setEnableDynamicResource(boolean bl) {
        this.enableDynamicResource = bl;
    }

    public boolean isEnableLinkedCatalog() {
        return this.isEnableLinkedCatalog;
    }

    public void setEnableLinkedCatalog(boolean bl) {
        this.isEnableLinkedCatalog = bl;
    }

    public String getLinkedCatalog() {
        return this.linkedCatalog;
    }

    public void setLinkedCatalog(String string) {
        this.linkedCatalog = string;
    }

    public boolean isUseInherited() {
        return this.isUseInherited;
    }

    public void setUseInherited(boolean bl) {
        this.isUseInherited = bl;
    }

    public void setProfileName(String string) {
        this.profileName = string;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public long getLastModified() {
        return this.lastModified;
    }
}

