/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.api.UserSession;
import jet.server.api.admin.ResourceAlias;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.http.HttpUtil;
import jet.server.db.resource.AliasTable;
import jet.server.intf.resource.Node;
import jet.server.intf.security.Group;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.JRDataService;
import jet.server.jrc.resource.ResourceAliasImpl;
import jet.server.log.ServiceLogger;
import jet.server.util.ui.AliasNode;
import jet.server.util.ui.AliasTree;

public class ResourceAliasManagerImpl {
    private SecurityService QOIV = null;
    private AliasTable add = null;
    private Hashtable addChild = null;

    public ResourceAliasManagerImpl(JRDataService jRDataService, SecurityService securityService) {
        this.QOIV = securityService;
        this.add = jRDataService.getAliasTable();
        this.addChild = new Hashtable(400);
    }

    public Hashtable allLoginUserAliases() {
        return this.addChild;
    }

    public void loadUserAliasToMem(String string) {
        Hashtable hashtable = new Hashtable();
        Vector vector = this.add.getAliasesByPrincipal(string, (byte)0);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                ResourceAlias resourceAlias = (ResourceAlias)vector.elementAt(n);
                hashtable.put(resourceAlias.aliasPath().toUpperCase(), resourceAlias);
                ++n;
            }
        }
        try {
            Vector vector2;
            Vector vector3 = this.QOIV.getRolesNameByUser(string);
            if (vector3 != null) {
                int n = 0;
                while (n < vector3.size()) {
                    String string2 = (String)vector3.elementAt(n);
                    hashtable = this.QOIV(hashtable, string2);
                    ++n;
                }
            }
            if ((vector2 = this.QOIV.getGroupsNameByUser(string)) != null) {
                int n = 0;
                while (n < vector2.size()) {
                    String string3 = (String)vector2.elementAt(n);
                    hashtable = this.add(hashtable, string3);
                    ++n;
                }
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException);
        }
        if (hashtable != null && hashtable.size() != 0) {
            this.addChild.put(string, hashtable);
        }
    }

    private Hashtable QOIV(Hashtable hashtable, String string) {
        Vector vector = this.add.getAliasesByPrincipal(string, (byte)1);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                ResourceAlias resourceAlias = (ResourceAlias)vector.elementAt(n);
                if (hashtable.get(resourceAlias.aliasPath().toUpperCase()) == null) {
                    hashtable.put(resourceAlias.aliasPath().toUpperCase(), resourceAlias);
                }
                ++n;
            }
        }
        try {
            Vector vector2 = this.QOIV.getRole(string).getParentRoleNames();
            if (vector2 != null && vector2.size() > 0) {
                int n = 0;
                while (n < vector2.size()) {
                    String string2 = (String)vector2.elementAt(n);
                    hashtable = this.QOIV(hashtable, string2);
                    ++n;
                }
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {
            // empty catch block
        }
        return hashtable;
    }

    private Hashtable add(Hashtable hashtable, String string) {
        Serializable serializable;
        Vector vector = this.add.getAliasesByPrincipal(string, (byte)2);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                serializable = (ResourceAlias)vector.elementAt(n);
                if (hashtable.get(serializable.aliasPath().toUpperCase()) == null) {
                    hashtable.put(serializable.aliasPath().toUpperCase(), serializable);
                }
                ++n;
            }
        }
        try {
            Vector vector2;
            Group group = this.QOIV.getGroup(string);
            serializable = group.getRoleNames();
            if (serializable != null && ((Vector)serializable).size() > 0) {
                int n = 0;
                while (n < ((Vector)serializable).size()) {
                    String string2 = (String)((Vector)serializable).elementAt(n);
                    hashtable = this.QOIV(hashtable, string2);
                    ++n;
                }
            }
            if ((vector2 = group.getParentGroupNames()) != null && vector2.size() > 0) {
                int n = 0;
                while (n < vector2.size()) {
                    String string3 = (String)vector2.elementAt(n);
                    hashtable = this.add(hashtable, string3);
                    ++n;
                }
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            // empty catch block
        }
        return hashtable;
    }

    public Hashtable getValidAliasesOfUser(String string) {
        return (Hashtable)this.addChild.get(string);
    }

    public void removeUserAliasFromMem(String string) {
        if (string != null && this.addChild.get(string) != null) {
            this.addChild.remove(string);
        }
    }

    public boolean isAliasNode(String string, String string2) {
        boolean bl = false;
        if (string == null || string2 == null || string.startsWith("/USERFOLDERPATH")) {
            return false;
        }
        Hashtable hashtable = (Hashtable)this.addChild.get(string2);
        if (hashtable != null && hashtable.size() != 0 && hashtable.containsKey(string.toUpperCase())) {
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isAliasSubNode(String var1_1, String var2_2) {
        block2: {
            var3_3 = false;
            var4_4 = var1_1;
            if (var1_1 == null || var2_2 == null || var4_4.startsWith("/USERFOLDERPATH")) {
                return false;
            }
            var5_5 = (Hashtable)this.addChild.get(var2_2);
            if (var5_5 == null || var5_5.size() == 0) break block2;
            if (!var5_5.containsKey("/")) ** GOTO lbl-1000
            return true;
            while (!(var3_3 = var5_5.containsKey((var4_4 = var4_4.substring(0, var4_4.lastIndexOf("/"))).toUpperCase()))) lbl-1000:
            // 2 sources

            {
                if (var4_4.lastIndexOf("/") > 0) continue;
            }
        }
        return var3_3;
    }

    public ResourceAlias getAlias(String string, String string2) {
        ResourceAlias resourceAlias = null;
        Hashtable hashtable = (Hashtable)this.addChild.get(string2);
        if (hashtable != null && hashtable.size() != 0) {
            if (hashtable.containsKey(string.toUpperCase())) {
                resourceAlias = (ResourceAlias)hashtable.get(string.toUpperCase());
            } else if (string.indexOf("/") > 0) {
                string = string.substring(0, string.lastIndexOf("/"));
                resourceAlias = this.getAlias(string.toUpperCase(), string2);
            }
        }
        return resourceAlias;
    }

    public ResourceAlias getParentAlias(String string, String string2) {
        if (string == null) {
            return null;
        }
        ResourceAlias resourceAlias = null;
        String string3 = string.toUpperCase();
        if (this.isAliasSubNode(string3, string2)) {
            Hashtable hashtable = (Hashtable)this.addChild.get(string2);
            while (string3.lastIndexOf("/") > 0) {
                if (!hashtable.containsKey((string3 = string3.substring(0, string3.lastIndexOf("/"))).toUpperCase())) continue;
                resourceAlias = (ResourceAlias)hashtable.get(string3.toUpperCase());
                break;
            }
            if (resourceAlias == null && hashtable.containsKey("/")) {
                resourceAlias = (ResourceAlias)hashtable.get("/");
            }
        }
        return resourceAlias;
    }

    public Vector getAliasesOfUser(String string, String string2) {
        Vector vector = null;
        try {
            if (this.QOIV.getUser(string2) != null && (this.QOIV.isAdminUser(string) || string.equalsIgnoreCase(string2))) {
                vector = this.add.getAliasesByPrincipal(string2, (byte)0);
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException.getMessage(), 3);
        }
        return vector;
    }

    public Vector getAliasesOfRole(String string, String string2) {
        Vector vector = null;
        try {
            if (this.QOIV.getRole(string2) != null && this.QOIV.isAdminUser(string)) {
                vector = this.add.getAliasesByPrincipal(string2, (byte)1);
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException.getMessage(), 3);
        }
        return vector;
    }

    public Vector getAliasesOfGroup(String string, String string2) {
        Vector vector = null;
        try {
            if (this.QOIV.getGroup(string2) != null && this.QOIV.isAdminUser(string)) {
                vector = this.add.getAliasesByPrincipal(string2, (byte)2);
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException.getMessage(), 3);
        }
        return vector;
    }

    public void deleteAliasOfUser(String string, String string2, String string3) {
        Hashtable hashtable;
        if (!this.QOIV.isAdminUser(string) && string.equalsIgnoreCase(string2)) {
            return;
        }
        boolean bl = this.add.deleteRecord(string2, (byte)0, string3);
        if (bl && (hashtable = (Hashtable)this.addChild.get(string2)) != null && hashtable.get(string3.toUpperCase()) != null) {
            hashtable.remove(string3.toUpperCase());
        }
    }

    public void deleteAllAliasesOfUser(String string, String string2) {
        if (!this.QOIV.isAdminUser(string) && string.equalsIgnoreCase(string2)) {
            return;
        }
        this.add.deleteRecord(string2, (byte)0, null);
    }

    public void deleteAliasOfRole(String string, String string2, String string3) {
        if (!this.QOIV.isAdminUser(string)) {
            return;
        }
        boolean bl = this.add.deleteRecord(string2, (byte)1, string3);
        if (bl) {
            Enumeration enumeration = this.addChild.keys();
            while (enumeration.hasMoreElements()) {
                ResourceAlias resourceAlias;
                String string4 = (String)enumeration.nextElement();
                Hashtable hashtable = (Hashtable)this.addChild.get(string4);
                if (hashtable == null || (resourceAlias = (ResourceAlias)hashtable.get(string3.toUpperCase())) == null || resourceAlias.principalType() != 1 || !resourceAlias.principalName().equalsIgnoreCase(string2)) continue;
                hashtable.remove(string3.toUpperCase());
            }
        }
    }

    public void deleteAllAliasesOfRole(String string, String string2) {
        boolean bl;
        if (!this.QOIV.isAdminUser(string)) {
            return;
        }
        Vector vector = this.add.getAliasesByPrincipal(string2, (byte)1);
        if (vector != null && vector.size() != 0 && (bl = this.add.deleteRecord(string2, (byte)1, null))) {
            Enumeration enumeration = this.addChild.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Hashtable hashtable = (Hashtable)this.addChild.get(string3);
                if (hashtable == null) continue;
                int n = 0;
                while (n < vector.size()) {
                    String string4 = ((ResourceAliasImpl)vector.elementAt(n)).aliasPath();
                    ResourceAlias resourceAlias = (ResourceAlias)hashtable.get(string4.toUpperCase());
                    if (resourceAlias != null && resourceAlias.principalType() == 1 && resourceAlias.principalName().equalsIgnoreCase(string2)) {
                        hashtable.remove(string4.toUpperCase());
                    }
                    ++n;
                }
            }
        }
    }

    public void deleteAliasOfGroup(String string, String string2, String string3) {
        if (!this.QOIV.isAdminUser(string)) {
            return;
        }
        boolean bl = this.add.deleteRecord(string2, (byte)2, string3);
        if (bl) {
            Enumeration enumeration = this.addChild.keys();
            while (enumeration.hasMoreElements()) {
                ResourceAlias resourceAlias;
                String string4 = (String)enumeration.nextElement();
                Hashtable hashtable = (Hashtable)this.addChild.get(string4);
                if (hashtable == null || (resourceAlias = (ResourceAlias)hashtable.get(string3.toUpperCase())) == null || resourceAlias.principalType() != 2 || !resourceAlias.principalName().equalsIgnoreCase(string2)) continue;
                hashtable.remove(string3.toUpperCase());
            }
        }
    }

    public void deleteAllAliasesOfGroup(String string, String string2) {
        if (!this.QOIV.isAdminUser(string)) {
            return;
        }
        Vector vector = this.add.getAliasesByPrincipal(string2, (byte)2);
        if (vector == null || vector.size() == 0) {
            return;
        }
        boolean bl = this.add.deleteRecord(string2, (byte)2, null);
        if (bl) {
            Enumeration enumeration = this.addChild.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                Hashtable hashtable = (Hashtable)this.addChild.get(string3);
                if (hashtable == null) continue;
                int n = 0;
                while (n < vector.size()) {
                    String string4 = ((ResourceAliasImpl)vector.elementAt(n)).aliasPath();
                    ResourceAlias resourceAlias = (ResourceAlias)hashtable.get(string4.toUpperCase());
                    if (resourceAlias != null && resourceAlias.principalType() == 2 && resourceAlias.principalName().equalsIgnoreCase(string2)) {
                        hashtable.remove(string4.toUpperCase());
                    }
                    ++n;
                }
            }
        }
    }

    public String setAliasForUser(String string, String string2, String string3, String string4, boolean bl) {
        int n;
        boolean bl2 = true;
        String string5 = "Setting alias for user '" + string2 + "' failed: the user '" + string2 + "' does not exist!";
        try {
            if (this.QOIV.getUser(string2) == null) {
                bl2 = false;
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            bl2 = false;
        }
        if (!bl2) {
            return string5;
        }
        if (!this.QOIV.isAdminUser(string)) {
            return "Setting alias for user '" + string2 + "' failed: the submitter '" + string + "' is not an admin user!";
        }
        String string6 = "";
        if (!string3.equalsIgnoreCase("/")) {
            n = string3.lastIndexOf("/");
            if (n == 0) {
                string6 = "/";
            } else if (n > 0) {
                string6 = string3.substring(0, n);
            }
            if (!string6.equalsIgnoreCase("/") && this.add.getRecord(string2, (byte)0, string6) == null) {
                return "Setting alias '" + string3 + "' for user '" + string2 + "' failed. The parent path '" + string6 + "' does not exist!";
            }
        }
        n = 0;
        n = this.add.getRecord(string2, (byte)0, string3) == null ? (int)(this.add.addRecord(string2, (byte)0, string3, string6, string4, bl) ? 1 : 0) : (int)(this.add.updateRecord(string2, (byte)0, string3, string6, string4, bl) ? 1 : 0);
        if (n == 0) {
            return "Setting alias '" + string3 + "' for user '" + string2 + "' error!";
        }
        Vector vector = this.contains();
        if (n != 0 && vector.contains(string2)) {
            this.aliasPath(string2, string3, string2, (byte)0, string6, string4, bl);
        }
        return null;
    }

    public String setAliasForRole(String string, String string2, String string3, String string4, boolean bl) {
        int n;
        boolean bl2 = true;
        String string5 = "Setting alias for role '" + string2 + "' failed: the role '" + string2 + "' does not exist!";
        try {
            if (this.QOIV.getRole(string2) == null) {
                bl2 = false;
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {
            bl2 = false;
        }
        if (!bl2) {
            return string5;
        }
        if (!this.QOIV.isAdminUser(string)) {
            return "Setting alias for role '" + string2 + "' failed: the submitter '" + string + "' is not an admin user!";
        }
        String string6 = "";
        if (!string3.equalsIgnoreCase("/")) {
            n = string3.lastIndexOf("/");
            if (n == 0) {
                string6 = "/";
            } else if (n > 0) {
                string6 = string3.substring(0, n);
            }
            if (!string6.equalsIgnoreCase("/") && this.add.getRecord(string2, (byte)1, string6) == null) {
                return "Setting alias '" + string3 + "' for role '" + string2 + "' failed. The parent path '" + string6 + "' does not exist!";
            }
        }
        n = 0;
        n = this.add.getRecord(string2, (byte)1, string3) == null ? (int)(this.add.addRecord(string2, (byte)1, string3, string6, string4, bl) ? 1 : 0) : (int)(this.add.updateRecord(string2, (byte)1, string3, string6, string4, bl) ? 1 : 0);
        if (n != 0) {
            Enumeration enumeration = this.contains().elements();
            Vector vector = new Vector();
            vector = this.addRecord(vector, string2);
            while (enumeration.hasMoreElements()) {
                String string7 = (String)enumeration.nextElement();
                if (vector == null || !vector.contains(string7)) continue;
                this.aliasPath(string7, string3, string2, (byte)1, string6, string4, bl);
            }
            return null;
        }
        return "Setting alias '" + string3 + "' for role '" + string2 + "' error!";
    }

    public String setAliasForGroup(String string, String string2, String string3, String string4, boolean bl) {
        int n;
        boolean bl2 = true;
        String string5 = "Setting alias for group '" + string2 + "' failed: the group '" + string2 + "' does not exist!";
        try {
            if (this.QOIV.getGroup(string2) == null) {
                bl2 = false;
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            bl2 = false;
        }
        if (!bl2) {
            return string5;
        }
        if (!this.QOIV.isAdminUser(string)) {
            return "Setting alias for group '" + string2 + "' failed: the submitter '" + string + "' is not an admin user!";
        }
        String string6 = "";
        if (!string3.equalsIgnoreCase("/")) {
            n = string3.lastIndexOf("/");
            if (n == 0) {
                string6 = "/";
            } else if (n > 0) {
                string6 = string3.substring(0, n);
            }
            if (!string6.equalsIgnoreCase("/") && this.add.getRecord(string2, (byte)2, string6) == null) {
                return "Setting alias '" + string3 + "' for group '" + string2 + "' failed. The parent path '" + string6 + "' does not exist!";
            }
        }
        n = 0;
        n = this.add.getRecord(string2, (byte)2, string3) == null ? (int)(this.add.addRecord(string2, (byte)2, string3, string6, string4, bl) ? 1 : 0) : (int)(this.add.updateRecord(string2, (byte)2, string3, string6, string4, bl) ? 1 : 0);
        if (n != 0) {
            Enumeration enumeration = this.contains().elements();
            Vector vector = new Vector();
            vector = this.addChild(vector, string2);
            while (enumeration.hasMoreElements()) {
                String string7 = (String)enumeration.nextElement();
                if (vector == null || !vector.contains(string7)) continue;
                this.aliasPath(string7, string3, string2, (byte)2, string6, string4, bl);
            }
            return null;
        }
        return "Setting alias '" + string3 + "' for group '" + string2 + "' error!";
    }

    private Vector addChild(Vector vector, String string) {
        try {
            Vector vector2;
            Vector vector3 = this.QOIV.getUsersNameByGroup(string);
            if (vector3 != null && vector3.size() > 0) {
                int n = 0;
                while (n < vector3.size()) {
                    String string2 = (String)vector3.elementAt(n);
                    if (!vector.contains(string2)) {
                        vector.add(string2);
                    }
                    ++n;
                }
            }
            if ((vector2 = this.QOIV.getGroup(string).getSubGroupNames()) != null && vector2.size() > 0) {
                int n = 0;
                while (n < vector2.size()) {
                    String string3 = (String)vector2.elementAt(n);
                    vector = this.addChild(vector, string3);
                    ++n;
                }
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            // empty catch block
        }
        return vector;
    }

    private Vector addRecord(Vector vector, String string) {
        try {
            Vector vector2;
            Vector vector3 = this.QOIV.getUsersNameByRole(string);
            if (vector3 != null && vector3.size() > 0) {
                int n = 0;
                while (n < vector3.size()) {
                    String string2 = (String)vector3.elementAt(n);
                    if (!vector.contains(string2)) {
                        vector.add(string2);
                    }
                    ++n;
                }
            }
            if ((vector2 = this.QOIV.getRole(string).getSubRoleNames()) != null && vector2.size() > 0) {
                int n = 0;
                while (n < vector2.size()) {
                    String string3 = (String)vector2.elementAt(n);
                    vector = this.addRecord(vector, string3);
                    ++n;
                }
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {
            // empty catch block
        }
        return vector;
    }

    private void aliasPath(String string, String string2, String string3, byte by, String string4, String string5, boolean bl) {
        Hashtable<String, ResourceAliasImpl> hashtable = (Hashtable<String, ResourceAliasImpl>)this.addChild.get(string);
        if (hashtable != null) {
            if (hashtable.get(string2.toUpperCase()) != null) {
                hashtable.remove(string2.toUpperCase());
            }
        } else {
            hashtable = new Hashtable<String, ResourceAliasImpl>();
            this.addChild.put(string, hashtable);
        }
        hashtable.put(string2.toUpperCase(), new ResourceAliasImpl(string3, by, string2, string4, string5, bl));
    }

    public boolean hasAliasOfUser(String string, String string2) {
        int n = 0;
        try {
            if (this.QOIV.getUser(string2) != null && (this.QOIV.isAdminUser(string) || string.equalsIgnoreCase(string2))) {
                n = this.add.getAliasCount(string2, (byte)0);
            }
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException.getMessage(), 3);
        }
        return n > 0;
    }

    public boolean hasAliasOfRole(String string, String string2) {
        int n = 0;
        try {
            if (this.QOIV.getRole(string2) != null && this.QOIV.isAdminUser(string)) {
                n = this.add.getAliasCount(string2, (byte)1);
            }
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException.getMessage(), 3);
        }
        return n > 0;
    }

    public boolean hasAliasOfGroup(String string, String string2) {
        int n = 0;
        try {
            if (this.QOIV.getGroup(string2) != null && this.QOIV.isAdminUser(string)) {
                n = this.add.getAliasCount(string2, (byte)2);
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException.getMessage(), 3);
        }
        return n > 0;
    }

    public Vector allAssignedUsers(String string) {
        if (!this.QOIV.isAdminUser(string)) {
            return null;
        }
        return this.add.getAssignedAliasUsers();
    }

    public Vector allAssignedRoles(String string) {
        if (!this.QOIV.isAdminUser(string)) {
            return null;
        }
        return this.add.getAssignedAliasRoles();
    }

    public Vector allAssignedGroups(String string) {
        if (!this.QOIV.isAdminUser(string)) {
            return null;
        }
        return this.add.getAssignedAliasGroups();
    }

    public boolean hiddenSubaliasUser(String string, String string2, String string3) {
        if (!this.QOIV.isAdminUser(string) && !string.equalsIgnoreCase(string2)) {
            return false;
        }
        return this.add.hiddenSubalias(string2, (byte)0, string3);
    }

    public boolean hiddenSubaliasRole(String string, String string2, String string3) {
        if (!this.QOIV.isAdminUser(string) && !this.QOIV.getAllRolesName().contains(string2)) {
            return false;
        }
        return this.add.hiddenSubalias(string2, (byte)1, string3);
    }

    public boolean hiddenSubaliasGroup(String string, String string2, String string3) {
        if (!this.QOIV.isAdminUser(string) && !this.QOIV.getAllGroupsName().contains(string2)) {
            return false;
        }
        return this.add.hiddenSubalias(string2, (byte)2, string3);
    }

    public String refreshAliasOfUser(String string, String string2) {
        if (!this.QOIV.isAdminUser(string) && !string.equalsIgnoreCase(string2)) {
            return null;
        }
        Vector vector = this.add.getAliasesByPrincipal(string2, (byte)0);
        return null;
    }

    public String refreshAliasOfRole(String string, String string2) {
        if (!this.QOIV.isAdminUser(string) && !this.QOIV.getAllRolesName().contains(string2)) {
            return null;
        }
        Vector vector = this.add.getAliasesByPrincipal(string2, (byte)1);
        return null;
    }

    public String refreshAliasOfGroup(String string, String string2) {
        if (!this.QOIV.isAdminUser(string) && !this.QOIV.getAllGroupsName().contains(string2)) {
            return null;
        }
        Vector vector = this.add.getAliasesByPrincipal(string2, (byte)2);
        return null;
    }

    public Vector getSubAliases(String string, String string2) {
        Vector<ResourceAlias> vector = null;
        Hashtable hashtable = (Hashtable)this.addChild.get(string2);
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            vector = new Vector<ResourceAlias>();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                ResourceAlias resourceAlias = (ResourceAlias)hashtable.get(string3);
                String string4 = resourceAlias.aliasPath();
                if (string4.lastIndexOf("/") > 0) {
                    if (!string.equalsIgnoreCase(string4 = string4.substring(0, string4.lastIndexOf("/")))) continue;
                    vector.add(resourceAlias);
                    continue;
                }
                if (!string.equals("/") || resourceAlias.aliasPath().equalsIgnoreCase("/")) continue;
                vector.add(resourceAlias);
            }
        }
        return vector;
    }

    public String getAliasName(ResourceAlias resourceAlias) {
        String string = "";
        string = resourceAlias.aliasPath();
        if (string.equalsIgnoreCase("/")) {
            string = string.substring(string.lastIndexOf("/"));
        }
        return string;
    }

    public static String contentPath(String string, String string2) {
        String string3 = string;
        if (string.equalsIgnoreCase("/")) {
            string3 = "";
        } else if (string3.endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string3 + string2;
    }

    public AliasTree getAliasTreeByPrincipal(String string, byte by, Hashtable hashtable, String string2) {
        Object object;
        String string3 = "";
        AliasTree aliasTree = null;
        ResourceAlias resourceAlias = null;
        boolean bl = true;
        if (by == 1) {
            try {
                if (this.QOIV.getRole(string) == null || !this.QOIV.isAdminUser(string2)) {
                    bl = false;
                }
            }
            catch (NoSuchRoleException noSuchRoleException) {
                ServiceLogger.logError(noSuchRoleException.getMessage(), 3);
                bl = false;
            }
            string3 = "alias_role_" + string;
        } else if (by == 2) {
            try {
                if (this.QOIV.getGroup(string) == null || !this.QOIV.isAdminUser(string2)) {
                    bl = false;
                }
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logError(noSuchGroupException.getMessage(), 3);
                bl = false;
            }
            string3 = "alias_group_" + string;
        } else if (by == 0) {
            try {
                if (this.QOIV.getUser(string) == null || !this.QOIV.isAdminUser(string2) && !string2.equalsIgnoreCase(string)) {
                    bl = false;
                }
            }
            catch (NoSuchUserException noSuchUserException) {
                ServiceLogger.logError(noSuchUserException.getMessage(), 3);
                bl = false;
            }
            string3 = "alias_user_" + string;
        }
        if (!bl) {
            return null;
        }
        resourceAlias = this.add.getRecord(string, by, "/");
        if (resourceAlias != null) {
            object = String.valueOf(((Node)hashtable.get(resourceAlias.resourcePath().toUpperCase())).getNodeType());
            aliasTree = new AliasTree(string3, string3, resourceAlias.aliasPath(), resourceAlias.aliasPath(), resourceAlias.resourcePath(), (String)object, String.valueOf(resourceAlias.hidden()));
        } else {
            resourceAlias = new ResourceAliasImpl(string, by, "/", "", "", false);
            aliasTree = new AliasTree(string3, string3, "/", "/", "", String.valueOf(1), "");
        }
        object = aliasTree.getRoot();
        this.append(resourceAlias, (AliasNode)object, string, by, hashtable);
        return aliasTree;
    }

    private void append(ResourceAlias resourceAlias, AliasNode aliasNode, String string, byte by, Hashtable hashtable) {
        String string2 = resourceAlias.aliasPath();
        Vector vector = this.add.getAliasOfPrincipalByParent(string, by, string2);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                ResourceAlias resourceAlias2 = (ResourceAlias)vector.elementAt(n);
                String string3 = resourceAlias2.resourcePath();
                byte by2 = 1;
                if (string3 != null && string3.length() > 0) {
                    try {
                        by2 = ((Node)hashtable.get(string3.toUpperCase())).getNodeType();
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception.getMessage(), 3);
                    }
                }
                String string4 = CSUtil.getLogicalFolderAndName(resourceAlias2.aliasPath())[1];
                AliasNode aliasNode2 = aliasNode.addChild(resourceAlias2.aliasPath(), string4, resourceAlias2.resourcePath(), String.valueOf(by2), String.valueOf(resourceAlias2.hidden()));
                if (by2 == 1) {
                    this.append(resourceAlias2, aliasNode2, string, by, hashtable);
                }
                ++n;
            }
        }
    }

    public synchronized void upgradeAbsolutePathForAlias(String string, String string2) {
        String string3 = string.toUpperCase();
        String string4 = string2.toUpperCase();
        this.add.updateResource(string, string2);
        Enumeration enumeration = this.addChild.keys();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            Hashtable hashtable = (Hashtable)this.addChild.get(string5);
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                String string6 = (String)enumeration2.nextElement();
                ResourceAlias resourceAlias = (ResourceAlias)hashtable.get(string6);
                String string7 = resourceAlias.resourcePath();
                if (!string7.startsWith(string3)) continue;
                if (string7.equalsIgnoreCase(string3)) {
                    hashtable.remove(string6);
                    ((ResourceAliasImpl)resourceAlias).setResourcePath(string4);
                    hashtable.put(string6, resourceAlias);
                    continue;
                }
                hashtable.remove(string6);
                ((ResourceAliasImpl)resourceAlias).setResourcePath(string4 + string7.substring(string3.length()));
                hashtable.put(string6, resourceAlias);
            }
        }
    }

    public synchronized void upgradeAliasPath(String string, String string2, String string3) throws NoPrivilegeException {
        Hashtable hashtable = (Hashtable)this.addChild.get(string3);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string4;
            String string5 = (String)enumeration.nextElement();
            ResourceAlias resourceAlias = (ResourceAlias)hashtable.get(string5);
            String string6 = resourceAlias.aliasPath();
            if (!string6.startsWith(string)) continue;
            String string7 = "";
            string7 = string6.equalsIgnoreCase(string) ? string2 : string2 + string6.substring(string.length());
            if (resourceAlias.principalType() == 0 || this.QOIV.isAdminUser(string3)) {
                this.add.deleteRecord(resourceAlias.principalName(), resourceAlias.principalType(), resourceAlias.aliasPath());
                string4 = "";
                if (!string7.equalsIgnoreCase("/")) {
                    int n = string7.lastIndexOf("/");
                    string4 = n == 0 ? "/" : string7.substring(0, n);
                }
            } else {
                throw new NoPrivilegeException(630013, (Object[])new String[]{string3, string}, null);
            }
            this.add.addRecord(resourceAlias.principalName(), resourceAlias.principalType(), string7, string4, resourceAlias.resourcePath(), resourceAlias.hidden());
            ((ResourceAliasImpl)resourceAlias).setAliasPath(string7);
            hashtable.remove(string5);
            hashtable.put(string7.toUpperCase(), resourceAlias);
        }
    }

    private Vector contains() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = HttpUtil.getHttpRptServer().getUserSessionManager().getAllUserSessions();
        while (enumeration.hasMoreElements()) {
            UserSession userSession = (UserSession)enumeration.nextElement();
            String string = userSession.getUserID();
            if (vector.contains(string)) continue;
            vector.add(userSession.getUserID());
        }
        return vector;
    }
}

