/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import com.jinfonet.report.convert.Converter;
import com.jinfonet.report.convert.ConverterFactory;
import java.io.File;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.cs.jacl.JPermissionImpl;
import jet.jetc.JetRptReportIOException;
import jet.jetc.ReadFailureException;
import jet.jetc.WriteFailureException;
import jet.server.ServerEnv;
import jet.server.api.ResultVersionRecord;
import jet.server.api.admin.ResourceAlias;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.NodeExistsException;
import jet.server.api.exception.UnknownResource;
import jet.server.db.resource.DynamicNodeRecord;
import jet.server.db.resource.DynamicNodeTable;
import jet.server.db.resource.FolderRecord;
import jet.server.db.resource.FolderTable;
import jet.server.db.resource.NodeRecord;
import jet.server.db.resource.NodeTable;
import jet.server.db.resource.ResourceMapRecord;
import jet.server.db.resource.ResourceMapTable;
import jet.server.db.resource.ResourceNodeRecord;
import jet.server.db.resource.ResourceNodeTable;
import jet.server.db.resource.VersionNodeRecord;
import jet.server.db.resource.VersionNodeTable;
import jet.server.intf.jrs.VersionService;
import jet.server.intf.resource.CatalogInfo;
import jet.server.intf.resource.Folder;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.ReportInfo;
import jet.server.intf.resource.Resource;
import jet.server.intf.resource.ResourceInfo;
import jet.server.intf.resource.ResourceTreeManager;
import jet.server.intf.resource.ResultInfo;
import jet.server.intf.resource.Version;
import jet.server.intf.security.SecurityService;
import jet.server.intf.security.User;
import jet.server.intf.security.UserFolderListener;
import jet.server.jrc.JRDataService;
import jet.server.jrc.JRSchedulingService;
import jet.server.jrc.JRVersionService;
import jet.server.jrc.resource.CatalogInfoImpl;
import jet.server.jrc.resource.FolderImpl;
import jet.server.jrc.resource.NodeImpl;
import jet.server.jrc.resource.ReportInfoImpl;
import jet.server.jrc.resource.ResourceAliasManagerImpl;
import jet.server.jrc.resource.ResourceImpl;
import jet.server.jrc.resource.ResourceInfoImpl;
import jet.server.jrc.resource.ResourceToolkit;
import jet.server.jrc.resource.ResultInfoImpl;
import jet.server.jrc.resource.ResultVersionRecordImpl;
import jet.server.jrc.resource.VersionImpl;
import jet.server.jrc.security.AclExistException;
import jet.server.jrc.security.PermissionSet;
import jet.server.jrc.security.ResourceProtector;
import jet.server.log.ServiceLogger;
import jet.server.schedule.JRResultFiles;
import jet.server.util.ServerUtil;
import jet.server.util.ui.AliasTree;
import jet.server.util.ui.UINode;
import jet.server.util.ui.UITree;
import jet.universe.exception.FMLFileException;
import jet.universe.exception.UniverseFileException;
import jet.upgrade.JUpgradeNotSupportedException;
import jet.util.IntKeyHashtable;
import jet.util.IntVector;

public class ResourceTreeManagerImpl
implements ResourceTreeManager,
UserFolderListener,
Runnable {
    private Object C = new Object();
    private VersionService DELETE;
    private SecurityService GRANT;
    private ResourceProtector QOIV = null;
    private ResourceAliasManagerImpl READ = null;
    public NodeTable nodeTable = null;
    private DynamicNodeTable VISIBLE = null;
    private ResourceMapTable WRITE = null;
    private FolderTable add = null;
    private ResourceNodeTable addChild = null;
    public VersionNodeTable versionNodeTable = null;
    public IntKeyHashtable tree;
    private Hashtable addElement;
    private Folder addPermission;
    private Thread addRecord = null;
    private boolean addSubFolder = false;

    public ResourceTreeManagerImpl(JRDataService jRDataService, VersionService versionService, SecurityService securityService, String string) {
        this.DELETE = versionService;
        this.tree = new IntKeyHashtable(400);
        this.addElement = new Hashtable(400);
        this.GRANT = securityService;
        this.READ = new ResourceAliasManagerImpl(jRDataService, securityService);
        this.nodeTable = jRDataService.getNodeTable();
        this.VISIBLE = jRDataService.getDynamicNodeTable();
        this.WRITE = jRDataService.getResourceMapTable();
        this.add = jRDataService.getFolderTable();
        this.addChild = jRDataService.getResourceNodeTable();
        this.versionNodeTable = jRDataService.getVersionNodeTable();
        this.QOIV = new ResourceProtector(string);
        securityService.addUserFolderListener(this);
    }

    public SecurityService getSecurityService() {
        return this.GRANT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Folder addSubFolder(Folder folder, Hashtable hashtable, String string) throws NoPrivilegeException, NodeExistsException {
        Folder folder2;
        File file;
        User user;
        block26: {
            ServiceLogger.logDebug(6620004, 6);
            ServiceLogger.logDebug(6620011, new Object[]{folder == null ? "" : folder.getAbsolutePath(), hashtable, string}, 6);
            if (folder != null && folder.isDynamic()) {
                throw new NoPrivilegeException(620010, new Object[]{folder.getAbsolutePath()}, null);
            }
            if (CSUtil.getBoolean((String)hashtable.get("jrs.node_no_real_path"), false)) {
                hashtable.remove("jrs.node_real_path");
            }
            user = null;
            try {
                user = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block26;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        String string2 = (String)hashtable.get("jrs.node_name");
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (!(folder == null || string2 != null && string2.trim().length() != 0 && CSUtil.isValidNodeName(string2))) {
            ServiceLogger.logError(JSvrResource.getMessage("RSC_ERROR4", string2), 3);
            return null;
        }
        if (folder != null) {
            if (folder.hasChild(string2)) {
                if (folder.getChild(string2).getNodeType() != 1) {
                    throw new NodeExistsException(620001, new Object[]{string2, folder.getAbsolutePath()}, null);
                }
                this.setNodeProperties(folder.getChild(string2), hashtable, (Hashtable[])hashtable.remove("jrs.permission_values"), string);
                return (Folder)folder.getChild(string2);
            }
            if (!this.checkPermission(folder, user, (Permission)JPermissionImpl.WRITE)) {
                throw new NoPrivilegeException(620008, new Object[]{string, JPermissionImpl.WRITE, folder.getAbsolutePath()}, null);
            }
            if (folder.isFakeFolder()) {
                folder = this.upgradeFakeFolder(folder);
            }
        }
        String string3 = (String)hashtable.get("jrs.node_desc");
        boolean bl = CSUtil.getBoolean((String)hashtable.get("jrs.enable.linked.catalog"), false);
        String string4 = (String)hashtable.get("jrs.linked.catalog");
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.is.use.inherited"), false);
        String string5 = (String)hashtable.get("jrs.owner_name");
        if (folder != null && (string5 == null || string5.length() == 0)) {
            string5 = folder.getOwnerName();
        }
        String string6 = (String)hashtable.get("jrs.node_real_path");
        boolean bl3 = CSUtil.getBoolean((String)hashtable.get("createOnly"), true);
        if (!(bl3 || string6 == null || string6.length() == 0 || (file = new File(string6)).exists() && file.isDirectory())) {
            return null;
        }
        boolean bl4 = CSUtil.getBoolean((String)hashtable.get("jrs.enable_archive_policy"), false);
        int n = 0;
        boolean bl5 = true;
        if (bl4 && (bl5 = CSUtil.getBoolean((String)hashtable.get("jrs.archive_new_version"), true))) {
            n = CSUtil.parseInt((String)hashtable.get("jrs.maxversion"), 0);
        }
        boolean bl6 = CSUtil.getBoolean((String)hashtable.get("jrs.node_share"), false);
        boolean bl7 = CSUtil.getBoolean((String)hashtable.get("jrs.enable_dynamic_resource"), false);
        Hashtable[] hashtableArray = (Hashtable[])hashtable.get("jrs.permission_values");
        String string7 = folder == null ? "/" : (folder.isRoot() ? folder.getAbsolutePath() : folder.getAbsolutePath() + "/") + string2;
        int n2 = -1;
        boolean bl8 = CSUtil.getBoolean((String)hashtable.get("jrs.ignore_permissions"), false);
        if (!bl8) {
            n2 = this.setPermissions(new FolderImpl(string7), string, hashtableArray);
        }
        String string8 = (String)hashtable.get("jrs.profile");
        Object object = this.C;
        synchronized (object) {
            if (folder == null || folder.getChild(string2) == null) {
                FolderRecord folderRecord = this.add.addRecord(string2, string, new Date(), folder == null ? -1 : folder.getID(), n2, string3, string6, string5, n, bl5, bl4, bl6, bl7, bl, string4, bl2);
                folder2 = new FolderImpl(folderRecord);
                if (folder != null) {
                    FolderImpl folderImpl = (FolderImpl)folder;
                    ((FolderImpl)folder2).setParent(folderImpl);
                    folderImpl.addChild(folder2);
                } else {
                    ((FolderImpl)folder2).setParent(folder2);
                }
                this.tree.put(folderRecord.getID(), (Object)folder2);
                this.addElement.put(this.clearPermissions(folder2.getAbsolutePath()), folder2);
            } else {
                Node node = folder.getChild(string2);
                if (node.getNodeType() == 1) {
                    folder2 = (Folder)node;
                } else {
                    throw new NodeExistsException(620001, new Object[]{string2, folder.getAbsolutePath()}, null);
                }
            }
        }
        if (folder == null) {
            ServiceLogger.logEvent(6620012, string, 5);
        } else {
            ServiceLogger.logEvent(6620013, new Object[]{string, folder2.getName(), folder.getAbsolutePath()}, 5);
        }
        return folder2;
    }

    public Folder upgradeFakeFolder(Folder folder) {
        if (!folder.isFakeFolder()) {
            return folder;
        }
        FolderRecord folderRecord = this.add.addRecord(folder.getName(), "JReport_System_User", new Date(), folder.getParent().getID(), -1, null, null, folder.getOwnerName(), 0, true, false, false, false, false, null, false);
        FolderImpl folderImpl = new FolderImpl(folderRecord);
        FolderImpl folderImpl2 = (FolderImpl)folder.getParent();
        folderImpl.setParent(folderImpl2);
        folderImpl2.addChild(folderImpl);
        this.tree.put(folderRecord.getID(), (Object)folderImpl);
        this.addElement.put(this.clearPermissions(folderImpl.getAbsolutePath()), folderImpl);
        folder.remove();
        return folderImpl;
    }

    public Version addResource(Folder folder, Hashtable hashtable, ResourceInfo resourceInfo, String string) throws NoPrivilegeException, NodeExistsException {
        String string2;
        Object object;
        String string3;
        byte by;
        User user;
        block29: {
            ServiceLogger.logDebug(6620005, 6);
            ServiceLogger.logDebug(6620011, new Object[]{folder.getAbsolutePath(), hashtable, string}, 6);
            if (folder.isDynamic()) {
                throw new NoPrivilegeException(620010, new Object[]{folder.getAbsolutePath()}, null);
            }
            user = null;
            try {
                user = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block29;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        String string4 = (String)hashtable.get("jrs.node_name");
        if (string4 != null) {
            string4 = string4.trim();
        }
        String string5 = (String)hashtable.get("jrs.node_desc");
        boolean bl = CSUtil.getBoolean((String)hashtable.get("jrs.enable.linked.catalog"), false);
        String string6 = (String)hashtable.get("jrs.linked.catalog");
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.is.use.inherited"), false);
        byte by2 = (byte)CSUtil.parseInt((String)hashtable.get("jrs.node_type"), -1);
        switch (by2) {
            case 2: {
                by = 1;
                break;
            }
            case 0: {
                by = 2;
                break;
            }
            case 1: {
                by = 3;
                ResultInfo resultInfo = (ResultInfo)resourceInfo;
                if (resultInfo.getCatalogResourceId() == -1 && (string3 = (String)hashtable.get("jrs.catalog")) != null && string3.length() != 0) {
                    resultInfo.setCatalogReourceId(this.getDynamicResourceID(string3, (byte)2));
                }
                if (resultInfo.getReportResourceId() != -1 || (string3 = (String)hashtable.get("jrs.report")) == null || string3.length() == 0) break;
                resultInfo.setReportResourceId(this.getDynamicResourceID(string3, (byte)1));
                break;
            }
            default: {
                ServiceLogger.logError(204806, string4, 6);
                return null;
            }
        }
        string3 = (String)hashtable.get("jrs.node_real_path");
        boolean bl3 = CSUtil.getBoolean((String)hashtable.get("jrs.enable_archive_policy"), false);
        int n = 0;
        boolean bl4 = true;
        if (bl3 && (bl4 = CSUtil.getBoolean((String)hashtable.get("jrs.archive_new_version"), true))) {
            n = CSUtil.parseInt((String)hashtable.get("jrs.maxversion"), 0);
        }
        Hashtable[] hashtableArray = (Hashtable[])hashtable.get("jrs.permission_values");
        ResourceImpl resourceImpl = null;
        boolean bl5 = false;
        if (folder.hasChild(string4)) {
            object = folder.getChild(string4);
            if (object.getNodeType() != 2 || ((Resource)object).getResourceType() != by) {
                throw new NodeExistsException(620001, new Object[]{string4, folder.getAbsolutePath()}, null);
            }
            if (!this.checkPermission((Node)object, user, (Permission)JPermissionImpl.WRITE)) {
                throw new NoPrivilegeException(630014, (Object[])new String[]{string, object.getAbsolutePath()}, null);
            }
            resourceImpl = (ResourceImpl)object;
        } else {
            if (!this.checkPermission(folder, user, (Permission)JPermissionImpl.WRITE)) {
                throw new NoPrivilegeException(630015, (Object[])new String[]{string, folder.getAbsolutePath()}, null);
            }
            if (folder.isFakeFolder()) {
                folder = this.upgradeFakeFolder(folder);
            }
            object = (folder.isRoot() ? folder.getAbsolutePath() : folder.getAbsolutePath() + "/") + string4;
            int n2 = -1;
            boolean bl6 = CSUtil.getBoolean((String)hashtable.get("jrs.ignore_permissions"), false);
            if (!bl6) {
                n2 = this.setPermissions(new ResourceImpl((String)object), string, hashtableArray);
            }
            string2 = (String)hashtable.get("jrs.profile");
            ResourceNodeRecord resourceNodeRecord = this.addChild.addRecord(string4, string, new Date(), folder.getID(), n2, string5, by, string3, n, bl4, bl3, bl, string6, bl2, string2);
            resourceImpl = new ResourceImpl(resourceNodeRecord);
            resourceImpl.setAbsolutePath((String)object);
            bl5 = true;
        }
        object = null;
        if (!bl5) {
            object = bl3 ? (bl4 ? this.addVersion(resourceImpl, resourceInfo, string, hashtableArray, string5) : this.replaceVersion(resourceImpl, resourceInfo, string, hashtableArray, string5)) : (this.DELETE(resourceImpl) ? this.addVersion(resourceImpl, resourceInfo, string, hashtableArray, string5) : this.replaceVersion(resourceImpl, resourceInfo, string, hashtableArray, string5));
            String string7 = object.getDescription();
            String string8 = resourceImpl.getDescription();
            if (!(string7 == null || string7.trim().length() == 0 || string8 != null && string8.trim().length() != 0 && string7.equals(string8))) {
                resourceImpl.setDescription(string7);
                this.nodeTable.updateDescription(resourceImpl.getID(), string7);
            }
            if (resourceImpl.setDefaultLinkedCatalogProps(hashtable)) {
                this.nodeTable.updateLinkedCatalogProps(resourceImpl.getID(), resourceImpl.isEnableLinkedCatalog(), resourceImpl.getLinkedCatalog(), resourceImpl.isUseInherited());
            }
        } else {
            object = this.addVersion(resourceImpl, resourceInfo, string, hashtableArray, string5);
        }
        int n3 = resourceImpl.getID();
        if (object != null) {
            resourceImpl.setEntity(resourceInfo);
            this.tree.put(n3, (Object)resourceImpl);
            FolderImpl folderImpl = (FolderImpl)folder;
            resourceImpl.setParent(folderImpl);
            this.addElement.put(this.clearPermissions(resourceImpl.getAbsolutePath()), resourceImpl);
            folderImpl.addChild(resourceImpl);
            if (!bl3) {
                n = this.GRANT(resourceImpl);
            } else if (resourceImpl.setProperties(hashtable)) {
                if (!bl5) {
                    string3 = resourceImpl.getRealDir();
                }
                string2 = (String)hashtable.get("jrs.profile");
                this.addChild.updateAll(resourceImpl.getID(), string3, n, bl4, bl3, string2);
            }
            this.setMaxVersionAmount(resourceImpl, n);
            ServiceLogger.logEvent(6620014, new Object[]{string, resourceImpl.getName(), folder.getAbsolutePath(), String.valueOf(object.getVersionNumber())}, 5);
        } else if (bl5) {
            resourceImpl = null;
            this.addChild.deleteRecord(n3);
            this.nodeTable.deleteRecord(n3);
        }
        return object;
    }

    public synchronized Resource addResult(Resource resource, int n, String string) throws NoPrivilegeException {
        User user;
        block5: {
            ServiceLogger.logDebug(6620015, new Object[]{resource.getAbsolutePath(), String.valueOf(n), string}, 6);
            user = null;
            try {
                user = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block5;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        if (!this.checkPermission(resource, user, (Permission)JPermissionImpl.WRITE)) {
            throw new NoPrivilegeException(630017, (Object[])new String[]{string, resource.getAbsolutePath()}, null);
        }
        ResourceImpl resourceImpl = (ResourceImpl)resource.getResult();
        if (resourceImpl == null) {
            ResourceNodeRecord resourceNodeRecord = this.addChild.addRecord("result", string, new Date(), resource.getID(), -1, null, (byte)3, null, n, false, false, false, null, false, null);
            resourceImpl = new ResourceImpl(resourceNodeRecord);
            ((ResourceImpl)resource).setResult(resourceImpl);
            resourceImpl.setParent(resource);
            this.tree.put(resourceImpl.getID(), (Object)resourceImpl);
            this.addElement.put(this.clearPermissions(resourceImpl.getAbsolutePath()), resourceImpl);
        } else {
            this.setMaxVersionAmount(resourceImpl, n);
        }
        ServiceLogger.logEvent(6620016, new Object[]{string, resource.getAbsolutePath()}, 5);
        return resourceImpl;
    }

    public synchronized Version addResult(Resource resource, Hashtable hashtable, ResourceInfo resourceInfo, String string) throws NoPrivilegeException {
        int n;
        int n2;
        Object object;
        User user;
        block15: {
            ServiceLogger.logDebug(6620017, new Object[]{resource.getAbsolutePath(), hashtable, string}, 6);
            user = null;
            try {
                user = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block15;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        if (!this.checkPermission(resource, user, (Permission)JPermissionImpl.WRITE)) {
            throw new NoPrivilegeException(630016, (Object[])new String[]{string, resource.getAbsolutePath()}, null);
        }
        String string2 = (String)hashtable.get("jrs.node_desc");
        ResourceImpl resourceImpl = (ResourceImpl)resource.getResult();
        if (resource.isDynamic()) {
            object = (String)hashtable.get("jrs.report");
            if (!this.addElement.containsKey(this.clearPermissions((String)object))) {
                n2 = this.getDynamicResourceID((String)object, (byte)1);
                ((ResultInfo)resourceInfo).setReportResourceId(n2);
                ((ResultInfo)resourceInfo).setReportVerNum(1);
            }
            if ((object = (String)hashtable.get("jrs.catalog")) == null || !this.addElement.containsKey(this.clearPermissions((String)object))) {
                n2 = this.getDynamicResourceID((String)object, (byte)2);
                ((ResultInfo)resourceInfo).setCatalogReourceId(n2);
                ((ResultInfo)resourceInfo).setCatalogVerNum(1);
            } else {
                n2 = ((Node)this.addElement.get(this.clearPermissions((String)object))).getID();
            }
            ((ResultInfo)resourceInfo).setName(resource.getAbsolutePath());
            int n3 = this.VISIBLE.getMaxVersionAmount(resource.getAbsolutePath());
            ResourceNodeRecord resourceNodeRecord = new ResourceNodeRecord(-1, resource.getName(), string, new Date(System.currentTimeMillis()), -1, -1, "result of report from real path", 3, "", n3, true, true, false, null, false);
            resourceNodeRecord.setIsDynamic(true);
            resourceImpl = new ResourceImpl(resourceNodeRecord);
            resourceImpl.setAbsolutePath(resource.getAbsolutePath());
        }
        try {
            n = Integer.parseInt((String)hashtable.get("jrs.maxversion"));
        }
        catch (NumberFormatException numberFormatException) {
            n = resourceImpl != null ? resourceImpl.getMaxVersionAmount() : 0;
        }
        if (resourceImpl == null && !resource.isDynamic()) {
            object = this.addChild.addRecord("result", string, new Date(), resource.getID(), -1, string2, (byte)3, null, n, false, false, false, null, false, null);
            resourceImpl = new ResourceImpl((ResourceNodeRecord)object);
        }
        object = null;
        object = this.addVersion(resourceImpl, resourceInfo, string, null, string2);
        n2 = resourceImpl.getID();
        if (object != null) {
            resourceImpl.setEntity(resourceInfo);
            if (resource.getResult() == null) {
                resource.setResult(resourceImpl);
                resourceImpl.setParent(resource);
                if (!resource.isDynamic()) {
                    this.tree.put(n2, (Object)resourceImpl);
                    this.addElement.put(this.clearPermissions(resourceImpl.getAbsolutePath()), resourceImpl);
                }
            }
            if (resource.isDynamic()) {
                this.setDynamicResultMaxVersionAmount(resource, n);
            } else {
                this.setMaxVersionAmount(resourceImpl, n);
            }
            ServiceLogger.logEvent(6620018, new Object[]{string, resource.getAbsolutePath(), String.valueOf(object.getVersionNumber())}, 5);
            return object;
        }
        this.addChild.deleteRecord(n2);
        this.nodeTable.deleteRecord(n2);
        return null;
    }

    private int C(Resource resource) {
        return this.versionNodeTable.getLatestVersionID(resource.getID());
    }

    private boolean DELETE(Node node) {
        if (node.getNodeType() == 1) {
            Folder folder = (Folder)node;
            if (folder.isEnableArchivePolicy() || folder.isRoot()) {
                return folder.isArchiveNewVersion();
            }
            return this.DELETE(folder.getParent());
        }
        if (node.getNodeType() == 2) {
            Resource resource = (Resource)node;
            if (resource.isEnableArchivePolicy()) {
                return resource.isArchiveNewVersion();
            }
            return this.DELETE(resource.getParent());
        }
        return true;
    }

    private int GRANT(Node node) {
        if (node.getNodeType() == 1) {
            Folder folder = (Folder)node;
            if (folder.isEnableArchivePolicy() || folder.isRoot()) {
                return folder.getMaxVersionAmount();
            }
            return this.GRANT(folder.getParent());
        }
        if (node.getNodeType() == 2) {
            Resource resource = (Resource)node;
            if (resource.isEnableArchivePolicy()) {
                return resource.getMaxVersionAmount();
            }
            return this.GRANT(resource.getParent());
        }
        return 0;
    }

    public synchronized Version replaceVersion(Resource resource, ResourceInfo resourceInfo, String string, Hashtable[] hashtableArray, String string2) {
        VersionNodeRecord versionNodeRecord;
        Version version;
        int n = this.C(resource);
        String string3 = "replaced";
        if (n == -1) {
            return this.addVersion(resource, resourceInfo, string, hashtableArray, string2);
        }
        this.DELETE.updateVersion(resourceInfo, resource.getID(), resource.getLatestVersionNumber(), string);
        long l = resourceInfo.getResourceType() == 3 && ((ResultInfo)resourceInfo).getExpire() ? ((ResultInfo)resourceInfo).getExpireationTime().getTime() : Long.MAX_VALUE;
        resourceInfo.setVersionNumber(resource.getLatestVersionNumber());
        try {
            version = this.getVersion(resource.getAbsolutePath(), resource.getLatestVersionNumber(), false, string);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource, 6);
            version = null;
        }
        int n2 = this.setPermissions(version, string, hashtableArray);
        if (this.nodeTable.updateForReplace(n, string3, string, new Date(), n2)) {
            this.versionNodeTable.updateExpirationTime(n, l);
        }
        try {
            versionNodeRecord = this.versionNodeTable.getRecord(n);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException, 6);
            return null;
        }
        if (versionNodeRecord == null) {
            return null;
        }
        VersionImpl versionImpl = new VersionImpl(versionNodeRecord);
        versionImpl.setDescription(string2);
        versionImpl.setEntity(resourceInfo);
        versionImpl.setParent(resource);
        return versionImpl;
    }

    public synchronized Version addVersion(Resource resource, ResourceInfo resourceInfo, String string, Hashtable[] hashtableArray, String string2) {
        int n = this.DELETE.addVersion(resourceInfo, resource.getID(), string);
        String string3 = String.valueOf(n);
        int n2 = resource.getID();
        if (n != -1) {
            int n3 = this.setPermissions(new VersionImpl(resource.getAbsolutePath(), n), string, hashtableArray);
            long l = resourceInfo.getResourceType() == 3 && ((ResultInfo)resourceInfo).getExpire() ? ((ResultInfo)resourceInfo).getExpireationTime().getTime() : Long.MAX_VALUE;
            resourceInfo.setVersionNumber(n);
            long l2 = resourceInfo.getCreatedTime();
            Date date = l2 == 0L ? new Date() : new Date(l2);
            VersionNodeRecord versionNodeRecord = null;
            if (!resource.isDynamic()) {
                versionNodeRecord = this.versionNodeTable.addRecord(string3, string, date, n2, n3, string2, n2, n, l);
            } else {
                long l3 = resourceInfo.getCreatedTime();
                if (l3 < 0L) {
                    l3 = System.currentTimeMillis();
                }
                int n4 = ((JRVersionService)this.DELETE).getDynamicResultVersionId(resourceInfo.getName(), n);
                versionNodeRecord = new VersionNodeRecord(n4, string3, resourceInfo.getCreator(), new Date(l3), -1, resource.getAclID(), resource.getDescription(), resource.getID(), n, ((ResultInfo)resourceInfo).getExpireationTime().getTime());
            }
            VersionImpl versionImpl = new VersionImpl(versionNodeRecord);
            versionImpl.setEntity(resourceInfo);
            versionImpl.setParent(resource);
            return versionImpl;
        }
        return null;
    }

    public Vector getChildren(Folder folder, String string) throws NoPrivilegeException {
        Vector vector;
        User user;
        block10: {
            user = null;
            try {
                user = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block10;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        if (!this.checkPermission(folder, user, (Permission)JPermissionImpl.READ)) {
            throw new NoPrivilegeException(630018, (Object[])new String[]{string, folder.getAbsolutePath()}, null);
        }
        if (folder.isRoot() && !this.GRANT.isAdminUser(string) && (vector = this.getAliasChildrenByPath(folder.getAbsolutePath(), string)) != null && vector.size() > 0) {
            return new Vector();
        }
        vector = !folder.isRoot() ? folder.getChildren() : ((FolderImpl)folder).getPublicChildren();
        Vector<Node> vector2 = new Vector<Node>();
        Node node = null;
        int n = 0;
        if (vector != null) {
            n = vector.size();
        }
        int n2 = 0;
        while (n2 < n) {
            node = (Node)vector.elementAt(n2);
            if (this.checkPermission(node, user, (Permission)JPermissionImpl.VISIBLE)) {
                vector2.addElement(node);
            }
            ++n2;
        }
        Vector vector3 = new Vector();
        if (ServerEnv.isEnableDynamicResource() && folder.isEnableDynamicResource() && folder.getRealPath() != null && folder.getRealPath().length() != 0) {
            vector3 = this.VISIBLE(folder);
        }
        int n3 = 0;
        while (n3 < vector3.size()) {
            node = (Node)vector3.elementAt(n3);
            if (this.checkPermission(node, user, (Permission)JPermissionImpl.VISIBLE)) {
                vector2.addElement(node);
            }
            ++n3;
        }
        return vector2;
    }

    private Vector QOIV(String string, User user) {
        Vector<NodeImpl> vector = null;
        String string2 = user.getName();
        ResourceAlias resourceAlias = this.READ.getParentAlias(string, user.getName());
        String string3 = resourceAlias.resourcePath();
        if (!resourceAlias.hidden()) {
            String string4 = string.substring(resourceAlias.aliasPath().length());
            String string5 = resourceAlias.resourcePath();
            string4 = string5.endsWith("/") && string4.startsWith("/") ? string5 + string4.substring(1) : (!string5.endsWith("/") && !string4.startsWith("/") ? string5 + "/" + string4 : string5 + string4);
            NodeImpl nodeImpl = (NodeImpl)this.addElement.get(string4.toUpperCase());
            if (nodeImpl != null && nodeImpl.getNodeType() == 1 && this.checkPermission(nodeImpl, user, (Permission)JPermissionImpl.READ)) {
                Vector vector2 = ((FolderImpl)nodeImpl).getChildren();
                int n = 0;
                if (vector2 != null) {
                    n = vector2.size();
                    vector = new Vector<NodeImpl>();
                }
                int n2 = 0;
                while (n2 < n) {
                    NodeImpl nodeImpl2 = (NodeImpl)((NodeImpl)vector2.elementAt(n2)).clone();
                    String string6 = nodeImpl2.getAbsolutePath();
                    string6 = string6.substring(string3.length() + 1);
                    string6 = resourceAlias.aliasPath().endsWith("/") ? resourceAlias.aliasPath() + string6 : resourceAlias.aliasPath() + "/" + string6;
                    if (this.checkPermission(nodeImpl2, user, (Permission)JPermissionImpl.VISIBLE) && !this.READ.isAliasNode(string6, string2)) {
                        nodeImpl2.setAbsolutePath(string6);
                        vector.addElement(nodeImpl2);
                    }
                    ++n2;
                }
            }
        }
        return vector;
    }

    public Vector getAliasChildrenByPath(String string, String string2) {
        try {
            User user = this.GRANT.getUser(string2);
            return this.READ(string, user);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException.getMessage());
            return null;
        }
    }

    private Vector READ(String string, User user) {
        NodeImpl nodeImpl;
        int n;
        Vector vector;
        Vector<NodeImpl> vector2 = null;
        String string2 = user.getName();
        ResourceAlias resourceAlias = this.READ.getAlias(string, string2);
        NodeImpl nodeImpl2 = null;
        String string3 = "";
        if (resourceAlias != null) {
            if (resourceAlias.hidden()) {
                return null;
            }
            nodeImpl2 = (NodeImpl)this.addElement.get(resourceAlias.resourcePath().toUpperCase());
            string3 = nodeImpl2.getAbsolutePath();
        }
        if ((resourceAlias == null && string.equalsIgnoreCase("/") || resourceAlias != null && nodeImpl2.getNodeType() == 1 && this.checkPermission(nodeImpl2, user, (Permission)JPermissionImpl.VISIBLE)) && (vector = this.READ.getSubAliases(string, string2)) != null) {
            vector2 = new Vector<NodeImpl>();
            n = 0;
            while (n < vector.size()) {
                ResourceAlias resourceAlias2 = (ResourceAlias)vector.elementAt(n);
                if (!resourceAlias2.hidden() && (nodeImpl = (NodeImpl)this.addElement.get(resourceAlias2.resourcePath().toUpperCase())) != null && this.checkPermission(nodeImpl = (NodeImpl)nodeImpl.clone(), user, (Permission)JPermissionImpl.VISIBLE)) {
                    nodeImpl.setAbsolutePath(resourceAlias2.aliasPath());
                    nodeImpl.rename(resourceAlias2.aliasPath().substring(resourceAlias2.aliasPath().lastIndexOf("/") + 1));
                    vector2.addElement(nodeImpl);
                }
                ++n;
            }
        }
        if (nodeImpl2 != null && nodeImpl2.getNodeType() == 1 && this.checkPermission(nodeImpl2, user, (Permission)JPermissionImpl.VISIBLE)) {
            vector = ((FolderImpl)nodeImpl2).getChildren();
            n = 0;
            if (vector != null) {
                n = vector.size();
                if (vector2 == null) {
                    vector2 = new Vector();
                }
            }
            int n2 = 0;
            while (n2 < n) {
                nodeImpl = (NodeImpl)((NodeImpl)vector.elementAt(n2)).clone();
                String string4 = nodeImpl.getAbsolutePath();
                if (this.checkPermission(nodeImpl, user, (Permission)JPermissionImpl.VISIBLE)) {
                    string4 = string3.equalsIgnoreCase("/") ? string4.substring(string3.length()) : string4.substring(string3.length() + 1);
                    string4 = string.equalsIgnoreCase("/") ? string + string4 : string + "/" + string4;
                    nodeImpl.setAbsolutePath(string4);
                    if (!this.READ.isAliasNode(string4, string2)) {
                        vector2.addElement(nodeImpl);
                    }
                }
                ++n2;
            }
        }
        return vector2;
    }

    private Vector VISIBLE(Folder folder) {
        String string = folder.getRealPath();
        if (string == null) {
            return null;
        }
        Vector<Node> vector = new Vector<Node>();
        File file = new File(folder.getRealPath());
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            String string2 = folder.getAbsolutePath();
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            int n = 0;
            while (n < fileArray.length) {
                String string3 = string2 + fileArray[n].getName();
                Node node = this.addUserFolderListener(folder, string3, fileArray[n].getPath());
                if (node != null && this.addElement.get(this.clearPermissions(node.getAbsolutePath())) == null) {
                    vector.addElement(node);
                }
                ++n;
            }
        }
        return vector;
    }

    public Vector getSubFolders(Folder folder, String string) throws NoPrivilegeException {
        User user;
        block8: {
            user = null;
            try {
                user = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block8;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        if (!this.checkPermission(folder, user, (Permission)JPermissionImpl.READ)) {
            throw new NoPrivilegeException(630023, (Object[])new String[]{string, folder.getAbsolutePath()}, null);
        }
        Vector vector = folder.getChildren();
        Vector<NodeImpl> vector2 = new Vector<NodeImpl>();
        NodeImpl nodeImpl = null;
        int n = 0;
        while (n < vector.size()) {
            nodeImpl = (NodeImpl)vector.elementAt(n);
            if (nodeImpl.getNodeType() == 1 && this.checkPermission(nodeImpl, user, (Permission)JPermissionImpl.VISIBLE)) {
                vector2.addElement(nodeImpl);
            }
            ++n;
        }
        if (ServerEnv.isEnableDynamicResource() && folder.isEnableDynamicResource() && folder.getRealPath() != null && folder.getRealPath().length() != 0) {
            Vector vector3 = new Vector();
            vector3 = this.VISIBLE(folder);
            int n2 = 0;
            while (n2 < vector3.size()) {
                nodeImpl = (NodeImpl)vector3.elementAt(n2);
                if (nodeImpl.getNodeType() == 1 && this.checkPermission(nodeImpl, user, (Permission)JPermissionImpl.VISIBLE)) {
                    vector2.addElement(nodeImpl);
                }
                ++n2;
            }
        }
        return vector2;
    }

    public Vector getResources(Folder folder, String string) throws NoPrivilegeException {
        Vector vector;
        User user;
        block10: {
            user = null;
            try {
                user = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block10;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        if (!this.checkPermission(folder, user, (Permission)JPermissionImpl.READ)) {
            throw new NoPrivilegeException(630022, (Object[])new String[]{string, folder.getAbsolutePath()}, null);
        }
        if (folder.isRoot() && !this.GRANT.isAdminUser(string) && (vector = this.getAliasChildrenByPath(folder.getAbsolutePath(), string)) != null && vector.size() > 0) {
            return new Vector();
        }
        vector = folder.getChildren();
        Vector<NodeImpl> vector2 = new Vector<NodeImpl>();
        NodeImpl nodeImpl = null;
        int n = 0;
        if (vector != null) {
            n = vector.size();
        }
        int n2 = 0;
        while (n2 < n) {
            nodeImpl = (NodeImpl)vector.elementAt(n2);
            if (nodeImpl.getNodeType() == 2 && this.checkPermission(nodeImpl, user, (Permission)JPermissionImpl.VISIBLE)) {
                vector2.addElement(nodeImpl);
            }
            ++n2;
        }
        Vector vector3 = new Vector();
        if (ServerEnv.isEnableDynamicResource() && folder.isEnableDynamicResource() && folder.getRealPath() != null && folder.getRealPath().length() != 0) {
            vector3 = this.VISIBLE(folder);
        }
        int n3 = 0;
        while (n3 < vector3.size()) {
            nodeImpl = (NodeImpl)vector3.elementAt(n3);
            if (nodeImpl.getNodeType() == 2 && this.checkPermission(nodeImpl, user, (Permission)JPermissionImpl.VISIBLE) && !this.READ.isAliasNode(nodeImpl.getAbsolutePath(), string)) {
                vector2.addElement(nodeImpl);
            }
            ++n3;
        }
        return vector2;
    }

    public Vector getVersions(Resource resource, String string) throws NoPrivilegeException {
        User user;
        block8: {
            user = null;
            try {
                user = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block8;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        if (!this.checkPermission(resource, user, (Permission)JPermissionImpl.READ)) {
            throw new NoPrivilegeException(630025, (Object[])new String[]{string, resource.getAbsolutePath()}, null);
        }
        if (resource.isDynamic()) {
            return this.WRITE(resource);
        }
        int n = resource.getResourceType() == 3 && resource.getParent().getNodeType() != 1 || resource.isEnableArchivePolicy() && resource.isArchiveNewVersion() ? resource.getMaxVersionAmount() : this.GRANT(resource);
        this.adjustVersion(resource, n);
        try {
            Vector vector = this.versionNodeTable.getRecordsByResource(resource.getID());
            IntKeyHashtable intKeyHashtable = this.DELETE.getVersions(resource.getID(), resource.getResourceType());
            Vector<VersionImpl> vector2 = new Vector<VersionImpl>();
            int n2 = vector.size();
            VersionNodeRecord versionNodeRecord = null;
            VersionImpl versionImpl = null;
            int n3 = 0;
            while (n3 < n2) {
                versionNodeRecord = (VersionNodeRecord)vector.elementAt(n3);
                int n4 = versionNodeRecord.getVersionNumber();
                versionImpl = new VersionImpl(versionNodeRecord);
                versionImpl.setParent(resource);
                if (intKeyHashtable.containsKey(n4) && this.checkPermission(versionImpl, user, (Permission)JPermissionImpl.VISIBLE)) {
                    versionImpl.setEntity((ResourceInfo)intKeyHashtable.get(n4));
                    vector2.addElement(versionImpl);
                }
                ++n3;
            }
            return vector2;
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException, 5);
            return null;
        }
    }

    private Vector WRITE(Resource resource) {
        Vector vector;
        String string;
        int n;
        IntKeyHashtable intKeyHashtable;
        VersionNodeRecord versionNodeRecord = null;
        VersionImpl versionImpl = null;
        Vector<VersionImpl> vector2 = new Vector<VersionImpl>();
        if (resource.getResourceType() == 1 || resource.getResourceType() == 2) {
            versionNodeRecord = new VersionNodeRecord(-1, resource.getName(), resource.getCreatorName(), new Date(System.currentTimeMillis()), -1, resource.getAclID(), resource.getDescription(), -1, 1, 0L);
            versionNodeRecord.setIsDynamic(true);
            versionImpl = new VersionImpl(versionNodeRecord);
            versionImpl.setEntity(resource.getEntity());
            if (versionImpl != null) {
                versionImpl.setParent(resource);
            }
            vector2.addElement(versionImpl);
        } else if (resource.getResourceType() == 3 && (intKeyHashtable = this.DELETE.getVersions(n = this.WRITE.getResNumber(string = resource.getAbsolutePath()), 3)) != null && (vector = intKeyHashtable.elements()) != null && vector.size() > 0) {
            int n2 = 0;
            while (n2 < intKeyHashtable.size()) {
                ResultInfo resultInfo = (ResultInfo)vector.elementAt(n2);
                versionNodeRecord = new VersionNodeRecord(resultInfo.getResID(), resultInfo.getName(), resultInfo.getCreator(), new Date(resultInfo.getCreatedTime()), -1, -1, "dynamic result version", -1, resultInfo.getVersionNumber(), resultInfo.getExpireationTime().getTime());
                versionNodeRecord.setIsDynamic(true);
                versionImpl = new VersionImpl(versionNodeRecord);
                ((NodeImpl)versionImpl).setAbsolutePath(string);
                versionImpl.setEntity(resultInfo);
                if (versionImpl != null) {
                    versionImpl.setParent(resource);
                }
                vector2.addElement(versionImpl);
                ++n2;
            }
        }
        return vector2;
    }

    public Version getVersion(String string, int n, String string2) throws NoPrivilegeException, UnknownResource {
        return this.getVersion(string, n, string2, true);
    }

    public Version getVersion(String string, int n, String string2, boolean bl) throws NoPrivilegeException, UnknownResource {
        User user;
        block4: {
            user = null;
            try {
                user = this.GRANT.getUser(string2);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block4;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        Version version = this.getVersion(string, n, bl, string2);
        if (version == null) {
            throw new UnknownResource(620009, new Object[]{string, String.valueOf(n)}, null);
        }
        if (!this.checkPermission(version, user, (Permission)JPermissionImpl.READ)) {
            throw new NoPrivilegeException(630024, (Object[])new String[]{string2, String.valueOf(n), string}, null);
        }
        return version;
    }

    public Version getVersion(Node node, int n, boolean bl) {
        if (node != null && node.getNodeType() == 2) {
            if (node.isDynamic()) {
                return this.add(node, n, bl);
            }
            try {
                VersionNodeRecord versionNodeRecord;
                if (n < 1) {
                    n = ((Resource)node).getLatestVersionNumber();
                }
                if ((versionNodeRecord = this.versionNodeTable.getRecord(node.getID(), n)) != null) {
                    VersionImpl versionImpl = new VersionImpl(versionNodeRecord);
                    if (bl) {
                        ResourceInfo resourceInfo = this.DELETE.getVersion(node.getID(), n, ((Resource)node).getResourceType());
                        versionImpl.setEntity(resourceInfo);
                    }
                    versionImpl.setParent(node);
                    return versionImpl;
                }
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException, 5);
            }
        }
        return null;
    }

    private Version add(Node node, int n, boolean bl) {
        VersionNodeRecord versionNodeRecord = null;
        VersionImpl versionImpl = null;
        if (((Resource)node).getResourceType() == 1 || ((Resource)node).getResourceType() == 2) {
            versionNodeRecord = new VersionNodeRecord(-1, node.getName(), node.getCreatorName(), new Date(System.currentTimeMillis()), -1, node.getAclID(), node.getDescription(), -1, 1, 0L);
            versionNodeRecord.setIsDynamic(true);
            versionImpl = new VersionImpl(versionNodeRecord);
            if (bl) {
                versionImpl.setEntity(((Resource)node).getEntity());
            }
            versionImpl.setParent(node);
        } else if (((Resource)node).getResourceType() == 3) {
            String string = node.getAbsolutePath();
            int n2 = this.WRITE.getResNumber(string);
            ResultInfo resultInfo = (ResultInfo)this.DELETE.getVersion(n2, n, 3);
            versionNodeRecord = new VersionNodeRecord(resultInfo.getResID(), resultInfo.getName(), resultInfo.getCreator(), new Date(resultInfo.getCreatedTime()), -1, -1, "dynamic result version", n2, n, resultInfo.getExpireationTime().getTime());
            versionNodeRecord.setIsDynamic(true);
            versionImpl = new VersionImpl(versionNodeRecord);
            if (bl) {
                versionImpl.setEntity(resultInfo);
            }
            versionImpl.setParent(node);
        }
        return versionImpl;
    }

    public Version getVersion(String string, int n, boolean bl, String string2) throws UnknownResource {
        Node node = null;
        try {
            node = this.getNodeByPath(string, string2);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
            return null;
        }
        return this.getVersion(node, n, bl);
    }

    public Version getVersion(Resource resource, int n, String string) throws NoPrivilegeException {
        block2: {
            try {
                this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block2;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        return this.getVersion((Node)resource, n, true);
    }

    public ResultVersionRecord getResultVersionRecord(String string) throws NoPrivilegeException, UnknownResource {
        ResultVersionRecordImpl resultVersionRecordImpl = null;
        try {
            Object object;
            int n = CSUtil.parseInt(string, -1);
            ResultInfo resultInfo = null;
            if (n != -1) {
                if (n < -1) {
                    resultInfo = (ResultInfo)this.DELETE.getVersionByID(n, 3);
                } else {
                    object = this.versionNodeTable.getRecord(n);
                    if (object != null) {
                        resultInfo = (ResultInfo)this.DELETE.getVersion(((VersionNodeRecord)object).getResourceID(), ((VersionNodeRecord)object).getVersionNumber(), 3);
                    }
                }
            }
            if (resultInfo != null) {
                object = ((CatalogInfo)this.DELETE.getVersion(resultInfo.getCatalogResourceId(), resultInfo.getCatalogVerNum(), 1)).getCatalog();
                String string2 = ((ReportInfo)this.DELETE.getVersion(resultInfo.getReportResourceId(), resultInfo.getReportVerNum(), 2)).getReportFile();
                resultVersionRecordImpl = new ResultVersionRecordImpl(string, resultInfo.getName(), resultInfo.getVersionNumber(), (String)object, string2, resultInfo.getParamFile(), resultInfo.getResultFile(), resultInfo.getTaskId(), resultInfo.getCreator(), resultInfo.getResultFormats(), new Date(resultInfo.getCreatedTime()), resultInfo.getExpireationTime(), new Long(resultInfo.getLaunchType()).intValue(), resultInfo.getRealPath(), resultInfo.getExpireationMethod(), resultInfo.getReportAmount(), resultInfo.getSheetsResultDetails());
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException, 5);
        }
        return resultVersionRecordImpl;
    }

    public void removeChild(Folder folder, Node node, String string) throws NoPrivilegeException {
        User user;
        block4: {
            if (node == this.addPermission || node.getAbsolutePath().equals("/USERFOLDERPATH")) {
                ServiceLogger.logError(204807, node, 5);
            }
            user = null;
            try {
                user = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block4;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        if (!this.checkPermission(node, user, (Permission)JPermissionImpl.DELETE)) {
            throw new NoPrivilegeException(630026, (Object[])new String[]{string, node.getAbsolutePath()}, null);
        }
        this.removeChild(folder, node, user);
    }

    public void removeChild(Folder folder, Node node, User user) throws NoPrivilegeException {
        folder.removeChild(node);
        switch (((NodeImpl)node).getNodeType()) {
            case 1: {
                Vector vector = ((Folder)node).getChildren();
                int n = 0;
                while (n < vector.size()) {
                    this.removeChild((Folder)node, (Node)vector.elementAt(n), user);
                    ++n;
                }
                this.add.deleteRecord(node.getID());
                this.nodeTable.deleteRecord(node.getID());
                break;
            }
            case 2: {
                Resource resource = ((Resource)node).getResult();
                if (resource != null) {
                    resource.removeVersions();
                    this.versionNodeTable.deleteRecordsByResource(resource.getID());
                    this.DELETE.removeVersions(resource.getID(), resource.getResourceType());
                    this.addChild.deleteRecord(resource.getID());
                    this.nodeTable.deleteRecord(resource.getID());
                    if (resource.getAclID() != -1) {
                        this.GRANT.clearPermissions(resource);
                    }
                    this.addElement.remove(this.clearPermissions(resource.getAbsolutePath()));
                    this.tree.remove(resource.getID());
                }
                ((Resource)node).removeVersions();
                this.versionNodeTable.deleteRecordsByResource(node.getID());
                this.DELETE.removeVersions(node.getID(), ((Resource)node).getResourceType());
                this.addChild.deleteRecord(node.getID());
                this.nodeTable.deleteRecord(node.getID());
                break;
            }
            default: {
                ServiceLogger.logError(204807, node, 6);
                return;
            }
        }
        this.GRANT.clearPermissions(node);
        this.addElement.remove(this.clearPermissions(node.getAbsolutePath()));
        this.tree.remove(node.getID());
        ServiceLogger.logEvent(6620019, new Object[]{user == null ? "" : user.getName(), node.getAbsolutePath()}, 5);
    }

    public void removeVersion(int n, String string) throws NoPrivilegeException {
        User user;
        block8: {
            user = null;
            try {
                user = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block8;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        if (n < -1) {
            this.addChild(n, user);
            return;
        }
        try {
            VersionNodeRecord versionNodeRecord = this.versionNodeTable.getVersionByID(n);
            if (versionNodeRecord == null) {
                return;
            }
            Resource resource = (Resource)this.getNodeByID(versionNodeRecord.getResourceID());
            VersionImpl versionImpl = new VersionImpl(versionNodeRecord);
            versionImpl.setParent(resource);
            if (!this.checkPermission(versionImpl, user, (Permission)JPermissionImpl.DELETE)) {
                throw new NoPrivilegeException(630027, (Object[])new String[]{string, String.valueOf(versionNodeRecord.getVersionNumber()), resource.getAbsolutePath()}, null);
            }
            if (versionImpl.getAclID() != -1) {
                this.GRANT.clearPermissions(versionImpl);
            }
            this.DELETE.removeVersion(resource.getID(), versionNodeRecord.getVersionNumber(), resource.getResourceType());
            this.versionNodeTable.deleteRecord(versionNodeRecord.getID());
            this.nodeTable.deleteRecord(versionNodeRecord.getID());
            ResourceInfo resourceInfo = this.DELETE.getLatestVersion(resource.getID(), resource.getResourceType());
            ((ResourceImpl)resource).setEntity(resourceInfo);
            ServiceLogger.logEvent(6620020, new Object[]{string, resource.getAbsolutePath(), String.valueOf(versionImpl.getVersionNumber())}, 5);
        }
        catch (SQLException sQLException) {
            throw new NoPrivilegeException(sQLException);
        }
    }

    private void addChild(int n, User user) throws NoPrivilegeException {
        ResultInfo resultInfo = (ResultInfo)this.DELETE.getVersionByID(n, 3);
        if (resultInfo != null) {
            int n2 = resultInfo.getReportResourceId();
            Node node = this.getNodeByID(n2);
            if (!this.checkPermission(node, user, (Permission)JPermissionImpl.DELETE)) {
                throw new NoPrivilegeException(630027, (Object[])new String[]{user.getName(), String.valueOf(resultInfo.getVersionNumber()), node.getAbsolutePath()}, null);
            }
            this.DELETE.removeVersionByID(n, 3);
        }
    }

    private void addElement() throws SQLException {
        Object object;
        if (this.addPermission == null) {
            return;
        }
        boolean bl = ServerEnv.isEnableDynamicResource();
        ExProperties exProperties = ServerEnv.getInstallProps();
        String string = null;
        if (exProperties != null) {
            string = exProperties.getProperty("server.publicReportsRealPath");
        }
        if (string == null) {
            return;
        }
        FolderRecord folderRecord = this.add.getFolderByID(this.addPermission.getID());
        if (string.trim().length() == 0) {
            string = folderRecord.getRealPath();
        } else {
            object = new File(string);
            if (!((File)object).exists() || !((File)object).isDirectory()) {
                string = folderRecord.getRealPath();
            }
        }
        this.add.updateAll(this.addPermission.getID(), string, folderRecord.getMaxVersionAmount(), folderRecord.isArchiveNewVersion(), folderRecord.isEnableArchivePolicy(), folderRecord.isShared(), bl);
        object = (FolderImpl)this.addPermission;
        ((FolderImpl)object).setRealPath(string);
        ((FolderImpl)object).setEnableDynamicResource(bl);
    }

    public void loadDefaultTree() throws SQLException {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("jrs.node_name", "");
            hashtable.put("jrs.ignore_permissions", "true");
            this.addPermission = this.addSubFolder(null, hashtable, "JReport_System_User");
            this.addPermission.setAclID(this.GRANT.getDefaultAclID());
            this.addElement();
            hashtable = new Hashtable();
            hashtable.put("jrs.node_name", "/USERFOLDERPATH".substring(1));
            hashtable.put("jrs.ignore_permissions", "true");
            this.addSubFolder(this.addPermission, hashtable, "JReport_System_User");
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException, 6);
        }
        catch (NodeExistsException nodeExistsException) {
            ServiceLogger.logError(nodeExistsException, 6);
        }
    }

    public void reloadTree() throws SQLException {
        this.addPermission = null;
        this.tree.clear();
        this.addElement.clear();
        this.initTree();
    }

    public void initTree() throws SQLException {
        Vector vector = this.add.getAllFolders();
        Vector vector2 = this.addChild.getAllResources();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            FolderRecord folderRecord = (FolderRecord)vector.elementAt(n2);
            FolderImpl folderImpl = new FolderImpl(folderRecord);
            this.tree.put(folderRecord.getID(), (Object)folderImpl);
            if (this.addPermission == null && folderImpl.isRoot()) {
                this.addPermission = folderImpl;
            }
            ++n2;
        }
        n = vector2.size();
        int n3 = 0;
        while (n3 < n) {
            ResourceNodeRecord resourceNodeRecord = (ResourceNodeRecord)vector2.elementAt(n3);
            int n4 = resourceNodeRecord.getID();
            ResourceImpl resourceImpl = new ResourceImpl(resourceNodeRecord);
            ResourceInfo resourceInfo = this.DELETE.getLatestVersion(n4, resourceNodeRecord.getResourceType());
            resourceImpl.setEntity(resourceInfo);
            this.tree.put(n4, (Object)resourceImpl);
            ++n3;
        }
        IntVector intVector = this.tree.keys();
        if (intVector != null) {
            n = intVector.size();
            int n5 = 0;
            while (n5 < n) {
                NodeImpl nodeImpl = (NodeImpl)this.tree.get(intVector.elementAt(n5));
                if (nodeImpl.getParent() == null) {
                    NodeImpl nodeImpl2 = (NodeImpl)this.tree.get(nodeImpl.getParentID());
                    this.addPermission(nodeImpl, nodeImpl2);
                }
                ++n5;
            }
        }
        if (this.addPermission != null) {
            this.addElement();
        }
        if (this.addPermission != null && this.addPermission.getAclID() == -1) {
            this.addPermission.setAclID(this.GRANT.getDefaultAclID());
        }
        ServiceLogger.logEvent(6620021, 5);
    }

    private void addPermission(NodeImpl nodeImpl, NodeImpl nodeImpl2) {
        if (nodeImpl2.getParent() == null && nodeImpl != nodeImpl2) {
            this.addPermission(nodeImpl2, (FolderImpl)this.tree.get(nodeImpl2.getParentID()));
        }
        nodeImpl.setParent(nodeImpl2);
        this.addElement.put(this.clearPermissions(nodeImpl.getAbsolutePath()), nodeImpl);
        if (nodeImpl2 != nodeImpl) {
            if (nodeImpl2.getNodeType() == 2) {
                ((ResourceImpl)nodeImpl2).setResult((ResourceImpl)nodeImpl);
            } else {
                ((FolderImpl)nodeImpl2).addChild(nodeImpl);
            }
        }
    }

    public UITree getUITreeByUser(String string) {
        Object object;
        Object object2;
        UITree uITree;
        block4: {
            uITree = new UITree(string, string, this.addPermission.getName(), this.addPermission.getAbsolutePath(), String.valueOf(this.addPermission.getNodeType()), null);
            UINode uINode = uITree.getRoot();
            if (string != null && string.trim().length() != 0) {
                object2 = "/USERFOLDERPATH/" + string;
                object = uINode.addChild((String)object2, "My Reports", String.valueOf(1), null);
                Folder folder = (Folder)this.addElement.get(this.clearPermissions((String)object2));
                if (folder != null) {
                    this.addSubFolder(folder, (UINode)object);
                }
            }
            object2 = uINode.addChild(this.addPermission.getAbsolutePath(), "Public Reports", String.valueOf(1), null);
            object = null;
            try {
                object = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block4;
                ServiceLogger.logError(noSuchUserException, 6);
                return uITree;
            }
        }
        this.addRecord(this.addPermission, (UINode)object2, (User)object);
        return uITree;
    }

    private void addRecord(Node node, UINode uINode, User user) {
        block16: {
            Object object;
            int n;
            Vector vector;
            String string;
            String string2;
            block15: {
                NodeImpl nodeImpl;
                string2 = node.getAbsolutePath();
                string = null;
                if (user != null) {
                    string = user.getName();
                }
                if (!this.READ.isAliasNode(string2, string) && !this.READ.isAliasSubNode(string2, string) && node.getNodeType() == 1 && this.checkPermission(node, user, (Permission)JPermissionImpl.READ)) {
                    vector = null;
                    int n2 = 0;
                    try {
                        vector = this.getChildren((FolderImpl)node, string);
                        n2 = vector.size();
                    }
                    catch (NoPrivilegeException noPrivilegeException) {
                        // empty catch block
                    }
                    if (vector != null) {
                        n = 0;
                        while (n < n2) {
                            nodeImpl = (NodeImpl)vector.elementAt(n);
                            if (nodeImpl.getNodeType() == 1 && !nodeImpl.getAbsolutePath().equals("/USERFOLDERPATH") && this.checkPermission(nodeImpl, user, (Permission)JPermissionImpl.VISIBLE)) {
                                object = uINode.addChild(nodeImpl.getAbsolutePath(), nodeImpl.getName(), String.valueOf(nodeImpl.getNodeType()), null);
                                this.addRecord(nodeImpl, (UINode)object, user);
                            }
                            ++n;
                        }
                    }
                }
                if (!this.READ.isAliasNode(string2, string) && (string == null || !string2.equalsIgnoreCase("/"))) break block15;
                vector = null;
                try {
                    vector = this.READ(string2, user);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                int n3 = 0;
                if (vector != null) {
                    n3 = vector.size();
                }
                n = 0;
                while (n < n3) {
                    nodeImpl = (NodeImpl)vector.elementAt(n);
                    ResourceAlias resourceAlias = this.READ.getAlias(string2, string);
                    if (!(resourceAlias != null && resourceAlias.hidden() || nodeImpl.getNodeType() != 1)) {
                        object = uINode.addChild(nodeImpl.getAbsolutePath(), nodeImpl.getName(), String.valueOf(nodeImpl.getNodeType()), null);
                        this.addRecord(nodeImpl, (UINode)object, user);
                    }
                    ++n;
                }
                break block16;
            }
            if (!this.READ.isAliasSubNode(string2, string)) break block16;
            vector = this.QOIV(string2, user);
            int n4 = 0;
            if (vector != null) {
                n4 = vector.size();
            }
            n = 0;
            while (n < n4) {
                object = (NodeImpl)vector.elementAt(n);
                if (!this.READ.getParentAlias(string2, string).hidden() && ((NodeImpl)object).getNodeType() == 1) {
                    UINode uINode2 = uINode.addChild(((NodeImpl)object).getAbsolutePath(), ((NodeImpl)object).getName(), String.valueOf(((NodeImpl)object).getNodeType()), null);
                    this.addRecord((Node)object, uINode2, user);
                }
                ++n;
            }
        }
    }

    private void addSubFolder(Node node, UINode uINode) {
        if (node.getNodeType() == 1) {
            Vector vector = ((FolderImpl)node).getChildren();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                NodeImpl nodeImpl = (NodeImpl)vector.elementAt(n2);
                if (nodeImpl.getNodeType() == 1 && !nodeImpl.getAbsolutePath().equals("/USERFOLDERPATH")) {
                    UINode uINode2 = uINode.addChild(nodeImpl.getAbsolutePath(), nodeImpl.getName(), String.valueOf(nodeImpl.getNodeType()), null);
                    this.addSubFolder(nodeImpl, uINode2);
                }
                ++n2;
            }
        }
    }

    public UITree getUITree() {
        UITree uITree = new UITree(null, null, this.addPermission.getAbsolutePath(), this.addPermission.getAbsolutePath(), String.valueOf(this.addPermission.getNodeType()), null);
        UINode uINode = uITree.getRoot();
        UINode uINode2 = uINode.addChild("/Public Reports", "Public Reports", String.valueOf(1), null);
        this.addSubFolder(this.addPermission, uINode2);
        this.addSubFolder(this.adjustVersion(), uINode);
        return uITree;
    }

    public AliasTree getAliasTreeByPrincipal(String string, byte by, String string2) {
        return this.READ.getAliasTreeByPrincipal(string, by, this.addElement, string2);
    }

    public Folder getRoot() {
        return this.addPermission;
    }

    public VersionService getVersionService() {
        return this.DELETE;
    }

    public boolean isNodeExist(String string, String string2) {
        boolean bl = true;
        try {
            Node node = this.getNodeByPath(string, string2);
            if (node == null) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public Node getNodeByPath(String string, String string2) throws NoPrivilegeException, UnknownResource {
        User user;
        block18: {
            user = null;
            try {
                user = this.GRANT.getUser(string2);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block18;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        if (string.length() > 1 && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        Node node = null;
        if (this.READ.isAliasNode(string, string2)) {
            String string3 = this.READ.getAlias(string, string2).resourcePath();
            node = (Node)this.addElement.get(this.clearPermissions(string3));
        } else if (this.READ.isAliasSubNode(string, string2)) {
            ResourceAlias resourceAlias = this.READ.getParentAlias(string, string2);
            String string4 = resourceAlias.resourcePath();
            string4 = ResourceAliasManagerImpl.contentPath(string4, string.substring(resourceAlias.aliasPath().length()));
            node = (Node)this.addElement.get(this.clearPermissions(string4));
        } else {
            node = this.getNodeByPath(string);
            if (node == null && string != null) {
                String string5 = "";
                if (string.equals("/USERFOLDERPATH/" + string2)) {
                    FolderImpl folderImpl = new FolderImpl();
                    folderImpl.rename(string2);
                    folderImpl.setOwnerName(string2);
                    folderImpl.setParent(this.adjustVersion());
                    this.addElement.put(this.clearPermissions(string), folderImpl);
                    node = folderImpl;
                } else if (string.lastIndexOf(".cls") != -1) {
                    int n = string.lastIndexOf("/");
                    String string6 = string.substring(0, n);
                    string5 = string.substring(n);
                    Node node2 = this.getNodeByPath(string6);
                    if (node2 != null) {
                        if (node2.getNodeType() == 2 && ((Resource)node2).getResourceType() == 1) {
                            string = string6.substring(0, string6.lastIndexOf("/")) + string.substring(n);
                            node = this.getNodeByPath(string);
                        }
                    } else {
                        node = this.getDynamicNodeByPath(string6, string5);
                    }
                } else if (string.lastIndexOf("/") != -1) {
                    int n = string.lastIndexOf("/");
                    String string7 = string.substring(0, n);
                    string5 = string.substring(n);
                    node = this.getDynamicNodeByPath(string7, string5);
                }
            }
        }
        if (node == null) {
            throw new UnknownResource(620002, new Object[]{string}, null);
        }
        if (!this.checkPermission(node, user, (Permission)JPermissionImpl.READ)) {
            throw new NoPrivilegeException(630020, (Object[])new String[]{string2, node.getAbsolutePath()}, null);
        }
        return node;
    }

    public Node getNodeByPath(String string) throws UnknownResource {
        if (string == null) {
            throw new UnknownResource(620002, new Object[]{string}, null);
        }
        Node node = (Node)this.addElement.get(this.clearPermissions(string));
        if (node == null) {
            if (string.lastIndexOf("/") != -1) {
                int n = string.lastIndexOf("/");
                String string2 = string.substring(0, n + 1);
                String string3 = string.substring(n + 1);
                node = this.getDynamicNodeByPath(string2, string3);
            }
            if (node == null && !string.startsWith("/USERFOLDERPATH")) {
                throw new UnknownResource(620002, new Object[]{string}, null);
            }
        }
        return node;
    }

    public Node getDynamicNodeByPath(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string3 = string;
        if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        string3 = string2.startsWith("/") ? string3 + string2.substring(1) : string3 + string2;
        if (string.length() > 1 && string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        Node node = null;
        Node node2 = (Node)this.addElement.get(this.clearPermissions(string));
        if (node2 != null) {
            if (node2.getNodeType() == 1) {
                if (((Folder)node2).isEnableDynamicResource()) {
                    String string4 = ((Folder)node2).getRealPath();
                    if (string4 == null || string4.length() == 0) {
                        node = null;
                    } else {
                        string4 = this.addVersion(string4, string2);
                        node = this.addUserFolderListener((Folder)node2, string3, string4);
                    }
                }
            } else if (string2 == null || string2.length() == 0) {
                node = node2;
            }
        } else if (string.lastIndexOf("/") != -1) {
            int n = string.lastIndexOf("/");
            String string5 = string.substring(0, n + 1);
            String string6 = string.substring(n + 1);
            if (string6.endsWith("/")) {
                string6 = string6.substring(0, string6.length() - 1);
            }
            string6 = string2.startsWith("/") ? string6 + string2 : string6 + "/" + string2;
            node = this.getDynamicNodeByPath(string5, string6);
        }
        return node;
    }

    private Node addUserFolderListener(Folder folder, String string, String string2) {
        Object object;
        Object object2 = null;
        String string3 = "";
        String string4 = "";
        int n = string.lastIndexOf("/");
        if (n >= 0) {
            string3 = string.substring(n + 1);
            string4 = n == 0 ? "/" : string.substring(0, n);
        } else {
            string3 = string;
        }
        if (!(folder == null || string3 != null && string3.trim().length() != 0 && CSUtil.isValidNodeName(string3))) {
            ServiceLogger.logError(JSvrResource.getMessage("RSC_ERROR4", string3), 3);
            return null;
        }
        File file = new File(string2);
        if (file.exists()) {
            if (file.isDirectory()) {
                object = new FolderRecord(-1, string3, folder.getCreatorName(), null, -1, -1, "folder from real path", string2, folder.getOwnerName(), 0, true, true, ((FolderImpl)folder).isShared(), true, false, null, false);
                ((NodeRecord)object).setIsDynamic(true);
                FolderImpl folderImpl = new FolderImpl((FolderRecord)object);
                object2 = folderImpl;
            } else {
                boolean bl = false;
                boolean bl2 = false;
                if (CSUtil.isCatalogFile(string2)) {
                    bl = true;
                } else if (CSUtil.isOrdinaryReportFile(string2)) {
                    bl2 = true;
                }
                if (bl || bl2) {
                    Cloneable cloneable;
                    ResourceNodeRecord resourceNodeRecord = null;
                    ResourceInfoImpl resourceInfoImpl = null;
                    ResourceImpl resourceImpl = null;
                    if (bl) {
                        resourceNodeRecord = new ResourceNodeRecord(-1, string3, folder.getCreatorName(), null, -1, -1, "catalog from real path", 1, string2, 0, false, true, false, null, false);
                        resourceInfoImpl = new CatalogInfoImpl();
                        ((CatalogInfo)((Object)resourceInfoImpl)).setCatalog(string2);
                    } else {
                        resourceNodeRecord = new ResourceNodeRecord(-1, string3, folder.getCreatorName(), null, -1, -1, "report from real path", 2, string2, 0, false, true, folder.isEnableLinkedCatalog(), folder.getLinkedCatalog(), folder.isUseInherited());
                        resourceInfoImpl = new ReportInfoImpl();
                        ((ReportInfo)((Object)resourceInfoImpl)).setReportFile(string2);
                        cloneable = new ResourceNodeRecord(-1, string3, null, null, -1, -1, "result of report from realpath", 3, "", 0, false, true, false, null, false);
                        ((NodeRecord)cloneable).setIsDynamic(true);
                        resourceImpl = new ResourceImpl((ResourceNodeRecord)cloneable);
                    }
                    resourceNodeRecord.setIsDynamic(true);
                    cloneable = new ResourceImpl(resourceNodeRecord);
                    resourceInfoImpl.setCreatedTime(System.currentTimeMillis());
                    resourceInfoImpl.setName(string3);
                    resourceInfoImpl.setVersionNumber(1);
                    ((ResourceImpl)cloneable).setEntity(resourceInfoImpl);
                    if (bl2) {
                        ((ResourceImpl)resourceImpl).setParent((Node)((Object)cloneable));
                        cloneable.setResult(resourceImpl);
                        ((NodeImpl)resourceImpl).setAbsolutePath(string);
                    }
                    object2 = cloneable;
                }
            }
        }
        if (object2 != null) {
            ((NodeImpl)object2).setAbsolutePath(string);
            object = (DynamicNodeRecord)this.VISIBLE.getRecord(string);
            if (object != null) {
                object2.setAclID(((DynamicNodeRecord)object).getAclID());
                ((NodeImpl)object2).setDescription(((DynamicNodeRecord)object).getDescription());
                object2.setLinkedCatalog(((DynamicNodeRecord)object).getDefaultLinkedCatalog());
                object2.setEnableLinkedCatalog(((DynamicNodeRecord)object).getEnableDefaultLinkedCatalog());
                object2.setUseInherited(((DynamicNodeRecord)object).getUsingInherited());
            }
            if (string4.length() > 0) {
                try {
                    ((NodeImpl)object2).setParent(this.getNodeByPath(string4));
                }
                catch (UnknownResource unknownResource) {
                    ServiceLogger.logError(unknownResource);
                }
            }
        }
        return object2;
    }

    private String addVersion(String string, String string2) {
        String string3 = "";
        String string4 = string2.replace('/', File.separatorChar);
        string3 = string.endsWith(File.separator) ? string.substring(0, string.length() - 1) : string;
        string3 = string4.startsWith(File.separator) ? string3 + string4 : string3 + File.separator + string4;
        return string3;
    }

    public Node getNodeByID(int n, String string) throws NoPrivilegeException {
        User user;
        block3: {
            user = null;
            try {
                user = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block3;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        Node node = (Node)this.tree.get(n);
        if (!this.checkPermission(node, user, (Permission)JPermissionImpl.READ)) {
            throw new NoPrivilegeException(630019, (Object[])new String[]{string, node.getAbsolutePath(), String.valueOf(n)}, null);
        }
        return node;
    }

    public Node getNodeByID(int n) {
        String string;
        Node node = (Node)this.tree.get(n);
        if (node == null && (string = this.WRITE.getResource(n)) != null && string.length() > 0) {
            try {
                node = this.getNodeByPath(string);
            }
            catch (UnknownResource unknownResource) {
                // empty catch block
            }
        }
        return node;
    }

    public void setMaxVersionAmount(Resource resource, int n) {
        int n2;
        if (n <= 0) {
            n = 0;
        }
        if ((n2 = resource.getMaxVersionAmount()) != n) {
            this.addChild.updateMaxVersionAmount(resource.getID(), n);
            resource.setMaxVersionAmount(n);
        }
        this.adjustVersion(resource, n);
    }

    private Folder adjustVersion() {
        return (Folder)this.addElement.get("/USERFOLDERPATH");
    }

    public void quit() {
        this.addSubFolder = true;
        this.tree.clear();
        this.addElement.clear();
        this.clearMem();
    }

    private synchronized void aliasPath(String string, String string2) {
        String string3;
        String string4 = this.clearPermissions(string);
        String string5 = this.clearPermissions(string2);
        Vector<String> vector = new Vector<String>(this.addElement.size() / 10);
        int n = string4.length();
        Enumeration enumeration = this.addElement.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            if (!string3.equals(string4) && !string3.startsWith(string4 + "/")) continue;
            vector.addElement(string3);
        }
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            string3 = (String)vector.elementAt(n3);
            NodeImpl nodeImpl = (NodeImpl)this.addElement.remove(string3);
            string3 = string5 + string3.substring(n);
            nodeImpl.setAbsolutePath(string2 + nodeImpl.getAbsolutePath().substring(n));
            this.addElement.put(string3, nodeImpl);
            ++n3;
        }
    }

    public void setNodeProperties(Node node, Hashtable hashtable, Hashtable[] hashtableArray, String string) throws NoPrivilegeException, NodeExistsException {
        int n;
        int n2;
        Object object;
        String string2;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        User user;
        block44: {
            ServiceLogger.logDebug(6620006, new Object[]{node.getAbsolutePath(), hashtable, hashtableArray, string}, 6);
            if (hashtableArray != null) {
                int n3 = 0;
                while (n3 < hashtableArray.length) {
                    ServiceLogger.logDebug(6620010, new Object[]{new Integer(n3), hashtableArray[n3]}, 6);
                    ++n3;
                }
            }
            user = null;
            try {
                user = this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block44;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        if (!this.checkPermission(node, user, (Permission)JPermissionImpl.WRITE)) {
            throw new NoPrivilegeException(630028, (Object[])new String[]{string, node.getAbsolutePath()}, null);
        }
        if (node.getNodeType() == 3 && (object5 = (Resource)(object4 = (Version)node).getParent()).getResourceType() == 3) {
            object3 = (ResultInfoImpl)object4.getEntity();
            object2 = (Date)hashtable.get("jrs.expired_time");
            if (object2 != null) {
                ((ResultInfoImpl)object3).setExpire(true);
                ((ResultInfoImpl)object3).setExpireationTime((Date)object2);
                ((ResultInfoImpl)object3).setExpireationMethod(CSUtil.parseInt((String)hashtable.get("jrs.auto_delete_method"), 0));
            } else {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.add(1, 100);
                ((ResultInfoImpl)object3).setExpireationTime(gregorianCalendar.getTime());
            }
            this.DELETE.updateVersion((ResourceInfo)object3, object4.getResourceID(), object4.getVersionNumber(), string);
            if (!object4.isDynamic()) {
                this.versionNodeTable.updateExpirationTime(node.getID(), ((ResultInfoImpl)object3).getExpireationTime().getTime());
            }
        }
        object4 = node.getAbsolutePath();
        object5 = node.getName();
        object3 = node.getAbsolutePath();
        object2 = (String)hashtable.get("jrs.node_name");
        object2 = object2 == null || ((String)object2).trim().length() == 0 ? object5 : ((String)object2).trim();
        boolean bl = !((String)object2).equalsIgnoreCase((String)object5);
        boolean bl2 = CSUtil.getBoolean((String)hashtable.get("jrs.ignore_permissions"), false);
        Hashtable[] hashtableArray2 = null;
        if ((((String)object4).equals("/") || ((String)object4).equals("/USERFOLDERPATH/" + string)) && bl) {
            throw new NoPrivilegeException(630029, (Object[])new String[]{string, object4}, null);
        }
        Node node2 = node.getParent();
        if (((String)object2).length() > 0 && bl && node2.getNodeType() == 1 && ((Folder)node2).hasChild((String)object2)) {
            throw new NodeExistsException(620001, new Object[]{object2, node2.getAbsolutePath()}, null);
        }
        if (node.getNodeType() == 1 && ((Folder)node).isFakeFolder()) {
            node = this.upgradeFakeFolder((Folder)node);
        }
        if (bl2 && bl) {
            try {
                hashtableArray2 = this.GRANT.getPermissions(node);
                this.GRANT.setPermissions(node, string, null);
            }
            catch (NoSuchAclException noSuchAclException) {
                ServiceLogger.logError(noSuchAclException, 6);
            }
            catch (NotOwnerException notOwnerException) {
                ServiceLogger.logError(notOwnerException, 6);
            }
            catch (AclExistException aclExistException) {
                ServiceLogger.logError(aclExistException, 6);
            }
        }
        boolean bl3 = (string2 = (String)hashtable.get("jrs.node_path")) == null ? false : this.READ.isAliasNode(string2, string);
        hashtable.put("jrs.is_alias", new Boolean(bl3).toString());
        if (node.setNodeProperties(hashtable) || bl3 || node.isDynamic() && node.setDefaultLinkedCatalogProps(hashtable)) {
            object = node.getDescription();
            if (!node.isDynamic()) {
                if (((String)object2).length() > 0) {
                    if (bl3) {
                        this.READ.upgradeAliasPath(string2, string2.substring(0, string2.lastIndexOf("/") + 1) + (String)object2, string);
                    } else {
                        this.nodeTable.updateNameAndDesc(node.getID(), (String)object2, (String)object);
                        if (!((String)object2).equalsIgnoreCase((String)object5)) {
                            this.aliasPath((String)object3, ((String)object3).substring(0, ((String)object3).lastIndexOf("/") + 1) + (String)object2);
                            this.READ.upgradeAbsolutePathForAlias((String)object3, ((String)object3).substring(0, ((String)object3).lastIndexOf("/") + 1) + (String)object2);
                        }
                    }
                } else {
                    this.nodeTable.updateDescription(node.getID(), (String)object);
                }
            } else {
                node.setDefaultLinkedCatalogProps(hashtable);
                if (this.VISIBLE.isNodeExists(node.getAbsolutePath())) {
                    this.VISIBLE.updateDescriptionAndLinkedCatProp(node.getAbsolutePath(), (String)object, node.isEnableLinkedCatalog(), node.getLinkedCatalog(), node.isUseInherited());
                } else {
                    this.contains(node);
                }
            }
        }
        if (node.setDefaultLinkedCatalogProps(hashtable)) {
            if (bl3) {
                try {
                    object = this.getNodeByPath(this.READ.getAlias(node.getAbsolutePath(), user.getName()).resourcePath());
                    if (object != null) {
                        this.nodeTable.updateLinkedCatalogProps(object.getID(), object.isEnableLinkedCatalog(), object.getLinkedCatalog(), object.isUseInherited());
                    }
                }
                catch (UnknownResource unknownResource) {
                    ServiceLogger.logError(unknownResource, 6);
                }
            } else {
                this.nodeTable.updateLinkedCatalogProps(node.getID(), node.isEnableLinkedCatalog(), node.getLinkedCatalog(), node.isUseInherited());
            }
        }
        if (node.setProperties(hashtable)) {
            int n4 = 0;
            boolean bl4 = true;
            String string3 = (String)hashtable.get("jrs.node_real_path");
            boolean bl5 = CSUtil.getBoolean((String)hashtable.get("jrs.enable_archive_policy"), false);
            if (bl5 && (bl4 = CSUtil.getBoolean((String)hashtable.get("jrs.archive_new_version"), true))) {
                n4 = CSUtil.parseInt((String)hashtable.get("jrs.maxversion"), 0);
            }
            String string4 = (String)hashtable.get("jrs.profile");
            if (node.getNodeType() == 1) {
                boolean bl6 = CSUtil.getBoolean((String)hashtable.get("jrs.node_share"), false);
                boolean bl7 = CSUtil.getBoolean((String)hashtable.get("jrs.enable_dynamic_resource"), false);
                this.add.updateAll(node.getID(), string3, n4, bl4, bl5, bl6, bl7);
            } else {
                this.addChild.updateAll(node.getID(), string3, n4, bl4, bl5, string4);
            }
        }
        if (bl2 && bl) {
            this.setPermissions(node, string, hashtableArray2);
        }
        if (!this.checkPermission(node, user, (Permission)JPermissionImpl.GRANT)) {
            return;
        }
        if (!bl2 && (n2 = node.getAclID()) != (n = this.setPermissions(node, string, hashtableArray))) {
            node.setAclID(n);
            if (!node.isDynamic()) {
                this.nodeTable.updateAcl(node.getID(), n);
            } else if (this.VISIBLE.isNodeExists(node.getAbsolutePath())) {
                this.VISIBLE.updateAcl(node.getAbsolutePath(), n);
            } else {
                this.contains(node);
            }
        }
    }

    public void run() {
        long l = 3600000L;
        while (!this.addSubFolder) {
            try {
                this.expireDelete();
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
            Thread.yield();
            try {
                if (this.addSubFolder) continue;
                Thread.sleep(l);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception, 3);
            }
        }
    }

    public void expireDelete() {
        try {
            Vector vector = this.versionNodeTable.getExpiredVersions();
            VersionNodeRecord versionNodeRecord = null;
            int n = 0;
            while (n < vector.size()) {
                versionNodeRecord = (VersionNodeRecord)vector.elementAt(n);
                this.versionNodeTable.deleteRecord(versionNodeRecord.getID());
                this.nodeTable.deleteRecord(versionNodeRecord.getID());
                this.DELETE.removeVersion(versionNodeRecord.getResourceID(), versionNodeRecord.getVersionNumber(), 3);
                ++n;
            }
            this.DELETE.expireDynamicResultDelete();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    public void adjustVersion(Resource resource, int n) {
        if (n > 0) {
            int n2 = this.versionNodeTable.getVersionNodeAmount(resource.getID());
            while (n2 > n) {
                VersionNodeRecord versionNodeRecord = this.versionNodeTable.getEarliestVersion(resource.getID());
                if (versionNodeRecord == null) continue;
                this.versionNodeTable.deleteRecord(versionNodeRecord.getID());
                this.nodeTable.deleteRecord(versionNodeRecord.getID());
                this.DELETE.removeVersion(versionNodeRecord.getResourceID(), versionNodeRecord.getVersionNumber(), resource.getResourceType());
                --n2;
            }
        }
    }

    public boolean checkPermission(String string, String string2, Permission permission) throws NoSuchUserException, UnknownResource {
        Node node = null;
        boolean bl = false;
        if (!ServerEnv.needSecurity()) {
            return !string.startsWith("/USERFOLDERPATH/") || string.startsWith("/USERFOLDERPATH/" + string2);
        }
        try {
            node = this.getNodeByPath(string, string2);
            bl = this.checkPermission(node, this.GRANT.getUser(string2), permission);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException.getMessage(), 6);
            bl = false;
        }
        return bl;
    }

    public boolean checkPermission(String string, int n, String string2, Permission permission) throws NoSuchUserException, UnknownResource {
        if (!ServerEnv.needSecurity()) {
            return !string.startsWith("/USERFOLDERPATH/") || string.startsWith("/USERFOLDERPATH/" + string2);
        }
        Version version = this.getVersion(string, n, false, string2);
        if (version == null) {
            throw new UnknownResource(620009, new Object[]{string, String.valueOf(n)}, null);
        }
        return this.checkPermission(version, this.GRANT.getUser(string2), permission);
    }

    public boolean checkPermission(Node node, User user, Permission permission) {
        Object[] objectArray = new Object[]{node.getAbsolutePath(), user == null ? null : user.getName(), permission};
        ServiceLogger.logDebug(6620008, objectArray, 6);
        String string = node.getAbsolutePath();
        if (user != null && !user.isSystemUser() && string.startsWith("/USERFOLDERPATH/") && !string.startsWith("/USERFOLDERPATH/" + user.getName())) {
            ServiceLogger.logDebug(6620009, "false", 6);
            return false;
        }
        if (!ServerEnv.needSecurity() || user.isSystemUser() || this.GRANT.isAdminUser(user.getName()) || node.isOwnerOrCreator(user.getName())) {
            ServiceLogger.logDebug(6620009, "true", 6);
            return true;
        }
        boolean bl = this.GRANT.checkPermission(node, user.getName(), permission);
        ServiceLogger.logDebug(6620009, String.valueOf(bl), 6);
        return bl;
    }

    public String getRealPath(String string, String string2) {
        try {
            Node node = this.getNodeByPath(string2, string);
            if (node.getNodeType() == 1) {
                return ((Folder)node).getRealPath();
            }
            if (node.getNodeType() == 2) {
                return ((Resource)node).getRealDir();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setPermissions(String string, int n, Hashtable[] hashtableArray, String string2) throws NoPrivilegeException, UnknownResource {
        int n2;
        int n3;
        User user;
        block11: {
            ServiceLogger.logDebug(6620007, new Object[]{string, new Integer(n), string2}, 6);
            if (hashtableArray != null) {
                int n4 = 0;
                while (n4 < hashtableArray.length) {
                    ServiceLogger.logDebug(6620010, new Object[]{new Integer(n4), hashtableArray[n4]}, 6);
                    ++n4;
                }
            }
            user = null;
            try {
                user = this.GRANT.getUser(string2);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block11;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        Node node = this.getNodeByPath(string, string2);
        if (!this.checkPermission(node, user, (Permission)JPermissionImpl.GRANT)) {
            throw new NoPrivilegeException(630021, (Object[])new String[]{string2, JPermissionImpl.GRANT.toString(), string, String.valueOf(n)}, null);
        }
        if (node.getNodeType() == 2 && n > 0 && !node.isDynamic()) {
            node = this.getVersion(string, n, string2);
        }
        if ((n3 = node.getAclID()) != (n2 = this.setPermissions(node, string2, hashtableArray))) {
            node.setAclID(n2);
            if (!node.isDynamic()) {
                this.nodeTable.updateAcl(node.getID(), n2);
            } else if (this.VISIBLE.isNodeExists(node.getAbsolutePath())) {
                this.VISIBLE.updateAcl(node.getAbsolutePath(), n2);
            } else {
                this.contains(node);
            }
        }
    }

    private int setPermissions(Node node, String string, Hashtable[] hashtableArray) {
        int n = -1;
        Hashtable[] hashtableArray2 = this.append(hashtableArray, string);
        try {
            n = this.GRANT.setPermissions(node, string, hashtableArray2);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 6);
        }
        return n;
    }

    private Hashtable[] append(Hashtable[] hashtableArray, String string) {
        Hashtable[] hashtableArray2 = null;
        if (hashtableArray != null && hashtableArray.length < 3) {
            hashtableArray2 = new Hashtable[3];
            System.arraycopy(hashtableArray, 0, hashtableArray2, 0, hashtableArray.length);
        } else {
            hashtableArray2 = hashtableArray;
        }
        hashtableArray2 = this.arraycopy(hashtableArray2);
        if (hashtableArray2 != null && (hashtableArray2[0] != null || hashtableArray2[1] != null || hashtableArray2[2] != null)) {
            if (!this.GRANT.isAdminUser(string)) {
                if (hashtableArray2[0] == null) {
                    hashtableArray2[0] = new Hashtable();
                }
                this.clear(hashtableArray2);
                PermissionSet permissionSet = new PermissionSet();
                permissionSet.setAllPermissions();
                hashtableArray2[0].put(string, permissionSet);
            }
            this.clearMem(hashtableArray2);
        }
        hashtableArray2 = this.checkPermission(hashtableArray2);
        return hashtableArray2;
    }

    private Hashtable[] arraycopy(Hashtable[] hashtableArray) {
        if (hashtableArray == null) {
            return null;
        }
        Hashtable[] hashtableArray2 = new Hashtable[hashtableArray.length];
        int n = 0;
        while (n < hashtableArray.length) {
            if (hashtableArray[n] != null) {
                hashtableArray2[n] = new Hashtable();
                Enumeration enumeration = hashtableArray[n].keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    hashtableArray2[n].put(k, new PermissionSet(hashtableArray[n].get(k)));
                }
            }
            ++n;
        }
        return hashtableArray2;
    }

    private Hashtable[] checkPermission(Hashtable[] hashtableArray) {
        if (hashtableArray == null) {
            return null;
        }
        Hashtable[] hashtableArray2 = new Hashtable[hashtableArray.length];
        int n = 0;
        while (n < hashtableArray.length) {
            if (hashtableArray[n] != null) {
                hashtableArray2[n] = new Hashtable();
                Enumeration enumeration = hashtableArray[n].keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    hashtableArray2[n].put(k, ((PermissionSet)hashtableArray[n].get(k)).getPermissionStr());
                }
            }
            ++n;
        }
        return hashtableArray2;
    }

    private void clear(Hashtable[] hashtableArray) {
        int n = 0;
        while (n < hashtableArray.length) {
            if (hashtableArray[n] != null) {
                Enumeration enumeration = hashtableArray[n].elements();
                while (enumeration.hasMoreElements()) {
                    PermissionSet permissionSet = (PermissionSet)enumeration.nextElement();
                    permissionSet.removePermission(6);
                }
            }
            ++n;
        }
    }

    private void clearMem(Hashtable[] hashtableArray) {
        int n = 0;
        while (n < hashtableArray.length) {
            if (hashtableArray[n] != null) {
                Enumeration enumeration = hashtableArray[n].elements();
                while (enumeration.hasMoreElements()) {
                    PermissionSet permissionSet = (PermissionSet)enumeration.nextElement();
                    if (permissionSet.containsPermission(6)) {
                        permissionSet.setAllPermissions();
                        continue;
                    }
                    if (!permissionSet.containsPermission(3) && !permissionSet.containsPermission(4) && !permissionSet.containsPermission(2)) continue;
                    permissionSet.addPermission(1);
                }
            }
            ++n;
        }
    }

    public Hashtable[] getPermissions(String string, int n, String string2) throws NoPrivilegeException, UnknownResource {
        User user;
        block5: {
            user = null;
            try {
                user = this.GRANT.getUser(string2);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block5;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        Node node = this.getNodeByPath(string, string2);
        if (!this.checkPermission(node, user, (Permission)JPermissionImpl.READ)) {
            throw new NoPrivilegeException(630021, (Object[])new String[]{string2, JPermissionImpl.READ.toString(), string, String.valueOf(n)}, null);
        }
        if (node.getNodeType() == 2 && n != 0 && !node.isDynamic()) {
            node = this.getVersion(string, n, string2);
        }
        if (node.getAclID() == -1) {
            return null;
        }
        return this.GRANT.getPermissions(node);
    }

    public ResourceProtector getProtector() {
        return this.QOIV;
    }

    public void setSchedulingService(JRSchedulingService jRSchedulingService) {
        this.DELETE.setSchedulingService(jRSchedulingService);
        this.addRecord = new Thread(this);
        this.addRecord.setDaemon(true);
        this.addRecord.start();
    }

    public void clearMem() {
        if (this.DELETE != null && this.DELETE instanceof JRVersionService) {
            JRVersionService jRVersionService = (JRVersionService)this.DELETE;
            jRVersionService.clearMem();
            jRVersionService = null;
        }
        if (this.addRecord != null) {
            this.addRecord.stop();
        }
        this.GRANT = null;
    }

    public void removeUserFolder(String string, String string2) {
        ServiceLogger.logDebug(6620001, string, 6);
        Node node = this.adjustVersion().getChild(string);
        if (node != null) {
            if (((Folder)node).isFakeFolder()) {
                this.adjustVersion().removeChild(node);
                this.addElement.remove(node.getAbsolutePath());
            }
            try {
                this.removeChild(this.adjustVersion(), node, string2);
                ServiceLogger.logDebug(6620002, string, 6);
            }
            catch (NoPrivilegeException noPrivilegeException) {
                ServiceLogger.logError(noPrivilegeException, 5);
                ServiceLogger.logDebug(6620003, string, 6);
            }
        }
    }

    private String clearPermissions(String string) {
        String string2 = null;
        if (string.startsWith("/USERFOLDERPATH")) {
            int n = string.indexOf("/", "/USERFOLDERPATH".length() + 1);
            if (n > -1) {
                String string3 = string.substring(n);
                string2 = string.substring(0, n) + string3.toUpperCase();
            } else {
                string2 = string;
            }
        } else {
            string2 = string.toUpperCase();
        }
        return string2;
    }

    public int getDynamicResultMaxVersionAmount(String string) {
        int n = this.VISIBLE.getMaxVersionAmount(string);
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public void setDynamicResultMaxVersionAmount(Resource resource, int n) {
        int n2;
        if (resource.getResourceType() != 2) {
            return;
        }
        String string = resource.getAbsolutePath();
        String string2 = this.clone(string);
        if (string2 == null || string2.length() == 0) {
            return;
        }
        if (n <= 0) {
            n = 0;
        }
        if ((n2 = this.VISIBLE.getMaxVersionAmount(resource.getAbsolutePath())) != n) {
            if (n2 == -1) {
                this.VISIBLE.addRecord(string, string2, resource.getRealDir(), (byte)1, resource.isEnableArchivePolicy(), false, resource.getAclID(), resource.getDescription(), n, resource.isEnableLinkedCatalog(), resource.getLinkedCatalog(), resource.isUseInherited());
            } else {
                this.VISIBLE.updateMaxVersionAmount(string, n);
            }
            resource.setMaxVersionAmount(n);
        }
        if (n > 0) {
            this.DELETE.adjustVersion(this.getDynamicResourceID(resource.getAbsolutePath(), (byte)1), 3, n);
        }
    }

    public int getDynamicResourceID(String string, byte by) {
        int n = this.WRITE.getResNumber(string);
        if (n == -1) {
            n = this.WRITE.addRecord(string, by);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String clone(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.lastIndexOf("/");
        if (n > 0) {
            String string2;
            String string3 = string.substring(0, n);
            Node node = (Node)this.addElement.get(this.clearPermissions(string3));
            if (node == null) return this.clone(string3);
            if (node.getNodeType() != 1 || (string2 = ((Folder)node).getRealPath()) == null || string2.length() == 0) return null;
            return string3;
        }
        if (n != 0) return null;
        return "/";
    }

    private void contains(Node node) {
        String string = node.getAbsolutePath();
        String string2 = this.clone(string);
        if (string2 == null || string2.length() == 0) {
            return;
        }
        if (node.getNodeType() == 1) {
            byte by = 0;
            this.VISIBLE.addRecord(string, string2, ((Folder)node).getRealPath(), by, ((Folder)node).isEnableArchivePolicy(), false, node.getAclID(), node.getDescription(), 0, node.isEnableLinkedCatalog(), node.getLinkedCatalog(), node.isUseInherited());
        } else {
            byte by = ((Resource)node).getResourceType() == 1 ? (byte)2 : 1;
            this.VISIBLE.addRecord(string, string2, ((Resource)node).getRealDir(), by, ((Resource)node).isEnableArchivePolicy(), false, node.getAclID(), node.getDescription(), 0, node.isEnableLinkedCatalog(), node.getLinkedCatalog(), node.isUseInherited());
        }
    }

    public Vector getAllInvalidDynamicNodes(String string) throws NoPrivilegeException {
        Object object;
        block15: {
            try {
                this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block15;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        Vector<Object> vector = new Vector<Object>();
        Vector vector2 = this.WRITE.getAllResources();
        int n = 0;
        while (n < vector2.size()) {
            object = (String)vector2.elementAt(n);
            if (this.addElement.get(this.clearPermissions((String)object)) != null) {
                vector.addElement(object);
            } else {
                try {
                    Node node = this.getNodeByPath((String)object, string);
                    if (node == null) {
                        vector.addElement(object);
                    }
                }
                catch (UnknownResource unknownResource) {
                    vector.addElement(object);
                }
            }
            ++n;
        }
        object = this.VISIBLE.getAllRecords();
        int n2 = 0;
        while (n2 < ((Vector)object).size()) {
            DynamicNodeRecord dynamicNodeRecord = (DynamicNodeRecord)((Vector)object).elementAt(n2);
            String string2 = dynamicNodeRecord.getName();
            if (!vector.contains(string2)) {
                String string3 = dynamicNodeRecord.getRoot();
                if (this.addElement.get(this.clearPermissions(string3)) == null) {
                    vector.addElement(string2);
                } else {
                    Node node = (Node)this.addElement.get(this.clearPermissions(string3));
                    if (node.getNodeType() != 1) {
                        vector.addElement(string2);
                    } else {
                        String string4 = ((Folder)node).getRealPath();
                        File file = new File(string4);
                        String string5 = dynamicNodeRecord.getrealPath();
                        File file2 = new File(string5);
                        if (!(file.exists() && file2.exists() && string5.startsWith(string4))) {
                            vector.addElement(string2);
                        }
                    }
                }
            }
            ++n2;
        }
        return vector;
    }

    public void deleteInvalidDynamicNodes(String string, Vector vector) throws NoPrivilegeException {
        block5: {
            try {
                this.GRANT.getUser(string);
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!ServerEnv.needSecurity()) break block5;
                throw new NoPrivilegeException(noSuchUserException);
            }
        }
        Vector vector2 = this.getAllInvalidDynamicNodes(string);
        if (vector2 == null || vector2.size() == 0 || vector == null || vector.size() == 0) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (vector2.contains(string2)) {
                this.containsKey(string2, string);
            }
            ++n;
        }
    }

    private void containsKey(String string, String string2) throws NoPrivilegeException {
        Object object;
        ResourceMapRecord resourceMapRecord = (ResourceMapRecord)this.WRITE.getRecord(string);
        if (resourceMapRecord != null) {
            object = null;
            if (resourceMapRecord.getResourceType() == 2) {
                object = this.DELETE.getResultByCatalog(resourceMapRecord.getResNumber());
                this.DELETE.removeResultsByCatalog(resourceMapRecord.getResNumber());
            } else {
                object = this.DELETE.getResultByReport(resourceMapRecord.getResNumber());
                this.DELETE.removeVersions(resourceMapRecord.getResNumber(), 3);
            }
            int n = 0;
            while (n < ((Vector)object).size()) {
                ResultInfo resultInfo = (ResultInfo)((Vector)object).elementAt(n);
                int n2 = resultInfo.getResID();
                int n3 = resultInfo.getVersionNumber();
                try {
                    int n4 = this.versionNodeTable.getRecord(n2, n3).getID();
                    this.removeVersion(n4, string2);
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException.getMessage());
                }
                catch (NoPrivilegeException noPrivilegeException) {
                    throw new NoPrivilegeException(noPrivilegeException);
                }
                ++n;
            }
            this.WRITE.deleteRecord(resourceMapRecord.getResNumber());
        }
        if ((object = this.containsPermission(string)) != null) {
            this.GRANT.clearPermissions((Node)object);
            this.VISIBLE.deleteRecord(string);
        }
    }

    private Node containsPermission(String string) {
        Cloneable cloneable = null;
        DynamicNodeRecord dynamicNodeRecord = (DynamicNodeRecord)this.VISIBLE.getRecord(string);
        if (dynamicNodeRecord != null) {
            if (dynamicNodeRecord.getNodeType() == 0) {
                FolderImpl folderImpl;
                FolderRecord folderRecord = new FolderRecord(-1, dynamicNodeRecord.getName(), "", null, -1, dynamicNodeRecord.getAclID(), dynamicNodeRecord.getDescription(), dynamicNodeRecord.getrealPath(), "", dynamicNodeRecord.getMaxVersionAmount(), true, dynamicNodeRecord.isEnableArchivePolicy(), false, true, dynamicNodeRecord.getEnableDefaultLinkedCatalog(), dynamicNodeRecord.getDefaultLinkedCatalog(), dynamicNodeRecord.getUsingInherited());
                folderRecord.setIsDynamic(true);
                cloneable = folderImpl = new FolderImpl(folderRecord);
            } else {
                Cloneable cloneable2;
                ResourceNodeRecord resourceNodeRecord = null;
                ResourceInfoImpl resourceInfoImpl = null;
                ResourceImpl resourceImpl = null;
                if (dynamicNodeRecord.getNodeType() == 2) {
                    resourceNodeRecord = new ResourceNodeRecord(-1, dynamicNodeRecord.getName(), "", null, -1, dynamicNodeRecord.getAclID(), dynamicNodeRecord.getDescription(), 1, dynamicNodeRecord.getrealPath(), dynamicNodeRecord.getMaxVersionAmount(), true, dynamicNodeRecord.isEnableArchivePolicy(), false, null, false);
                    resourceInfoImpl = new CatalogInfoImpl();
                    ((CatalogInfo)((Object)resourceInfoImpl)).setCatalog(dynamicNodeRecord.getrealPath());
                } else {
                    resourceNodeRecord = new ResourceNodeRecord(-1, dynamicNodeRecord.getName(), "", null, -1, dynamicNodeRecord.getAclID(), dynamicNodeRecord.getDescription(), 2, dynamicNodeRecord.getrealPath(), dynamicNodeRecord.getMaxVersionAmount(), true, dynamicNodeRecord.isEnableArchivePolicy(), dynamicNodeRecord.getEnableDefaultLinkedCatalog(), dynamicNodeRecord.getDefaultLinkedCatalog(), dynamicNodeRecord.getUsingInherited());
                    resourceInfoImpl = new ReportInfoImpl();
                    ((ReportInfo)((Object)resourceInfoImpl)).setReportFile(dynamicNodeRecord.getrealPath());
                    cloneable2 = new ResourceNodeRecord(-1, dynamicNodeRecord.getName(), null, null, -1, -1, "result of report from real path", 3, "", 0, false, true, false, null, false);
                    ((NodeRecord)cloneable2).setIsDynamic(true);
                    resourceImpl = new ResourceImpl((ResourceNodeRecord)cloneable2);
                    ((NodeImpl)resourceImpl).setAbsolutePath(string);
                }
                resourceNodeRecord.setIsDynamic(true);
                cloneable2 = new ResourceImpl(resourceNodeRecord);
                resourceInfoImpl.setCreatedTime(System.currentTimeMillis());
                resourceInfoImpl.setName(dynamicNodeRecord.getName());
                resourceInfoImpl.setVersionNumber(1);
                ((NodeImpl)cloneable2).setAbsolutePath(string);
                ((ResourceImpl)cloneable2).setEntity(resourceInfoImpl);
                if (dynamicNodeRecord.getNodeType() == 1) {
                    cloneable2.setResult(resourceImpl);
                }
                cloneable = cloneable2;
            }
        }
        return cloneable;
    }

    public ResourceAliasManagerImpl getResourceAliasManager() {
        return this.READ;
    }

    public Node checkNode(Node node, String string, String string2) {
        Node node2 = (Node)((NodeImpl)node).clone();
        if (this.READ.isAliasNode(node.getAbsolutePath(), string2)) {
            ((NodeImpl)node2).setAbsolutePath(this.READ.getAlias(node.getAbsolutePath(), string2).resourcePath());
        } else if (this.READ.isAliasSubNode(node.getAbsolutePath(), string2)) {
            ResourceAlias resourceAlias = this.READ.getParentAlias(node.getAbsolutePath(), string2);
            String string3 = resourceAlias.aliasPath();
            string3 = string3.endsWith("/") ? string3.substring(0, string3.lastIndexOf("/")) + node.getAbsolutePath().substring(resourceAlias.resourcePath().length()) : string3 + node.getAbsolutePath().substring(resourceAlias.resourcePath().length());
            ((NodeImpl)node2).setAbsolutePath(string3);
        }
        return node2;
    }

    public UITree getCompleteTree(String string) {
        if (!this.GRANT.isAdminUser(string)) {
            return null;
        }
        UITree uITree = new UITree(null, null, "/Public Reports", "Public Reports", String.valueOf(this.addPermission.getNodeType()), null);
        UINode uINode = uITree.getRoot();
        this.contentPath(this.addPermission, uINode);
        return uITree;
    }

    private void contentPath(Node node, UINode uINode) {
        if (node.getNodeType() == 1) {
            Vector vector = ((FolderImpl)node).getChildren();
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                NodeImpl nodeImpl = (NodeImpl)vector.elementAt(n2);
                if (!nodeImpl.getAbsolutePath().equals("/USERFOLDERPATH")) {
                    UINode uINode2 = uINode.addChild(nodeImpl.getAbsolutePath(), nodeImpl.getName(), String.valueOf(nodeImpl.getNodeType()), null);
                    this.contentPath(nodeImpl, uINode2);
                }
                ++n2;
            }
        }
    }

    public void cleanupUserFolder() {
        if (ServerEnv.isAutoCleanupUserFolder()) {
            Vector vector = this.adjustVersion().getChildren();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string = ((Node)enumeration.nextElement()).getName();
                try {
                    this.GRANT.getUser(string);
                }
                catch (NoSuchUserException noSuchUserException) {
                    this.removeUserFolder(string, "JReport_System_User");
                }
            }
        }
    }

    public String convertReports(String string, boolean bl, boolean bl2, boolean bl3) {
        Converter converter = ConverterFactory.getConverter();
        String string2 = ServerEnv.getReportHome();
        String string3 = !string2.endsWith(File.separator) ? string2 + File.separator + "temp" + File.separator + "convertFilesInWebUI" : string2 + "temp" + File.separator + "convertFilesInWebUI";
        File file = new File(string3);
        if (!file.exists()) {
            file.mkdirs();
        }
        Enumeration enumeration = this.addElement.elements();
        while (enumeration.hasMoreElements()) {
            String string4;
            String string5;
            Resource resource = null;
            Node node = (Node)enumeration.nextElement();
            byte by = node.getNodeType();
            if (by != 2) continue;
            resource = (Resource)node;
            String string6 = node.getAbsolutePath();
            ResourceInfo resourceInfo = resource.getEntity();
            int n = resourceInfo.getResourceType();
            if (n == 2) {
                ResourceInfo resourceInfo2;
                Hashtable<String, String> hashtable;
                String string7;
                boolean bl4;
                string5 = resourceInfo.getRealPath();
                String string8 = this.convertRptSchema(resource);
                if (string8 == null) continue;
                try {
                    bl4 = converter.isPreviousReportSchema(string5);
                }
                catch (ReadFailureException readFailureException) {
                    ServiceLogger.logError(readFailureException);
                    continue;
                }
                catch (JetRptReportIOException jetRptReportIOException) {
                    ServiceLogger.logError(jetRptReportIOException);
                    continue;
                }
                if (!bl4) continue;
                if (bl2 && string6.startsWith("/USERFOLDERPATH")) {
                    if (bl3) {
                        try {
                            converter.convertRptSchema(string8, string5, string5);
                        }
                        catch (ReadFailureException readFailureException) {
                            ServiceLogger.logError(readFailureException);
                        }
                        catch (UniverseFileException universeFileException) {
                            ServiceLogger.logError(universeFileException);
                        }
                        catch (JUpgradeNotSupportedException jUpgradeNotSupportedException) {
                            ServiceLogger.logError(jUpgradeNotSupportedException);
                        }
                        catch (WriteFailureException writeFailureException) {
                            ServiceLogger.logError(writeFailureException);
                        }
                        continue;
                    }
                    string4 = new File(string6).getName();
                    string7 = string3 + File.separator + string4;
                    try {
                        converter.convertRptSchema(string8, string5, string7);
                    }
                    catch (ReadFailureException readFailureException) {
                        ServiceLogger.logError(readFailureException);
                        continue;
                    }
                    catch (UniverseFileException universeFileException) {
                        ServiceLogger.logError(universeFileException);
                        continue;
                    }
                    catch (JUpgradeNotSupportedException jUpgradeNotSupportedException) {
                        ServiceLogger.logError(jUpgradeNotSupportedException);
                        continue;
                    }
                    catch (WriteFailureException writeFailureException) {
                        ServiceLogger.logError(writeFailureException);
                        continue;
                    }
                    hashtable = new Hashtable();
                    hashtable.put("jrs.node_name", resource.getName());
                    hashtable.put("jrs.deploy_from_file", string7);
                    hashtable.put("jrs.node_type", String.valueOf(0));
                    try {
                        resourceInfo2 = ResourceToolkit.createResourceInfo(hashtable, string, this);
                    }
                    catch (UnknownResource unknownResource) {
                        ServiceLogger.logError(unknownResource);
                        continue;
                    }
                    this.addVersion(resource, resourceInfo2, string, null, "converted report");
                    continue;
                }
                if (!bl) continue;
                if (bl3) {
                    try {
                        converter.convertRptSchema(string8, string5, string5);
                    }
                    catch (ReadFailureException readFailureException) {
                        ServiceLogger.logError(readFailureException);
                    }
                    catch (UniverseFileException universeFileException) {
                        ServiceLogger.logError(universeFileException);
                    }
                    catch (JUpgradeNotSupportedException jUpgradeNotSupportedException) {
                        ServiceLogger.logError(jUpgradeNotSupportedException);
                    }
                    catch (WriteFailureException writeFailureException) {
                        ServiceLogger.logError(writeFailureException);
                    }
                    continue;
                }
                string4 = new File(string6).getName();
                string7 = string3 + File.separator + string4;
                try {
                    converter.convertRptSchema(string8, string5, string7);
                }
                catch (ReadFailureException readFailureException) {
                    ServiceLogger.logError(readFailureException);
                    continue;
                }
                catch (UniverseFileException universeFileException) {
                    ServiceLogger.logError(universeFileException);
                    continue;
                }
                catch (JUpgradeNotSupportedException jUpgradeNotSupportedException) {
                    ServiceLogger.logError(jUpgradeNotSupportedException);
                    continue;
                }
                catch (WriteFailureException writeFailureException) {
                    ServiceLogger.logError(writeFailureException);
                    continue;
                }
                hashtable = new Hashtable<String, String>();
                hashtable.put("jrs.node_name", resource.getName());
                hashtable.put("jrs.deploy_from_file", string7);
                hashtable.put("jrs.node_type", String.valueOf(0));
                resourceInfo2 = null;
                try {
                    resourceInfo2 = ResourceToolkit.createResourceInfo(hashtable, string, this);
                }
                catch (UnknownResource unknownResource) {
                    ServiceLogger.logError(unknownResource);
                    continue;
                }
                this.addVersion(resource, resourceInfo2, string, null, "converted report");
                continue;
            }
            if (n != 1) continue;
            string5 = resourceInfo.getRealPath();
            int n2 = string5.lastIndexOf(File.separator);
            String string9 = string5.substring(0, n2 + 1);
            string4 = string5.substring(n2 + 1);
            try {
                if (!ServerUtil.needCompileFml(string9, string4)) continue;
                ServerUtil.saveCatFml(string9, string4);
            }
            catch (ReadFailureException readFailureException) {
                ServiceLogger.logError(readFailureException);
            }
            catch (UniverseFileException universeFileException) {
                ServiceLogger.logError(universeFileException);
            }
            catch (FMLFileException fMLFileException) {
                ServiceLogger.logError(fMLFileException);
            }
            catch (WriteFailureException writeFailureException) {
                ServiceLogger.logError(writeFailureException);
            }
        }
        return null;
    }

    private String convertRptSchema(Resource resource) {
        Node node = resource.getParent();
        Folder folder = null;
        byte by = node.getNodeType();
        if (by == 1) {
            folder = (Folder)node;
        }
        Vector vector = folder.getChildren();
        int n = 0;
        while (n < vector.size()) {
            Resource resource2;
            ResourceInfo resourceInfo;
            int n2;
            Node node2 = (Node)vector.elementAt(n);
            byte by2 = node2.getNodeType();
            if (by2 == 2 && (n2 = (resourceInfo = (resource2 = (Resource)node2).getEntity()).getResourceType()) == 1) {
                return resourceInfo.getRealPath();
            }
            ++n;
        }
        return null;
    }

    public String getInheritedLinkedCatalog(Node node, String string) {
        String string2 = null;
        String string3 = this.clearPermissions("/USERFOLDERPATH/" + string);
        Node node2 = node.getParent();
        if (node.isRoot() || node.getAbsolutePath().equalsIgnoreCase(string3) || node2 == null) {
            if (ServerEnv.isEnableLinkedCatalog()) {
                string2 = ServerEnv.getLinkedCatalog();
            }
        } else if (node2.isEnableLinkedCatalog()) {
            string2 = !node2.isUseInherited() ? node2.getLinkedCatalog() : this.getInheritedLinkedCatalog(node2, string);
        }
        return string2;
    }

    public boolean isCatalogLinked(String string, String string2) {
        if (ServerEnv.isEnableLinkedCatalog() && ServerEnv.getLinkedCatalog().equalsIgnoreCase(string2)) {
            return true;
        }
        try {
            Vector vector = this.nodeTable.getAllNodeIDsByLinkCatalog(string2);
            if (vector != null && vector.size() > 0) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException.getMessage(), 3);
        }
        return false;
    }

    public void setResultVersionViewed(String string, String string2, int n, String string3, int n2) throws NoPrivilegeException, UnknownResource {
        Node node = this.getNodeByPath(string2, string);
        if (node != null && node.getNodeType() == 2) {
            Object object;
            Object object2;
            Resource resource = (Resource)node;
            Version version = null;
            int n3 = 0;
            if (resource.getResourceType() == 2 && resource.getResult() != null) {
                object2 = resource.getResult();
                object = object2.getAbsolutePath();
                if (this.getResourceAliasManager().isAliasNode(string2, string) || this.getResourceAliasManager().isAliasSubNode(string2, string)) {
                    object = string2 + ((String)object).substring(resource.getAbsolutePath().length());
                }
                if (!resource.isDynamic()) {
                    version = this.getVersion((String)object, n, string);
                    n3 = object2.getID();
                } else {
                    version = this.getVersion(resource.getResult(), n, string);
                    n3 = -1;
                }
            } else if (resource.getResourceType() == 3) {
                version = this.getVersion(string2, n, string);
                n3 = resource.getID();
            }
            if (n3 != 0) {
                object2 = (ResultVersionRecord)version.toVersionRecord(this, string);
                object = object2.getAllReportResultFiles();
                JRResultFiles jRResultFiles = string3 != null ? (JRResultFiles)((Hashtable)object).get(string3) : (JRResultFiles)object2.getAllResultFiles();
                jRResultFiles.setFormatViewed(JRResultFiles.getFormat(n2));
                this.DELETE.updateViewedFormats(n3, resource.getAbsolutePath(), n, string3, jRResultFiles.getFormatViewedStatus());
            }
        }
    }
}

