/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.api.ResultFiles;
import jet.server.api.ResultVersionRecord;
import jet.server.db.version.ResultDetailedInfo;
import jet.server.schedule.JRResultFiles;

public class ResultVersionRecordImpl
implements ResultVersionRecord {
    private String QOIV;
    private String add;
    private String elementAt;
    private String endsWith;
    private String equalsIgnoreCase;
    private String get;
    private String getAllResultFiles;
    private String getExtName;
    private long getNameWithoutExt;
    private Date getPlsResultBits;
    private Date getReportDisplayname;
    private int getResult;
    private int getResultFile;
    private String getResultFileNames;
    private int getSecConstraintBits;
    private Hashtable getTime = null;
    private int getViewedFormats = -1;

    public ResultVersionRecordImpl(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, String string8, long l, Date date, Date date2, int n2, String string9, int n3, int n4, Hashtable hashtable) {
        Serializable serializable;
        this.QOIV = string;
        this.add = string2 == null ? "" : string2;
        this.getResultFile = n;
        this.elementAt = string3 == null ? "" : string3;
        this.endsWith = string4 == null ? "" : string4;
        this.equalsIgnoreCase = string5 == null ? "" : string5;
        this.get = string6 == null ? "" : string6;
        this.getAllResultFiles = string7 == null ? "" : string7;
        this.getExtName = string8 == null ? "" : string8;
        this.getNameWithoutExt = l;
        Date date3 = this.getPlsResultBits = date == null ? new Date() : date;
        if (date2 == null) {
            serializable = new GregorianCalendar();
            serializable.add(1, 100);
            this.getReportDisplayname = serializable.getTime();
        } else {
            this.getReportDisplayname = date2;
        }
        this.getSecConstraintBits = n3;
        this.getResult = n2;
        this.getResultFileNames = string9;
        this.getViewedFormats = n4;
        this.getTime = new Hashtable();
        if (hashtable != null && hashtable.size() > 0) {
            this.QOIV(hashtable);
        } else if (string6.length() > 0) {
            serializable = null;
            serializable = l != 0L ? new JRResultFiles(string6, l, 0L, 0L, 0L, n4) : new JRResultFiles(CSUtil.getNameWithoutExt(string6), CSUtil.getExtName(string6));
            this.getTime.put("jrs.report_result", serializable);
        }
    }

    public String getCatalogFile() {
        return this.elementAt;
    }

    public Date getCreatedTime() {
        return this.getPlsResultBits;
    }

    public Date getExpirationTime() {
        return this.getReportDisplayname;
    }

    public int getLaunchType() {
        return this.getResult;
    }

    public String getParamFile() {
        return this.equalsIgnoreCase;
    }

    public String getReportFile() {
        return this.endsWith;
    }

    public String getResultFile() {
        ResultFiles resultFiles = this.getAllResultFiles();
        if (resultFiles != null) {
            Vector vector = resultFiles.getResultFileNames();
            return (String)vector.elementAt(0);
        }
        return null;
    }

    public ResultFiles getAllResultFiles() {
        Enumeration enumeration = this.getTime.keys();
        if (enumeration.hasMoreElements()) {
            Object v = this.getTime.get("jrs.report_result");
            if (v == null) {
                v = this.getTime.get("jrs.rst_result");
            }
            if (v == null) {
                v = this.getTime.get("jrs.rsd_result");
            }
            if (v == null) {
                String string = (String)enumeration.nextElement();
                v = this.getTime.get(string);
            }
            return (ResultFiles)v;
        }
        return null;
    }

    public Hashtable getAllReportResultFiles() {
        return this.getTime;
    }

    private void QOIV(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ResultDetailedInfo resultDetailedInfo = (ResultDetailedInfo)hashtable.get(string);
            String string2 = resultDetailedInfo.getResult();
            long l = resultDetailedInfo.getViewedFormats();
            long l2 = resultDetailedInfo.getPlsResultBits();
            long l3 = resultDetailedInfo.getSecConstraintBits();
            JRResultFiles jRResultFiles = null;
            if (string.equalsIgnoreCase("jrs.rst_result")) {
                if (string2.endsWith(".rst")) {
                    string2 = CSUtil.getNameWithoutExt(string2);
                }
                jRResultFiles = new JRResultFiles(string2, ".rst", l, l2, l3);
            } else if (string.equalsIgnoreCase("jrs.rsd_result")) {
                if (string2.endsWith(".rsd")) {
                    string2 = CSUtil.getNameWithoutExt(string2);
                }
                jRResultFiles = new JRResultFiles(string2, ".rsd", l, l2, l3);
            } else if (this.getNameWithoutExt != 0L) {
                jRResultFiles = new JRResultFiles(string2, this.getNameWithoutExt, l, l2, l3, this.getViewedFormats);
                jRResultFiles.removeFormat(0);
                jRResultFiles.removeFormat(12);
                String string3 = this.getDisplayName(resultDetailedInfo, string);
                jRResultFiles.setReportName(string);
                jRResultFiles.setReportDisplayName(string3);
            } else {
                jRResultFiles = new JRResultFiles(CSUtil.getNameWithoutExt(string2), CSUtil.getExtName(string2));
            }
            this.getTime.put(string, jRResultFiles);
        }
    }

    private String getDisplayName(ResultDetailedInfo resultDetailedInfo, String string) {
        String string2 = resultDetailedInfo.getReportDisplayname();
        if (string2 == null && !string.equalsIgnoreCase("jrs.rst_result") && !string.equalsIgnoreCase("jrs.rsd_result")) {
            string2 = string;
        }
        return string2;
    }

    public String getSubmitter() {
        return this.getExtName;
    }

    public String getTaskID() {
        return this.getAllResultFiles;
    }

    public String getVersionID() {
        return this.QOIV;
    }

    public String getVersionName() {
        return this.add;
    }

    public int getVersionNumber() {
        return this.getResultFile;
    }

    public Properties toProperties(Properties properties) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.version_id", this.getAllResultFiles);
        properties2.put("jrs.catalog", this.elementAt);
        properties2.put("jrs.report", this.endsWith);
        properties2.put("jrs.param_file", this.equalsIgnoreCase);
        if (this.getTime.get("jrs.report_result") != null) {
            JRResultFiles jRResultFiles = (JRResultFiles)this.getAllResultFiles();
            properties2.put("jrs.result", jRResultFiles == null ? null : jRResultFiles.getResultFileNames());
        } else {
            Vector vector = new Vector();
            Enumeration enumeration = this.getTime.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                JRResultFiles jRResultFiles = (JRResultFiles)this.getTime.get(string);
                Vector vector2 = jRResultFiles.getResultFileNames();
                int n = 0;
                while (n < vector2.size()) {
                    vector.add(vector2.elementAt(n));
                    ++n;
                }
            }
            properties2.put("jrs.result", vector);
        }
        properties2.put("jrs.created_time", String.valueOf(this.getPlsResultBits.getTime()));
        properties2.put("jrs.expired_time", String.valueOf(this.getReportDisplayname.getTime()));
        properties2.put("jrs.uid", this.getExtName);
        properties2.put("jrs.version_number", String.valueOf(this.getResultFile));
        properties2.put("jrs.version_name", this.add);
        return properties2;
    }

    public String getCreator() {
        return this.getExtName;
    }

    public String getResourcePath() {
        return this.getResultFileNames;
    }

    public String getRealPath() {
        return this.getResultFile();
    }

    public int getExpirationMethod() {
        return this.getSecConstraintBits;
    }
}

