/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource.nls;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import jet.cs.util.APIUtil;
import jet.jetc.ReadFailureException;
import jet.jetc.ReportLoader;
import jet.report.JReportUtil;
import jet.reportset.JetRptReportSet;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.intf.resource.NLSManager;
import jet.server.jrc.resource.nls.NLSContent;
import jet.server.jrc.resource.nls.NLSFontMap;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.jrc.resource.nls.xml.NLSFontMapXMLReader;
import jet.server.jrc.resource.nls.xml.NLSFontMapXMLWriter;
import jet.server.log.ServiceLogger;
import jet.universe.JetUParameter;
import jet.universe.JetUUniverse;
import jet.universe.exception.UniverseFileException;
import jet.util.NLSResourceBundle;
import jet.util.NLSResourceBundleManager;
import org.xml.sax.SAXException;

public class NLSManagerImpl
implements NLSManager {
    private Hashtable C;
    private String I = ServerEnv.propertiesPath + "FontMaps.xml";
    private NLSFontMapXMLWriter LoadUniverse = new NLSFontMapXMLWriter();

    public NLSManagerImpl() {
        File file = new File(this.I);
        if (file.exists()) {
            NLSFontMapXMLReader nLSFontMapXMLReader = new NLSFontMapXMLReader();
            try {
                this.C = nLSFontMapXMLReader.read(this.I);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ServiceLogger.logError(parserConfigurationException);
                this.C = new Hashtable();
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
                this.C = new Hashtable();
            }
            catch (SAXException sAXException) {
                ServiceLogger.logError(sAXException);
                this.C = new Hashtable();
            }
        } else {
            this.C = new Hashtable();
        }
    }

    public Locale[] getAvailableLocalesOfReport(String string, int n, String string2) throws UnknownResource, NoPrivilegeException {
        String string3 = this.C(string, n, string2);
        return NLSResourceBundleManager.getAvailableLocalesOfReport((String)string3);
    }

    public Locale[] getAvailableLocalesOfReport(String string) throws UnknownResource {
        return NLSResourceBundleManager.getAvailableLocalesOfReport((String)string);
    }

    public NLSContent getAvailableCategoryContents(String string, int n, Locale locale, String string2) throws UnknownResource, NoPrivilegeException, IOException {
        String string3 = this.C(string, n, string2);
        Map[] mapArray = NLSResourceBundleManager.getAvailableCategoryContents((String)string3, (Locale)locale, null, (boolean)true);
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.loadReportNLS((String)string3, (Locale)locale);
        Map[] mapArray2 = new Map[]{NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_LABEL_TEXT], 0), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_FORMAT_TEXT], 1), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_FONT_TEXT], 2), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_COLUMN_TEXT], 3), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_PARAM_PROMPT], 4), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_TOC_TEXT], 5)};
        NLSContent nLSContent = new NLSContent(locale);
        nLSContent.setContent(mapArray2);
        nLSContent.setReportPath(string);
        nLSContent.setVersionNumber(n);
        nLSContent.setEncoding(nLSResourceBundle.getEncoding());
        if (mapArray2[0].size() == 0 && mapArray2[3].size() == 0 && mapArray2[4].size() == 0 && mapArray2[5].size() == 0) {
            nLSContent.setEnableLabel(false);
        }
        if (mapArray2[1].size() == 0) {
            nLSContent.setEnableFormat(false);
        }
        if (mapArray2[2].size() == 0) {
            nLSContent.setEnableFont(false);
        }
        return nLSContent;
    }

    public NLSContent getAvailableCategoryContents(String string, Locale locale) throws UnknownResource, IOException {
        Map[] mapArray = NLSResourceBundleManager.getAvailableCategoryContents((String)string, (Locale)locale, null, (boolean)true);
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.loadReportNLS((String)string, (Locale)locale);
        Map[] mapArray2 = new Map[]{NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_LABEL_TEXT], 0), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_FORMAT_TEXT], 1), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_FONT_TEXT], 2), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_COLUMN_TEXT], 3), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_PARAM_PROMPT], 4), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_TOC_TEXT], 5)};
        NLSContent nLSContent = new NLSContent(locale);
        nLSContent.setContent(mapArray2);
        nLSContent.setReportPath(string);
        nLSContent.setVersionNumber(-1);
        nLSContent.setEncoding(nLSResourceBundle.getEncoding());
        if (mapArray2[0].size() == 0 && mapArray2[3].size() == 0 && mapArray2[4].size() == 0 && mapArray2[5].size() == 0) {
            nLSContent.setEnableLabel(false);
        }
        if (mapArray2[1].size() == 0) {
            nLSContent.setEnableFormat(false);
        }
        if (mapArray2[2].size() == 0) {
            nLSContent.setEnableFont(false);
        }
        return nLSContent;
    }

    public Map[] getAvailableContentsFromReport(String string, int n, String string2, int n2, Locale locale, String string3) throws UnknownResource, NoPrivilegeException, ReadFailureException {
        String string4 = this.C(string, n, string3);
        String string5 = this.I(string2, n2, string3);
        ReportLoader reportLoader = new ReportLoader(string4);
        JetRptReportSet jetRptReportSet = (JetRptReportSet)reportLoader.loadObject(true, locale);
        try {
            jetRptReportSet.setUniverse(JetUUniverse.LoadUniverse((String)string5));
        }
        catch (UniverseFileException universeFileException) {
            ServiceLogger.logError(universeFileException);
        }
        Map[] mapArray = NLSResourceBundleManager.getAvailableContentsFromReport((JetRptReportSet)jetRptReportSet);
        Map[] mapArray2 = new Map[]{NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_LABEL_TEXT], 0), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_FORMAT_TEXT], 1), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_FONT_TEXT], 2), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_COLUMN_TEXT], 3), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_PARAM_PROMPT], 4), NLSUtil.clearEmptyProperty(mapArray[NLSResourceBundleManager.IDX_CATEGORY_TOC_TEXT], 5)};
        return mapArray2;
    }

    public Map[] getAllAvailableContentsFromReport(String string, String string2, Locale locale) throws UnknownResource, ReadFailureException {
        ReportLoader reportLoader = new ReportLoader(string);
        JetRptReportSet jetRptReportSet = (JetRptReportSet)reportLoader.loadObject(true, locale);
        try {
            jetRptReportSet.setUniverse(JetUUniverse.LoadUniverse((String)string2));
        }
        catch (UniverseFileException universeFileException) {
            ServiceLogger.logError(universeFileException);
        }
        return NLSResourceBundleManager.getAvailableContentsFromReport((JetRptReportSet)jetRptReportSet);
    }

    public String[] getAvailableEncoding() {
        return NLSResourceBundleManager.getAvailableEncoding();
    }

    public Locale[] getAvailableLocales() {
        Locale[] localeArray = Locale.getAvailableLocales();
        Arrays.sort(localeArray, new Comparator(this){
            private final NLSManagerImpl this$0;
            {
                this.this$0 = nLSManagerImpl;
            }

            public int compare(Object object, Object object2) {
                if (object == null || object2 == null) {
                    return 0;
                }
                return object.toString().compareTo(object2.toString());
            }
        });
        return localeArray;
    }

    public void saveReportNLS(NLSContent nLSContent, String string) throws UnknownResource, NoPrivilegeException, IOException {
        String string2 = this.C(nLSContent.getReportPath(), nLSContent.getVersionNumber(), string);
        Map[] mapArray = NLSResourceBundleManager.getAvailableCategoryContents((String)string2, (Locale)nLSContent.getLocale(), null, (boolean)true);
        if (nLSContent.isEnableLabel()) {
            mapArray[NLSResourceBundleManager.IDX_CATEGORY_LABEL_TEXT] = nLSContent.getContent()[0];
            mapArray[NLSResourceBundleManager.IDX_CATEGORY_COLUMN_TEXT] = nLSContent.getContent()[3];
            mapArray[NLSResourceBundleManager.IDX_CATEGORY_PARAM_PROMPT] = nLSContent.getContent()[4];
            mapArray[NLSResourceBundleManager.IDX_CATEGORY_TOC_TEXT] = nLSContent.getContent()[5];
        } else {
            mapArray[NLSResourceBundleManager.IDX_CATEGORY_LABEL_TEXT] = new Hashtable();
            mapArray[NLSResourceBundleManager.IDX_CATEGORY_COLUMN_TEXT] = new Hashtable();
            mapArray[NLSResourceBundleManager.IDX_CATEGORY_PARAM_PROMPT] = new Hashtable();
            mapArray[NLSResourceBundleManager.IDX_CATEGORY_TOC_TEXT] = new Hashtable();
        }
        mapArray[NLSResourceBundleManager.IDX_CATEGORY_FORMAT_TEXT] = nLSContent.isEnableFormat() ? nLSContent.getContent()[1] : new Hashtable();
        mapArray[NLSResourceBundleManager.IDX_CATEGORY_FONT_TEXT] = nLSContent.isEnableFont() ? nLSContent.getContent()[2] : new Hashtable();
        NLSResourceBundleManager.saveReportNLS((String)string2, (Locale)nLSContent.getLocale(), (String)nLSContent.getEncoding(), (Map[])mapArray);
    }

    public void removeReportNLS(NLSContent nLSContent, String string) throws UnknownResource, NoPrivilegeException, IOException {
        String string2 = this.C(nLSContent.getReportPath(), nLSContent.getVersionNumber(), string);
        NLSResourceBundleManager.removeReportNLSResource((String)string2, (Locale)nLSContent.getLocale());
    }

    private String C(String string, int n, String string2) throws UnknownResource, NoPrivilegeException {
        if (n == NLSUtil.NLS_SUB_REPORT_VERSION_NUMBER) {
            return string;
        }
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        return httpRptServer.getResourceManager().getReportVersion(string2, string, n).getRealPath();
    }

    private String I(String string, int n, String string2) throws UnknownResource, NoPrivilegeException {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        return httpRptServer.getResourceManager().getCatalogVersion(string2, string, n).getRealPath();
    }

    public String getEncoding(String string, int n, Locale locale, String string2) throws UnknownResource, NoPrivilegeException, IOException {
        String string3 = this.C(string, n, string2);
        NLSResourceBundle nLSResourceBundle = NLSResourceBundleManager.loadReportNLS((String)string3, (Locale)locale);
        return nLSResourceBundle.getEncoding();
    }

    public synchronized void setFontMap(NLSFontMap nLSFontMap, String string) {
        this.C.put(nLSFontMap.getLocale(), nLSFontMap);
        try {
            this.LoadUniverse.writeFontMapInfo(this.I, this.C);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    public synchronized Locale[] getAvailableLocalesOfFontMaps(String string) {
        Locale[] localeArray = new Locale[this.C.size()];
        Enumeration enumeration = this.C.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            localeArray[n] = (Locale)enumeration.nextElement();
            if (n >= localeArray.length) break;
            ++n;
        }
        return localeArray;
    }

    public NLSFontMap getFontMap(Locale locale, String string) {
        return (NLSFontMap)this.C.get(locale);
    }

    public void removeFontMap(Locale locale, String string) {
        this.C.remove(locale);
        try {
            this.LoadUniverse.writeFontMapInfo(this.I, this.C);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    public boolean isNationalLanguageSupport(String string, int n, String string2) throws UnknownResource, NoPrivilegeException {
        String string3 = this.C(string, n, string2);
        try {
            return JReportUtil.isNationalLanguageSupport((String)string3);
        }
        catch (ReadFailureException readFailureException) {
            ServiceLogger.logError(readFailureException);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
        return false;
    }

    public String[] getAllSubReportsFromMainReportRealPath(String string, int n, String string2) throws UnknownResource, NoPrivilegeException {
        Serializable serializable;
        Object object;
        if (n == 1) {
            object = HttpUtil.getHttpRptServer();
            try {
                serializable = object.getResourceManager().getPathInfo(string2, string);
                if (serializable.isDynamic()) {
                    return new String[0];
                }
            }
            catch (RptServerException rptServerException) {
                ServiceLogger.logError(rptServerException);
                return new String[0];
            }
        }
        if ((object = this.C(string, n, string2)) == null) {
            return new String[0];
        }
        if (((String)object).endsWith(File.separator)) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        serializable = new ArrayList();
        int n2 = ((String)object).lastIndexOf(File.separator);
        String string3 = ((String)object).substring(0, n2 + 1);
        String string4 = ((String)object).substring(n2 + 1);
        File file = new File((String)object);
        File file2 = file.getParentFile();
        String[] stringArray = file2.list();
        int n3 = 0;
        while (n3 < stringArray.length) {
            String string5 = string3 + stringArray[n3];
            if (APIUtil.isReportFile(string5) && !stringArray[n3].equals(string4)) {
                ((ArrayList)serializable).add(string5);
            }
            ++n3;
        }
        return ((ArrayList)serializable).toArray(new String[((ArrayList)serializable).size()]);
    }

    public Properties getGlobalNls(int n, Locale locale) {
        ServiceLogger.logDebug("Try to load Global Nls: globalNlsType=" + n + ", locale=" + locale, 6);
        if (locale == null) {
            return null;
        }
        String string = ServerEnv.getReportHome();
        String string2 = "en";
        String string3 = locale.getLanguage().toLowerCase();
        if (locale.getCountry().length() > 0) {
            string3 = string3 + "-" + locale.getCountry().toLowerCase();
        }
        string3 = string3.equals(string2) ? null : string3;
        String[] stringArray = new String[]{string3, string2};
        String string4 = "report.properties";
        String string5 = "{0}resources/report/languages/{1}/properties/{2}";
        Properties properties = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string6 = stringArray[n2];
            if (string6 != null) {
                String string7 = MessageFormat.format(string5, string, string6, string4);
                properties = this.IDX_CATEGORY_COLUMN_TEXT(string7 = string7.replace('/', File.separatorChar), true);
                if (properties != null || (properties = this.IDX_CATEGORY_COLUMN_TEXT(string7 = MessageFormat.format(string5, "", string6, string4), false)) != null) break;
            }
            ++n2;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Properties IDX_CATEGORY_COLUMN_TEXT(String string, boolean bl) {
        Properties properties;
        block12: {
            properties = null;
            InputStream inputStream = null;
            inputStream = bl ? new FileInputStream(string) : this.getClass().getResourceAsStream(string);
            properties = new Properties();
            properties.load(inputStream);
            Object var7_5 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block12;
            }
            catch (Throwable throwable) {}
            break block12;
            {
                catch (Throwable throwable) {
                    properties = null;
                    Object var7_6 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block12;
                    }
                    catch (Throwable throwable2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (properties != null) {
            ServiceLogger.logDebug("Load Global Nls successfully, path=" + string, 6);
        }
        return properties;
    }

    public void saveGlobalNls(int n, Locale locale, Properties properties) {
        ServiceLogger.logDebug("saveGlobalNls: not implement yet.");
    }

    public Map getParameterNamesMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            JetUUniverse jetUUniverse = JetUUniverse.LoadUniverse((String)string);
            Vector vector = jetUUniverse.getParameters();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                String string2 = ((JetUParameter)iterator.next()).getParamDesc().getName();
                hashMap.put(string2.toUpperCase(), string2);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        return hashMap;
    }
}

