/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.resource.nls;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import jet.cs.util.APIUtil;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.UnknownResource;
import jet.server.intf.resource.NLSManager;
import jet.server.jrc.resource.nls.FontNameComparator;
import jet.server.jrc.resource.nls.NLSComparator;
import jet.server.jrc.resource.nls.NLSContent;
import jet.server.jrc.resource.nls.NLSFontInfo;
import jet.server.jrc.resource.nls.NLSFontMap;
import jet.server.jrc.resource.nls.NLSSorter;
import jet.server.jrc.resource.nls.NLSStorage;
import jet.server.jrc.resource.nls.NLSStringParser;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;
import jet.util.FontSets;
import jet.util.NLSResourceBundle;

public class NLSWebPageHelper {
    public static Map ALLNLSCONTENTS = new HashMap();
    public static Hashtable TEMPFONTMAPS = new Hashtable();
    private static Map QOIV = new HashMap();

    public static NLSStorage createNLSStorage(String string) {
        NLSStorage nLSStorage = new NLSStorage(string);
        ALLNLSCONTENTS.put(string, nLSStorage);
        return nLSStorage;
    }

    public static void removeNSLStorage(String string) {
        ALLNLSCONTENTS.remove(string);
        QOIV.remove(string);
    }

    public static Locale[] getAvailableLocalesOfReport(String string, int n, String string2) {
        Locale[] localeArray;
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        try {
            localeArray = nLSManager.getAvailableLocalesOfReport(string, n, string2);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource);
            return null;
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
            return null;
        }
        if (localeArray == null || localeArray.length < 0) {
            return null;
        }
        return localeArray;
    }

    public static String initStorage(String string, int n, String string2) {
        Locale[] localeArray;
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        try {
            localeArray = nLSManager.getAvailableLocalesOfReport(string, n, string2);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource);
            return null;
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
            return null;
        }
        if (localeArray == null || localeArray.length < 0) {
            return null;
        }
        String string3 = string2 + "[" + System.currentTimeMillis() + ":" + string + ":" + n + "]";
        NLSStorage nLSStorage = NLSWebPageHelper.createNLSStorage(string3);
        int n2 = 0;
        while (n2 < localeArray.length) {
            block9: {
                NLSContent nLSContent;
                Locale locale = localeArray[n2];
                try {
                    nLSContent = nLSManager.getAvailableCategoryContents(string, n, locale, string2);
                }
                catch (UnknownResource unknownResource) {
                    ServiceLogger.logError(unknownResource);
                    break block9;
                }
                catch (NoPrivilegeException noPrivilegeException) {
                    ServiceLogger.logError(noPrivilegeException);
                    break block9;
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                    break block9;
                }
                nLSStorage.setContent(nLSContent);
            }
            ++n2;
        }
        return string3;
    }

    public static void addNewContent(String string, String string2, int n, Locale locale) {
        NLSContent nLSContent;
        NLSStorage nLSStorage = (NLSStorage)ALLNLSCONTENTS.get(string);
        if (nLSStorage == null) {
            nLSStorage = NLSWebPageHelper.createNLSStorage(string);
        }
        if ((nLSContent = nLSStorage.getContent(locale)) == null) {
            nLSContent = new NLSContent(locale);
            nLSStorage.setContent(nLSContent);
        }
        Map[] mapArray = new Hashtable[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};
        nLSContent.setContent(mapArray);
        nLSContent.setReportPath(string2);
        nLSContent.setVersionNumber(n);
    }

    public static void setContent(String string, NLSContent nLSContent) {
        NLSStorage nLSStorage = (NLSStorage)ALLNLSCONTENTS.get(string);
        if (nLSStorage == null) {
            nLSStorage = NLSWebPageHelper.createNLSStorage(string);
        }
        nLSStorage.setContent(nLSContent);
    }

    public static Locale[] getAvailableLocales(String string) {
        NLSStorage nLSStorage = (NLSStorage)ALLNLSCONTENTS.get(string);
        if (nLSStorage == null) {
            return null;
        }
        Set set = nLSStorage.getLocales();
        Locale[] localeArray = new Locale[set.size()];
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            localeArray[n] = (Locale)iterator.next();
            ++n;
        }
        return localeArray;
    }

    public static NLSContent getContent(String string, Locale locale) {
        NLSStorage nLSStorage = (NLSStorage)ALLNLSCONTENTS.get(string);
        if (nLSStorage == null) {
            return null;
        }
        return nLSStorage.getContent(locale);
    }

    public static String getEncoding(String string, Locale locale) {
        NLSStorage nLSStorage = (NLSStorage)ALLNLSCONTENTS.get(string);
        if (nLSStorage == null) {
            return null;
        }
        NLSContent nLSContent = nLSStorage.getContent(locale);
        return nLSContent.getEncoding();
    }

    public static void submitContent(String string, String string2) {
        NLSStorage nLSStorage = (NLSStorage)ALLNLSCONTENTS.get(string);
        if (nLSStorage != null) {
            NLSContent nLSContent;
            Object object;
            Set set = nLSStorage.getLocales();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (Locale)iterator.next();
                nLSContent = nLSStorage.getContent((Locale)object);
                NLSWebPageHelper.submit(nLSContent, string2);
            }
            object = nLSStorage.getRemovedContents().iterator();
            while (object.hasNext()) {
                nLSContent = (NLSContent)object.next();
                NLSWebPageHelper.ALLNLSCONTENTS(nLSContent, string2);
            }
        }
    }

    private static void submit(NLSContent nLSContent, String string) {
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        try {
            nLSManager.saveReportNLS(nLSContent, string);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    public static void removeLocale(String string, Locale locale, String string2) {
        NLSStorage nLSStorage = (NLSStorage)ALLNLSCONTENTS.get(string);
        if (nLSStorage != null) {
            nLSStorage.removeLocale(locale);
        }
    }

    private static void ALLNLSCONTENTS(NLSContent nLSContent, String string) {
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        try {
            nLSManager.removeReportNLS(nLSContent, string);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource);
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    public static boolean isValidID(String string) {
        NLSStorage nLSStorage = (NLSStorage)ALLNLSCONTENTS.get(string);
        return nLSStorage != null;
    }

    public static String createTempFontMapContent(String string) {
        String string2 = string + "[" + System.currentTimeMillis() + "]";
        NLSFontMap nLSFontMap = new NLSFontMap();
        TEMPFONTMAPS.put(string2, nLSFontMap);
        return string2;
    }

    public static String initFontMapContent(String string, Locale locale) {
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        String string2 = string + "[" + System.currentTimeMillis() + "]";
        NLSFontMap nLSFontMap = nLSManager.getFontMap(locale, string);
        NLSFontMap nLSFontMap2 = nLSFontMap.getInstance();
        TEMPFONTMAPS.put(string2, nLSFontMap2);
        return string2;
    }

    public static String addFontInfo(String string, NLSFontInfo nLSFontInfo) {
        NLSFontMap nLSFontMap = (NLSFontMap)TEMPFONTMAPS.get(string);
        if (nLSFontMap == null) {
            nLSFontMap = new NLSFontMap();
            TEMPFONTMAPS.put(string, nLSFontMap);
        }
        String string2 = NLSWebPageHelper.createFontInfoName(nLSFontInfo);
        nLSFontMap.setFontInfo(string2, nLSFontInfo);
        return string2;
    }

    public static void editFontInfo(String string, String string2, NLSFontInfo nLSFontInfo) {
        NLSFontMap nLSFontMap = (NLSFontMap)TEMPFONTMAPS.get(string);
        if (nLSFontMap == null) {
            return;
        }
        nLSFontMap.setFontInfo(string2, nLSFontInfo);
    }

    public static void setFontMapEncoding(String string, String string2) {
        NLSFontMap nLSFontMap = (NLSFontMap)TEMPFONTMAPS.get(string);
        if (nLSFontMap == null) {
            return;
        }
        nLSFontMap.setEncoding(string2);
    }

    public static void setFontMapLocale(String string, Locale locale) {
        NLSFontMap nLSFontMap = (NLSFontMap)TEMPFONTMAPS.get(string);
        if (nLSFontMap == null) {
            return;
        }
        nLSFontMap.setLocale(locale);
    }

    public static void removeFontInfo(String string, String string2) {
        NLSFontMap nLSFontMap = (NLSFontMap)TEMPFONTMAPS.get(string);
        if (nLSFontMap == null) {
            return;
        }
        nLSFontMap.removeFontInfo(string2);
    }

    public static void submitFontMap(String string, String string2) {
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        NLSFontMap nLSFontMap = (NLSFontMap)TEMPFONTMAPS.get(string);
        if (nLSFontMap == null) {
            return;
        }
        nLSManager.setFontMap(nLSFontMap, string2);
        TEMPFONTMAPS.remove(string);
    }

    public static void removeFontMap(Locale locale, String string) {
        NLSManager nLSManager = UserDataToolkit.getNLSManager();
        nLSManager.removeFontMap(locale, string);
    }

    public static Locale[] getAvailableLocalesOfFontMaps(String string) {
        return UserDataToolkit.getNLSManager().getAvailableLocalesOfFontMaps(string);
    }

    public static Locale[] getAllAvailableLocales() {
        return UserDataToolkit.getNLSManager().getAvailableLocales();
    }

    public static String[] getAvailableEncoding() {
        return UserDataToolkit.getNLSManager().getAvailableEncoding();
    }

    public static NLSFontMap getFontInfoContent(String string) {
        return (NLSFontMap)TEMPFONTMAPS.get(string);
    }

    public static double getPointSize(double d) {
        double d2 = d * 72.0 / 5760.0;
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d2));
        BigDecimal bigDecimal2 = bigDecimal.setScale(1, 4);
        d2 = bigDecimal2.doubleValue();
        String string = String.valueOf(d2);
        String string2 = string.substring(string.indexOf(".") + 1);
        String string3 = string.substring(0, string.indexOf("."));
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string3);
        double d3 = 0.0;
        if (n < 5) {
            d3 = Double.parseDouble(string3);
        }
        if (n == 5) {
            d3 = Double.parseDouble(string3 + "." + "5");
        }
        if (n > 5) {
            String string4 = String.valueOf(n2 + 1);
            d3 = Double.parseDouble(string4);
        }
        return d3;
    }

    public static long getUnit(double d) {
        return Math.round(d * 5760.0 / 72.0);
    }

    public static String[] parseFontContext(String string) {
        return NLSResourceBundle.parseFontContext((String)string);
    }

    public static String mergeFontContext(String string, String string2) {
        return NLSResourceBundle.mergeFontContext((String)string, (String)string2);
    }

    public static String createFontInfoName(NLSFontInfo nLSFontInfo) {
        String string = nLSFontInfo.getOriginalFontFace();
        double d = nLSFontInfo.getOriginalFontSize();
        boolean bl = nLSFontInfo.isIgnoreSize();
        String string2 = !bl ? String.valueOf(d) : "*";
        String string3 = string + NLSUtil.VALUES_CONCAT_CHAR + string2;
        String string4 = nLSFontInfo.getTargetFontFace();
        String string5 = String.valueOf(nLSFontInfo.getTargetFontSize());
        boolean bl2 = nLSFontInfo.isRelative();
        String string6 = string4 + NLSUtil.VALUES_CONCAT_CHAR + string5 + NLSUtil.VALUES_CONCAT_CHAR + bl2;
        return "FontInfo[" + System.currentTimeMillis() + ":" + string3 + ":" + string6 + "]";
    }

    public static List getSizeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 7;
        while (n < 73) {
            arrayList.add(String.valueOf(n));
            ++n;
        }
        return arrayList;
    }

    public static List getFaceList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = FontSets.getAllFonts();
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        if (!arrayList.contains("Default")) {
            arrayList.add("Default");
            FontNameComparator fontNameComparator = new FontNameComparator();
            NLSSorter.sort(arrayList, (NLSComparator)fontNameComparator);
        }
        return arrayList;
    }

    public static Locale[] parseAcceptLanguage(String string) {
        int n;
        int n2;
        if (string == null || string.length() == 0) {
            return new Locale[0];
        }
        NLSStringParser nLSStringParser = new NLSStringParser();
        TreeMap<Object, ArrayList<Locale>> treeMap = new TreeMap<Object, ArrayList<Locale>>();
        int n3 = string.indexOf(32);
        if (n3 < 0) {
            n3 = string.indexOf(9);
        }
        if (n3 >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            n2 = string.length();
            n = 0;
            while (n < n2) {
                char c = string.charAt(n);
                if (c != ' ' && c != '\t') {
                    stringBuffer.append(c);
                }
                ++n;
            }
            string = stringBuffer.toString();
        }
        nLSStringParser.setString(string);
        int n4 = nLSStringParser.getLength();
        while ((n2 = nLSStringParser.getIndex()) < n4) {
            Object object;
            String string2;
            Object object2;
            String string3;
            n = nLSStringParser.findChar(',');
            String string4 = nLSStringParser.extract(n2, n).trim();
            nLSStringParser.advance();
            double d = 1.0;
            int n5 = string4.indexOf(";q=");
            if (n5 >= 0) {
                try {
                    d = Double.parseDouble(string4.substring(n5 + 3));
                }
                catch (NumberFormatException numberFormatException) {
                    d = 0.0;
                }
                string4 = string4.substring(0, n5);
            }
            if (d < 5.0E-5 || "*".equals(string4)) continue;
            int n6 = string4.indexOf(45);
            if (n6 < 0) {
                string3 = string4;
                object2 = "";
                string2 = "";
            } else {
                string3 = string4.substring(0, n6);
                object2 = string4.substring(n6 + 1);
                int n7 = ((String)object2).indexOf(45);
                if (n7 > 0) {
                    object = ((String)object2).substring(0, n7);
                    string2 = ((String)object2).substring(n7 + 1);
                    object2 = object;
                } else {
                    string2 = "";
                }
            }
            Locale locale = new Locale(string3, (String)object2, string2);
            object = new Double(-d);
            ArrayList<Locale> arrayList = (ArrayList<Locale>)treeMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<Locale>();
                treeMap.put(object, arrayList);
            }
            arrayList.add(locale);
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Double d = (Double)iterator.next();
            ArrayList arrayList2 = (ArrayList)treeMap.get(d);
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                Locale locale = (Locale)iterator2.next();
                arrayList.add(locale);
            }
        }
        Locale[] localeArray = new Locale[arrayList.size()];
        arrayList.toArray(localeArray);
        return localeArray;
    }

    public static boolean isNationalLanguageSupport(String string, int n, String string2) {
        try {
            return UserDataToolkit.getNLSManager().isNationalLanguageSupport(string, n, string2);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource);
            return false;
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
            return false;
        }
    }

    public static Locale getPreferenceLocale(Properties properties, String string, Vector vector) {
        boolean bl = APIUtil.getBoolean(properties.getProperty("enable_setting_display_language"), false);
        Locale locale = null;
        if (bl) {
            String string2 = properties.getProperty("locale_nls");
            if (string2 != null && string2.length() != 0) {
                String string3 = "";
                String string4 = "";
                String string5 = "";
                int n = string2.indexOf("_");
                if (n > 0) {
                    string3 = string2.substring(0, n);
                    if ((n = (string2 = string2.substring(n + 1)).indexOf("_")) > 0) {
                        string4 = string2.substring(0, n);
                        string5 = string2.substring(n + 1);
                    } else {
                        string4 = string2;
                    }
                } else {
                    string3 = string2;
                }
                locale = new Locale(string3, string4, string5);
            }
        } else {
            Locale[] localeArray = NLSWebPageHelper.parseAcceptLanguage(string);
            int n = 0;
            while (n < localeArray.length) {
                Locale locale2 = localeArray[n];
                if (vector.contains(locale2)) {
                    locale = locale2;
                    break;
                }
                ++n;
            }
        }
        return locale;
    }

    public static String[] getAllSubReportsFromMainReportRealPath(String string, int n, String string2) {
        try {
            return UserDataToolkit.getNLSManager().getAllSubReportsFromMainReportRealPath(string, n, string2);
        }
        catch (UnknownResource unknownResource) {
            ServiceLogger.logError(unknownResource);
            return null;
        }
        catch (NoPrivilegeException noPrivilegeException) {
            ServiceLogger.logError(noPrivilegeException);
            return null;
        }
    }

    public static Map getParameterNamesMap(String string, String string2) {
        Map map = null;
        try {
            HashMap<String, Map> hashMap = (HashMap<String, Map>)QOIV.get(string);
            if (hashMap == null) {
                hashMap = new HashMap<String, Map>();
                QOIV.put(string, hashMap);
            }
            if ((map = (Map)hashMap.get(string2)) == null) {
                map = UserDataToolkit.getNLSManager().getParameterNamesMap(string2);
                hashMap.put(string2, map);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return map;
    }
}

