/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.security.acl.NotOwnerException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JAclEntryImpl;
import jet.server.api.custom.JRCustomerException;
import jet.server.event.EventHandler;
import jet.server.event.SelectorImpl;
import jet.server.event.Subscriber;
import jet.server.event.TopicEvent;
import jet.server.event.subscriber.SubscribeService;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.User;
import jet.server.jrc.security.PermissionUtil;
import jet.server.jrc.security.cache.CachedSecurityDataImpl;
import jet.server.jrc.security.config.intf.SecurityProvidersManager;
import jet.server.jrc.security.custom.SecurityUtil;
import jet.server.jrc.security.event.EventUtil;
import jet.server.log.ServiceLogger;

public class ExCachedSecurityDataImpl
extends CachedSecurityDataImpl
implements EventHandler {
    private Subscriber QOIV = null;
    String activate;

    public ExCachedSecurityDataImpl(String string, SecurityProvidersManager securityProvidersManager) {
        super(string, securityProvidersManager);
        SubscribeService subscribeService = SubscribeService.newInstance();
        this.QOIV = subscribeService.createSubscriber(this);
        try {
            this.QOIV.activate();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        this.activate = EventUtil.createTopic(string, "security_event_name");
        SelectorImpl selectorImpl = new SelectorImpl(this.activate, 32);
        selectorImpl.enableAll();
        this.QOIV.addSelector(selectorImpl);
        boolean bl = this.QOIV.isValid();
        if (bl) {
            this.start();
        }
    }

    public void start() {
        if (this.isStart()) {
            return;
        }
        try {
            this.QOIV.activate();
            ServiceLogger.logEvent(5630074, this.activate, 5);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public boolean isStart() {
        return this.QOIV.isActive();
    }

    public void stop() {
        if (!this.isStart()) {
            return;
        }
        try {
            this.QOIV.deactivate();
            ServiceLogger.logEvent(5630075, this.activate, 5);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void process(TopicEvent topicEvent) {
        int n = topicEvent.getType();
        switch (n) {
            case 0: {
                this.securityCache.clear();
                break;
            }
            case 1: {
                Properties properties = (Properties)topicEvent.getData();
                this.QOIV(properties);
                break;
            }
            case 2: {
                Properties properties = (Properties)topicEvent.getData();
                this.addParentGroup(properties);
                break;
            }
            case 3: {
                Properties properties = (Properties)topicEvent.getData();
                this.addSubUser(properties);
                break;
            }
            case 4: {
                Properties properties = (Properties)topicEvent.getData();
                this.deactivate(properties);
                break;
            }
            case 5: {
                Properties properties = (Properties)topicEvent.getData();
                this.finalize(properties);
                break;
            }
            case 6: {
                Properties properties = (Properties)topicEvent.getData();
                this.get(properties);
                break;
            }
        }
    }

    private void QOIV(Properties properties) {
        String string = properties.getProperty("security_event_para_principal");
        if (string == null) {
            return;
        }
        String string2 = properties.getProperty("security_event_para_principal_type");
        if (string2 == null) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException);
            return;
        }
        switch (n) {
            case 1: {
                this.activate(string);
                break;
            }
            case 2: {
                this.addEntry(string);
                break;
            }
            case 3: {
                this.addGroup(string);
                break;
            }
        }
    }

    private void activate(String string) {
        this.getUser(string);
    }

    private void addEntry(String string) {
        this.getRole(string);
    }

    private void addGroup(String string) {
        this.getGroup(string);
    }

    private void addParentGroup(Properties properties) {
        String string = properties.getProperty("security_event_para_principal");
        if (string == null) {
            return;
        }
        String string2 = properties.getProperty("security_event_para_principal_type");
        if (string2 == null) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException);
            return;
        }
        switch (n) {
            case 1: {
                this.addParentRole(string);
                break;
            }
            case 2: {
                this.addRole(string);
                break;
            }
            case 3: {
                this.addSubGroup(string);
                break;
            }
        }
    }

    private void addParentRole(String string) {
        User user = this.securityCache.getUser(string);
        if (user != null) {
            Object object;
            Vector vector = user.getParentRoleNames();
            int n = 0;
            while (n < vector.size()) {
                object = (String)vector.elementAt(n);
                Role role = this.securityCache.getQuietRole((String)object);
                if (role != null) {
                    role.removeSubUser(string);
                }
                ++n;
            }
            object = user.getGroupNames();
            int n2 = 0;
            while (n2 < ((Vector)object).size()) {
                String string2 = (String)((Vector)object).elementAt(n2);
                Group group = this.securityCache.getQuietGroup(string2);
                if (group != null) {
                    group.removeUser(string);
                }
                ++n2;
            }
            this.securityCache.removeUser(string);
        } else {
            Object object;
            String[] stringArray = this.securityCache.getAllRoleNames();
            int n = 0;
            while (n < stringArray.length) {
                object = stringArray[n];
                Role role = this.securityCache.getQuietRole((String)object);
                if (role != null) {
                    role.removeSubUser(string);
                }
                ++n;
            }
            object = this.securityCache.getAllGroupNames();
            int n3 = 0;
            while (n3 < ((String[])object).length) {
                String string3 = object[n3];
                Group group = this.securityCache.getQuietGroup(string3);
                if (group != null) {
                    group.removeUser(string);
                }
                ++n3;
            }
        }
        this.addPrivilegeToAclEntry(string);
        this.userFolderListener.removeUserFolder(string, "JReport_System_User");
    }

    private void addPrivilegeToAclEntry(String string) {
        String[] stringArray = this.securityCache.getAllAclNames();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            JAcl jAcl = this.securityCache.getAcl(string2);
            if (jAcl != null) {
                jAcl.removeJAclEntry(string, 1);
            }
            ++n;
        }
    }

    private void addRole(String string) {
        Role role = this.securityCache.getRole(string);
        if (role != null) {
            Object object;
            Object object2;
            Object object3;
            Vector vector = role.getSubUserNames();
            int n = 0;
            while (n < vector.size()) {
                object3 = (String)vector.elementAt(n);
                User user = this.securityCache.getQuietUser((String)object3);
                if (user != null) {
                    user.removeParentRole(string);
                }
                ++n;
            }
            object3 = role.getGroupNames();
            int n2 = 0;
            while (n2 < ((Vector)object3).size()) {
                object2 = (String)((Vector)object3).elementAt(n2);
                Group group = this.securityCache.getQuietGroup((String)object2);
                if (group != null) {
                    group.removeRole(string);
                }
                ++n2;
            }
            object2 = role.getSubRoleNames();
            int n3 = 0;
            while (n3 < ((Vector)object2).size()) {
                object = (String)((Vector)object2).elementAt(n3);
                Role role2 = this.securityCache.getQuietRole((String)object);
                if (role2 != null) {
                    role2.removeParentRole(string);
                }
                ++n3;
            }
            object = role.getParentRoleNames();
            int n4 = 0;
            while (n4 < ((Vector)object).size()) {
                String string2 = (String)((Vector)object).elementAt(n4);
                Role role3 = this.securityCache.getQuietRole(string2);
                if (role3 != null) {
                    role3.removeSubRole(string);
                }
                ++n4;
            }
            this.securityCache.removeRole(string);
        } else {
            Object object;
            Object object4;
            String[] stringArray = this.securityCache.getAllUserNames();
            int n = 0;
            while (n < stringArray.length) {
                object4 = stringArray[n];
                User user = this.securityCache.getQuietUser((String)object4);
                if (user != null && user.isHaveParentRole(string)) {
                    user.removeParentRole(string);
                }
                ++n;
            }
            object4 = this.securityCache.getAllGroupNames();
            int n5 = 0;
            while (n5 < ((String[])object4).length) {
                object = object4[n5];
                Group group = this.securityCache.getQuietGroup((String)object);
                if (group != null && group.isHaveRole(string)) {
                    group.removeRole(string);
                }
                ++n5;
            }
            object = this.securityCache.getAllRoleNames();
            int n6 = 0;
            while (n6 < ((String[])object).length) {
                String string3 = object[n6];
                Role role4 = this.securityCache.getQuietRole(string3);
                if (role4 != null) {
                    if (role4.isHaveParentRole(string)) {
                        role4.removeParentRole(string);
                    }
                    if (role4.isHaveSubRole(string)) {
                        role4.removeSubRole(string);
                    }
                }
                ++n6;
            }
        }
        this.addSelector(string);
    }

    private void addSelector(String string) {
        String[] stringArray = this.securityCache.getAllAclNames();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            JAcl jAcl = this.securityCache.getAcl(string2);
            if (jAcl != null) {
                jAcl.removeJAclEntry(string, 2);
            }
            ++n;
        }
    }

    private void addSubGroup(String string) {
        Group group = this.securityCache.getGroup(string);
        if (group != null) {
            Object object;
            Object object2;
            Object object3;
            Vector vector = group.getUserNames();
            int n = 0;
            while (n < vector.size()) {
                object3 = (String)vector.elementAt(n);
                User user = this.securityCache.getQuietUser((String)object3);
                if (user != null) {
                    user.removeGroup(string);
                }
                ++n;
            }
            object3 = group.getRoleNames();
            int n2 = 0;
            while (n2 < ((Vector)object3).size()) {
                object2 = (String)((Vector)object3).elementAt(n2);
                Role role = this.securityCache.getQuietRole((String)object2);
                if (role != null) {
                    role.removeGroup(string);
                }
                ++n2;
            }
            object2 = group.getSubGroupNames();
            int n3 = 0;
            while (n3 < ((Vector)object2).size()) {
                object = (String)((Vector)object2).elementAt(n3);
                Group group2 = this.securityCache.getQuietGroup((String)object);
                if (group2 != null) {
                    group2.removeParentGroup(string);
                }
                ++n3;
            }
            object = group.getParentGroupNames();
            int n4 = 0;
            while (n4 < ((Vector)object).size()) {
                String string2 = (String)((Vector)object).elementAt(n4);
                Group group3 = this.securityCache.getQuietGroup(string2);
                if (group3 != null) {
                    group3.removeSubGroup(string);
                }
                ++n4;
            }
            this.securityCache.removeGroup(string);
        } else {
            Object object;
            Object object4;
            String[] stringArray = this.securityCache.getAllUserNames();
            int n = 0;
            while (n < stringArray.length) {
                object4 = stringArray[n];
                User user = this.securityCache.getQuietUser((String)object4);
                if (user != null && user.isHaveGroup(string)) {
                    user.removeGroup(string);
                }
                ++n;
            }
            object4 = this.securityCache.getAllRoleNames();
            int n5 = 0;
            while (n5 < ((String[])object4).length) {
                object = object4[n5];
                Role role = this.securityCache.getQuietRole((String)object);
                if (role != null && role.isHaveGroup(string)) {
                    role.removeGroup(string);
                }
                ++n5;
            }
            object = this.securityCache.getAllGroupNames();
            int n6 = 0;
            while (n6 < ((String[])object).length) {
                String string3 = object[n6];
                Group group4 = this.securityCache.getQuietGroup(string3);
                if (group4 != null) {
                    if (group4.isHaveParentGroup(string)) {
                        group4.removeParentGroup(string);
                    }
                    if (group4.isHaveSubGroup(string)) {
                        group4.removeSubGroup(string);
                    }
                }
                ++n6;
            }
        }
        this.addSubRole(string);
    }

    private void addSubRole(String string) {
        String[] stringArray = this.securityCache.getAllAclNames();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            JAcl jAcl = this.securityCache.getAcl(string2);
            if (jAcl != null) {
                jAcl.removeJAclEntry(string, 3);
            }
            ++n;
        }
    }

    private void addSubUser(Properties properties) {
        String string = properties.getProperty("security_event_para_parent_principal");
        String string2 = properties.getProperty("security_event_para_sub_principal");
        if (string == null || string2 == null) {
            return;
        }
        String string3 = properties.getProperty("security_event_para_parent_principal_type");
        String string4 = properties.getProperty("security_event_para_sub_principal_type");
        if (string3 == null || string4 == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(string3);
            n2 = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException);
            return;
        }
        block1 : switch (n) {
            case 1: {
                break;
            }
            case 2: {
                switch (n2) {
                    case 1: {
                        this.addUser(string2, string);
                        break block1;
                    }
                    case 3: {
                        this.createAclName(string2, string);
                        break block1;
                    }
                    case 2: {
                        this.createTopic(string2, string);
                        break block1;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: {
                        this.clear(string2, string);
                        break block1;
                    }
                    case 3: {
                        this.createSubscriber(string2, string);
                        break block1;
                    }
                    case 2: {
                        break block1;
                    }
                }
            }
        }
    }

    private void addUser(String string, String string2) {
        User user;
        Role role = this.securityCache.getRole(string2);
        if (role != null) {
            role.addSubUser(string);
        }
        if ((user = this.securityCache.getUser(string)) != null) {
            user.addParentRole(string2);
        }
    }

    private void clear(String string, String string2) {
        User user;
        Group group = this.securityCache.getGroup(string2);
        if (group != null) {
            group.addUser(string);
        }
        if ((user = this.securityCache.getUser(string)) != null) {
            user.addGroup(string2);
        }
    }

    private void createAclName(String string, String string2) {
        Group group;
        Role role = this.securityCache.getRole(string2);
        if (role != null) {
            role.addGroup(string);
        }
        if ((group = this.securityCache.getGroup(string)) != null) {
            group.addRole(string2);
        }
    }

    private void createSubscriber(String string, String string2) {
        Group group;
        Group group2 = this.securityCache.getGroup(string2);
        if (group2 != null) {
            group2.addSubGroup(string);
        }
        if ((group = this.securityCache.getGroup(string)) != null) {
            group.addParentGroup(string2);
        }
    }

    private void createTopic(String string, String string2) {
        Role role;
        Role role2 = this.securityCache.getRole(string2);
        if (role2 != null) {
            role2.addSubRole(string);
        }
        if ((role = this.securityCache.getRole(string)) != null) {
            role.addParentRole(string2);
        }
    }

    private void deactivate(Properties properties) {
        String string = properties.getProperty("security_event_para_parent_principal");
        String string2 = properties.getProperty("security_event_para_sub_principal");
        if (string == null || string2 == null) {
            return;
        }
        String string3 = properties.getProperty("security_event_para_parent_principal_type");
        String string4 = properties.getProperty("security_event_para_sub_principal_type");
        if (string3 == null || string4 == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(string3);
            n2 = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException);
            return;
        }
        block1 : switch (n) {
            case 1: {
                break;
            }
            case 2: {
                switch (n2) {
                    case 1: {
                        this.destroy(string2, string);
                        break block1;
                    }
                    case 3: {
                        this.elementAt(string2, string);
                        break block1;
                    }
                    case 2: {
                        this.equals(string2, string);
                        break block1;
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: {
                        this.dispose(string2, string);
                        break block1;
                    }
                    case 3: {
                        this.enableAll(string2, string);
                        break block1;
                    }
                    case 2: {
                        break block1;
                    }
                }
            }
        }
    }

    private void destroy(String string, String string2) {
        User user;
        Role role = this.securityCache.getRole(string2);
        if (role != null) {
            role.removeSubUser(string);
        }
        if ((user = this.securityCache.getUser(string)) != null) {
            user.removeParentRole(string2);
        }
    }

    private void dispose(String string, String string2) {
        User user;
        Group group = this.securityCache.getGroup(string2);
        if (group != null) {
            group.removeUser(string);
        }
        if ((user = this.securityCache.getUser(string)) != null) {
            user.removeGroup(string2);
        }
    }

    private void elementAt(String string, String string2) {
        Role role;
        Group group = this.securityCache.getGroup(string);
        if (group != null) {
            group.removeRole(string2);
        }
        if ((role = this.securityCache.getRole(string2)) != null) {
            role.removeGroup(string);
        }
    }

    private void enableAll(String string, String string2) {
        Group group;
        Group group2 = this.securityCache.getGroup(string);
        if (group2 != null) {
            group2.removeParentGroup(string2);
        }
        if ((group = this.securityCache.getGroup(string2)) != null) {
            group.removeSubGroup(string);
        }
    }

    private void equals(String string, String string2) {
        Role role;
        Role role2 = this.securityCache.getRole(string);
        if (role2 != null) {
            role2.removeParentRole(string2);
        }
        if ((role = this.securityCache.getRole(string2)) != null) {
            role.removeSubRole(string);
        }
    }

    private void finalize(Properties properties) {
        String string = properties.getProperty("security_event_para_resource_path");
        String string2 = properties.getProperty("security_event_para_version_number");
        if (string == null || string2 == null) {
            return;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException, 3);
            return;
        }
        String string3 = SecurityUtil.createAclName(string, n);
        JAcl jAcl = this.securityCache.getAcl(string3);
        if (jAcl != null) {
            this.securityCache.removeAcl(string3);
        }
        this.getAcl(string, n);
    }

    private void get(Properties properties) {
        String string = properties.getProperty("security_event_para_principal");
        if (string == null) {
            return;
        }
        String string2 = properties.getProperty("security_event_para_principal_type");
        if (string2 == null) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException);
            return;
        }
        switch (n) {
            case 1: {
                this.getAcl(string);
                break;
            }
            case 2: {
                this.getAllAclNames(string);
                break;
            }
            case 3: {
                this.getAllGroupNames(string);
                break;
            }
        }
    }

    private void getAcl(String string) {
        Hashtable hashtable = null;
        try {
            hashtable = this.userPrivilegeProvider.getUserPrivileges(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        BaseUser baseUser = this.getUser(string);
        if (baseUser == null) {
            return;
        }
        if (hashtable != null) {
            JAcl jAcl = this.securityCache.getExtendAcl();
            if (jAcl == null) {
                this.getExtendAcl();
                return;
            }
            jAcl.removeJAclEntry(baseUser, true);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                if (!string2.equals(string)) continue;
                JAclEntry jAclEntry = new JAclEntryImpl(string, this);
                jAclEntry.setPrincipal(baseUser);
                int n = 0;
                n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                jAclEntry = PermissionUtil.addPrivilegeToAclEntry(jAclEntry, n);
                try {
                    jAcl.addEntry(baseUser, jAclEntry);
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException, 3);
                }
            }
        }
    }

    private void getAllAclNames(String string) {
        Hashtable hashtable = null;
        try {
            hashtable = this.rolePrivilegeProvider.getRolePrivileges(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        BaseRole baseRole = this.getRole(string);
        if (baseRole == null) {
            return;
        }
        if (hashtable != null) {
            JAcl jAcl = this.securityCache.getExtendAcl();
            if (jAcl == null) {
                this.getExtendAcl();
                return;
            }
            jAcl.removeJAclEntry(baseRole, true);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                if (!string2.equals(string)) continue;
                JAclEntry jAclEntry = new JAclEntryImpl(string, this);
                jAclEntry.setPrincipal(baseRole);
                int n = 0;
                n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                jAclEntry = PermissionUtil.addPrivilegeToAclEntry(jAclEntry, n);
                try {
                    jAcl.addEntry(baseRole, jAclEntry);
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException, 3);
                }
            }
        }
    }

    private void getAllGroupNames(String string) {
        Hashtable hashtable = null;
        try {
            hashtable = this.groupPrivilegeProvider.getGroupPrivileges(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        BaseGroup baseGroup = this.getGroup(string);
        if (baseGroup == null) {
            return;
        }
        if (hashtable != null) {
            JAcl jAcl = this.securityCache.getExtendAcl();
            if (jAcl == null) {
                this.getExtendAcl();
                return;
            }
            jAcl.removeJAclEntry(baseGroup, true);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String[] stringArray = (String[])hashtable.get(string);
                if (!string2.equals(string)) continue;
                JAclEntry jAclEntry = new JAclEntryImpl(string, this);
                jAclEntry.setPrincipal(baseGroup);
                int n = 0;
                n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                jAclEntry = PermissionUtil.addPrivilegeToAclEntry(jAclEntry, n);
                try {
                    jAcl.addEntry(baseGroup, jAclEntry);
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException, 3);
                }
            }
        }
    }

    public void destory() {
        this.QOIV.destroy();
        this.securityCache.clear();
        this.securityCache.dispose();
    }

    protected void finalize() throws Throwable {
        this.QOIV.destroy();
        this.securityCache.clear();
        this.securityCache.dispose();
        super.finalize();
    }
}

