/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.log.ServiceLogger;

public class Realm {
    public static final int SCHEME_BASIC = 0;
    public static final int SCHEME_DIGEST = 1;
    protected static Vector realms = new Vector();
    protected String name;
    protected File realmDir;
    protected int scheme = 0;
    static Class class$jet$server$jrc$security$Realm;

    public Realm() {
        this("");
    }

    public Realm(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector list() {
        Class clazz = class$jet$server$jrc$security$Realm == null ? (class$jet$server$jrc$security$Realm = Realm.class$("jet.server.jrc.security.Realm")) : class$jet$server$jrc$security$Realm;
        synchronized (clazz) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < realms.size()) {
                vector.addElement(((Realm)realms.elementAt(n)).getName());
                ++n;
            }
            Vector<String> vector2 = vector;
            return vector2;
        }
    }

    public synchronized void setScheme(int n) {
        this.scheme = n;
        if (this.scheme != 0 && this.scheme != 1) {
            this.scheme = 0;
        }
    }

    public int getScheme() {
        return this.scheme;
    }

    public static void clearAll() {
        realms.removeAllElements();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Realm get(String string) throws NoSuchRealmException, BadRealmException {
        Class clazz = class$jet$server$jrc$security$Realm == null ? (class$jet$server$jrc$security$Realm = Realm.class$("jet.server.jrc.security.Realm")) : class$jet$server$jrc$security$Realm;
        synchronized (clazz) {
            int n = 0;
            while (n < realms.size()) {
                Realm realm = (Realm)realms.elementAt(n);
                if (realm.getName().equalsIgnoreCase(string)) {
                    return realm;
                }
                ++n;
            }
            throw new NoSuchRealmException(620003, new Object[]{string}, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Realm realm) {
        Class clazz = class$jet$server$jrc$security$Realm == null ? (class$jet$server$jrc$security$Realm = Realm.class$("jet.server.jrc.security.Realm")) : class$jet$server$jrc$security$Realm;
        synchronized (clazz) {
            try {
                Realm.get(realm.getName());
            }
            catch (NoSuchRealmException noSuchRealmException) {
                realms.addElement(realm);
            }
            catch (BadRealmException badRealmException) {
                ServiceLogger.logError(badRealmException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(String string) {
        Class clazz = class$jet$server$jrc$security$Realm == null ? (class$jet$server$jrc$security$Realm = Realm.class$("jet.server.jrc.security.Realm")) : class$jet$server$jrc$security$Realm;
        synchronized (clazz) {
            try {
                Realm realm = Realm.get(string);
                realms.removeElement(realm);
            }
            catch (NoSuchRealmException noSuchRealmException) {
                ServiceLogger.logError(noSuchRealmException, 3);
            }
            catch (BadRealmException badRealmException) {
                ServiceLogger.logError(badRealmException, 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getRealmNames() {
        Class clazz = class$jet$server$jrc$security$Realm == null ? (class$jet$server$jrc$security$Realm = Realm.class$("jet.server.jrc.security.Realm")) : class$jet$server$jrc$security$Realm;
        synchronized (clazz) {
            Object object;
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < realms.size()) {
                object = (Realm)realms.elementAt(n);
                vector.addElement(((Realm)object).getName());
                ++n;
            }
            object = vector.iterator();
            return object;
        }
    }

    public final String getName() {
        return this.name;
    }

    protected final synchronized void setName(String string) {
        this.name = string;
    }

    protected synchronized void init(Properties properties) throws BadRealmException, NoSuchRealmException {
    }

    protected synchronized void setRealmDir(File file) {
        this.realmDir = file;
    }

    public synchronized File getRealmDir() {
        return this.realmDir;
    }

    public String toString() {
        return "Realm:" + this.hashCode() + " " + this.name;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

