/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.SecurityListener;
import jet.server.api.custom.security.relation.RoleGroupRelationProvider;
import jet.server.api.custom.security.relation.RoleUserRelationProvider;
import jet.server.api.custom.security.role.RoleProvider;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.RoleExistsException;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.SecurityWebUIController;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.cache.CachedSecurityDataImpl;
import jet.server.jrc.security.custom.SecurityListenerSynImpl;
import jet.server.jrc.security.custom.db.role.RoleProviderDBImpl;
import jet.server.log.ServiceLogger;

public class RoleDataManager {
    private String QOIV;
    private SecurityListener TAG_ROLE_DB_BUILDIN;
    private CachedSecurityDataImpl TAG_ROLE_DB_TYPE;
    protected RoleProvider roleProvider;
    protected RoleGroupRelationProvider roleGroupRelationProvider;
    protected RoleUserRelationProvider roleUserRelationProvider;
    boolean add = true;
    boolean addGroupToRole = true;
    boolean addPrincipal = true;
    boolean addRelation = true;
    boolean addRole = true;

    public RoleDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl, SecurityWebUIController securityWebUIController) {
        this.TAG_ROLE_DB_TYPE = exCachedSecurityDataImpl;
        this.QOIV = exCachedSecurityDataImpl.getRealmName();
        this.add = securityWebUIController.isEditing(5);
        this.addGroupToRole = securityWebUIController.isEditing(7);
        this.addPrincipal = securityWebUIController.isEditing(6);
        this.addRelation = securityWebUIController.isEditing(21);
        this.addRole = securityWebUIController.isEditing(18);
        this.roleProvider = exCachedSecurityDataImpl.getRoleProvider();
        this.roleGroupRelationProvider = exCachedSecurityDataImpl.getRoleGroupRelationProvider();
        this.roleUserRelationProvider = exCachedSecurityDataImpl.getRoleUserRelationProvider();
        this.TAG_ROLE_DB_BUILDIN = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public RoleDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl) {
        this.TAG_ROLE_DB_TYPE = exCachedSecurityDataImpl;
        this.QOIV = exCachedSecurityDataImpl.getRealmName();
        this.roleProvider = exCachedSecurityDataImpl.getRoleProvider();
        this.roleGroupRelationProvider = exCachedSecurityDataImpl.getRoleGroupRelationProvider();
        this.roleUserRelationProvider = exCachedSecurityDataImpl.getRoleUserRelationProvider();
        this.TAG_ROLE_DB_BUILDIN = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public synchronized String addNewRole(String string, String string2, int n) throws RoleExistsException {
        if (!this.addGroupToRole) {
            return "Can not add new role when the RoleProvider isEnableEdit() method return false";
        }
        try {
            this.getBaseRole(string);
            throw new RoleExistsException(630082, (Object[])new String[]{string}, null);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException, 3);
            Properties properties = new Properties();
            properties.setProperty("role_name", string);
            properties.setProperty("role_description", string2);
            properties.setProperty(RoleProviderDBImpl.TAG_ROLE_DB_TYPE, String.valueOf(n));
            properties.setProperty(RoleProviderDBImpl.TAG_ROLE_DB_BUILDIN, "false");
            try {
                this.roleProvider.addRole(this.QOIV, properties);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError(jRCustomerException);
                return JSvrResource.getMessage("SECURITY_M_01001", string);
            }
            this.TAG_ROLE_DB_BUILDIN.addPrincipal(this.QOIV, string, 2);
            return null;
        }
    }

    public synchronized String removeRole(String string) throws NoSuchRoleException {
        if (!this.addPrincipal) {
            return "Can not remove the role when the RoleProvider isEnableEdit() method return false";
        }
        this.getBaseRole(string);
        try {
            this.roleProvider.removeRole(this.QOIV, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            return JSvrResource.getMessage("SECURITY_M_01002", string);
        }
        this.TAG_ROLE_DB_BUILDIN.removePrincipal(this.QOIV, string, 2);
        return null;
    }

    public synchronized Role getRole(String string) throws NoSuchRoleException {
        Role role = this.TAG_ROLE_DB_TYPE.getIntegrityRole(string);
        if (role == null) {
            throw new NoSuchRoleException(630002, (Object[])new String[]{string}, null);
        }
        return role;
    }

    public synchronized BaseRole getBaseRole(String string) throws NoSuchRoleException {
        BaseRole baseRole = this.TAG_ROLE_DB_TYPE.getRole(string);
        if (baseRole == null) {
            throw new NoSuchRoleException(630002, (Object[])new String[]{string}, null);
        }
        return baseRole;
    }

    public synchronized String removeRoleFromParentRole(String string, String string2) throws NoSuchRoleException {
        if (!this.addRelation) {
            return "Can not edit the role-subrole relationship when the RoleProvider isEnableEdit() method return false";
        }
        BaseRole baseRole = this.getBaseRole(string);
        BaseRole baseRole2 = this.getBaseRole(string2);
        if (!baseRole.getParentRoleNames().contains(string2)) {
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_ERR_14_HAVE_NOT_PARENT", objectArray);
        }
        if (!baseRole2.getSubRoleNames().contains(string)) {
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_ERR_15_HAVE_NOT_SUBROLE", objectArray);
        }
        try {
            this.roleProvider.removeSubRole(this.QOIV, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_M_04005", objectArray);
        }
        this.TAG_ROLE_DB_BUILDIN.removeRelation(this.QOIV, string2, 2, string, 2);
        return null;
    }

    public synchronized String addRoleToParentRole(String string, String string2) throws NoSuchRoleException {
        if (!this.addRelation) {
            return "Can not edit the role-subrole relationship when the RoleProvider isEnableEdit() method return false";
        }
        BaseRole baseRole = this.getBaseRole(string);
        BaseRole baseRole2 = this.getBaseRole(string2);
        if (baseRole.getParentRoleNames().contains(string2)) {
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_ERR_17_HAVE_PARENT", objectArray);
        }
        if (baseRole2.getSubRoleNames().contains(string)) {
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_ERR_18_HAVE_SUBROLE", objectArray);
        }
        try {
            this.roleProvider.addSubRole(this.QOIV, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_M_04006", objectArray);
        }
        catch (RoleExistsException roleExistsException) {
            ServiceLogger.logError(roleExistsException);
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_M_04023", objectArray);
        }
        this.TAG_ROLE_DB_BUILDIN.addRelation(this.QOIV, string2, 2, string, 2);
        return null;
    }

    public synchronized String addGroupIntoRole(String string, String string2) throws NoSuchGroupException, NoSuchRoleException {
        if (!this.addRole) {
            return "Can not edit the role-group relationship when the RoleGroupRelationProvider isEnableEdit() method return false";
        }
        BaseGroup baseGroup = this.getBaseGroup(string);
        if (baseGroup.getRoleNames().contains(string2)) {
            return JSvrResource.getMessage("SECURITY_ERR_86_GROUP_EXIST_ROLE", string);
        }
        BaseRole baseRole = this.getBaseRole(string2);
        if (baseRole.getGroupNames().contains(string)) {
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_ERR_87_ROLE_EXIST_SUB_GROUP", objectArray);
        }
        try {
            this.roleGroupRelationProvider.addGroupToRole(this.QOIV, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_M_04007", objectArray);
        }
        catch (GroupExistsException groupExistsException) {
            ServiceLogger.logError(groupExistsException);
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_M_04025", objectArray);
        }
        this.TAG_ROLE_DB_BUILDIN.addRelation(this.QOIV, string2, 2, string, 3);
        return null;
    }

    public synchronized String removeGroupFromRole(String string, String string2) throws NoSuchGroupException, NoSuchRoleException {
        if (!this.addRole) {
            return "Can not edit the role-group relationship when the RoleGroupRelationProvider isEnableEdit() method return false";
        }
        BaseGroup baseGroup = this.getBaseGroup(string);
        if (!baseGroup.getRoleNames().contains(string2)) {
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_ERR_89_GROUP_HAVE_NOT_ROLE", objectArray);
        }
        BaseRole baseRole = this.getBaseRole(string2);
        if (!baseRole.getGroupNames().contains(string)) {
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_ERR_90_ROLE_NOT_EXIST_SUB_GROUP", objectArray);
        }
        try {
            this.roleGroupRelationProvider.removeGroupFromRole(this.QOIV, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_M_04008", objectArray);
        }
        this.TAG_ROLE_DB_BUILDIN.removeRelation(this.QOIV, string2, 2, string, 3);
        return null;
    }

    public BaseGroup getBaseGroup(String string) throws NoSuchGroupException {
        Group group = (Group)this.TAG_ROLE_DB_TYPE.getGroup(string);
        if (group == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string}, null);
        }
        return group;
    }

    public Enumeration getAllRoles() {
        Role[] roleArray = this.TAG_ROLE_DB_TYPE.getAllRoles();
        Vector<Role> vector = new Vector<Role>();
        int n = 0;
        while (n < roleArray.length) {
            Role role = roleArray[n];
            vector.add(role);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getAllRoleNames() {
        Role[] roleArray = this.TAG_ROLE_DB_TYPE.getAllRoles();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < roleArray.length) {
            Role role = roleArray[n];
            vector.add(role.getName());
            ++n;
        }
        return vector.elements();
    }
}

