/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.security.Principal;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.jacl.JAcl;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationLDAP;
import jet.server.api.custom.security.AuthenticationProvider;
import jet.server.api.custom.security.AuthorizationProvider;
import jet.server.api.exception.GroupExistsException;
import jet.server.api.exception.InUseException;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.RoleExistsException;
import jet.server.api.exception.UserExistsException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.Version;
import jet.server.intf.security.Comparator;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.SecurityProvider;
import jet.server.intf.security.SecurityService;
import jet.server.intf.security.SecurityWebUIController;
import jet.server.intf.security.User;
import jet.server.intf.security.UserFolderListener;
import jet.server.jrc.resource.VersionImpl;
import jet.server.jrc.security.AclDataManager;
import jet.server.jrc.security.AclManager;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.GroupComparator;
import jet.server.jrc.security.GroupDataManager;
import jet.server.jrc.security.GroupManagerImpl;
import jet.server.jrc.security.NameComparator;
import jet.server.jrc.security.NoSuchAclEntryException;
import jet.server.jrc.security.RoleComparator;
import jet.server.jrc.security.RoleDataManager;
import jet.server.jrc.security.RoleManager;
import jet.server.jrc.security.Sorter;
import jet.server.jrc.security.UserComparator;
import jet.server.jrc.security.UserDataManager;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.UserImpl;
import jet.server.jrc.security.UserManager;
import jet.server.jrc.security.cache.CachedSecurityDataImpl;
import jet.server.jrc.security.custom.SecurityListenerSynImpl;
import jet.server.jrc.security.ldap.LDAPData;
import jet.server.jrc.security.ldap.intf.LDAPGroup;
import jet.server.jrc.security.ldap.intf.LDAPUser;
import jet.server.log.ServiceLogger;
import jet.util.MiscTools;

public class SecurityServiceImpl
implements SecurityService,
SecurityProvider {
    UserManager QOIV = null;
    RoleManager add = null;
    AclManager addElement = null;
    GroupManagerImpl addGroupIntoParentGroup = null;
    CachedSecurityDataImpl addGroupIntoRole = null;
    SecurityWebUIController addNewGroup = null;
    private static Hashtable addNewRole = new Hashtable();
    private String addNewUser;
    private AuthenticationProvider addPrivilegedGroups;
    private AuthorizationProvider addPrivilegedRoles;

    public SecurityServiceImpl(String string, ExCachedSecurityDataImpl exCachedSecurityDataImpl, SecurityWebUIController securityWebUIController) {
        this.addNewUser = string;
        this.addGroupIntoRole = exCachedSecurityDataImpl;
        this.addNewGroup = securityWebUIController;
        SecurityListenerSynImpl securityListenerSynImpl = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
        UserDataManager userDataManager = new UserDataManager(exCachedSecurityDataImpl, securityWebUIController);
        RoleDataManager roleDataManager = new RoleDataManager(exCachedSecurityDataImpl, securityWebUIController);
        AclDataManager aclDataManager = new AclDataManager(exCachedSecurityDataImpl, securityWebUIController);
        GroupDataManager groupDataManager = new GroupDataManager(exCachedSecurityDataImpl, securityWebUIController);
        this.addGroupIntoParentGroup = new GroupManagerImpl(groupDataManager);
        this.QOIV = new UserManager(userDataManager);
        this.add = new RoleManager(roleDataManager);
        this.addElement = new AclManager(aclDataManager, exCachedSecurityDataImpl);
        this.addPrivilegedGroups = exCachedSecurityDataImpl.getAuthenticationProvider();
        this.addPrivilegedRoles = exCachedSecurityDataImpl.getAuthorizationProvider();
        this.addPrivilegedGroups.addSecurityListener(securityListenerSynImpl);
    }

    public SecurityServiceImpl(String string, ExCachedSecurityDataImpl exCachedSecurityDataImpl) {
        this.addNewUser = string;
        this.addGroupIntoRole = exCachedSecurityDataImpl;
        SecurityListenerSynImpl securityListenerSynImpl = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
        UserDataManager userDataManager = new UserDataManager(exCachedSecurityDataImpl);
        RoleDataManager roleDataManager = new RoleDataManager(exCachedSecurityDataImpl);
        AclDataManager aclDataManager = new AclDataManager(exCachedSecurityDataImpl);
        GroupDataManager groupDataManager = new GroupDataManager(exCachedSecurityDataImpl);
        this.addGroupIntoParentGroup = new GroupManagerImpl(groupDataManager);
        this.QOIV = new UserManager(userDataManager);
        this.add = new RoleManager(roleDataManager);
        this.addElement = new AclManager(aclDataManager, exCachedSecurityDataImpl);
        this.addPrivilegedGroups = exCachedSecurityDataImpl.getAuthenticationProvider();
        this.addPrivilegedRoles = exCachedSecurityDataImpl.getAuthorizationProvider();
        this.addPrivilegedGroups.addSecurityListener(securityListenerSynImpl);
    }

    public boolean checkPrivilege(String string, String string2) {
        return this.addPrivilegedRoles.checkPrivilege(this.addNewUser, string, string2);
    }

    public boolean checkPermission(Node node, String string, Permission permission) {
        if (!ServerEnv.needSecurity() || this.isAdminUser(string) || node.isOwnerOrCreator(string)) {
            return true;
        }
        Node node2 = node;
        node2 = this.QOIV(node2);
        int n = -1;
        boolean bl = false;
        if (node2.getNodeType() == 3) {
            bl = true;
            n = ((Version)node2).getVersionNumber();
        }
        boolean bl2 = false;
        if (bl) {
            bl2 = this.addPrivilegedRoles.isPermissionOk(this.addNewUser, string, node2.getParent().getAbsolutePath(), n, permission);
            ServiceLogger.logDebug(6630002, new Object[]{node.getParent().getAbsolutePath(), string, permission, String.valueOf(bl2)}, 6);
        } else {
            bl2 = this.addPrivilegedRoles.isPermissionOk(this.addNewUser, string, node2.getAbsolutePath(), n, permission);
            ServiceLogger.logDebug(6630002, new Object[]{node.getParent().getAbsolutePath(), string, permission, String.valueOf(bl2)}, 6);
        }
        return bl2;
    }

    private Node QOIV(Node node) {
        if (!UserDataToolkit.useBuiltinAuthorizationProvider() || node.getAclID() != -1 || node.isRoot()) {
            if (node.getNodeType() == 3 && node.isDynamic()) {
                return this.QOIV(node.getParent());
            }
            return node;
        }
        return this.QOIV(node.getParent());
    }

    public boolean isValidUser(String string, String string2) {
        block8: {
            HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
            ConfigService configService = httpRptServer.getAdminService().getConfigService();
            ConfigurationLDAP configurationLDAP = configService.getConfigurationLDAP();
            boolean bl = false;
            String string3 = LDAPData.getProperty("enableLDAPSupport");
            if (string3 != null && string3.equals("true")) {
                bl = true;
            }
            boolean bl2 = false;
            String string4 = LDAPData.getProperty("enableAutoImportLDAPUser");
            if (string4 != null && string4.equals("true")) {
                bl2 = true;
            }
            try {
                User user = this.getIntegrityUser(string);
                int n = user.getAuthType();
                if (n == 0 || n == -1) {
                    return this.add(string, string2);
                }
                if (n == 1 && bl) {
                    String string5 = user.getPassword();
                    if (string5 != null && string5.length() != 0) {
                        return configurationLDAP.isValidLDAPUserByDN(string, string5, string2);
                    }
                    return configurationLDAP.isValidLDAPUser(string, string2);
                }
            }
            catch (NoSuchUserException noSuchUserException) {
                if (!bl || !bl2) break block8;
                String string6 = configurationLDAP.autoImportLDAPUser(string, string2);
                if (string6 != null) {
                    ServiceLogger.logDebug(string6);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean add(String string, String string2) {
        boolean bl = false;
        bl = this.addPrivilegedGroups.isValidUser(this.addNewUser, string, string2);
        return bl;
    }

    public boolean isAdminUser(String string) {
        boolean bl = this.addPrivilegedGroups.isAdminUser(this.addNewUser, string);
        return bl;
    }

    public static void removeKey(String string) {
        if (addNewRole.containsKey(string)) {
            addNewRole.remove(string);
        }
    }

    public User getUser(String string) throws NoSuchUserException {
        if (string == null || string.length() == 0) {
            throw new NoSuchUserException(630004);
        }
        if (string.equals("JReport_System_User")) {
            return UserImpl.systemUser;
        }
        User user = (User)this.addGroupIntoRole.getUser(string);
        if (user == null) {
            throw new NoSuchUserException(630003, new Object[]{string}, null);
        }
        return user;
    }

    public User getIntegrityUser(String string) throws NoSuchUserException {
        if (string == null || string.length() == 0) {
            throw new NoSuchUserException(630004);
        }
        if (string.equals("JReport_System_User")) {
            return UserImpl.systemUser;
        }
        return this.QOIV.getUser(string);
    }

    public Vector getAllUsers() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.QOIV.getAllUsers();
        while (enumeration.hasMoreElements()) {
            object = (User)enumeration.nextElement();
            vector.add(object);
        }
        object = new UserComparator();
        Sorter.sort(vector, (Comparator)object);
        return vector;
    }

    public Vector getUsersNameByRole(String string) throws NoSuchRoleException {
        return this.add.getSubUserNames(string);
    }

    public Role getRole(String string) throws NoSuchRoleException {
        return this.add.getRole(string);
    }

    public Vector getAllRoles() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.add.getAllRoles();
        while (enumeration.hasMoreElements()) {
            object = (Role)enumeration.nextElement();
            vector.add(object);
        }
        object = new RoleComparator();
        Sorter.sort(vector, (Comparator)object);
        return vector;
    }

    public Vector getRolesNameByUser(String string) throws NoSuchUserException {
        return this.QOIV.getParentRoleNames(string);
    }

    public Group getGroup(String string) throws NoSuchGroupException {
        return this.addGroupIntoParentGroup.getGroup(string);
    }

    public Vector getAllGroups() {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.addGroupIntoParentGroup.getAllGroups();
        while (enumeration.hasMoreElements()) {
            object = (Group)enumeration.nextElement();
            vector.add(object);
        }
        object = new GroupComparator();
        Sorter.sort(vector, (Comparator)object);
        return vector;
    }

    public Vector getGroupsNameByUser(String string) throws NoSuchUserException {
        User user = this.getUser(string);
        return user.getGroupNames();
    }

    public Vector getUsersNameByGroup(String string) throws NoSuchGroupException {
        Group group = this.getGroup(string);
        return group.getUserNames();
    }

    public Vector getGroupsByUser(String string) throws NoSuchUserException {
        Vector<Group> vector = new Vector<Group>();
        User user = this.getUser(string);
        Vector vector2 = user.getGroupNames();
        int n = 0;
        while (n < vector2.size()) {
            String string2 = (String)vector2.elementAt(n);
            try {
                Group group = this.getGroup(string2);
                vector.add(group);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logError(noSuchGroupException);
            }
            ++n;
        }
        return vector;
    }

    public Vector getUsersByGroup(String string) throws NoSuchGroupException {
        Group group = this.addGroupIntoParentGroup.getGroup(string);
        Vector<User> vector = new Vector<User>();
        Vector vector2 = group.getUserNames();
        int n = 0;
        while (n < vector2.size()) {
            block3: {
                String string2 = (String)vector2.elementAt(n);
                User user = null;
                try {
                    user = this.getUser(string2);
                }
                catch (NoSuchUserException noSuchUserException) {
                    ServiceLogger.logError(noSuchUserException);
                    break block3;
                }
                vector.add(user);
            }
            ++n;
        }
        return vector;
    }

    public Vector getRolesByGroup(String string) throws NoSuchGroupException {
        Vector<Role> vector = new Vector<Role>();
        Group group = this.getGroup(string);
        Vector vector2 = group.getRoleNames();
        int n = 0;
        while (n < vector2.size()) {
            String string2 = (String)vector2.elementAt(n);
            try {
                Role role = this.getRole(string2);
                vector.add(role);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                ServiceLogger.logError(noSuchRoleException);
            }
            ++n;
        }
        return vector;
    }

    public Vector getGroupsByRole(String string) throws NoSuchRoleException {
        Vector<Group> vector = new Vector<Group>();
        Role role = this.getRole(string);
        Vector vector2 = role.getGroupNames();
        int n = 0;
        while (n < vector2.size()) {
            String string2 = (String)vector2.elementAt(n);
            try {
                Group group = this.getGroup(string2);
                vector.add(group);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logError(noSuchGroupException);
            }
            ++n;
        }
        return vector;
    }

    public Hashtable[] getPermissions(Node node) {
        Hashtable[] hashtableArray;
        String string = node.getAbsolutePath();
        int n = -1;
        if (node.getNodeType() == 3) {
            hashtableArray = (Hashtable[])node;
            n = hashtableArray.getVersionNumber();
        }
        hashtableArray = new Hashtable[]{new Hashtable(), new Hashtable(), new Hashtable()};
        Hashtable[] hashtableArray2 = null;
        try {
            hashtableArray2 = this.addElement.getPermssions(string, n);
        }
        catch (NotOwnerException notOwnerException) {
        }
        catch (NoSuchAclException noSuchAclException) {
            // empty catch block
        }
        if (hashtableArray2 != null) {
            return hashtableArray2;
        }
        return hashtableArray;
    }

    public int setPermissions(Node node, String string, Hashtable[] hashtableArray) throws NoSuchAclException {
        String string2 = node.getAbsolutePath();
        int n = -1;
        if (node.getNodeType() == 3) {
            VersionImpl versionImpl = (VersionImpl)node;
            n = versionImpl.getVersionNumber();
        }
        return this.addElement.setPermissions(string2, n, hashtableArray);
    }

    public boolean removeUserPermissions(Node node, String string) throws NoSuchAclException, NoSuchAclEntryException {
        User user = null;
        try {
            user = this.getUser(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            return false;
        }
        String string2 = node.getAbsolutePath();
        int n = -1;
        if (node.getNodeType() == 3) {
            VersionImpl versionImpl = (VersionImpl)node;
            n = versionImpl.getVersionNumber();
        }
        return this.addElement.removeAclEntry(string2, n, user);
    }

    public boolean removeRolePermissions(Node node, String string) throws NoSuchAclException, NoSuchAclEntryException {
        Role role = null;
        try {
            role = this.getRole(string);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            return false;
        }
        String string2 = node.getAbsolutePath();
        int n = -1;
        if (node.getNodeType() == 3) {
            VersionImpl versionImpl = (VersionImpl)node;
            n = versionImpl.getVersionNumber();
        }
        return this.addElement.removeAclEntry(string2, n, role);
    }

    public boolean removeGroupPermissions(Node node, String string) throws NoSuchAclException, NoSuchAclEntryException {
        Group group = null;
        try {
            group = this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            return false;
        }
        String string2 = node.getAbsolutePath();
        int n = -1;
        if (node.getNodeType() == 3) {
            VersionImpl versionImpl = (VersionImpl)node;
            n = versionImpl.getVersionNumber();
        }
        return this.addElement.removeAclEntry(string2, n, group);
    }

    public boolean addAcl(String string, String string2, int n, Hashtable[] hashtableArray) {
        this.addElement.setPermissions(string2, n, hashtableArray);
        return true;
    }

    public JAcl getAclByID(int n) {
        return null;
    }

    public JAcl getAcl(String string, int n) throws NoSuchAclException, NotOwnerException {
        return this.addElement.getAcl(string, n);
    }

    public String changePassword(boolean bl, String string, String string2, String string3, String string4) throws NoSuchUserException {
        if (!bl) {
            if (string.equals("guest")) {
                return JSvrResource.getMessage("SECURITY_ERR_26_GUEST_NO_POWER_CHANGE_PS");
            }
            if (!this.isValidUser(string, string2)) {
                return JSvrResource.getMessage("SECURITY_ERR_27_USER_NO_POWER_CHANGE_PS");
            }
            if (!string.equals(string3) && !this.isAdminUser(string)) {
                return JSvrResource.getMessage("SECURITY_ERR_27_USER_NO_POWER_CHANGE_PS");
            }
        } else if (this.isAdminUser(string)) {
            if (!this.isValidUser(string, string2)) {
                return "The user password is wrong.";
            }
        } else {
            return "The user: " + string + " is not administrator.";
        }
        String string5 = null;
        User user = this.QOIV.getUser(string3);
        this.QOIV.getUser(string);
        if (MiscTools.containChar((String)string4, (String)" :")) {
            return JSvrResource.getMessage("SVR_26", "space and ':'");
        }
        boolean bl2 = user.isEnableNullPS();
        if (!bl2) {
            if (string4 == null || string4.trim().length() == 0) {
                string5 = JSvrResource.getMessage("SVR_27");
            } else {
                int n = user.getMinPSLength();
                if (string4.length() < n) {
                    string5 = JSvrResource.getMessage("SVR_32", "" + n);
                }
            }
        }
        if (string5 == null) {
            string5 = this.addPrivilegedGroups.changePassword(this.addNewUser, string, string3, string2, string4);
        }
        if (string5 == null) {
            ServiceLogger.logManageSuccessEvent(this.addNewUser, string3, 6630079, string3, 6);
        }
        return string5;
    }

    public String updateAttributes(String string, String string2, String string3, String string4, boolean bl, int n, Date date, boolean bl2, int n2, boolean bl3) throws NoSuchUserException {
        return this.QOIV.updataAttributes(string, string2, string3, string4, bl, n, date, bl2, n2, bl3);
    }

    public String addNewUser(String string, String string2, String string3, String string4, String string5, Date date, String string6, boolean bl, int n, Date date2, boolean bl2, int n2, boolean bl3) throws UserExistsException {
        String string7 = this.QOIV.addNewUser(string2, string3, string4, string5, date, string6, bl, n, date2, bl2, n2, bl3, false);
        return string7;
    }

    public String updataEvent(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws NoSuchUserException {
        return this.QOIV.updataEvent(string, bl, bl2, bl3, bl4, bl5);
    }

    public boolean getAuditState(String string, int n, boolean bl) throws NoSuchUserException {
        int n2 = 0;
        int n3 = 1;
        User user = this.getUser(string);
        if (user.isNoAudit()) {
            return false;
        }
        if (n == n2) {
            if (bl) {
                return user.isAccessEventSuc();
            }
            return user.isAccessEventFail();
        }
        if (n == n3) {
            if (bl) {
                return user.isManagementEventSuc();
            }
            return user.isManagementEventFail();
        }
        return true;
    }

    public int getUserParentRolesCount(String string) throws NoSuchUserException {
        User user = this.getUser(string);
        return user.getParentRoleNames().size();
    }

    public String addUserToParentRole(String string, String string2) throws NoSuchRoleException, NoSuchUserException {
        return this.QOIV.addUserToParentRole(string, string2);
    }

    public int getRoleSubMembersCount(String string) throws NoSuchRoleException {
        Role role = this.getRole(string);
        int n = role.getSubRoleNames().size();
        int n2 = role.getSubUserNames().size();
        int n3 = role.getGroupNames().size();
        return n + n3 + n2;
    }

    public Vector getSubRolesByRole(String string) throws NoSuchRoleException {
        Vector<Role> vector = new Vector<Role>();
        Vector vector2 = this.add.getSubRoleNames(string);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Role role = this.getRole(string2);
            vector.add(role);
        }
        return vector;
    }

    public Vector getSubUsersByRole(String string) throws NoSuchRoleException {
        Vector<User> vector = new Vector<User>();
        Vector vector2 = this.add.getSubUserNames(string);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            User user;
            String string2 = (String)enumeration.nextElement();
            try {
                user = this.getUser(string2);
            }
            catch (NoSuchUserException noSuchUserException) {
                continue;
            }
            vector.add(user);
        }
        return vector;
    }

    public Vector getSubUsersNameByRole(String string) throws NoSuchRoleException {
        return this.add.getSubUserNames(string);
    }

    public Vector getAllUsersName() {
        Vector vector = new Vector();
        Enumeration enumeration = this.QOIV.getAllUserNames();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public String addSubUserToRole(String string, String string2) throws NoSuchRoleException, NoSuchUserException {
        return this.QOIV.addUserToParentRole(string, string2);
    }

    public String addSubRoleToRole(String string, String string2) throws NoSuchRoleException {
        return this.add.addRoleToParentRole(string, string2);
    }

    public String addNewRole(String string, String string2) throws RoleExistsException {
        return this.add.addNewRole(string, string2, 0);
    }

    public String removeRoleFromParentRole(String string, String string2) throws NoSuchRoleException {
        return this.add.removeRoleFromParentRole(string, string2);
    }

    public String removeUserFromParentRole(String string, String string2) throws NoSuchRoleException, NoSuchUserException {
        return this.QOIV.removeUserFromParentRole(string, string2);
    }

    public String removeUser(String string, String string2) throws NoSuchUserException, InUseException {
        String string3 = this.QOIV.removeUser(string);
        return string3;
    }

    public String removeRole(String string) throws NoSuchRoleException, InUseException {
        return this.add.removeRole(string);
    }

    public Vector getAllRolesName() {
        Vector vector = new Vector();
        Enumeration enumeration = this.add.getAllRoleNames();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public Vector getAllGroupsName() {
        Vector vector = new Vector();
        Enumeration enumeration = this.addGroupIntoParentGroup.getAllGroupNames();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        NameComparator nameComparator = new NameComparator();
        Sorter.sort(vector, (Comparator)nameComparator);
        return vector;
    }

    public Vector getParentRolesByUser(String string) throws NoSuchUserException {
        Vector<Role> vector = new Vector<Role>();
        User user = this.getUser(string);
        Vector vector2 = user.getParentRoleNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Role role;
            String string2 = (String)enumeration.nextElement();
            try {
                role = this.add.getRole(string2);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                continue;
            }
            vector.add(role);
        }
        return vector;
    }

    public AclManager getAclManager() {
        return this.addElement;
    }

    public RoleManager getRoleManager() {
        return this.add;
    }

    public UserManager getUserManager() {
        return this.QOIV;
    }

    public JAcl getDefaultAcl() throws NoSuchAclException {
        return this.addElement.getDefaultAcl();
    }

    public void addUserFolderListener(UserFolderListener userFolderListener) {
        this.addGroupIntoRole.addUserFolderListener(userFolderListener);
    }

    public void clearPermissions(Node node) {
        String string = node.getAbsolutePath();
        int n = -1;
        if (node.getNodeType() == 3) {
            VersionImpl versionImpl = (VersionImpl)node;
            n = versionImpl.getVersionNumber();
        }
        this.addElement.removeAcl(string, n);
    }

    private boolean addElement(User user) {
        boolean bl = user.isNeverExpire();
        Date date = user.getLastModifyTime();
        long l = date.getTime();
        int n = user.getExpireTime();
        int n2 = user.getAuthType();
        if (n2 == 1) {
            return false;
        }
        if (bl) {
            return false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(System.currentTimeMillis());
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTimeInMillis(l);
        ((Calendar)gregorianCalendar2).add(5, n);
        return gregorianCalendar.after(gregorianCalendar2);
    }

    public boolean isExpired(String string) {
        User user;
        try {
            user = this.getIntegrityUser(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            return true;
        }
        return this.addElement(user);
    }

    public boolean isEditing(int n) {
        if (this.addNewGroup != null) {
            return this.addNewGroup.isEditing(n);
        }
        return false;
    }

    public String[] getAllInheritRoleNames(String string) throws NoSuchUserException {
        String[] stringArray;
        Object object;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        User user = this.getUser(string);
        Vector vector = user.getParentRoleNames();
        int n = 0;
        while (n < vector.size()) {
            object = (String)vector.elementAt(n);
            linkedList.add(object);
            this.addGroupIntoParentGroup((String)object, linkedList);
            ++n;
        }
        object = user.getGroupNames();
        int n2 = 0;
        while (n2 < ((Vector)object).size()) {
            stringArray = (String)((Vector)object).elementAt(n2);
            this.addGroupIntoRole((String)stringArray, linkedList);
            ++n2;
        }
        stringArray = new String[linkedList.size()];
        linkedList.toArray(stringArray);
        return stringArray;
    }

    private void addGroupIntoParentGroup(String string, LinkedList linkedList) {
        Role role;
        try {
            role = this.getRole(string);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException);
            return;
        }
        if (role != null) {
            Vector vector = role.getParentRoleNames();
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                linkedList.add(string2);
                this.addGroupIntoParentGroup(string2, linkedList);
                ++n;
            }
        }
    }

    private void addGroupIntoRole(String string, LinkedList linkedList) {
        Group group;
        try {
            group = this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException);
            return;
        }
        if (group != null) {
            Vector vector = group.getRoleNames();
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                linkedList.add(string2);
                this.addGroupIntoParentGroup(string2, linkedList);
                ++n;
            }
        }
    }

    public String[] getAllInheritGroupNames(String string) throws NoSuchUserException {
        String[] stringArray;
        LinkedList linkedList = new LinkedList();
        User user = this.getUser(string);
        Vector vector = user.getGroupNames();
        int n = 0;
        while (n < vector.size()) {
            stringArray = (String)vector.elementAt(n);
            this.addNewGroup((String)stringArray, linkedList);
            ++n;
        }
        stringArray = new String[linkedList.size()];
        linkedList.toArray(stringArray);
        return stringArray;
    }

    private void addNewGroup(String string, LinkedList linkedList) {
        Group group;
        try {
            group = this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException);
            return;
        }
        if (group != null) {
            Vector vector = group.getParentGroupNames();
            int n = 0;
            while (n < vector.size()) {
                String string2 = (String)vector.elementAt(n);
                linkedList.add(string2);
                this.addNewGroup(string2, linkedList);
                ++n;
            }
        }
    }

    public Vector getReferUsers(String string) throws NoSuchUserException {
        Vector vector = new Vector();
        NameComparator nameComparator = new NameComparator();
        if (this.isAdminUser(string)) {
            Enumeration enumeration = this.getAllUsersName().elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            vector.remove("admin");
            vector.remove(string);
            Sorter.sort(vector, (Comparator)nameComparator);
            return vector;
        }
        User user = this.getUser(string);
        Vector vector2 = (Vector)user.getGroupNames().clone();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Group group;
            String string2 = (String)enumeration.nextElement();
            try {
                group = this.addGroupIntoParentGroup.getGroup(string2);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                ServiceLogger.logDebug(6630066, 6);
                continue;
            }
            Vector vector3 = group.getUserNames();
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                if (vector.contains(string3) || string3.equals(string)) continue;
                vector.add(string3);
            }
        }
        Sorter.sort(vector, (Comparator)nameComparator);
        return vector;
    }

    public Vector getReferRoles(String string) throws NoSuchUserException {
        this.QOIV.getUser(string);
        Vector<String> vector = new Vector<String>();
        NameComparator nameComparator = new NameComparator();
        Enumeration enumeration = this.getAllRolesName().elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("administrators")) continue;
            vector.add(string2);
        }
        Sorter.sort(vector, (Comparator)nameComparator);
        return vector;
    }

    public Vector getReferGroups(String string) throws NoSuchUserException {
        this.QOIV.getUser(string);
        Vector<String> vector = new Vector<String>();
        NameComparator nameComparator = new NameComparator();
        Enumeration enumeration = this.getAllGroupsName().elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            vector.add(string2);
        }
        Sorter.sort(vector, (Comparator)nameComparator);
        return vector;
    }

    public Vector getImportedLDAPUsers() {
        Enumeration enumeration = this.QOIV.getAllUsers();
        Vector<User> vector = new Vector<User>();
        while (enumeration.hasMoreElements()) {
            User user = (User)enumeration.nextElement();
            int n = user.getAuthType();
            if (n != 1) continue;
            vector.add(user);
        }
        return vector;
    }

    public Vector getImportedLDAPUserNames() {
        Enumeration enumeration = this.QOIV.getAllUsers();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            User user = (User)enumeration.nextElement();
            int n = user.getAuthType();
            if (n != 1) continue;
            vector.add(user.getName());
        }
        return vector;
    }

    public Vector getImportedLDAPRoles() {
        Enumeration enumeration = this.add.getAllRoles();
        Vector<Role> vector = new Vector<Role>();
        while (enumeration.hasMoreElements()) {
            Role role = (Role)enumeration.nextElement();
            int n = role.getType();
            if (n != 1) continue;
            vector.add(role);
        }
        return vector;
    }

    public Vector getImportedLDAPRoleNames() {
        Enumeration enumeration = this.add.getAllRoles();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            Role role = (Role)enumeration.nextElement();
            int n = role.getType();
            if (n != 1) continue;
            vector.add(role.getName());
        }
        return vector;
    }

    public Vector getImportedLDAPGroups() {
        Enumeration enumeration = this.addGroupIntoParentGroup.getAllGroups();
        Vector<Group> vector = new Vector<Group>();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            int n = group.getType();
            if (n != 1) continue;
            vector.add(group);
        }
        return vector;
    }

    public Vector getImportedLDAPGroupNames() {
        Enumeration enumeration = this.addGroupIntoParentGroup.getAllGroups();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            Group group = (Group)enumeration.nextElement();
            int n = group.getType();
            if (n != 1) continue;
            vector.add(group.getName());
        }
        return vector;
    }

    public String addLDAPUser(LDAPUser lDAPUser, boolean bl) {
        String string;
        String string2;
        String string3;
        Object object;
        String string4 = lDAPUser.getName();
        if (string4 == null) {
            return JSvrResource.getMessage("SECURITY_ERR_30_LDAP_NULL_NAME");
        }
        if (string4.equals("admin") || string4.equals("guest")) {
            Object[] objectArray = new String[]{"admin", "guest"};
            return JSvrResource.getMessage("SECURITY_ERR_31_IMPORTED_BUILDED_USER", objectArray);
        }
        try {
            object = this.getIntegrityUser(string4);
            if (object.getAuthType() == 1) {
                return null;
            }
            if (!bl) {
                return JSvrResource.getMessage("SECURITY_ERR_32_LDAP_USER_EXIST");
            }
            this.QOIV.removeUser(string4);
        }
        catch (InUseException inUseException) {
            ServiceLogger.logDebug(6630067, string4, 6);
            return JSvrResource.getMessage("SECURITY_ERR_33_CAN_NOT_COVER", string4);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException, 3);
        }
        object = lDAPUser.getProperty("full_name");
        if (object == null) {
            object = "";
        }
        if ((string3 = lDAPUser.getProperty("description")) == null) {
            string3 = "";
        }
        if ((string2 = lDAPUser.getProperty("email")) == null) {
            string2 = "";
        }
        Date date = new Date(System.currentTimeMillis());
        String string5 = lDAPUser.getProperty("ldapuser_dn");
        if (string5 == null || string5.trim().length() == 0) {
            string5 = "";
        }
        String string6 = string5;
        boolean bl2 = true;
        int n = 0;
        Date date2 = new Date(System.currentTimeMillis());
        boolean bl3 = true;
        int n2 = 30;
        boolean bl4 = false;
        try {
            string = this.QOIV.addNewUser(string4, (String)object, string3, string2, date, string6, bl2, n, date2, bl3, n2, bl4, true);
        }
        catch (UserExistsException userExistsException) {
            string = JSvrResource.getMessage("SECURITY_ERR_32_LDAP_USER_EXIST");
        }
        User user = null;
        try {
            user = this.getUser(string4);
        }
        catch (NoSuchUserException noSuchUserException) {
            return noSuchUserException.getMessage();
        }
        if (string == null) {
            ServiceLogger.logDebug(6630068, string4, 6);
            Vector vector = new Vector();
            this.setPrincipalPrivileges(user, vector);
            return null;
        }
        ServiceLogger.logDebug(string);
        ServiceLogger.logDebug(6630069, 6);
        return JSvrResource.getMessage("SECURITY_ERR_34_LDAP_USER_ADD_FAILED");
    }

    public String addLDAPGroup(LDAPGroup lDAPGroup, boolean bl) {
        Group group;
        if (bl) {
            String string = lDAPGroup.getName();
            if (string == null || string.length() == 0) {
                return JSvrResource.getMessage("SVR_99");
            }
            String string2 = LDAPData.getProperty("groupAdminGroup");
            if (string.equals("administrators") || string.equals("everyone")) {
                Object[] objectArray = new String[]{"admin", "guest"};
                return JSvrResource.getMessage("SECURITY_ERR_35_IMPORTED_BUILDED_ROLE", objectArray);
            }
            String string3 = lDAPGroup.getProperty("description");
            String string4 = lDAPGroup.getProperty("group_dn");
            String string5 = null;
            try {
                string5 = this.add.addNewRole(string, string4, 1);
            }
            catch (RoleExistsException roleExistsException) {
                ServiceLogger.logDebug(6630070, string, 6);
            }
            if (string5 != null) {
                return string5;
            }
            if (string2 != null && string2.length() != 0 && string.equals(string2)) {
                try {
                    this.add.addRoleToParentRole(string, "administrators");
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    return JSvrResource.getMessage("SECURITY_ERR_36_NO_LDAP_ROLE", string);
                }
            }
            Vector vector = new Vector();
            Role role = null;
            try {
                role = this.getRole(string);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                return noSuchRoleException.getMessage();
            }
            this.setPrincipalPrivileges(role, vector);
            return null;
        }
        String string = lDAPGroup.getName();
        if (string == null || string.length() == 0) {
            return JSvrResource.getMessage("SECURITY_ERR_73_GROUP_NAME_NULL");
        }
        String string6 = LDAPData.getProperty("groupAdminGroup");
        String string7 = lDAPGroup.getProperty("description");
        String string8 = lDAPGroup.getProperty("group_dn");
        String string9 = null;
        try {
            string9 = this.addGroupIntoParentGroup.addNewGroup(string, string8, 1);
        }
        catch (GroupExistsException groupExistsException) {
            ServiceLogger.logDebug(6630071, string, 6);
        }
        if (string9 != null) {
            return string9;
        }
        if (string6 != null && string6.length() != 0 && string.equals(string6)) {
            try {
                this.add.addGroupIntoRole(string, "administrators");
            }
            catch (NoSuchRoleException noSuchRoleException) {
                return JSvrResource.getMessage("SECURITY_ERR_36_NO_LDAP_ROLE", string);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                return JSvrResource.getMessage("SEUCRITY_ERR_63_GROUP_NOT_EXIST", string);
            }
        }
        try {
            group = this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            return noSuchGroupException.getMessage();
        }
        Vector vector = new Vector();
        this.setPrincipalPrivileges(group, vector);
        return null;
    }

    public ExSecurityData getSecurityData() {
        return this.addGroupIntoRole;
    }

    public int getDefaultAclID() {
        return 1;
    }

    public String getPassword(String string) throws NoSuchUserException {
        return this.QOIV.getPassword(string);
    }

    public synchronized boolean removeUserInherRelation(String string) {
        User user;
        try {
            user = this.getUser(string);
        }
        catch (NoSuchUserException noSuchUserException) {
            return false;
        }
        Vector vector = (Vector)user.getParentRoleNames().clone();
        Vector vector2 = (Vector)user.getGroupNames().clone();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            try {
                this.removeUserFromParentRole(string, string2);
            }
            catch (NoSuchRoleException noSuchRoleException) {
            }
            catch (NoSuchUserException noSuchUserException) {
                return false;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            String string3 = (String)vector2.elementAt(n2);
            try {
                this.removeUserFromGroup(string, string3);
            }
            catch (NoSuchGroupException noSuchGroupException) {
            }
            catch (NoSuchUserException noSuchUserException) {
                // empty catch block
            }
            ++n2;
        }
        return true;
    }

    public synchronized boolean removeRoleInherRelation(String string) {
        Role role;
        try {
            role = this.getRole(string);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            return false;
        }
        Vector vector = (Vector)role.getSubUserNames().clone();
        Vector vector2 = (Vector)role.getGroupNames().clone();
        Vector vector3 = (Vector)role.getSubRoleNames().clone();
        Vector vector4 = (Vector)role.getParentRoleNames().clone();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            try {
                this.removeUserFromParentRole(string2, string);
            }
            catch (NoSuchUserException noSuchUserException) {
            }
            catch (NoSuchRoleException noSuchRoleException) {
                // empty catch block
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            String string3 = (String)vector2.elementAt(n2);
            try {
                this.removeGroupFromRole(string3, string);
            }
            catch (NoSuchGroupException noSuchGroupException) {
            }
            catch (NoSuchRoleException noSuchRoleException) {
                // empty catch block
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < vector3.size()) {
            String string4 = (String)vector3.elementAt(n3);
            try {
                this.removeRoleFromParentRole(string4, string);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                // empty catch block
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < vector4.size()) {
            String string5 = (String)vector4.elementAt(n4);
            try {
                this.removeRoleFromParentRole(string, string5);
            }
            catch (NoSuchRoleException noSuchRoleException) {
                // empty catch block
            }
            ++n4;
        }
        return true;
    }

    public boolean removeGroupInherRelation(String string) {
        Group group;
        try {
            group = this.getGroup(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            return false;
        }
        Vector vector = (Vector)group.getUserNames().clone();
        Vector vector2 = (Vector)group.getSubGroupNames().clone();
        Vector vector3 = (Vector)group.getParentGroupNames().clone();
        Vector vector4 = (Vector)group.getRoleNames().clone();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            try {
                this.removeUserFromGroup(string2, string);
            }
            catch (NoSuchUserException noSuchUserException) {
            }
            catch (NoSuchGroupException noSuchGroupException) {
                // empty catch block
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            String string3 = (String)vector2.elementAt(n2);
            try {
                this.removeSubGroupFromGroup(string3, string);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                // empty catch block
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < vector3.size()) {
            String string4 = (String)vector3.elementAt(n3);
            try {
                this.removeSubGroupFromGroup(string, string4);
            }
            catch (NoSuchGroupException noSuchGroupException) {
                // empty catch block
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < vector4.size()) {
            String string5 = (String)vector4.elementAt(n4);
            try {
                this.removeGroupFromRole(string, string5);
            }
            catch (NoSuchGroupException noSuchGroupException) {
            }
            catch (NoSuchRoleException noSuchRoleException) {
                // empty catch block
            }
            ++n4;
        }
        return true;
    }

    public JAcl getExtendAcl() throws NoSuchAclException {
        return this.addElement.getExtendAcl();
    }

    public void setPrincipalPrivileges(Principal principal, Vector vector) {
        this.addElement.setPrivileges(principal, vector);
    }

    public Vector getPrincipalPrivileges(Principal principal) {
        return this.addElement.getPrivileges(principal);
    }

    public Vector getPrivilegedPrincipals(byte by, String string) {
        if (by == 1) {
            return this.addElement.getPrivilegedUsers(string);
        }
        if (by == 2) {
            return this.addElement.getPrivilegedRoles(string);
        }
        if (by == 3) {
            return this.addElement.getPrivilegedGroups(string);
        }
        return new Vector();
    }

    public void addPrivilegedPrincipal(String string, Vector vector, byte by) {
        if (by == 1) {
            this.addElement.addPrivilegedUsers(string, vector);
        } else if (by == 2) {
            this.addElement.addPrivilegedRoles(string, vector);
        } else if (by == 3) {
            this.addElement.addPrivilegedGroups(string, vector);
        }
    }

    public String removePrivilegedPrincipals(String string, Vector vector, byte by) {
        if (by == 1) {
            return this.addElement.removePrivilegedUsers(string, vector);
        }
        if (by == 2) {
            return this.addElement.removePrivilegedRoles(string, vector);
        }
        if (by == 3) {
            return this.addElement.removePrivilegedGroups(string, vector);
        }
        return "No Such Principal Type!";
    }

    public String addNewGroup(String string, String string2) throws GroupExistsException {
        return this.addGroupIntoParentGroup.addNewGroup(string, string2, 0);
    }

    public String removeGroup(String string) throws InUseException, NoSuchGroupException {
        return this.addGroupIntoParentGroup.removeGroup(string);
    }

    public String addSubGroupToGroup(String string, String string2) throws NoSuchGroupException {
        return this.addGroupIntoParentGroup.addGroupIntoParentGroup(string, string2);
    }

    public String addUserToGroup(String string, String string2) throws NoSuchGroupException, NoSuchUserException {
        return this.QOIV.addUserToGroup(string, string2);
    }

    public String addGroupToRole(String string, String string2) throws NoSuchGroupException, NoSuchRoleException {
        return this.add.addGroupIntoRole(string, string2);
    }

    public String removeSubGroupFromGroup(String string, String string2) throws NoSuchGroupException {
        return this.addGroupIntoParentGroup.removeGroupFromParentGroup(string, string2);
    }

    public String removeUserFromGroup(String string, String string2) throws NoSuchGroupException, NoSuchUserException {
        return this.QOIV.removeUserFromGroup(string, string2);
    }

    public String removeGroupFromRole(String string, String string2) throws NoSuchGroupException, NoSuchRoleException {
        return this.add.removeGroupFromRole(string, string2);
    }

    public Vector getSubGroupsByGroup(String string) throws NoSuchGroupException {
        Vector<Group> vector = new Vector<Group>();
        Group group = this.getGroup(string);
        Vector vector2 = group.getSubGroupNames();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Group group2 = this.getGroup(string2);
            vector.add(group2);
        }
        return vector;
    }

    public Vector getAllUserNamesByReferedRole(String string) throws NoSuchRoleException, NoSuchGroupException {
        Object object;
        Vector vector = new Vector();
        this.addNewRole(vector, this.getUsersNameByRole(string));
        Vector vector2 = this.getGroupsByRole(string);
        int n = 0;
        while (n < vector2.size()) {
            object = (Group)vector2.get(n);
            this.addNewRole(vector, this.getAllContainedUserNamesByGroup(object.getName()));
            ++n;
        }
        object = this.add.getSubRoleNames(string);
        int n2 = 0;
        while (n2 < ((Vector)object).size()) {
            this.addNewRole(vector, this.getAllUserNamesByReferedRole((String)((Vector)object).get(n2)));
            ++n2;
        }
        return vector;
    }

    public Vector getAllContainedUserNamesByGroup(String string) throws NoSuchGroupException {
        Vector vector = new Vector();
        this.addNewRole(vector, this.getUsersNameByGroup(string));
        Group group = this.getGroup(string);
        Vector vector2 = group.getSubGroupNames();
        int n = 0;
        while (n < vector2.size()) {
            this.addNewRole(vector, this.getAllContainedUserNamesByGroup((String)vector2.get(n)));
            ++n;
        }
        return vector;
    }

    private void addNewRole(Vector vector, Vector vector2) {
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            if (!vector.contains(vector2.get(n2))) {
                vector.add(vector2.get(n2));
            }
            ++n2;
        }
    }
}

