/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.server.api.exception.NoSuchAclException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.intf.resource.Node;
import jet.server.intf.resource.Version;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.SecurityService;
import jet.server.intf.security.User;
import jet.server.intf.security.UserFolderListener;
import jet.server.jrc.security.AclExistException;
import jet.server.jrc.security.GroupImpl;
import jet.server.jrc.security.JSPermissionImpl;
import jet.server.jrc.security.NoSuchAclEntryException;
import jet.server.jrc.security.RoleImpl;
import jet.server.jrc.security.SecurityDataImplForAPI;
import jet.server.jrc.security.UserImpl;
import jet.server.log.ServiceLogger;
import jet.server.userman.UserAuthenticator;

public class SecurityServiceImpl3
implements SecurityService {
    private String QOIV;
    private UserAuthenticator addElement;
    private UserFolderListener changePassword;
    private ExSecurityData checkPermission;

    public SecurityServiceImpl3(String string, UserAuthenticator userAuthenticator) {
        this.QOIV = string;
        this.addElement = userAuthenticator;
        this.checkPermission = new SecurityDataImplForAPI(this);
    }

    public boolean isValidUser(String string, String string2) {
        return this.addElement.isValidUser(this.QOIV, string, string2);
    }

    public boolean isAdminUser(String string) {
        String string2 = this.addElement.getPassword(this.QOIV, string);
        return this.addElement.isValidAdminUser(this.QOIV, string, string2);
    }

    public User getUser(String string) throws NoSuchUserException {
        return new UserImpl(string);
    }

    public User getIntegrityUser(String string) throws NoSuchUserException {
        return new UserImpl(string);
    }

    public Vector getAllUsers() {
        Vector<UserImpl> vector = new Vector<UserImpl>();
        Enumeration enumeration = this.addElement.getUserNames(this.QOIV);
        while (enumeration.hasMoreElements()) {
            vector.addElement(new UserImpl((String)enumeration.nextElement()));
        }
        return vector;
    }

    public Vector getUsersNameByRole(String string) throws NoSuchRoleException {
        return new Vector(0);
    }

    public Role getRole(String string) throws NoSuchRoleException {
        return new RoleImpl(string);
    }

    public Vector getAllRoles() {
        return new Vector(0);
    }

    public Vector getRolesNameByUser(String string) throws NoSuchUserException {
        return new Vector(0);
    }

    public Group getGroup(String string) throws NoSuchGroupException {
        return new GroupImpl(string);
    }

    public Vector getAllGroups() {
        return new Vector(0);
    }

    public Vector getGroupsNameByUser(String string) throws NoSuchUserException {
        return new Vector(0);
    }

    public Vector getUsersNameByGroup(String string) throws NoSuchGroupException {
        return new Vector(0);
    }

    public String changePassword(boolean bl, String string, String string2, String string3, String string4) throws NoSuchUserException {
        return this.addElement.changePassword(this.QOIV, string, string3, string2, string4);
    }

    public boolean getAuditState(String string, int n, boolean bl) throws NoSuchUserException {
        return this.addElement.getAuditState(this.QOIV, string, n, bl);
    }

    public Vector getAllUsersName() {
        Vector vector = new Vector();
        Enumeration enumeration = this.addElement.getUserNames(this.QOIV);
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public Vector getAllRolesName() {
        return new Vector(0);
    }

    public Vector getAllGroupsName() {
        return new Vector(0);
    }

    public void addUserFolderListener(UserFolderListener userFolderListener) {
        this.changePassword = userFolderListener;
    }

    public Vector getReferUsers(String string) throws NoSuchUserException {
        return new Vector(0);
    }

    public Vector getReferRoles(String string) throws NoSuchUserException {
        return new Vector(0);
    }

    public Vector getReferGroups(String string) throws NoSuchUserException {
        return new Vector(0);
    }

    public boolean checkPermission(String string, int n, String string2, Permission permission) {
        boolean bl = n > 0 ? this.addElement.isPermissionOk(this.QOIV, string2, string, n, JSPermissionImpl.getCmd(permission)) : this.addElement.isPermissionOk(this.QOIV, string2, string, n, JSPermissionImpl.getCmd(permission));
        ServiceLogger.logDebug(6630001, new Object[]{string, String.valueOf(n), string2, permission, String.valueOf(bl)}, 6);
        return bl;
    }

    public boolean checkPermission(Node node, String string, Permission permission) {
        String string2;
        int n = -1;
        if (node.getNodeType() == 3) {
            string2 = node.getParent().getAbsolutePath();
            n = ((Version)node).getVersionNumber();
        } else {
            string2 = node.getAbsolutePath();
        }
        boolean bl = this.checkPermission(string2, n, string, permission);
        ServiceLogger.logDebug(6630002, new Object[]{node.getParent().getAbsolutePath(), string, permission, String.valueOf(bl)}, 6);
        return bl;
    }

    public boolean checkPrivilege(String string, String string2) {
        return this.addElement.isPermissionOk(this.QOIV, string, "jrs.p_r_i_v_i_l_e_g_e_uri", string2);
    }

    public void clearPermissions(Node node) {
    }

    public Hashtable[] getPermissions(Node node) {
        return null;
    }

    public Hashtable[] getAccessPermissions(Node node) throws NotOwnerException, NoSuchAclException {
        return new Hashtable[0];
    }

    public int setPermissions(Node node, String string, Hashtable[] hashtableArray) throws NoSuchAclException, NotOwnerException, AclExistException {
        return -1;
    }

    public void setAccessPermissions(Node node, String string, Hashtable[] hashtableArray) throws NoSuchAclException {
    }

    public boolean removeUserPermissions(Node node, String string) throws NoSuchAclException, NoSuchAclEntryException {
        return false;
    }

    public boolean removeRolePermissions(Node node, String string) throws NoSuchAclException, NoSuchAclEntryException {
        return false;
    }

    public boolean removeGroupPermissions(Node node, String string) throws NoSuchAclException, NoSuchAclEntryException {
        return false;
    }

    public int getDefaultAclID() {
        return 0;
    }

    public ExSecurityData getSecurityData() {
        return this.checkPermission;
    }

    public String getPassword(String string) throws NoSuchUserException {
        return this.addElement.getPassword(this.QOIV, string);
    }

    public boolean isExpired(String string) {
        return false;
    }

    public boolean isEditing(int n) {
        return true;
    }

    public String[] getAllInheritRoleNames(String string) throws NoSuchUserException {
        return new String[0];
    }

    public String[] getAllInheritGroupNames(String string) throws NoSuchUserException {
        return new String[0];
    }

    public Vector getAllUserNamesByReferedRole(String string) throws NoSuchRoleException, NoSuchGroupException {
        return new Vector();
    }

    public Vector getAllContainedUserNamesByGroup(String string) throws NoSuchGroupException {
        return new Vector();
    }
}

