/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;
import jet.server.ServerEnv;
import jet.server.api.UserMailList;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UnknownResource;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.security.JSPermissionImpl;
import jet.server.jrc.security.Realm;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;
import jet.server.userman.JReportImplementation;
import jet.server.userman.UserAuthenticator;

public class UserAuthenticatorImpl
implements UserAuthenticator,
JReportImplementation {
    String QOIV = ServerEnv.realmsPath;
    UserMailList append = UserDataToolkit.getMailList();

    public String changePassword(String string, String string2, String string3, String string4, String string5) {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        try {
            return securityService.changePassword(false, string2, string4, string3, string5);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException, 6);
            return "user: " + string3 + " does not exist in realm: " + string;
        }
    }

    public boolean isPermissionOk(String string, String string2, String string3, String string4) {
        ServiceLogger.logDebug(4630003, String.valueOf(ServerEnv.needSecurity()), 4);
        ServiceLogger.logDebug(4630004, string4, 4);
        if (!ServerEnv.needSecurity()) {
            return true;
        }
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        if (string3.equalsIgnoreCase("jrs.p_r_i_v_i_l_e_g_e_uri")) {
            return securityService.checkPrivilege(string2, string4);
        }
        if (securityService.isAdminUser(string2) && (string4.equals("jrs.stop_task") || string4.equals("jrs.del_schedule") || string4.equals("jrs.del_completed") || string4.equals("jrs.del_all_completed") || string4.equals("jrs.enable_schedule") || string4.equals("jrs.disable_schedule"))) {
            return true;
        }
        return this.isPermissionOk(string, string2, string3, JSPermissionImpl.parseCmds(string4));
    }

    private boolean isPermissionOk(String string, String string2, String string3, Vector vector) {
        Object object;
        ServiceLogger.logDebug(4630005, new Object[]{string2, string3, vector}, 4);
        try {
            object = UserDataToolkit.getSecurityService(string);
            object.getUser(string2);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logDebug(6630006, string2, 6);
        }
        if (string3 != null && string3.startsWith("/USERFOLDERPATH")) {
            return string3.startsWith("/USERFOLDERPATH/" + string2);
        }
        object = vector;
        if (object == null) {
            ServiceLogger.logDebug(4630007, 4);
            return true;
        }
        try {
            ResourceTreeManagerImpl resourceTreeManagerImpl = UserDataToolkit.getResourceManager(string);
            int n = 0;
            while (n < ((Vector)object).size()) {
                block10: {
                    try {
                        if (!resourceTreeManagerImpl.checkPermission(string3, string2, (Permission)((Vector)object).elementAt(n))) {
                            ServiceLogger.logDebug(4630008, 4);
                            return false;
                        }
                    }
                    catch (UnknownResource unknownResource) {
                        if (ServerEnv.isUndefinedResourceFree()) break block10;
                        ServiceLogger.logError(unknownResource, 6);
                        return false;
                    }
                }
                ++n;
            }
            ServiceLogger.logDebug(4630007, 4);
            return true;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    public boolean isPermissionOk(String string, String string2, String string3, int n, String string4) {
        ServiceLogger.logDebug(4630003, String.valueOf(ServerEnv.needSecurity()), 4);
        ServiceLogger.logDebug(4630004, string4, 4);
        if (!ServerEnv.needSecurity()) {
            return true;
        }
        return this.isPermissionOk(string, string2, string3, n, JSPermissionImpl.parseCmds(string4));
    }

    private boolean isPermissionOk(String string, String string2, String string3, int n, Vector vector) {
        Object object;
        ServiceLogger.logDebug(4630009, new Object[]{string2, string3, String.valueOf(n), vector}, 4);
        try {
            object = UserDataToolkit.getSecurityService(string);
            object.getUser(string2);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logDebug(6630010, string2, 6);
        }
        if (string3 != null && string3.startsWith("/USERFOLDERPATH")) {
            return string3.startsWith("/USERFOLDERPATH/" + string2);
        }
        object = vector;
        if (object == null) {
            ServiceLogger.logDebug(4630007, 4);
            return true;
        }
        try {
            ResourceTreeManagerImpl resourceTreeManagerImpl = UserDataToolkit.getResourceManager(string);
            int n2 = 0;
            while (n2 < ((Vector)object).size()) {
                if (!resourceTreeManagerImpl.checkPermission(string3, n, string2, (Permission)((Vector)object).elementAt(n2))) {
                    ServiceLogger.logDebug(4630008, 4);
                    return false;
                }
                ++n2;
            }
            ServiceLogger.logDebug(4630007, 4);
            return true;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return false;
        }
    }

    public boolean isValidUser(String string, String string2, String string3) {
        ServiceLogger.logDebug(4630011, String.valueOf(ServerEnv.needSecurity()), 4);
        ServiceLogger.logDebug(4630012, new Object[]{string, string2}, 4);
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        boolean bl = securityService.isValidUser(string2, string3);
        ServiceLogger.logDebug(4630013, String.valueOf(bl), 4);
        return bl;
    }

    public boolean isValidAdminUser(String string, String string2, String string3) {
        ServiceLogger.logDebug(4630014, String.valueOf(ServerEnv.needSecurity()), 4);
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        boolean bl = securityService.isValidUser(string2, string3) && securityService.isAdminUser(string2);
        ServiceLogger.logDebug(4630015, String.valueOf(bl), 4);
        return bl;
    }

    public String getPassword(String string, String string2) {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        try {
            return securityService.getPassword(string2);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException);
            return null;
        }
    }

    public boolean checkExpire(String string, String string2) {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        return securityService.isExpired(string2);
    }

    public Enumeration getRealmNames() {
        return Realm.list().elements();
    }

    public Enumeration getUserNames(String string) {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        return securityService.getAllUsersName().elements();
    }

    public boolean getAuditState(String string, String string2, int n, boolean bl) {
        SecurityService securityService = UserDataToolkit.getSecurityService(string);
        try {
            return securityService.getAuditState(string2, n, bl);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException, 6);
            return false;
        }
    }

    public UserMailList getMailList() {
        return this.append;
    }
}

