/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security;

import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import jet.JSvrResource;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.AuthenticationProvider;
import jet.server.api.custom.security.SecurityListener;
import jet.server.api.custom.security.relation.GroupUserRelationProvider;
import jet.server.api.custom.security.relation.RoleUserRelationProvider;
import jet.server.api.custom.security.role.RoleProvider;
import jet.server.api.custom.security.user.UserProvider;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.UserExistsException;
import jet.server.intf.security.SecurityWebUIController;
import jet.server.intf.security.User;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.cache.CachedSecurityDataImpl;
import jet.server.jrc.security.custom.SecurityListenerSynImpl;
import jet.server.jrc.security.custom.db.role.RoleProviderDBImpl;
import jet.server.log.ServiceLogger;

public class UserDataManager {
    private UserProvider QOIV;
    private RoleProvider add;
    private GroupUserRelationProvider addPrincipal;
    private RoleUserRelationProvider addRelation;
    private AuthenticationProvider addUser;
    private CachedSecurityDataImpl addUserToGroup;
    private SecurityListener addUserToRole;
    private String changePassword;
    boolean contains = true;
    boolean currentTimeMillis = true;
    boolean elements = true;
    boolean equals = true;
    boolean getAdhocResourceManager = true;
    boolean getAllUsers = true;

    public UserDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl, SecurityWebUIController securityWebUIController) {
        this.addUserToGroup = exCachedSecurityDataImpl;
        this.changePassword = exCachedSecurityDataImpl.getRealmName();
        this.contains = securityWebUIController.isEditing(1);
        this.currentTimeMillis = securityWebUIController.isEditing(4);
        this.elements = securityWebUIController.isEditing(3);
        this.equals = securityWebUIController.isEditing(19);
        this.getAdhocResourceManager = securityWebUIController.isEditing(17);
        this.getAllUsers = securityWebUIController.isEditing(0);
        this.QOIV = exCachedSecurityDataImpl.getUserProvider();
        this.add = exCachedSecurityDataImpl.getRoleProvider();
        this.addPrincipal = exCachedSecurityDataImpl.getGroupUserRelationProvider();
        this.addRelation = exCachedSecurityDataImpl.getRoleUserRelationProvider();
        this.addUser = exCachedSecurityDataImpl.getAuthenticationProvider();
        this.addUserToRole = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public UserDataManager(ExCachedSecurityDataImpl exCachedSecurityDataImpl) {
        this.addUserToGroup = exCachedSecurityDataImpl;
        this.changePassword = exCachedSecurityDataImpl.getRealmName();
        this.QOIV = exCachedSecurityDataImpl.getUserProvider();
        this.addPrincipal = exCachedSecurityDataImpl.getGroupUserRelationProvider();
        this.addRelation = exCachedSecurityDataImpl.getRoleUserRelationProvider();
        this.addUser = exCachedSecurityDataImpl.getAuthenticationProvider();
        this.addUserToRole = new SecurityListenerSynImpl(exCachedSecurityDataImpl);
    }

    public synchronized User getUser(String string) throws NoSuchUserException {
        User user = this.addUserToGroup.getIntegrityUser(string);
        if (user == null) {
            throw new NoSuchUserException(JSvrResource.getMessage("SVR_93", string));
        }
        return user;
    }

    public synchronized BaseUser getBaseUser(String string) throws NoSuchUserException {
        BaseUser baseUser = this.addUserToGroup.getUser(string);
        if (baseUser == null) {
            throw new NoSuchUserException(JSvrResource.getMessage("SVR_93", string));
        }
        return baseUser;
    }

    public synchronized String addNewUser(String string, String string2, String string3, String string4, Date date, String string5, boolean bl, int n, Date date2, boolean bl2, int n2, boolean bl3, boolean bl4) throws UserExistsException {
        if (!this.currentTimeMillis) {
            return "Can not add user when the UserProvider isEnableEdit() method return false";
        }
        try {
            this.getBaseUser(string);
            throw new UserExistsException(630083, (Object[])new String[]{string}, null);
        }
        catch (NoSuchUserException noSuchUserException) {
            int n3 = 0;
            if (bl4) {
                n3 = 1;
            }
            Properties properties = new Properties();
            properties.setProperty("user_name", string);
            properties.setProperty("user_password", string5);
            properties.setProperty("user_db_ldapType", "false");
            properties.setProperty("user_fullname", string2);
            properties.setProperty("user_description", string3);
            properties.setProperty("user_email", string4);
            properties.put("user_create_time", new Date(System.currentTimeMillis()));
            properties.setProperty("user_enable_null_pwd", String.valueOf(bl));
            properties.setProperty("user_min_pwd_length", String.valueOf(n));
            properties.put("user_last_modify_time", new Date(System.currentTimeMillis()));
            properties.setProperty("user_never_expire", String.valueOf(bl2));
            properties.setProperty("user_expire_time", String.valueOf(n2));
            properties.setProperty("user_disabled_account", String.valueOf(bl3));
            properties.setProperty("user_db_ldapType", String.valueOf(n3));
            try {
                this.QOIV.addUser(this.changePassword, properties);
                this.addUserToRole.addPrincipal(this.changePassword, string, 1);
            }
            catch (JRCustomerException jRCustomerException) {
                ServiceLogger.logError(jRCustomerException);
                return JSvrResource.getMessage("SECURITY_M_00001", string);
            }
            if (this.add instanceof RoleProviderDBImpl) {
                Properties properties2 = null;
                try {
                    properties2 = this.add.getRoleProperties(this.changePassword, "everyone");
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    ServiceLogger.logError(noSuchRoleException, 3);
                }
                catch (JRCustomerException jRCustomerException) {
                    ServiceLogger.logError(jRCustomerException, 3);
                }
                if (properties2 != null && properties2.size() != 0 && this.getAdhocResourceManager) {
                    try {
                        this.addRelation.addUserToRole(this.changePassword, "everyone", string);
                        this.addUserToRole.addRelation(this.changePassword, "everyone", 2, string, 1);
                    }
                    catch (NoSuchRoleException noSuchRoleException) {
                        ServiceLogger.logError(noSuchRoleException);
                    }
                    catch (NoSuchUserException noSuchUserException2) {
                        ServiceLogger.logError(noSuchUserException2);
                    }
                    catch (JRCustomerException jRCustomerException) {
                        ServiceLogger.logError(jRCustomerException);
                    }
                }
            }
            return null;
        }
    }

    public synchronized String removeUser(String string) throws NoSuchUserException {
        if (!this.elements) {
            return "Can not remove the user when the UserProvider isEnableEdit() method return false";
        }
        this.getBaseUser(string);
        try {
            this.QOIV.removeUser(this.changePassword, string);
            UserDataToolkit.getAdhocResourceManager().removeUpload(this.changePassword, string);
        }
        catch (JRCustomerException jRCustomerException) {
            return JSvrResource.getMessage("SECURITY_M_00002", string);
        }
        this.addUserToRole.removePrincipal(this.changePassword, string, 1);
        return null;
    }

    public synchronized Vector getParentRoleNames(String string) throws NoSuchUserException {
        BaseUser baseUser = this.getBaseUser(string);
        return baseUser.getParentRoleNames();
    }

    public synchronized String updataAttributes(String string, String string2, String string3, String string4, boolean bl, int n, Date date, boolean bl2, int n2, boolean bl3) throws NoSuchUserException {
        if (!this.contains) {
            return "Can not edit the user's properties when the UserProvider isEnableEdit() method return false";
        }
        User user = this.getUser(string);
        int n3 = user.getAuthType();
        boolean bl4 = user.isAccessEventSuc();
        boolean bl5 = user.isAccessEventFail();
        boolean bl6 = user.isManagementEventSuc();
        boolean bl7 = user.isManagementEventFail();
        boolean bl8 = user.isNoAudit();
        Properties properties = new Properties();
        properties.setProperty("user_name", string);
        properties.setProperty("user_db_ldapType", "false");
        properties.setProperty("user_fullname", string2);
        properties.setProperty("user_description", string3);
        properties.setProperty("user_email", string4);
        properties.put("user_create_time", new Date(System.currentTimeMillis()));
        properties.setProperty("user_enable_null_pwd", String.valueOf(bl));
        properties.setProperty("user_min_pwd_length", String.valueOf(n));
        properties.put("user_last_modify_time", new Date(System.currentTimeMillis()));
        properties.setProperty("user_never_expire", String.valueOf(bl2));
        properties.setProperty("user_expire_time", String.valueOf(n2));
        properties.setProperty("user_disabled_account", String.valueOf(bl3));
        properties.setProperty("user_db_ldapType", String.valueOf(n3));
        properties.setProperty("user_db_access_event_suc", String.valueOf(bl4));
        properties.setProperty("user_db_access_event_fail", String.valueOf(bl5));
        properties.setProperty("user_db_management_event_suc", String.valueOf(bl6));
        properties.setProperty("user_db_management_event_fail", String.valueOf(bl7));
        properties.setProperty("user_db_noAudit", String.valueOf(bl8));
        try {
            this.QOIV.setUser(this.changePassword, properties);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            return JSvrResource.getMessage("SECURITY_M_00003", string);
        }
        return null;
    }

    public synchronized String updataEvent(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws NoSuchUserException {
        if (!this.contains) {
            return "Can not edit the user's properties when the UserProvider isEnableEdit() method return false";
        }
        User user = this.getUser(string);
        Properties properties = new Properties();
        properties.setProperty("user_name", string);
        properties.setProperty("user_db_ldapType", "false");
        properties.setProperty("user_fullname", user.getFullName());
        properties.setProperty("user_description", user.getDescription());
        properties.setProperty("user_email", user.getEmail());
        properties.put("user_create_time", user.getCreateTime());
        properties.setProperty("user_enable_null_pwd", String.valueOf(user.isEnableNullPS()));
        properties.setProperty("user_min_pwd_length", String.valueOf(user.getMinPSLength()));
        properties.put("user_last_modify_time", new Date(System.currentTimeMillis()));
        properties.setProperty("user_never_expire", String.valueOf(user.isNeverExpire()));
        properties.setProperty("user_expire_time", String.valueOf(user.getExpireTime()));
        properties.setProperty("user_disabled_account", String.valueOf(user.isAccountDisable()));
        properties.setProperty("user_db_ldapType", String.valueOf(user.getAuthType()));
        properties.setProperty("user_db_access_event_suc", String.valueOf(bl));
        properties.setProperty("user_db_access_event_fail", String.valueOf(bl2));
        properties.setProperty("user_db_management_event_suc", String.valueOf(bl3));
        properties.setProperty("user_db_management_event_fail", String.valueOf(bl4));
        properties.setProperty("user_db_noAudit", String.valueOf(bl5));
        try {
            this.QOIV.setUser(this.changePassword, properties);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            return JSvrResource.getMessage("SECURITY_M_00004", string);
        }
        return null;
    }

    public synchronized String changePassword(String string, String string2, String string3) throws NoSuchUserException {
        if (this.getAllUsers) {
            return "Can not edit the user's password when the AuthenticationProvider isEnableEdit() method return false";
        }
        User user = this.getUser(string2);
        String string4 = user.getPassword();
        String string5 = null;
        string5 = this.addUser.changePassword(this.changePassword, string, string2, string4, string3);
        return string5;
    }

    public synchronized String getPassword(String string) throws NoSuchUserException {
        User user = this.getUser(string);
        String string2 = user.getPassword();
        return string2;
    }

    public synchronized String addUserToParentRole(String string, String string2) throws NoSuchUserException, NoSuchRoleException {
        if (!this.getAdhocResourceManager) {
            return "Can not edit the user's relationship when the RoleUserRelationProvider isEnableEdit() method return false";
        }
        BaseUser baseUser = this.getBaseUser(string);
        if (baseUser.getParentRoleNames().contains(string2)) {
            return JSvrResource.getMessage("SECURITY_ERR_43_USER_EXIST_PARENT_ROLE", string);
        }
        BaseRole baseRole = this.QOIV(string2);
        if (baseRole.getSubUserNames().contains(string)) {
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_ERR_44_ROLE_EXIST_SUB_USER", objectArray);
        }
        try {
            this.addRelation.addUserToRole(this.changePassword, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_M_04001", objectArray);
        }
        catch (UserExistsException userExistsException) {
            ServiceLogger.logError(userExistsException);
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_M_04020", objectArray);
        }
        this.addUserToRole.addRelation(this.changePassword, string2, 2, string, 1);
        return null;
    }

    public synchronized String removeUserFromParentRole(String string, String string2) throws NoSuchUserException, NoSuchRoleException {
        if (!this.getAdhocResourceManager) {
            return "Can not edit the user's relationship when the RoleUserRelationProvider isEnableEdit() method return false";
        }
        if (string.equals("admin") && string2.equals("administrators")) {
            return JSvrResource.getMessage("SECURITY_ERR_49_REMOVE_ADMIN_FROM_ADMINROLE");
        }
        BaseUser baseUser = this.getBaseUser(string);
        if (!baseUser.getParentRoleNames().contains(string2)) {
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_ERR_46_USER_HAVE_NOT_PARENT_ROLE", objectArray);
        }
        BaseRole baseRole = this.QOIV(string2);
        if (!baseRole.getSubUserNames().contains(string)) {
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_ERR_47_ROLE_NOT_EXIST_SUB_USER", objectArray);
        }
        try {
            this.addRelation.removeUserFromRole(this.changePassword, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_M_04002", objectArray);
        }
        this.addUserToRole.removeRelation(this.changePassword, string2, 2, string, 1);
        return null;
    }

    public synchronized String addUserToGroup(String string, String string2) throws NoSuchUserException, NoSuchGroupException {
        if (!this.equals) {
            return "Can not edit the user's relationship when the GroupUserRelationProvider isEnableEdit() method return false";
        }
        BaseUser baseUser = this.addUserToGroup.getUser(string);
        if (baseUser.getGroupNames().contains(string2)) {
            return JSvrResource.getMessage("SECURITY_ERR_80_USER_EXIST_PARENT_GROUP", string);
        }
        BaseGroup baseGroup = this.add(string2);
        if (baseGroup.getUserNames().contains(string)) {
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_ERR_81_GROUP_EXIST_SUB_USER", objectArray);
        }
        try {
            this.addPrincipal.addUserToGroup(this.changePassword, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_M_04003", objectArray);
        }
        catch (UserExistsException userExistsException) {
            ServiceLogger.logError(userExistsException);
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_M_04022", objectArray);
        }
        this.addUserToRole.addRelation(this.changePassword, string2, 3, string, 1);
        return null;
    }

    public synchronized String removeUserFromGroup(String string, String string2) throws NoSuchUserException, NoSuchGroupException {
        if (!this.equals) {
            return "Can not edit the user's relationship when the GroupUserRelationProvider isEnableEdit() method return false";
        }
        BaseUser baseUser = this.getBaseUser(string);
        if (!baseUser.getGroupNames().contains(string2)) {
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_ERR_83_USER_HAVE_NOT_PARENT_GROUP", objectArray);
        }
        BaseGroup baseGroup = this.add(string2);
        if (!baseGroup.getUserNames().contains(string)) {
            Object[] objectArray = new String[]{string2, string};
            return JSvrResource.getMessage("SECURITY_ERR_84_GROUP_NOT_EXIST_SUB_USER", objectArray);
        }
        try {
            this.addPrincipal.removeUserFromGroup(this.changePassword, string2, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            Object[] objectArray = new String[]{string, string2};
            return JSvrResource.getMessage("SECURITY_M_04004", objectArray);
        }
        this.addUserToRole.removeRelation(this.changePassword, string2, 3, string, 1);
        return null;
    }

    public Enumeration getAllUsers() {
        User[] userArray = this.addUserToGroup.getAllUsers();
        Vector<User> vector = new Vector<User>();
        int n = 0;
        while (n < userArray.length) {
            User user = userArray[n];
            vector.add(user);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getAllUserNames() {
        User[] userArray = this.addUserToGroup.getAllUsers();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < userArray.length) {
            User user = userArray[n];
            vector.add(user.getName());
            ++n;
        }
        return vector.elements();
    }

    public int getParentRolesCount(String string) throws NoSuchUserException {
        BaseUser baseUser = this.getBaseUser(string);
        return baseUser.getParentRoleNames().size();
    }

    private BaseRole QOIV(String string) throws NoSuchRoleException {
        BaseRole baseRole = this.addUserToGroup.getRole(string);
        if (baseRole == null) {
            throw new NoSuchRoleException(630005, (Object[])new String[]{string}, null);
        }
        return baseRole;
    }

    private BaseGroup add(String string) throws NoSuchGroupException {
        BaseGroup baseGroup = this.addUserToGroup.getGroup(string);
        if (baseGroup == null) {
            throw new NoSuchGroupException(630001, (Object[])new String[]{string}, null);
        }
        return baseGroup;
    }
}

