/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.cache;

import java.security.Principal;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import jet.JSRuntimeException;
import jet.cs.jacl.BaseGroup;
import jet.cs.jacl.BaseRole;
import jet.cs.jacl.BaseUser;
import jet.cs.jacl.JAcl;
import jet.cs.jacl.JAclEntry;
import jet.cs.jacl.JAclEntryImpl;
import jet.cs.jacl.JAclImpl;
import jet.server.ServerEnv;
import jet.server.api.custom.JRCustomerException;
import jet.server.api.custom.security.AuthenticationProvider;
import jet.server.api.custom.security.AuthorizationProvider;
import jet.server.api.custom.security.group.GroupPermissionProvider;
import jet.server.api.custom.security.group.GroupPrivilegeProvider;
import jet.server.api.custom.security.group.GroupProvider;
import jet.server.api.custom.security.relation.GroupUserRelationProvider;
import jet.server.api.custom.security.relation.RoleGroupRelationProvider;
import jet.server.api.custom.security.relation.RoleUserRelationProvider;
import jet.server.api.custom.security.role.RolePermissionProvider;
import jet.server.api.custom.security.role.RolePrivilegeProvider;
import jet.server.api.custom.security.role.RoleProvider;
import jet.server.api.custom.security.user.UserPermissionProvider;
import jet.server.api.custom.security.user.UserPrivilegeProvider;
import jet.server.api.custom.security.user.UserProvider;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.Group;
import jet.server.intf.security.Role;
import jet.server.intf.security.User;
import jet.server.intf.security.UserFolderListener;
import jet.server.jrc.security.GroupImpl;
import jet.server.jrc.security.PermissionUtil;
import jet.server.jrc.security.RoleImpl;
import jet.server.jrc.security.UserImpl;
import jet.server.jrc.security.cache.SecurityCache;
import jet.server.jrc.security.config.intf.SecurityProvidersManager;
import jet.server.jrc.security.custom.SecurityUtil;
import jet.server.jrc.security.custom.db.group.GroupProviderDBImpl;
import jet.server.jrc.security.custom.db.role.RoleProviderDBImpl;
import jet.server.log.ServiceLogger;

public class CachedSecurityDataImpl
implements ExSecurityData {
    protected SecurityCache securityCache;
    protected String realmName;
    protected SecurityProvidersManager securityProvidersManager;
    protected AuthenticationProvider authenticationProvider;
    protected AuthorizationProvider authorizationProvider;
    protected UserProvider userProvider;
    protected UserPermissionProvider userPermissionProvider;
    protected UserPrivilegeProvider userPrivilegeProvider;
    protected GroupProvider groupProvider;
    protected GroupPermissionProvider groupPermissionProvider;
    protected GroupPrivilegeProvider groupPrivilegeProvider;
    protected RoleProvider roleProvider;
    protected RolePermissionProvider rolePermissionProvider;
    protected RolePrivilegeProvider rolePrivilegeProvider;
    protected RoleGroupRelationProvider roleGroupRelationProvider;
    protected RoleUserRelationProvider roleUserRelationProvider;
    protected GroupUserRelationProvider groupUserRelationProvider;
    protected UserFolderListener userFolderListener;

    public CachedSecurityDataImpl(String string, SecurityProvidersManager securityProvidersManager) {
        this.realmName = string;
        this.securityProvidersManager = securityProvidersManager;
        this.QOIV();
        this.TAG_GROUP_DB_TYPE();
        this.TAG_ROLE_DB_BUILDIN();
        this.addParentRole();
    }

    public SecurityProvidersManager getSecurityProvidersManager() {
        return this.securityProvidersManager;
    }

    public BaseUser getUser(String string) {
        User user = this.securityCache.getUser(string);
        if (user == null && (user = this.authenticationProvider(string)) != null) {
            this.securityCache.updateUser(user);
        }
        return user;
    }

    public BaseRole getRole(String string) {
        Role role = this.securityCache.getRole(string);
        if (role == null && (role = this.TAG_ROLE_DB_TYPE(string)) != null) {
            this.securityCache.updateRole(role);
        }
        return role;
    }

    public BaseGroup getGroup(String string) {
        Group group = this.securityCache.getGroup(string);
        if (group == null && (group = this.addPermissionToAclEntry(string)) != null) {
            this.securityCache.updateGroup(group);
        }
        return group;
    }

    public User[] getAllUsers() {
        Object object;
        Vector<User> vector = new Vector<User>();
        Iterator iterator = null;
        try {
            iterator = this.userProvider.getAllUsers(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                User user = this.getIntegrityUser((String)object);
                if (user == null) continue;
                vector.add(user);
            }
        }
        object = new User[vector.size()];
        return vector.toArray((T[])object);
    }

    public Role[] getAllRoles() {
        Object object;
        Vector<Role> vector = new Vector<Role>();
        Iterator iterator = null;
        try {
            iterator = this.roleProvider.getAllRoles(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Role role = this.getIntegrityRole((String)object);
                if (role == null) continue;
                vector.add(role);
            }
        }
        object = new Role[vector.size()];
        return vector.toArray((T[])object);
    }

    public Group[] getAllGroups() {
        Object object;
        Vector<Group> vector = new Vector<Group>();
        Iterator iterator = null;
        try {
            iterator = this.groupProvider.getAllGroups(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Group group = this.getIntegrityGroup((String)object);
                if (group == null) continue;
                vector.add(group);
            }
        }
        object = new Group[vector.size()];
        return vector.toArray((T[])object);
    }

    public User getIntegrityUser(String string) {
        User user = this.securityCache.getUser(string);
        if (user == null) {
            user = this.authenticationProvider(string);
            if (user != null) {
                this.securityCache.updateUser(user);
            }
        } else {
            this.authorizationProvider(user);
        }
        return user;
    }

    public Role getIntegrityRole(String string) {
        Role role = this.securityCache.getRole(string);
        if (role == null) {
            role = this.TAG_ROLE_DB_TYPE(string);
            if (role != null) {
                this.securityCache.updateRole(role);
            }
        } else {
            this.add(role);
        }
        return role;
    }

    public Group getIntegrityGroup(String string) {
        Group group = this.securityCache.getGroup(string);
        if (group == null) {
            group = this.addPermissionToAclEntry(string);
            if (group != null) {
                this.securityCache.updateGroup(group);
            }
        } else {
            this.addPrivilegeToAclEntry(group);
        }
        return group;
    }

    public JAcl getAcl(String string, int n) {
        String string2 = SecurityUtil.createAclName(string, n);
        JAcl jAcl = this.securityCache.getAcl(string2);
        if (jAcl == null && (jAcl = this.equals(string, n)) != null) {
            this.securityCache.updateAcl(jAcl);
        }
        return jAcl;
    }

    public JAcl getExtendAcl() {
        JAcl jAcl = this.securityCache.getExtendAcl();
        if (jAcl == null && (jAcl = this.equalsIgnoreCase()) != null) {
            this.securityCache.updateExtendAcl(jAcl);
        }
        return jAcl;
    }

    public Permission[] getUserPermissions(String string, String string2, int n) {
        return new Permission[0];
    }

    public Vector getAllUsers(String string) {
        Vector<User> vector = new Vector<User>();
        boolean bl = false;
        bl = this.authenticationProvider.isAdminUser(this.realmName, string);
        if (!bl) {
            return vector;
        }
        Iterator iterator = null;
        try {
            iterator = this.userProvider.getAllUsers(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                User user = this.getIntegrityUser(string2);
                if (user == null) continue;
                vector.add(user);
            }
        }
        return vector;
    }

    public Vector getAllRoles(String string) {
        Vector<Role> vector = new Vector<Role>();
        boolean bl = false;
        bl = this.authenticationProvider.isAdminUser(this.realmName, string);
        if (!bl) {
            return vector;
        }
        Iterator iterator = null;
        try {
            iterator = this.roleProvider.getAllRoles(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Role role = this.getIntegrityRole(string2);
                if (role == null) continue;
                vector.add(role);
            }
        }
        return vector;
    }

    public Vector getAllGroups(String string) {
        Vector<Group> vector = new Vector<Group>();
        boolean bl = false;
        bl = this.authenticationProvider.isAdminUser(this.realmName, string);
        if (!bl) {
            return vector;
        }
        Iterator iterator = null;
        try {
            iterator = this.groupProvider.getAllGroups(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Group group = this.getIntegrityGroup(string2);
                if (group == null) continue;
                vector.add(group);
            }
        }
        return vector;
    }

    private void QOIV() {
        try {
            int n = ServerEnv.getSecurityUserCacheSize();
            int n2 = ServerEnv.getSecurityRoleCacheSize();
            int n3 = ServerEnv.getSecurityGroupCacheSize();
            int n4 = ServerEnv.getSecurityProtectionCacheSize();
            this.securityCache = new SecurityCache(n, n2, n3, n4);
        }
        catch (Exception exception) {
            this.securityCache = new SecurityCache();
        }
    }

    private void TAG_GROUP_DB_TYPE() {
        try {
            this.authenticationProvider = this.securityProvidersManager.getAuthenticationProvider();
            this.authorizationProvider = this.securityProvidersManager.getAuthorizationProvider();
            this.userProvider = this.securityProvidersManager.getUserProvider();
            this.userPermissionProvider = this.securityProvidersManager.getUserPermissionProvider();
            this.userPrivilegeProvider = this.securityProvidersManager.getUserPrivilegeProvider();
            this.roleProvider = this.securityProvidersManager.getRoleProvider();
            this.rolePermissionProvider = this.securityProvidersManager.getRolePermissionProvider();
            this.rolePrivilegeProvider = this.securityProvidersManager.getRolePrivilegeProvider();
            this.groupProvider = this.securityProvidersManager.getGroupProvider();
            this.groupPermissionProvider = this.securityProvidersManager.getGroupPermissinProvider();
            this.groupPrivilegeProvider = this.securityProvidersManager.getGroupPrivilegeProvider();
            this.roleGroupRelationProvider = this.securityProvidersManager.getRoleGroupRelationProvider();
            this.roleUserRelationProvider = this.securityProvidersManager.getRoleUserRelationProvider();
            this.groupUserRelationProvider = this.securityProvidersManager.getGroupUserRelationProvider();
        }
        catch (ClassCastException classCastException) {
            ServiceLogger.logError(classCastException);
            throw new JSRuntimeException(classCastException);
        }
    }

    private void TAG_ROLE_DB_BUILDIN() {
        Iterator iterator = null;
        try {
            iterator = this.roleProvider.getAllRoles(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Role role = this.TAG_ROLE_DB_TYPE(string);
                if (role == null) continue;
                this.securityCache.updateRole(role);
            }
        }
    }

    private Role TAG_ROLE_DB_TYPE(String string) {
        Properties properties;
        String string2;
        String string3;
        Properties properties2 = null;
        try {
            properties2 = this.roleProvider.getRoleProperties(this.realmName, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException, 3);
            return null;
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logDebug(noSuchRoleException.getMessage(), 6);
            return null;
        }
        if (properties2 == null || properties2.size() == 0) {
            return null;
        }
        String string4 = properties2.getProperty("role_description", "");
        boolean bl = false;
        int n = 0;
        String string5 = properties2.getProperty(RoleProviderDBImpl.TAG_ROLE_DB_TYPE);
        boolean bl2 = false;
        if (string5 != null && string5.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        if (bl2) {
            n = 1;
        }
        if ((string3 = properties2.getProperty(RoleProviderDBImpl.TAG_ROLE_DB_BUILDIN)) != null && string3.equalsIgnoreCase("true")) {
            bl = true;
        }
        RoleImpl roleImpl = new RoleImpl(string, bl, string4, n);
        Iterator iterator = null;
        Iterator iterator2 = null;
        Iterator iterator3 = null;
        Iterator iterator4 = null;
        try {
            iterator = this.roleProvider.getSubRoles(this.realmName, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException);
        }
        try {
            iterator2 = this.addParentGroup(string);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        try {
            iterator3 = this.roleGroupRelationProvider.getGroupsByRole(this.realmName, string);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        try {
            iterator4 = this.roleUserRelationProvider.getUsersByRole(this.realmName, string);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                properties = null;
                try {
                    properties = this.roleProvider.getRoleProperties(this.realmName, string2);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    continue;
                }
                catch (JRCustomerException jRCustomerException) {
                    continue;
                }
                if (properties == null || properties.size() == 0) continue;
                roleImpl.addSubRole(string2);
            }
        }
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                properties = null;
                try {
                    properties = this.roleProvider.getRoleProperties(this.realmName, string2);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    continue;
                }
                catch (JRCustomerException jRCustomerException) {
                    continue;
                }
                if (properties == null || properties.size() == 0) continue;
                roleImpl.addParentRole(string2);
            }
        }
        if (iterator3 != null) {
            while (iterator3.hasNext()) {
                string2 = (String)iterator3.next();
                properties = null;
                try {
                    properties = this.groupProvider.getGroupProperties(this.realmName, string2);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    continue;
                }
                catch (JRCustomerException jRCustomerException) {
                    continue;
                }
                if (properties == null || properties.size() == 0) continue;
                roleImpl.addGroup(string2);
            }
        }
        if (iterator4 != null) {
            while (iterator4.hasNext()) {
                string2 = (String)iterator4.next();
                properties = null;
                try {
                    properties = this.userProvider.getUserProperties(this.realmName, string2);
                }
                catch (NoSuchUserException noSuchUserException) {
                    continue;
                }
                catch (JRCustomerException jRCustomerException) {
                    continue;
                }
                if (properties == null || properties.size() == 0) continue;
                roleImpl.addSubUser(string2);
            }
        }
        return roleImpl;
    }

    private void add(Role role) {
        String string;
        Properties properties = null;
        try {
            properties = this.roleProvider.getRoleProperties(this.realmName, role.getName());
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            return;
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException);
            return;
        }
        String string2 = properties.getProperty("role_description", "");
        boolean bl = false;
        int n = 0;
        String string3 = properties.getProperty(RoleProviderDBImpl.TAG_ROLE_DB_TYPE);
        boolean bl2 = false;
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        if (bl2) {
            n = 1;
        }
        if ((string = properties.getProperty(RoleProviderDBImpl.TAG_ROLE_DB_BUILDIN)) != null && string.equalsIgnoreCase("true")) {
            bl = true;
        }
        role.setDescription(string2);
        role.setType(n);
        role.setBuildin(bl);
    }

    private Iterator addParentGroup(String string) throws NoSuchRoleException, JRCustomerException {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = this.roleProvider.getAllRoles(this.realmName);
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Role role = this.securityCache.getRole((String)object);
                if (role != null) {
                    if (!role.isHaveSubRole(string)) continue;
                    vector.add(object);
                    continue;
                }
                Iterator iterator2 = this.roleProvider.getSubRoles(this.realmName, (String)object);
                if (iterator2 == null) continue;
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    if (!string2.equals(string)) continue;
                    vector.add(object);
                }
            }
        }
        object = vector.iterator();
        return object;
    }

    private void addParentRole() {
        Iterator iterator = null;
        try {
            iterator = this.groupProvider.getAllGroups(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Group group = this.addPermissionToAclEntry(string);
                if (group == null) continue;
                this.securityCache.updateGroup(group);
            }
        }
    }

    private Group addPermissionToAclEntry(String string) {
        Properties properties;
        String string2;
        Properties properties2 = null;
        try {
            properties2 = this.groupProvider.getGroupProperties(this.realmName, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            return null;
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logDebug(noSuchGroupException.getMessage(), 6);
            return null;
        }
        if (properties2 == null || properties2.size() == 0) {
            return null;
        }
        String string3 = properties2.getProperty("group_description", "");
        boolean bl = false;
        int n = 0;
        String string4 = properties2.getProperty(GroupProviderDBImpl.TAG_GROUP_DB_TYPE);
        boolean bl2 = false;
        if (string4 != null && string4.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        if (bl2) {
            n = 1;
        }
        GroupImpl groupImpl = new GroupImpl(string, bl, string3, n);
        Iterator iterator = null;
        Iterator iterator2 = null;
        Iterator iterator3 = null;
        Iterator iterator4 = null;
        try {
            iterator = this.groupProvider.getSubGroups(this.realmName, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException);
        }
        try {
            iterator2 = this.addSubUser(string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        try {
            iterator3 = this.addUser(string);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        try {
            iterator4 = this.groupUserRelationProvider.getSubUsers(this.realmName, string);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                properties = null;
                try {
                    properties = this.groupProvider.getGroupProperties(this.realmName, string2);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    continue;
                }
                catch (JRCustomerException jRCustomerException) {
                    continue;
                }
                if (properties == null || properties.size() == 0) continue;
                groupImpl.addSubGroup(string2);
            }
        }
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                properties = null;
                try {
                    properties = this.groupProvider.getGroupProperties(this.realmName, string2);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    continue;
                }
                catch (JRCustomerException jRCustomerException) {
                    continue;
                }
                if (properties == null || properties.size() == 0) continue;
                groupImpl.addParentGroup(string2);
            }
        }
        if (iterator3 != null) {
            while (iterator3.hasNext()) {
                string2 = (String)iterator3.next();
                properties = null;
                try {
                    properties = this.roleProvider.getRoleProperties(this.realmName, string2);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    continue;
                }
                catch (JRCustomerException jRCustomerException) {
                    continue;
                }
                if (properties == null || properties.size() == 0) continue;
                groupImpl.addRole(string2);
            }
        }
        if (iterator4 != null) {
            while (iterator4.hasNext()) {
                string2 = (String)iterator4.next();
                properties = null;
                try {
                    properties = this.userProvider.getUserProperties(this.realmName, string2);
                }
                catch (NoSuchUserException noSuchUserException) {
                    continue;
                }
                catch (JRCustomerException jRCustomerException) {
                    continue;
                }
                if (properties == null || properties.size() == 0) continue;
                groupImpl.addUser(string2);
            }
        }
        return groupImpl;
    }

    private void addPrivilegeToAclEntry(Group group) {
        Properties properties = null;
        try {
            properties = this.groupProvider.getGroupProperties(this.realmName, group.getName());
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            return;
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException);
            return;
        }
        String string = properties.getProperty("group_description", "");
        int n = 0;
        String string2 = properties.getProperty(GroupProviderDBImpl.TAG_GROUP_DB_TYPE);
        boolean bl = false;
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            bl = true;
        }
        if (bl) {
            n = 1;
        }
        group.setDescription(string);
        group.setType(n);
    }

    private Iterator addSubUser(String string) throws NoSuchGroupException, JRCustomerException {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.groupProvider.getAllGroups(this.realmName);
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Iterator iterator2 = null;
                Group group = this.securityCache.getGroup(string2);
                if (group != null) {
                    if (!group.isHaveSubGroup(string)) continue;
                    vector.add(string2);
                    continue;
                }
                iterator2 = this.groupProvider.getSubGroups(this.realmName, string2);
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    if (!string3.equals(string)) continue;
                    vector.add(string2);
                }
            }
        }
        return vector.iterator();
    }

    private Iterator addUser(String string) throws JRCustomerException, NoSuchRoleException {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.roleProvider.getAllRoles(this.realmName);
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Iterator iterator2 = null;
                Role role = this.securityCache.getRole(string2);
                if (role != null) {
                    if (!role.isHaveGroup(string)) continue;
                    vector.add(string2);
                    continue;
                }
                iterator2 = this.roleGroupRelationProvider.getGroupsByRole(this.realmName, string2);
                if (iterator2 == null) continue;
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    if (!string3.equals(string)) continue;
                    vector.add(string2);
                }
            }
        }
        return vector.iterator();
    }

    private User authenticationProvider(String string) {
        Properties properties;
        String string2;
        Properties properties2 = null;
        try {
            properties2 = this.userProvider.getUserProperties(this.realmName, string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException, 3);
            return null;
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logDebug(noSuchUserException.getMessage(), 6);
            return null;
        }
        if (properties2 == null || properties2.size() == 0) {
            return null;
        }
        String string3 = properties2.getProperty("user_password");
        int n = 0;
        int n2 = 0;
        String string4 = properties2.getProperty("user_db_ldapType");
        if (string4 == null) {
            n = -1;
            n2 = -1;
        } else if (string4.equalsIgnoreCase("true")) {
            n = 1;
            n2 = 1;
        }
        boolean bl = false;
        String string5 = properties2.getProperty("user_db_buildin");
        if (string5 != null && string5.equalsIgnoreCase("true")) {
            bl = true;
        }
        String string6 = properties2.getProperty("user_fullname");
        String string7 = properties2.getProperty("user_description");
        String string8 = properties2.getProperty("user_email");
        Date date = (Date)properties2.get("user_create_time");
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        boolean bl2 = false;
        String string9 = properties2.getProperty("user_enable_null_pwd");
        if (string9 != null && string9.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        int n3 = 6;
        String string10 = properties2.getProperty("user_min_pwd_length");
        try {
            n3 = Integer.parseInt(string10);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logDebug(3630091, new Object[]{string10, string}, 3);
        }
        Date date2 = (Date)properties2.get("user_last_modify_time");
        boolean bl3 = false;
        String string11 = properties2.getProperty("user_never_expire");
        if (string11 != null && string11.equalsIgnoreCase("true")) {
            bl3 = true;
        }
        int n4 = 30;
        String string12 = properties2.getProperty("user_expire_time");
        try {
            n4 = Integer.parseInt(string12);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logDebug(3630090, new Object[]{string12, string}, 3);
        }
        boolean bl4 = false;
        String string13 = properties2.getProperty("user_disabled_account");
        if (string13 != null && string13.equalsIgnoreCase("true")) {
            bl4 = true;
        }
        boolean bl5 = false;
        String string14 = properties2.getProperty("user_db_access_event_suc");
        if (string14 != null && string14.equalsIgnoreCase("true")) {
            bl5 = true;
        }
        boolean bl6 = false;
        String string15 = properties2.getProperty("user_db_access_event_fail");
        if (string15 != null && string15.equalsIgnoreCase("true")) {
            bl6 = true;
        }
        boolean bl7 = false;
        String string16 = properties2.getProperty("user_db_management_event_suc");
        if (string16 != null && string16.equalsIgnoreCase("true")) {
            bl7 = true;
        }
        boolean bl8 = false;
        String string17 = properties2.getProperty("user_db_management_event_fail");
        if (string17 != null && string17.equalsIgnoreCase("true")) {
            bl8 = true;
        }
        boolean bl9 = false;
        String string18 = properties2.getProperty("user_db_noAudit");
        if (string18 != null && string18.equalsIgnoreCase("true")) {
            bl9 = true;
        }
        UserImpl userImpl = new UserImpl();
        userImpl.setName(string);
        userImpl.setFullName(string6);
        userImpl.setDescription(string7);
        userImpl.setEmail(string8);
        userImpl.setPassword(string3);
        userImpl.setCreateTime(date);
        userImpl.setBuildin(bl);
        userImpl.setEnableNullPS(bl2);
        userImpl.setMinPSLength(n3);
        userImpl.setNeverExpire(bl3);
        userImpl.setLastModifyTime(date2);
        userImpl.setExpireTime(n4);
        userImpl.setAccountDisable(bl4);
        userImpl.setAccessEventSuc(bl5);
        userImpl.setAccessEventFail(bl6);
        userImpl.setManagementEventSuc(bl7);
        userImpl.setManagementEventFail(bl8);
        userImpl.setNoAudit(bl9);
        userImpl.setAuthType(n);
        userImpl.setLdapType(n2);
        Iterator iterator = null;
        Iterator iterator2 = null;
        try {
            iterator = this.currentTimeMillis(string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        catch (NoSuchRoleException noSuchRoleException) {
            ServiceLogger.logError(noSuchRoleException);
        }
        try {
            iterator2 = this.createAclName(string);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        catch (NoSuchGroupException noSuchGroupException) {
            ServiceLogger.logError(noSuchGroupException);
        }
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                string2 = (String)iterator2.next();
                properties = null;
                try {
                    properties = this.groupProvider.getGroupProperties(this.realmName, string2);
                }
                catch (NoSuchGroupException noSuchGroupException) {
                    continue;
                }
                catch (JRCustomerException jRCustomerException) {
                    continue;
                }
                if (properties == null || properties.size() == 0) continue;
                userImpl.addGroup(string2);
            }
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                properties = null;
                try {
                    properties = this.roleProvider.getRoleProperties(this.realmName, string2);
                }
                catch (NoSuchRoleException noSuchRoleException) {
                    continue;
                }
                catch (JRCustomerException jRCustomerException) {
                    continue;
                }
                if (properties == null || properties.size() == 0) continue;
                userImpl.addParentRole(string2);
            }
        }
        return userImpl;
    }

    private void authorizationProvider(User user) {
        Properties properties = null;
        try {
            properties = this.userProvider.getUserProperties(this.realmName, user.getName());
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
            return;
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError(noSuchUserException);
            return;
        }
        String string = properties.getProperty("user_password");
        int n = 0;
        int n2 = 0;
        String string2 = properties.getProperty("user_db_ldapType");
        boolean bl = false;
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            bl = true;
        }
        if (bl) {
            n = 1;
            n2 = 1;
        }
        boolean bl2 = false;
        String string3 = properties.getProperty("user_db_buildin");
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            bl2 = true;
        }
        String string4 = properties.getProperty("user_fullname");
        String string5 = properties.getProperty("user_description");
        String string6 = properties.getProperty("user_email");
        Date date = (Date)properties.get("user_create_time");
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        boolean bl3 = false;
        String string7 = properties.getProperty("user_enable_null_pwd");
        if (string7 != null && string7.equalsIgnoreCase("true")) {
            bl3 = true;
        }
        int n3 = 6;
        String string8 = properties.getProperty("user_min_pwd_length");
        try {
            n3 = Integer.parseInt(string8);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logDebug(3630091, new Object[]{string8, user.getName()}, 3);
        }
        Date date2 = (Date)properties.get("user_last_modify_time");
        boolean bl4 = false;
        String string9 = properties.getProperty("user_never_expire");
        if (string9 != null && string9.equalsIgnoreCase("true")) {
            bl4 = true;
        }
        int n4 = 30;
        String string10 = properties.getProperty("user_expire_time");
        try {
            n4 = Integer.parseInt(string10);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logDebug(3630090, new Object[]{string10, user.getName()}, 3);
        }
        boolean bl5 = false;
        String string11 = properties.getProperty("user_disabled_account");
        if (string11 != null && string11.equalsIgnoreCase("true")) {
            bl5 = true;
        }
        boolean bl6 = false;
        String string12 = properties.getProperty("user_db_access_event_suc");
        if (string12 != null && string12.equalsIgnoreCase("true")) {
            bl6 = true;
        }
        boolean bl7 = false;
        String string13 = properties.getProperty("user_db_access_event_fail");
        if (string13 != null && string13.equalsIgnoreCase("true")) {
            bl7 = true;
        }
        boolean bl8 = false;
        String string14 = properties.getProperty("user_db_management_event_suc");
        if (string14 != null && string14.equalsIgnoreCase("true")) {
            bl8 = true;
        }
        boolean bl9 = false;
        String string15 = properties.getProperty("user_db_management_event_fail");
        if (string15 != null && string15.equalsIgnoreCase("true")) {
            bl9 = true;
        }
        boolean bl10 = false;
        String string16 = properties.getProperty("user_db_noAudit");
        if (string16 != null && string16.equalsIgnoreCase("true")) {
            bl10 = true;
        }
        user.setFullName(string4);
        user.setDescription(string5);
        user.setEmail(string6);
        user.setPassword(string);
        user.setCreateTime(date);
        user.setBuildin(bl2);
        user.setEnableNullPS(bl3);
        user.setMinPSLength(n3);
        user.setNeverExpire(bl4);
        user.setLastModifyTime(date2);
        user.setExpireTime(n4);
        user.setAccountDisable(bl5);
        user.setAccessEventSuc(bl6);
        user.setAccessEventFail(bl7);
        user.setManagementEventSuc(bl8);
        user.setManagementEventFail(bl9);
        user.setNoAudit(bl10);
        user.setAuthType(n);
        user.setLdapType(n2);
    }

    private Iterator createAclName(String string) throws JRCustomerException, NoSuchGroupException {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.groupProvider.getAllGroups(this.realmName);
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Iterator iterator2 = null;
                Group group = this.securityCache.getGroup(string2);
                if (group != null) {
                    if (!group.isHaveUser(string)) continue;
                    vector.add(string2);
                    continue;
                }
                iterator2 = this.groupUserRelationProvider.getSubUsers(this.realmName, string2);
                if (string == null) continue;
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    if (!string3.equals(string)) continue;
                    vector.add(string2);
                }
            }
        }
        return vector.iterator();
    }

    private Iterator currentTimeMillis(String string) throws JRCustomerException, NoSuchRoleException {
        Vector<String> vector = new Vector<String>();
        Iterator iterator = this.roleProvider.getAllRoles(this.realmName);
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Iterator iterator2 = null;
                Role role = this.securityCache.getRole(string2);
                if (role != null) {
                    if (!role.isHaveSubUser(string)) continue;
                    vector.add(string2);
                    continue;
                }
                iterator2 = this.roleUserRelationProvider.getUsersByRole(this.realmName, string2);
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    if (!string3.equals(string)) continue;
                    vector.add(string2);
                }
            }
        }
        return vector.iterator();
    }

    private JAcl equals(String string, int n) {
        int n2;
        JAclEntry jAclEntry;
        Principal principal;
        String string2;
        String string3;
        Enumeration enumeration;
        String string4 = SecurityUtil.createAclName(string, n);
        JAclImpl jAclImpl = new JAclImpl(string4, this);
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Hashtable hashtable3 = null;
        try {
            hashtable = this.userPermissionProvider.getUserPermissions(this.realmName, string, n);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        try {
            hashtable2 = this.rolePermissionProvider.getRolePermissions(this.realmName, string, n);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        try {
            hashtable3 = this.groupPermissionProvider.getGroupPermissions(this.realmName, string, n);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        if (hashtable == null && hashtable2 == null && hashtable3 == null) {
            return null;
        }
        if (hashtable != null) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                string2 = (String)hashtable.get(string3);
                principal = this.getUser(string3);
                if (principal == null) continue;
                jAclEntry = new JAclEntryImpl(string3, this);
                jAclEntry.setPrincipal(principal);
                n2 = 0;
                try {
                    n2 = SecurityUtil.getPermissionCodeFromString(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    ServiceLogger.logError(numberFormatException, 3);
                    continue;
                }
                jAclEntry = PermissionUtil.addPermissionToAclEntry(jAclEntry, n2);
                try {
                    jAclImpl.addEntry(principal, jAclEntry);
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException, 3);
                }
            }
        }
        if (hashtable2 != null) {
            enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                string2 = (String)hashtable2.get(string3);
                principal = this.getRole(string3);
                if (principal == null) continue;
                jAclEntry = new JAclEntryImpl(string3, this);
                jAclEntry.setPrincipal(principal);
                n2 = 0;
                try {
                    n2 = SecurityUtil.getPermissionCodeFromString(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    ServiceLogger.logError(numberFormatException, 3);
                    continue;
                }
                jAclEntry = PermissionUtil.addPermissionToAclEntry(jAclEntry, n2);
                try {
                    jAclImpl.addEntry(principal, jAclEntry);
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException, 3);
                }
            }
        }
        if (hashtable3 != null) {
            enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                string2 = (String)hashtable3.get(string3);
                principal = this.getGroup(string3);
                if (principal == null) continue;
                jAclEntry = new JAclEntryImpl(string3, this);
                jAclEntry.setPrincipal(principal);
                n2 = 0;
                try {
                    n2 = SecurityUtil.getPermissionCodeFromString(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    ServiceLogger.logError(numberFormatException, 3);
                    continue;
                }
                jAclEntry = PermissionUtil.addPermissionToAclEntry(jAclEntry, n2);
                try {
                    jAclImpl.addEntry(principal, jAclEntry);
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException, 3);
                }
            }
        }
        return jAclImpl;
    }

    private JAcl equalsIgnoreCase() {
        int n;
        JAclEntry jAclEntry;
        Principal principal;
        String[] stringArray;
        String string;
        Enumeration enumeration;
        String string2 = "JAcl{extendAcl}";
        JAclImpl jAclImpl = new JAclImpl(string2, this);
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Hashtable hashtable3 = null;
        try {
            hashtable = this.userPrivilegeProvider.getUserPrivileges(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        try {
            hashtable2 = this.rolePrivilegeProvider.getRolePrivileges(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        try {
            hashtable3 = this.groupPrivilegeProvider.getGroupPrivileges(this.realmName);
        }
        catch (JRCustomerException jRCustomerException) {
            ServiceLogger.logError(jRCustomerException);
        }
        if (hashtable == null && hashtable2 == null && hashtable3 == null) {
            return null;
        }
        if (hashtable != null) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                stringArray = (String[])hashtable.get(string);
                principal = this.getUser(string);
                if (principal == null) continue;
                jAclEntry = new JAclEntryImpl(string, this);
                jAclEntry.setPrincipal(principal);
                n = 0;
                n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                jAclEntry = PermissionUtil.addPrivilegeToAclEntry(jAclEntry, n);
                try {
                    jAclImpl.addEntry(principal, jAclEntry);
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException, 3);
                }
            }
        }
        if (hashtable2 != null) {
            enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                stringArray = (String[])hashtable2.get(string);
                principal = this.getRole(string);
                if (principal == null) continue;
                jAclEntry = new JAclEntryImpl(string, this);
                jAclEntry.setPrincipal(principal);
                n = 0;
                n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                jAclEntry = PermissionUtil.addPrivilegeToAclEntry(jAclEntry, n);
                try {
                    jAclImpl.addEntry(principal, jAclEntry);
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException, 3);
                }
            }
        }
        if (hashtable3 != null) {
            enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                stringArray = (String[])hashtable3.get(string);
                principal = this.getGroup(string);
                if (principal == null) continue;
                jAclEntry = new JAclEntryImpl(string, this);
                jAclEntry.setPrincipal(principal);
                n = 0;
                n = PermissionUtil.getPrivilegesCodeFromPrivilegeNames(stringArray);
                jAclEntry = PermissionUtil.addPrivilegeToAclEntry(jAclEntry, n);
                try {
                    jAclImpl.addEntry(principal, jAclEntry);
                }
                catch (NotOwnerException notOwnerException) {
                    ServiceLogger.logError(notOwnerException, 3);
                }
            }
        }
        return jAclImpl;
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public AuthorizationProvider getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    public UserProvider getUserProvider() {
        return this.userProvider;
    }

    public UserPermissionProvider getUserPermissionProvider() {
        return this.userPermissionProvider;
    }

    public UserPrivilegeProvider getUserPrivilegeProvider() {
        return this.userPrivilegeProvider;
    }

    public GroupProvider getGroupProvider() {
        return this.groupProvider;
    }

    public GroupPermissionProvider getGroupPermissionProvider() {
        return this.groupPermissionProvider;
    }

    public GroupPrivilegeProvider getGroupPrivilegeProvider() {
        return this.groupPrivilegeProvider;
    }

    public RoleProvider getRoleProvider() {
        return this.roleProvider;
    }

    public RolePermissionProvider getRolePermissionProvider() {
        return this.rolePermissionProvider;
    }

    public RolePrivilegeProvider getRolePrivilegeProvider() {
        return this.rolePrivilegeProvider;
    }

    public RoleGroupRelationProvider getRoleGroupRelationProvider() {
        return this.roleGroupRelationProvider;
    }

    public RoleUserRelationProvider getRoleUserRelationProvider() {
        return this.roleUserRelationProvider;
    }

    public GroupUserRelationProvider getGroupUserRelationProvider() {
        return this.groupUserRelationProvider;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void addUserFolderListener(UserFolderListener userFolderListener) {
        this.userFolderListener = userFolderListener;
    }
}

