/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.config.xml;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import jet.Classes;
import jet.cs.ExProperties;
import jet.server.ServerEnv;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.security.config.ProviderDescriptorImpl;
import jet.server.jrc.security.config.intf.ProviderDescriptor;
import jet.server.jrc.security.config.intf.SecurityConfiguration;
import jet.server.jrc.security.config.xml.SecurityXMLReader;
import jet.server.jrc.security.custom.comp.AuthenticationProviderCompImpl;
import jet.server.jrc.security.ldap.intf.LDAPManager;
import jet.server.log.ServiceLogger;
import jet.server.userman.JReportImplementation;
import jet.server.userman.SecurityDataLoader;
import jet.server.userman.UserAuthenticator;
import org.xml.sax.SAXException;

public class SecurityConfigurationImpl
implements SecurityConfiguration {
    private static String[] QOIV = new String[]{"authentication_provider", "authorization_provider", "user_permission_provider", "user_privilege_provider", "user_provider", "role_permission_provider", "role_privilege_provider", "role_provider", "group_permission_provider", "group_privilege_provider", "group_provider", "group_user_relation_provider", "role_group_relation_provider", "role_user_relation_provider"};
    private static String[] append = new String[]{"jet.server.jrc.security.custom.db.AuthenticationProviderDBImpl", "jet.server.jrc.security.custom.db.AuthorizationProviderDBImpl", "jet.server.jrc.security.custom.db.user.UserPermissionProviderDBImpl", "jet.server.jrc.security.custom.db.user.UserPrivilegeProviderDBImpl", "jet.server.jrc.security.custom.db.user.UserProviderDBImpl", "jet.server.jrc.security.custom.db.role.RolePermissionProviderDBImpl", "jet.server.jrc.security.custom.db.role.RolePrivilegeProviderDBImpl", "jet.server.jrc.security.custom.db.role.RoleProviderDBImpl", "jet.server.jrc.security.custom.db.group.GroupPermissionProviderDBImpl", "jet.server.jrc.security.custom.db.group.GroupPrivilegeProviderDBImpl", "jet.server.jrc.security.custom.db.group.GroupProviderDBImpl", "jet.server.jrc.security.custom.db.relation.GroupUserRelationProviderDBImpl", "jet.server.jrc.security.custom.db.relation.RoleGroupRelationProviderDBImpl", "jet.server.jrc.security.custom.db.relation.RoleUserRelationProviderDBImpl"};
    private static String[] clear = new String[]{"jet.server.jrc.security.custom.ldap.AuthenticationProviderLDAPImpl", "jet.server.jrc.security.custom.db.AuthorizationProviderDBImpl", "jet.server.jrc.security.custom.db.user.UserPermissionProviderDBImpl", "jet.server.jrc.security.custom.db.user.UserPrivilegeProviderDBImpl", "jet.server.jrc.security.custom.ldap.user.UserProviderLDAPImpl", "jet.server.jrc.security.custom.db.role.RolePermissionProviderDBImpl", "jet.server.jrc.security.custom.db.role.RolePrivilegeProviderDBImpl", "jet.server.jrc.security.custom.db.role.RoleProviderDBImpl", "jet.server.jrc.security.custom.db.group.GroupPermissionProviderDBImpl", "jet.server.jrc.security.custom.db.group.GroupPrivilegeProviderDBImpl", "jet.server.jrc.security.custom.ldap.group.GroupProviderLDAPImpl", "jet.server.jrc.security.custom.ldap.relation.GroupUserRelationProviderLDAPImpl", "jet.server.jrc.security.custom.db.relation.RoleGroupRelationProviderDBImpl", "jet.server.jrc.security.custom.ldap.relation.RoleUserRelationProviderLDAPImpl"};
    private Hashtable endsWith;
    private String equals = "customizedAPI.xml";
    private boolean exists = false;

    public SecurityConfigurationImpl(String string) {
        this.init(string);
    }

    public SecurityConfigurationImpl(String string, boolean bl) {
        this.init(string);
        this.exists = bl;
    }

    private void init(String string) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        String string2 = string + this.equals;
        this.endsWith = new Hashtable();
        if (new File(string2).exists()) {
            SecurityXMLReader securityXMLReader = new SecurityXMLReader(string2);
            try {
                securityXMLReader.read();
                this.endsWith = securityXMLReader.getProperties();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                ServiceLogger.logError(parserConfigurationException, 6);
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
            catch (SAXException sAXException) {
                ServiceLogger.logError(sAXException);
            }
        }
        if (this.endsWith.size() == 0) {
            this.append();
        } else {
            this.QOIV();
        }
        if (this.endsWith.size() == 0) {
            this.clear(string);
        }
    }

    private void QOIV() {
        String string = this.getClassName("authentication_provider");
        if (string == null) {
            this.endsWith.clear();
            return;
        }
        String string2 = this.getClassName("user_provider");
        String string3 = this.getClassName("group_provider");
        String string4 = this.getClassName("role_provider");
        if (string2 == null) {
            this.endsWith.remove("user_permission_provider");
            this.endsWith.remove("user_privilege_provider");
            this.endsWith.remove("group_user_relation_provider");
            this.endsWith.remove("role_user_relation_provider");
        }
        if (string3 == null) {
            this.endsWith.remove("group_permission_provider");
            this.endsWith.remove("group_privilege_provider");
            this.endsWith.remove("group_user_relation_provider");
            this.endsWith.remove("role_group_relation_provider");
        }
        if (string4 == null) {
            this.endsWith.remove("role_permission_provider");
            this.endsWith.remove("role_privilege_provider");
            this.endsWith.remove("role_group_relation_provider");
            this.endsWith.remove("role_user_relation_provider");
        }
    }

    private void append() {
        String string;
        String string2 = System.getProperty("com.jinfonet.AuthenticationProvider");
        if (string2 == null) {
            string2 = ServerEnv.getCustomAuthenticationProvider();
        }
        if ((string = System.getProperty("com.jinfonet.AuthorizationProvider")) == null) {
            string = ServerEnv.getCustomAuthorizationProvider();
        }
        if (string2 != null || string != null) {
            if (string2 == null) {
                string2 = "jet.server.jrc.security.custom.DefaultAuthenticationProvider";
            }
            if (string == null) {
                string = "jet.server.jrc.security.custom.DefaultAuthorizationProvider";
            }
            this.endsWith.put("authentication_provider", new ProviderDescriptorImpl("authentication_provider", string2, false));
            this.endsWith.put("authorization_provider", new ProviderDescriptorImpl("authorization_provider", string, false));
        }
    }

    private void clear(String string) {
        UserAuthenticator userAuthenticator = null;
        SecurityDataLoader securityDataLoader = null;
        if (System.getProperty("com.jinfonet.authenticator") != null) {
            try {
                userAuthenticator = (UserAuthenticator)Class.forName(System.getProperty("com.jinfonet.authenticator")).newInstance();
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
        } else {
            String string2 = string + "classes.properties";
            try {
                ExProperties exProperties = new ExProperties();
                Classes.loadData(string2, exProperties);
                userAuthenticator = (UserAuthenticator)Classes.newInstance("UserAuthenticator");
                String string3 = System.getProperty("line.separator") + "\t";
                String string4 = "";
                string4 = string4 + "class.UserAuthenticator = " + Classes.getClass("UserAuthenticator");
                string4 = string4 + string3 + "class.UserAuthenticator.loader = " + Classes.getClass("UserAuthenticator.loader");
                string4 = string4 + string3 + "UserAuthenticator.loader.path = " + Classes.getProperty("UserAuthenticator.loader.path");
                ServiceLogger.logDebug(6630045, string4, 6);
                if (Classes.getClass("UserAuthenticator.loader") != null) {
                    securityDataLoader = (SecurityDataLoader)Classes.newInstance("UserAuthenticator.loader");
                }
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        }
        if (userAuthenticator != null && !(userAuthenticator instanceof JReportImplementation)) {
            AuthenticationProviderCompImpl.setUserAuthenticator(userAuthenticator);
            if (userAuthenticator.getMailList() != null) {
                UserDataToolkit.setMailList(userAuthenticator.getMailList());
            }
            this.endsWith.put("authentication_provider", new ProviderDescriptorImpl("authentication_provider", "jet.server.jrc.security.custom.comp.AuthenticationProviderCompImpl", false));
            this.endsWith.put("authorization_provider", new ProviderDescriptorImpl("authorization_provider", "jet.server.jrc.security.custom.comp.AuthorizationProviderCompImpl", false));
            this.endsWith.put("user_provider", new ProviderDescriptorImpl("user_provider", "jet.server.jrc.security.custom.comp.UserProviderCompImpl", false));
        }
        if (securityDataLoader != null && !(securityDataLoader instanceof JReportImplementation)) {
            securityDataLoader.loadData(Classes.getProperty("UserAuthenticator.loader.path"));
        }
    }

    public String[] getAllNames() {
        return QOIV;
    }

    public String[] getDefaultClasses() {
        if (this.exists) {
            return append;
        }
        LDAPManager lDAPManager = UserDataToolkit.getLdapManager();
        boolean bl = lDAPManager.isEnableNoneImportedLDAPSupport();
        if (bl) {
            return clear;
        }
        return append;
    }

    public boolean isActive(String string) {
        ProviderDescriptor providerDescriptor = (ProviderDescriptor)this.endsWith.get(string);
        if (providerDescriptor == null) {
            return false;
        }
        return providerDescriptor.isActive();
    }

    public String getClassName(String string) {
        ProviderDescriptor providerDescriptor = (ProviderDescriptor)this.endsWith.get(string);
        String string2 = null;
        if (providerDescriptor != null) {
            string2 = providerDescriptor.getProviderClassName();
        }
        return string2;
    }

    public boolean useBuiltinAPI() {
        return this.endsWith.size() == 0 || this.getClassName("authentication_provider").equals("jet.server.jrc.security.custom.db.AuthenticationProviderDBImpl");
    }

    public boolean useBuiltinAuthorizationProvider() {
        return this.getClassName("authorization_provider") == null;
    }
}

