/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrc.security.config.xml;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jet.server.jrc.security.config.ProviderDescriptorImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SecurityXMLReader {
    private String QOIV;
    private Hashtable equals;

    public SecurityXMLReader(String string) {
        this.QOIV = string;
        this.equals = new Hashtable();
    }

    public Hashtable getProperties() {
        return this.equals;
    }

    public void read() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(this.QOIV));
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("security");
        if (nodeList.getLength() <= 0) {
            throw new ParserConfigurationException("The format of configuration file has some error: 'can not find the tag <security>'!");
        }
        Element element2 = (Element)nodeList.item(0);
        this.getProperties(element2);
    }

    private void getProperties(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (node.getNodeType() == 1 && string != null) {
                if (string.equals("authentication-provider")) {
                    this.getChildNodes("authentication_provider", (Element)node);
                }
                if (string.equals("authorization-provider")) {
                    this.getChildNodes("authorization_provider", (Element)node);
                }
                if (string.equals("user")) {
                    this.QOIV((Element)node);
                }
                if (string.equals("role")) {
                    this.equals((Element)node);
                }
                if (string.equals("group")) {
                    this.equalsIgnoreCase((Element)node);
                }
                if (string.equals("relation")) {
                    this.getAttribute((Element)node);
                }
            }
            ++n;
        }
    }

    private void QOIV(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (node.getNodeType() == 1 && string != null) {
                if (string.equals("permission-provider")) {
                    this.getChildNodes("user_permission_provider", (Element)node);
                }
                if (string.equals("privilege-provider")) {
                    this.getChildNodes("user_privilege_provider", (Element)node);
                }
                if (string.equals("provider")) {
                    this.getChildNodes("user_provider", (Element)node);
                }
            }
            ++n;
        }
    }

    private void equals(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (node.getNodeType() == 1 && string != null) {
                if (string.equals("permission-provider")) {
                    this.getChildNodes("role_permission_provider", (Element)node);
                }
                if (string.equals("privilege-provider")) {
                    this.getChildNodes("role_privilege_provider", (Element)node);
                }
                if (string.equals("provider")) {
                    this.getChildNodes("role_provider", (Element)node);
                }
            }
            ++n;
        }
    }

    private void equalsIgnoreCase(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (node.getNodeType() == 1 && string != null) {
                if (string.equals("permission-provider")) {
                    this.getChildNodes("group_permission_provider", (Element)node);
                }
                if (string.equals("privilege-provider")) {
                    this.getChildNodes("group_privilege_provider", (Element)node);
                }
                if (string.equals("provider")) {
                    this.getChildNodes("group_provider", (Element)node);
                }
            }
            ++n;
        }
    }

    private void getAttribute(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (node.getNodeType() == 1 && string != null) {
                if (string.equals("role-group")) {
                    this.getChildNodes("role_group_relation_provider", (Element)node);
                }
                if (string.equals("role-user")) {
                    this.getChildNodes("role_user_relation_provider", (Element)node);
                }
                if (string.equals("group-user")) {
                    this.getChildNodes("group_user_relation_provider", (Element)node);
                }
            }
            ++n;
        }
    }

    private void getChildNodes(String string, Element element) {
        Node node = element.getFirstChild();
        String string2 = node.getNodeValue();
        boolean bl = true;
        String string3 = element.getAttribute("active");
        if (string3 != null && string3.equalsIgnoreCase("false")) {
            bl = false;
        }
        ProviderDescriptorImpl providerDescriptorImpl = new ProviderDescriptorImpl(string, string2, bl);
        this.equals.put(string, providerDescriptorImpl);
    }
}

